/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.multipageeditor;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.CheckReportItem;
import com.kingdee.bos.dao.xml.ICheckReport;
import com.kingdee.bos.dao.xml.XMLLoader;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.md.dao.MDORMUtil;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.md.multipageeditor.AbstractMDEditor;
import com.kingdee.bos.md.multipageeditor.IMDFileEditorInput;
import com.kingdee.bos.md.multipageeditor.IMDSourceEditor;
import com.kingdee.bos.md.multipageeditor.MDFileEditorInput;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.DynamicMetaDataContainer;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.metadata.validate.ValidateItem;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.ToolBasePlugin;
import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.tool.check.ConsoleVerifyListener;
import com.kingdee.bos.tool.check.VerifyOperator;
import com.kingdee.bos.tool.check.VerifyReport;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.common.TranslateUtil;
import com.kingdee.bos.tool.console.IUserStream;
import com.kingdee.bos.tool.multipageeditor.ExceptionHandler;
import com.kingdee.bos.tool.multipageeditor.MEditorDocumentProvider;
import com.kingdee.bos.tool.multipageeditor.Messages;
import com.kingdee.bos.tool.multipageeditor.SetTCWhenSaveHelper;
import com.kingdee.bos.tool.multipageeditor.ToolEditorContributor;
import com.kingdee.bos.tool.multipageeditor.common.CommonPage;
import com.kingdee.bos.tool.multipageeditor.common.ICommonPage;
import com.kingdee.bos.tool.utils.EditorHelper;
import com.kingdee.bos.tool.views.verify.CheckReport;
import com.kingdee.bos.tool.wizard.saveas.SaveAsWizard;
import com.kingdee.bos.tool.xmleditor.XMLEditor;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.utils.FileAccessSupport;
import com.kingdee.util.DateTimeUtils;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class BaseMDSourceEditor
extends AbstractMDEditor
implements IMDSourceEditor {
    private boolean reloadResult = true;
    private int sourceIndex;
    private XMLEditor xeditor;
    private IDocumentListener listener;
    private boolean documentDirty = false;
    protected HashSet readOnlyKeys = new HashSet();
    protected IObjectValue model = null;
    protected BOSObjectType modelType = null;
    protected MEditorDocumentProvider documentProvider;
    protected IUserStream us;
    private IEditorSite aSite;
    private boolean changeByPage = false;
    private boolean opened = false;

    protected XMLEditor getXMLEditor() {
        return this.xeditor;
    }

    @Override
    public IObjectValue getModel() {
        return this.model;
    }

    public BOSObjectType getModelType() {
        return this.modelType;
    }

    @Override
    public IDocumentListener getDocumentListener() {
        return this.listener;
    }

    @Override
    protected void createTabPages() {
        this.createSourcePage();
    }

    private void createSourcePage() {
        this.xeditor = new XMLEditor();
        this.xeditor.setDocumentProvider((IDocumentProvider)this.documentProvider);
        try {
            this.sourceIndex = this.addPage((IEditorPart)this.xeditor, this.getEditorInput());
            this.setPageText(this.sourceIndex, TranslateUtil.MUTILPAGEEDITOR_SOURCEPAGE_TITLE);
        }
        catch (Exception e) {
            ExceptionHandler.showException(e);
        }
        this.unregisterGlobalActions();
    }

    private void unregisterGlobalActions() {
        IKeyBindingService service = this.getSite().getKeyBindingService();
        service.unregisterAction(this.xeditor.getAction(ITextEditorActionConstants.DELETE));
        service.unregisterAction(this.xeditor.getAction(ITextEditorActionConstants.UNDO));
        service.unregisterAction(this.xeditor.getAction(ITextEditorActionConstants.REDO));
        service.unregisterAction(this.xeditor.getAction(ITextEditorActionConstants.CUT));
        service.unregisterAction(this.xeditor.getAction(ITextEditorActionConstants.COPY));
        service.unregisterAction(this.xeditor.getAction(ITextEditorActionConstants.PASTE));
        service.unregisterAction(this.xeditor.getAction(ITextEditorActionConstants.SELECT_ALL));
        service.unregisterAction(this.xeditor.getAction(ITextEditorActionConstants.FIND));
        service.unregisterAction(this.xeditor.getAction(IDEActionFactory.BOOKMARK.getId()));
    }

    public ToolEditorContributor getContributor() {
        return (ToolEditorContributor)this.getEditorSite().getActionBarContributor();
    }

    protected void refreshSourcePage() {
        this.documentProvider.refresh();
        this.documentDirty = false;
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        ToolCommonPlugin.startWatch();
        this.changeByPage = true;
        this.aSite = site;
        super.init(site, input);
        try {
            if (this.file != null) {
                if (!this.file.getMDProject().isValidateProject()) {
                    throw new Exception("\u6587\u4ef6\u6240\u5728\u7684\u5de5\u7a0b[" + this.file.getMDProject().getName() + "]\u662f\u65e0\u6548\u7684BIM\u5de5\u7a0b\uff0c\u65e0\u6cd5\u7f16\u8f91\u8be5\u6587\u4ef6[" + this.file.getName() + "]");
                }
                this.modelType = this.file.getBOSType();
                this.model = MDORMUtil.load(this.file);
                ((AbstractMetaDataValue)this.model).setDirty(true);
            }
            this.listener = new InnerDocumentListener();
            this.documentProvider = new MEditorDocumentProvider(this);
            this.setReadOnlyKey("package");
            this.setReadOnlyKey("name");
            AbstractMetaDataValue model = (AbstractMetaDataValue)this.getModel();
            if (this.file != null && !FileAccessSupport.getInstance(this.file.getMDProject()).canModifyField(this.file, model)) {
                Context ctx = this.file.getMDProject().getORMContext();
                BOSObjectType bosType = model.getBOSType();
                try {
                    XMLLoader xmlLoader = MDResourceUtil.getXMLLoader(ctx);
                    EntityObjectInfo entity = xmlLoader.loadMeta(bosType);
                    LogicalKeyInfo lkInfo = entity.getLogicalKey();
                    PropertyCollection pc = lkInfo.getKeyPropertys();
                    int size = pc.size();
                    for (int i = 0; i < size; ++i) {
                        PropertyInfo pi = pc.get(i);
                        String lkName = pi.getName();
                        this.setReadOnlyKey(lkName);
                    }
                }
                catch (DataAccessException e) {
                    LogTool.logError("", e);
                }
            }
            ToolCommonPlugin.stopWatch();
        }
        catch (Exception e) {
            LogTool.logError("\u6253\u5f00\u7f16\u8f91\u5668\u5931\u8d25", e);
            ExceptionHandler.showException(e);
        }
    }

    @Override
    public void reLoad() {
        ToolCommonPlugin.startWatch();
        try {
            if (this.file != null) {
                this.model = MDORMUtil.load(this.file);
                this.modelType = this.file.getBOSType();
            }
        }
        catch (Exception e) {
            ExceptionHandler.showException(e);
        }
        ToolCommonPlugin.stopWatch();
    }

    public IUserStream getUserStream() {
        if (this.us == null) {
            String consoleName = ((AbstractMetaDataValue)this.getModel()).getFullName();
            consoleName = consoleName + " (" + DateTimeUtils.format((Date)new Date(System.currentTimeMillis())) + ")";
            this.us = ToolBasePlugin.getDefault().getUserStream(consoleName);
            this.us.setColor(Display.getCurrent().getSystemColor(3));
        }
        return this.us;
    }

    @Override
    protected void pageChange(int newPageIndex) {
        ToolCommonPlugin.startWatch();
        this.changeByPage = true;
        if (this.currentPage == this.sourceIndex && this.documentDirty) {
            this.refreshModel();
        }
        if (this.isNeedSync()) {
            this.refreshSourcePage();
        }
        super.pageChange(newPageIndex);
        this.getContributor().setActiveEditor(this);
        this.changeByPage = false;
        ToolCommonPlugin.startWatch();
    }

    protected void sourcePageAboutToBeChanged(DocumentEvent event) {
    }

    protected void sourcePageChanged(DocumentEvent event) {
        if (this.getCurrentPage() == this.sourceIndex) {
            this.documentDirty = true;
            this.setNeedSync(true);
            this.setModify(true);
        }
    }

    protected boolean refreshModel() {
        ToolCommonPlugin.startWatch();
        IDocument doc = this.documentProvider.getDocument();
        boolean invalid = false;
        String k2 = "";
        try {
            String pkg = (String)this.model.get("package");
            String name = (String)this.model.get("name");
            MetaDataPK pk = new MetaDataPK(pkg, name);
            MDORMUtil.getObjectValue(this.file.getMDProject(), (IMetaDataPK)pk, this.modelType, doc.get());
            IObjectValue newmodel = MDORMUtil.getObjectValue(this.file.getMDProject(), (IMetaDataPK)pk, this.modelType, doc.get());
            for (String k2 : this.readOnlyKeys) {
                Object newobj = newmodel.get(k2);
                Object oldobj = this.model.get(k2);
                if (newobj == null || oldobj == null || newobj.equals(oldobj)) continue;
                invalid = true;
                break;
            }
            if (invalid) {
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)"", (String)(Messages.BaseSourceEditor_ShuXing + k2 + Messages.BaseSourceEditor_BuNengBeiXiuGai));
            } else {
                this.model = newmodel;
            }
        }
        catch (Throwable e) {
            LogTool.logError("", e);
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.BaseSourceEditor_CuoWu, (String)Messages.BaseSourceEditor_JinXingLiaoFeiFaDeCaoZuoBianJiQiJiangHuiFuDaoYiQianBanBen);
            ToolCommonPlugin.stopWatch();
            return false;
        }
        ToolCommonPlugin.stopWatch();
        return !invalid;
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        ToolCommonPlugin.startWatch();
        this.changeByPage = true;
        if (this.documentDirty) {
            if (!this.refreshModel()) {
                ToolCommonPlugin.stopWatch();
                return;
            }
            this.documentDirty = false;
        }
        this.check();
        this.checkPackageAndName();
        try {
            MDORMUtil.store(this.file.getMDProject(), this.getModel(), monitor);
        }
        catch (IDEException e) {
            ExceptionHandler.showException(e);
        }
        this.documentProvider.refresh();
        super.doSave(monitor);
        boolean flag = SetTCWhenSaveHelper.setTChineseAuto(this.file.getMDProject(), this.getModel());
        if (flag) {
            EditorHelper.refreshOpenedEditor(this.file);
        }
        this.reloadResult = true;
        MDResourceUtil.fireResourceUpdated(this.file);
        ToolCommonPlugin.stopWatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSaveAs() {
        ToolCommonPlugin.startWatch();
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        Shell shell = this.getSite().getShell();
        IMDFileEditorInput input = EditorHelper.transEditor(this.getEditorInput());
        IMDFile original = input.getFile();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)new SaveAsWizard((IWorkbenchSite)this.getSite(), this.getModel()));
        dialog.create();
        MEditorDocumentProvider provider = this.documentProvider;
        if (provider == null) {
            ToolCommonPlugin.stopWatch();
            return;
        }
        if (provider.isDeleted(input) && original != null) {
            String message = MessageFormat.format("Editor.warning.save.delete", original.getName());
            dialog.setErrorMessage(null);
            dialog.setMessage(message, 2);
        }
        if (dialog.open() == 1) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            ToolCommonPlugin.stopWatch();
            return;
        }
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart aEditor = workbenchPage.findEditor((IEditorInput)input);
        workbenchPage.closeEditor(aEditor, false);
        final MDFileEditorInput newInput = new MDFileEditorInput(MDResourceUtil.getFile(this.file.getMDProject(), this.model));
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                IMDFile file;
                if (BaseMDSourceEditor.this.documentDirty) {
                    if (!BaseMDSourceEditor.this.refreshModel()) {
                        ToolCommonPlugin.stopWatch();
                        return;
                    }
                    BaseMDSourceEditor.this.documentDirty = false;
                }
                if (BaseMDSourceEditor.this.getModel() instanceof AbstractMetaDataValue) {
                    ValidateList vldList = ((AbstractMetaDataValue)BaseMDSourceEditor.this.getModel()).validate();
                    BaseMDSourceEditor.showConsole();
                    if (vldList != null && BaseMDSourceEditor.this.getUserStream() != null) {
                        ValidateItem[] items = vldList.getItems();
                        for (int i = 0; i < items.length; ++i) {
                            BaseMDSourceEditor.this.getUserStream().println(items[i].getMessage());
                        }
                    }
                }
                if (!(file = newInput.getFile()).toFile().exists()) {
                    file.toFile().getParentFile().mkdirs();
                }
                try {
                    MDORMUtil.store(file.getMDProject(), BaseMDSourceEditor.this.getModel(), monitor);
                }
                catch (Exception e) {
                    ExceptionHandler.showException(e);
                }
            }
        };
        boolean success = false;
        try {
            provider.aboutToChange(newInput);
            new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)op);
            success = true;
        }
        catch (InterruptedException e) {
            ExceptionHandler.showException(e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            String title = "Editor.error.save.title";
            String msg = MessageFormat.format("Editor.error.save.message", targetException.getMessage());
            if (targetException instanceof CoreException) {
                CoreException coreException = (CoreException)targetException;
                IStatus status = coreException.getStatus();
                if (status != null) {
                    switch (status.getSeverity()) {
                        case 1: {
                            MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                        case 2: {
                            MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                        default: {
                            MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                    }
                } else {
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                }
            }
        }
        finally {
            provider.changed(newInput);
            if (success) {
                this.setInput(newInput);
                try {
                    this.init(this.aSite, newInput);
                }
                catch (Exception e) {
                    ExceptionHandler.showException(e);
                }
                aEditor = workbenchPage.findEditor((IEditorInput)newInput);
                workbenchPage.closeEditor(aEditor, false);
                EditorHelper.openFile(newInput.getFile());
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
        ToolCommonPlugin.stopWatch();
    }

    @Override
    public void refreshPages() {
        ToolCommonPlugin.startWatch();
        super.refreshPages();
        ToolCommonPlugin.stopWatch();
    }

    @Override
    public void performGlobalAction(String id) {
        IAction action;
        ToolCommonPlugin.startWatch();
        ICommonPage ipage = this.getCurrPage();
        CommonPage page = null;
        if (ipage instanceof CommonPage) {
            page = (CommonPage)ipage;
        }
        boolean handled = false;
        if (page != null) {
            handled = page.doGlobalAction(id);
        }
        if (!handled && (action = this.xeditor.getAction(id)) != null) {
            action.run();
        }
        ToolCommonPlugin.stopWatch();
    }

    private void check() {
        ToolCommonPlugin.startWatch();
        try {
            CheckReport checkReport = ToolCommonPlugin.getCheckReport();
            BaseMDSourceEditor.showConsole();
            IUserStream userStream = this.getUserStream();
            ConsoleVerifyListener verifyListener = new ConsoleVerifyListener(userStream);
            Context ctx = this.file.getMDProject().getORMContext();
            DynamicMetaDataContainer container = new DynamicMetaDataContainer(ctx);
            MetaDataInfo meta = new MetaDataInfo();
            meta.setName(this.model.getString("name"));
            meta.setPackage(this.model.getString("package"));
            meta.setMetaDataType(this.model.getBOSType().toString());
            container.addMetaData(meta);
            container.check(null, (ICheckReport)checkReport, null);
            Collection items = checkReport.getItems();
            for (CheckReportItem item : items) {
                checkReport.addItem(item);
            }
            VerifyReport report = new VerifyReport();
            report.registerListener(verifyListener);
            VerifyOperator operator = new VerifyOperator(report);
            operator.check(this.getModel(), 1);
        }
        catch (DataAccessException e) {
            LogTool.logError("\u6570\u636e\u6821\u9a8c\u51fa\u9519", e);
        }
        ToolCommonPlugin.stopWatch();
    }

    @Override
    public void setReadOnlyKey(String key) {
        this.readOnlyKeys.add(key);
    }

    @Override
    public void dispose() {
        if (this.isModify()) {
            this.file.getMDProject().getMetadataLoader().clear(this.model.getBOSType(), (IMetaDataPK)this.file.getMetaDataPK());
        }
        if (this.us != null) {
            this.us.close();
        }
        super.dispose();
    }

    private boolean checkPackageAndName() {
        String message;
        ToolCommonPlugin.startWatch();
        AbstractMetaDataValue value = (AbstractMetaDataValue)this.getModel();
        String name = value.getName();
        String pkg = value.getPackage();
        String fileName = this.file.getName();
        String rPkg = this.file.getParent().getPackageName();
        if (fileName != null && fileName.indexOf(46) > -1) {
            fileName = fileName.substring(0, fileName.indexOf(46));
        }
        if (name != null && fileName != null && !name.equals(fileName)) {
            message = Messages.BaseSourceEditor_YuanShuJuZhongDeNAMEYuWenJianMingChengBuYiZhiQingQueRen;
            this.printConsoleMsg(message);
        }
        if (pkg != null && rPkg != null && !pkg.equals(rPkg)) {
            message = Messages.BaseSourceEditor_YuanShuJuZhongDePACKAGEYuWenJianLuJingBaoMingBuYiZhiQingQueRen;
            this.printConsoleMsg(message);
        }
        ToolCommonPlugin.stopWatch();
        return false;
    }

    private void printConsoleMsg(String message) {
        MetaDataInfo meta = new MetaDataInfo();
        meta.setName(this.model.getString("name"));
        meta.setPackage(this.model.getString("package"));
        meta.setMetaDataType(this.model.getBOSType().toString());
        BaseMDSourceEditor.showConsole();
        ConsoleVerifyListener listener = new ConsoleVerifyListener(this.getUserStream());
        listener.addWarning(meta, message);
    }

    public static void showConsole() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView("com.kingdee.bos.tool.console.Console").setFocus();
        }
        catch (PartInitException e) {
            LogTool.logError("", e);
        }
    }

    public static void showVerifyView() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView("com.kingdee.bos.tool.views.VerifyMessageView").setFocus();
        }
        catch (PartInitException e) {
            LogTool.logError("", e);
        }
    }

    @Override
    public boolean isSaveAsAllowed() {
        return this.isDirty();
    }

    @Override
    public void setActive() {
        block8: {
            if (!this.changeByPage) {
                if (this.opened) {
                    IDevMetadataLoader loader = this.file.getMDProject().getMetadataLoader();
                    try {
                        if (this.reloadResult && loader.lastModifiedChanged((AbstractMetaDataValue)this.model)) {
                            this.reloadResult = MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"\u7cfb\u7edf\u63d0\u793a", (String)"\u5916\u90e8\u4fee\u6539\u4e86\u76f8\u5173\u5143\u6570\u636e\uff0c\u662f\u5426\u91cd\u65b0\u88c5\u8f7d\uff1f");
                            if (this.reloadResult) {
                                this.model = MetaDataTypeList.UIOBJECT.equals((Object)this.model.getBOSType()) ? loader.loadAssmebledUIObject((IMetaDataPK)this.file.getMetaDataPK()) : (MetaDataTypeList.WEBUIOBJECT.equals((Object)this.model.getBOSType()) ? loader.loadAssmebledWebUIObject((IMetaDataPK)this.file.getMetaDataPK()) : loader.loadMetadata(this.model.getBOSType(), (IMetaDataPK)this.file.getMetaDataPK()));
                                ((AbstractMetaDataValue)this.model).setDirty(true);
                                this.refreshPages();
                            }
                            break block8;
                        }
                        this.model = loader.refreshMetadata((AbstractMetaDataValue)this.getModel());
                        this.refreshPages();
                    }
                    catch (Exception e1) {
                        LogTool.logError("", e1);
                    }
                } else {
                    this.opened = true;
                }
            } else {
                this.changeByPage = false;
            }
        }
    }

    @Override
    public IMDFile getMDFile() {
        return this.getFile();
    }

    @Override
    public IMDProject getMDProject() {
        return this.getMDFile().getMDProject();
    }

    private class InnerDocumentListener
    implements IDocumentListener {
        private InnerDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            BaseMDSourceEditor.this.sourcePageAboutToBeChanged(event);
        }

        public void documentChanged(DocumentEvent event) {
            BaseMDSourceEditor.this.sourcePageChanged(event);
        }
    }
}

