/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.ui;

import com.kingdee.bos.md.cache.AliasUtil;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDObject;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDObjectAdapter;
import com.kingdee.bos.md.ui.MDTypeImages;
import com.kingdee.bos.tool.utils.XmlFileUtils;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class MDTreeLabelProvider
extends LabelProvider {
    public static final int TEXT_MODE_NAME = 0;
    public static final int TEXT_MODE_ALIAS = 1;
    public static final int TEXT_MODE_BOTH = 2;
    private int textMode = 0;

    public void setTextMode(int mode) {
        this.textMode = mode;
    }

    public int getTextMode() {
        return this.textMode;
    }

    public Image getImage(Object element) {
        assert (element instanceof IMDObject || element instanceof MDObjectAdapter);
        if (element instanceof IMDObject) {
            IMDObject object = (IMDObject)element;
            Image image = MDTypeImages.getImage(object);
            return this.decorateImage(image, object);
        }
        MDObjectAdapter object = (MDObjectAdapter)element;
        Image image = MDTypeImages.getImage(object);
        return this.decorateImage(image, object);
    }

    protected Image decorateImage(Image image, IMDObject object) {
        return image;
    }

    protected Image decorateImage(Image image, MDObjectAdapter adapter) {
        return this.decorateImage(image, adapter.getModel());
    }

    private String getName(Object element) {
        assert (element instanceof IMDObject || element instanceof MDObjectAdapter);
        IMDObject obj = null;
        obj = element instanceof IMDObject ? (IMDObject)element : ((MDObjectAdapter)element).getModel();
        if (obj instanceof IMDFolder && ((IMDFolder)obj).isRoot()) {
            if (element instanceof MDObjectAdapter) {
                MDObjectAdapter adapter = (MDObjectAdapter)element;
                return adapter.isInSrcBranch() ? "metadata" : "basemetas";
            }
            return obj.getMDProject().getName();
        }
        return obj.getName();
    }

    private String showProjectVersionText(IMDProject project) {
        String version = XmlFileUtils.getProjectEasVersion(project);
        if (version.trim().length() == 0) {
            version = "unknown";
        }
        return "--eas version:" + version;
    }

    public String getText(Object element) {
        String alias;
        assert (element instanceof IMDObject || element instanceof MDObjectAdapter);
        if (element instanceof MDObjectAdapter && ((MDObjectAdapter)element).getModel() instanceof IMDProject) {
            return ((MDObjectAdapter)element).getModel().getName() + this.showProjectVersionText((IMDProject)((MDObjectAdapter)element).getModel());
        }
        if (this.textMode == 0) {
            return this.getName(element);
        }
        if (this.textMode == 1) {
            return this.getAlias(element);
        }
        String name = this.getName(element);
        if (!name.equals(alias = this.getAlias(element))) {
            return alias + "(" + name + ")";
        }
        return alias;
    }

    private String getAlias(Object element) {
        if (element instanceof MDObjectAdapter) {
            MDObjectAdapter adapter = (MDObjectAdapter)element;
            if (adapter.getModel().isRoot()) {
                return adapter.isInSrcBranch() ? "\u5ba2\u6237\u5316\u5143\u6570\u636e" : "\u57fa\u7840\u5143\u6570\u636e";
            }
            return AliasUtil.getAlias(adapter.getModel());
        }
        return AliasUtil.getAlias((IMDObject)element);
    }
}

