/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.ui;

import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDObject;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDObjectAdapter;
import com.kingdee.bos.md.ui.MDImageDescriptor;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class MDTypeImages {
    public static final String SUFFIX_MODIFY = "_modified";
    public static final String SUFFIX_LIB = "_lib";
    public static final String SUFFIX_LOCK = "_lock";
    public static final String SUFFIX_EDIT = "_edit";
    public static final String IMAGE_FOLDER = "folder";
    public static final String IMAGE_PROJECT = "project";
    public static final String IMAGE_ROOT = "root";
    private static MDTypeImages instance = null;
    private static final String IMAGE_PATH = "icons/mdtypes/";
    private Map images = new HashMap();

    public static Image getImage(IMDObject object) {
        if (object == null) {
            return null;
        }
        return MDTypeImages.getImage(MDTypeImages.getImageName(object));
    }

    public static Image getImage(MDObjectAdapter object) {
        if (object == null) {
            return null;
        }
        return MDTypeImages.getImage(MDTypeImages.getImageName(object));
    }

    private static String getImageName(MDObjectAdapter adapter) {
        if (!adapter.isInSrcBranch()) {
            return MDTypeImages.getImageName(adapter.getModel());
        }
        IMDObject object = adapter.getModel();
        if (object instanceof IMDProject) {
            return IMAGE_PROJECT;
        }
        if (object instanceof IMDFolder) {
            if (object.isRoot()) {
                return IMAGE_ROOT;
            }
            String name = IMAGE_FOLDER;
            if (((IMDFolder)object).isInLib()) {
                name = name + SUFFIX_LIB;
            }
            return name;
        }
        if (object instanceof IMDFile) {
            IMDFile file = (IMDFile)object;
            String name = file.getExtension();
            if (file.isInLib()) {
                name = name + SUFFIX_LIB;
            }
            return name;
        }
        return null;
    }

    private static String getImageName(IMDObject object) {
        if (object instanceof IMDProject) {
            return IMAGE_PROJECT;
        }
        if (object instanceof IMDFolder) {
            if (object.isRoot()) {
                return IMAGE_ROOT;
            }
            String name = IMAGE_FOLDER;
            IMDFolder folder = (IMDFolder)object;
            if (folder.isModified()) {
                if (folder.isInLib()) {
                    return name + SUFFIX_LIB;
                }
                return name + SUFFIX_MODIFY;
            }
            return name;
        }
        if (object instanceof IMDFile) {
            IMDFile file = (IMDFile)object;
            String name = file.getExtension();
            if (file.isModified()) {
                if (file.isInLib()) {
                    return name + SUFFIX_LIB;
                }
                return name + SUFFIX_MODIFY;
            }
            return name;
        }
        return null;
    }

    private static MDTypeImages getInstance() {
        if (instance == null) {
            instance = new MDTypeImages();
            try {
                instance.init();
            }
            catch (IOException e) {
                LogTool.logError("\u521d\u59cb\u5316\u56fe\u7247\u8d44\u6e90\u65f6\u51fa\u9519", e);
                instance = null;
            }
        }
        return instance;
    }

    private MDTypeImages() {
    }

    public static Image getImage(String extendsion) {
        if (StringUtils.isEmpty((String)extendsion)) {
            return null;
        }
        if ((extendsion = extendsion.trim().toLowerCase(Locale.ENGLISH)).indexOf(46) == 0) {
            extendsion = extendsion.substring(1);
        }
        return (Image)MDTypeImages.getInstance().images.get(extendsion);
    }

    private void init() throws IOException {
        Image image;
        this.dispose();
        URL baseURL = null;
        try {
            baseURL = ToolCommonPlugin.getPlugInURL(IMAGE_PATH);
        }
        catch (IDEException e) {
            LogTool.logError("\u521d\u59cb\u5316\u56fe\u50cf\u8d44\u6e90\u65f6\u51fa\u9519", e);
            return;
        }
        File root = new File(FileLocator.toFileURL((URL)baseURL).getFile());
        File[] gifs = root.listFiles();
        for (int i = 0; i < gifs.length; ++i) {
            File gif = gifs[i];
            if (!gif.isFile() || !gif.getName().toLowerCase(Locale.ENGLISH).endsWith(".gif")) continue;
            String name = gif.getName();
            image = MDTypeImages.create(baseURL, name).createImage();
            String key = name.substring(0, name.length() - 4).toLowerCase(Locale.ENGLISH);
            this.images.put(key, image);
        }
        HashMap<String, Image> temp = new HashMap<String, Image>();
        for (String key : this.images.keySet()) {
            if (key.startsWith("_")) continue;
            image = (Image)this.images.get(key);
            MDImageDescriptor desc = new MDImageDescriptor(image, 1);
            temp.put(key + SUFFIX_MODIFY, desc.createImage());
            desc = new MDImageDescriptor(image, 2);
            temp.put(key + SUFFIX_LIB, desc.createImage());
            desc = new MDImageDescriptor(image, 4);
            temp.put(key + SUFFIX_LOCK, desc.createImage());
            desc = new MDImageDescriptor(image, 8);
            temp.put(key + SUFFIX_EDIT, desc.createImage());
        }
        this.images.putAll(temp);
    }

    private static ImageDescriptor create(URL url, String name) {
        try {
            url = new URL(url, name);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public void dispose() {
        for (String key : this.images.keySet()) {
            Image image = (Image)this.images.get(key);
            if (image.isDisposed()) continue;
            image.dispose();
        }
        this.images.clear();
    }
}

