/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool;

import com.kingdee.bos.tool.FileMD5Cache;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;

public class ToolSetting {
    private static final String KEY_REPORT_TEMP_DIR = "report_temp_dir";
    private static final String KEY_AUTO_UPDATE_TOOL = "auto_update_tool";
    private static final String KEY_TOOL_UPDATE_TEMP_DIR = "tool_update_temp_dir";
    private static final String KEY_KEEP_TOOL_UPDATE_TEMP = "keep_tool_update_temp";
    private static final String FILE_NAME_PROPERTIES = "tool_setting.properties";
    private static final String KEY_SHARE_METADATA_DIR = "share_metadata_dir";
    private static final String KEY_BOS_CLOUD_USER = "bos_cloud_user";
    private static final String KEY_BOS_CLOUD_P = "bos_cloud_password";
    private static final String KEY_SUBMIT_ON_CLOSE = "remote_submit_on_close";
    private static long loadTime = -1L;
    private static Properties prop = new Properties();

    public static boolean isAutoSubmitCloudMD() {
        String value = ToolSetting.get(KEY_SUBMIT_ON_CLOSE, "false");
        return Boolean.valueOf(value);
    }

    public static void setAutoSubmitCloudMD(boolean flag) {
        ToolSetting.store(KEY_SUBMIT_ON_CLOSE, String.valueOf(flag));
    }

    public static FileMD5Cache getFileMD5Cache() throws IOException {
        return new FileMD5Cache(new File(ToolSetting.getInstallDir(), "md5.cache"));
    }

    public static String getCloudComUser() {
        return ToolSetting.get(KEY_BOS_CLOUD_USER, "user");
    }

    public static void setCloudComUser(String user) {
        ToolSetting.store(KEY_BOS_CLOUD_USER, user);
    }

    public static String getCloudComP() {
        return ToolSetting.get(KEY_BOS_CLOUD_P, "");
    }

    public static void setCloudComP(String p) {
        ToolSetting.store(KEY_BOS_CLOUD_P, p);
    }

    public static String getReportTempDir() {
        String value = ToolSetting.get(KEY_REPORT_TEMP_DIR, null);
        if (StringUtils.isEmpty((String)value)) {
            value = new File(ToolSetting.getInstallDir(), "report_client").getAbsolutePath();
        }
        return value;
    }

    public static void setReportTempDir(String dir) {
        ToolSetting.store(KEY_REPORT_TEMP_DIR, dir);
    }

    public static boolean isAutoUpdateTool() {
        String value = ToolSetting.get(KEY_AUTO_UPDATE_TOOL, "true");
        return Boolean.valueOf(value);
    }

    public static void setAutoUpdateTool(boolean flag) {
        ToolSetting.store(KEY_AUTO_UPDATE_TOOL, String.valueOf(flag));
    }

    public static boolean isKeepUpdateToolTemp() {
        String value = ToolSetting.get(KEY_KEEP_TOOL_UPDATE_TEMP, "false");
        return Boolean.valueOf(value);
    }

    public static void setKeepUpdateToolTemp(boolean flag) {
        ToolSetting.store(KEY_KEEP_TOOL_UPDATE_TEMP, String.valueOf(flag));
    }

    public static String getToolUpdateTempDir() {
        String value = ToolSetting.get(KEY_TOOL_UPDATE_TEMP_DIR, null);
        if (StringUtils.isEmpty((String)value)) {
            value = new File(ToolSetting.getInstallDir(), "update_temp").getAbsolutePath();
        }
        return value;
    }

    public static void setToolUpdateTempDir(String dir) {
        ToolSetting.store(KEY_TOOL_UPDATE_TEMP_DIR, dir);
    }

    public static String getShareMDDir() {
        String value = ToolSetting.get(KEY_SHARE_METADATA_DIR, null);
        if (StringUtils.isEmpty((String)value)) {
            value = new File(ToolSetting.getInstallDir(), "shared_metadata").getAbsolutePath();
        }
        return value;
    }

    public static void setShareMDDir(String dir) {
        ToolSetting.store(KEY_SHARE_METADATA_DIR, dir);
    }

    private static File getInstallDir() {
        String toolInstall;
        try {
            toolInstall = FileLocator.resolve((URL)Platform.getInstallLocation().getURL()).getFile();
        }
        catch (Throwable e) {
            LogTool.debug("\u9519\u8bef", e);
            toolInstall = "C:\\";
        }
        File root = new File(toolInstall);
        if (root.getParentFile() != null) {
            root = root.getParentFile();
        }
        if (root.getParentFile() != null) {
            root = root.getParentFile();
        }
        return root;
    }

    private static synchronized Properties getProperties() {
        File file = new File(ToolSetting.getInstallDir(), FILE_NAME_PROPERTIES);
        if (file.exists() && loadTime != file.lastModified()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                prop.load(fileInputStream);
                fileInputStream.close();
            }
            catch (Exception e) {
                try {
                    LogTool.logError("\u88c5\u8f7d\u914d\u7f6e\u4fe1\u606f\u65f6\u51fa\u9519", e);
                }
                catch (Throwable throwable) {
                    FileUtils.close(fileInputStream);
                    throw throwable;
                }
                FileUtils.close(fileInputStream);
            }
            FileUtils.close(fileInputStream);
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void store(String key, String value) {
        if (StringUtils.isEmpty((String)key) || value == null) {
            return;
        }
        prop.setProperty(key, value);
        File file = new File(ToolSetting.getInstallDir(), FILE_NAME_PROPERTIES);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            prop.store(fileOutputStream, "mic");
            loadTime = file.lastModified();
        }
        catch (Exception e) {
            try {
                LogTool.logError("\u4fdd\u5b58\u914d\u7f6e\u4fe1\u606f\u65f6\u51fa\u9519", e);
            }
            catch (Throwable throwable) {
                FileUtils.close(fileOutputStream);
                throw throwable;
            }
            FileUtils.close(fileOutputStream);
        }
        FileUtils.close(fileOutputStream);
    }

    private static String get(String key, String defaultValue) {
        Properties prop = ToolSetting.getProperties();
        String value = prop.getProperty(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
}

