/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.check;

import com.kingdee.bos.tool.check.VerifyItem;
import com.kingdee.bos.tool.check.VerifyItemSet;
import com.kingdee.bos.tool.check.VerifyTarget;
import com.kingdee.bos.tool.check.VerifyTargetType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.WorkbenchException;

public class VerifyExtensionPointProcess {
    private static final String EXTENSION_POINT = "com.kingdee.bos.tool.toolcommon.metaDataVerify";
    private static VerifyItemSet items = VerifyItemSet.getInstance();

    public static VerifyItemSet getVerifyItems() {
        return items;
    }

    public static void process() throws WorkbenchException {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT);
        if (extensionPoint == null) {
            throw new WorkbenchException("unable to resolve extension-point: com.kingdee.bos.tool.toolcommon.metaDataVerify");
        }
        IConfigurationElement[] setElements = extensionPoint.getConfigurationElements();
        items.getItems().clear();
        List list = VerifyExtensionPointProcess.getCategory(setElements);
        for (int i = 0; i < setElements.length; ++i) {
            VerifyItem item = VerifyExtensionPointProcess.getVerifyItem(setElements[i], list);
            if (item == null) continue;
            items.addItem(item);
        }
    }

    private static List getCategory(IConfigurationElement[] elements) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < elements.length; ++i) {
            IConfigurationElement element = elements[i];
            if (!element.getName().equals("category") || !"false".equalsIgnoreCase(element.getAttribute("enable"))) continue;
            list.add(element.getAttribute("name"));
        }
        return list;
    }

    private static VerifyItem getVerifyItem(IConfigurationElement element, List category) {
        VerifyItem item = null;
        if (!element.getName().equals("category") && !category.contains(element.getAttribute("category"))) {
            item = new VerifyItem();
            item.setElement(element);
            item.setName(element.getAttribute("name"));
            item.setCategory(element.getAttribute("category"));
            item.setClassName(element.getAttribute("class"));
            item.setLevel(VerifyExtensionPointProcess.getVerifyLevel(element));
            IConfigurationElement[] targetsElement = element.getChildren("targets");
            IConfigurationElement[] targets = targetsElement[0].getChildren();
            for (int j = 0; j < targets.length; ++j) {
                item.getTargets().add(VerifyExtensionPointProcess.getVerifyTarget(targets[j]));
            }
        }
        return item;
    }

    private static int getVerifyLevel(IConfigurationElement element) {
        String sLevel = element.getAttribute("level");
        int level = "ERROR".equals(sLevel) ? 2 : ("FATAL".equals(sLevel) ? 4 : 1);
        return level;
    }

    private static VerifyTarget getVerifyTarget(IConfigurationElement element) {
        VerifyTarget target = new VerifyTarget();
        String sType = element.getAttribute("style");
        target.setType(VerifyTargetType.getEnum(sType));
        int scene = 0;
        if ("true".equals(element.getAttribute("saveEnable"))) {
            ++scene;
        }
        if ("true".equals(element.getAttribute("createEnable"))) {
            scene += 2;
        }
        target.setScene(scene);
        return target;
    }
}

