/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.connection;

import com.kingdee.bos.metadata.management.DataSource;
import com.kingdee.bos.metadata.management.JdbcDriverType;
import com.kingdee.bos.tool.connection.IConnection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.internal.runtime.InternalPlatform;

public class DBConnection
implements IConnection,
Cloneable {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.connection.DBConnection");
    public static final String DBCONNECTION_GROUP_ID = "DBConnection";
    public static final String JDBC_DRIVER_TYPE = "jdbcdrivertype";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String DBName = "dbname";
    public static final String USER = "user";
    public static final String P = "password";
    private String name;
    private Map properties = new HashMap();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Object getValue(String propertyId) {
        return this.properties.get(propertyId);
    }

    @Override
    public void setValue(String propertyId, Object value) {
        this.properties.put(propertyId, value);
    }

    @Override
    public boolean connect() {
        JdbcDriverType type = null;
        Object obj = this.getValue(JDBC_DRIVER_TYPE);
        if (obj instanceof String) {
            type = JdbcDriverType.getEnum((String)((String)this.getValue(JDBC_DRIVER_TYPE)));
        } else if (obj instanceof JdbcDriverType) {
            type = (JdbcDriverType)obj;
        }
        String host = (String)this.getValue(HOST);
        int port = (Integer)this.getValue(PORT);
        String db = (String)this.getValue(DBName);
        String user = (String)this.getValue(USER);
        String password = (String)this.getValue(P);
        DataSource ds = new DataSource(type, host, port, db, user, password);
        return ds.connect();
    }

    @Override
    public Object getConnection() {
        JdbcDriverType type = null;
        Object obj = this.getValue(JDBC_DRIVER_TYPE);
        type = obj instanceof JdbcDriverType ? (JdbcDriverType)obj : JdbcDriverType.getEnum((String)obj.toString());
        String host = (String)this.getValue(HOST);
        int port = (Integer)this.getValue(PORT);
        String db = (String)this.getValue(DBName);
        String user = (String)this.getValue(USER);
        String password = (String)this.getValue(P);
        DataSource ds = new DataSource(type, host, port, db, user, password);
        try {
            return ds.getConnection();
        }
        catch (SQLException e) {
            logger.error((Object)"get connection:", (Throwable)e);
            return null;
        }
    }

    public Object getAdapter(Class adapter) {
        return InternalPlatform.getDefault().getAdapterManager().getAdapter((Object)this, adapter);
    }

    public Object clone() {
        DBConnection c = new DBConnection();
        c.setName(this.getName());
        c.setValue(JDBC_DRIVER_TYPE, this.getValue(JDBC_DRIVER_TYPE));
        c.setValue(HOST, this.getValue(HOST));
        c.setValue(PORT, new Integer((Integer)this.getValue(PORT)));
        c.setValue(DBName, this.getValue(DBName));
        c.setValue(USER, this.getValue(USER));
        c.setValue(P, this.getValue(P));
        return c;
    }

    @Override
    public void initValue() {
    }
}

