/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dao;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.context.ToolContextManager;
import com.kingdee.bos.tool.dao.ICommand;
import com.kingdee.bos.tool.dao.ORMStudioBridger;
import com.kingdee.util.StringUtils;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class CreatePackageCommand
implements ICommand {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.dao.CreatePackageCommand");
    private PackageInfo info;
    private IFolder folder;

    public CreatePackageCommand(IFolder fold, PackageInfo info) {
        this.info = info;
        this.folder = fold;
    }

    @Override
    public void exec(IProgressMonitor monitor) {
        try {
            this.innerCreatePackage(this.info, monitor);
        }
        catch (Exception e) {
            logger.error((Object)"createPackage error", (Throwable)e);
        }
    }

    private void innerCreatePackage(PackageInfo pInfo, IProgressMonitor monitor) throws IDEException {
        try {
            if (pInfo != null) {
                IFile file;
                IFolder folder;
                if (pInfo.getAlias() == null) {
                    pInfo.setAlias(pInfo.getName());
                }
                if (!(folder = this.getFolder(pInfo.getPackage())).exists()) {
                    this.createParentPackage(pInfo, monitor);
                    folder.create(true, true, monitor);
                }
                if (!(file = this.getFile(pInfo)).exists()) {
                    Context ctx = ToolContextManager.getContext(file.getProject()).getORMContext();
                    ContextManager.setContext((Context)ctx);
                    folder = ORMStudioBridger.getFolder((IResource)file);
                    ORMStudioBridger.store(folder, (IObjectValue)pInfo);
                }
            }
        }
        catch (CoreException ce) {
            throw new IDEException((Throwable)ce);
        }
    }

    private void createParentPackage(PackageInfo child, IProgressMonitor monitor) throws IDEException {
        int dot = child.getPackage().lastIndexOf(".");
        if (!StringUtils.isEmpty((String)child.getPackage())) {
            String name;
            String pkName;
            if (dot != -1) {
                name = pkName = child.getPackage().substring(0, dot);
                if (pkName.lastIndexOf(".") != -1) {
                    name = pkName.substring(pkName.lastIndexOf(".") + 1);
                }
            } else {
                pkName = "";
                name = "";
            }
            PackageInfo parent = new PackageInfo();
            parent.setPackage(pkName);
            parent.setName(name);
            this.innerCreatePackage(parent, monitor);
        }
    }

    private IFile getFile(PackageInfo pInfo) {
        String fileName = pInfo.getName();
        if (StringUtils.isEmpty((String)pInfo.getName())) {
            fileName = "default";
        }
        fileName = fileName + "." + "package";
        return this.getFolder(pInfo.getPackage()).getFile(fileName);
    }

    private IFolder getFolder(String pkName) {
        IFolder tfolder = this.folder;
        if (!StringUtils.isEmpty((String)pkName)) {
            StringTokenizer tokenizer = new StringTokenizer(pkName, ".");
            while (tokenizer.hasMoreElements()) {
                String token = (String)tokenizer.nextElement();
                tfolder = tfolder.getFolder(token);
            }
        }
        return tfolder;
    }
}

