/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dao.tableimpexp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.MissingMetaDataException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.IAbstractTableCtrl;
import com.kingdee.bos.metadata.management.ISolutionCtrl;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.management.application.MetaDataCollection;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.tool.dao.tableimpexp.DBTableLoader;
import com.kingdee.bos.tool.dao.tableimpexp.DBTableStore;
import com.kingdee.bos.tool.dao.tableimpexp.ImpExpErrorInfo;
import com.kingdee.bos.tool.dao.tableimpexp.TableImpExpMap;
import com.kingdee.bos.util.BOSObjectType;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class TableImpExpDAO {
    private static String multiLingualFlag = "_L";
    private final Context ctx;
    private Connection cn;
    private IAbstractTableCtrl dtCtrl = null;
    private SolutionInfo solution = null;

    public TableImpExpDAO(Context ctx, Connection cn) throws BOSException {
        this.ctx = ctx;
        this.cn = cn;
        this.dtCtrl = (IAbstractTableCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)MetaDataTypeList.ABSTRACTTABLE);
        ISolutionCtrl slnCtrl = (ISolutionCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)MetaDataTypeList.SOLUTION);
        this.solution = slnCtrl.getValue();
    }

    public ArrayList importTables(String packageName, Hashtable tables, ArrayList importTableList) {
        ArrayList errList = new ArrayList();
        if (importTableList == null) {
            TableImpExpDAO.addError(errList, "importTableList", "parameter importTableList can not be null");
            return errList;
        }
        Enumeration e = tables.keys();
        while (e.hasMoreElements()) {
            String srcTableName = (String)e.nextElement();
            String destTableName = (String)tables.get(srcTableName);
            try {
                this.importTable(packageName, destTableName, srcTableName, importTableList);
            }
            catch (Exception exc) {
                TableImpExpDAO.addError(errList, srcTableName, exc.getMessage());
            }
        }
        return errList;
    }

    public ArrayList exportTables(MetaDataCollection tables) {
        MetaDataInfo srcTable;
        int i;
        ArrayList errList = new ArrayList();
        int size = tables.size();
        for (i = 0; i < size; ++i) {
            srcTable = tables.get(i);
            try {
                this.exportTable(srcTable.getPackage(), srcTable.getName(), srcTable.getName());
                continue;
            }
            catch (Exception exc) {
                TableImpExpDAO.addError(errList, srcTable.getName(), exc.getMessage());
            }
        }
        size = tables.size();
        for (i = 0; i < size; ++i) {
            srcTable = tables.get(i);
            try {
                this.exportFKey(srcTable.getPackage(), srcTable.getName(), srcTable.getName());
                continue;
            }
            catch (Exception exc) {
                TableImpExpDAO.addError(errList, srcTable.getName(), exc.getMessage(), 1);
            }
        }
        return errList;
    }

    public ArrayList generateSQLScript(MetaDataCollection tables, TableImpExpMap tableImpExpMap) {
        MetaDataInfo srcTable;
        int i;
        ArrayList errList = new ArrayList();
        if (tableImpExpMap == null) {
            TableImpExpDAO.addError(errList, "tableImpExpMap", "parameter tableImpExpMap can not be null");
            return errList;
        }
        int size = tables.size();
        for (i = 0; i < size; ++i) {
            srcTable = tables.get(i);
            try {
                this.exportTable(srcTable.getPackage(), srcTable.getName(), srcTable.getName(), tableImpExpMap);
                continue;
            }
            catch (Exception exc) {
                TableImpExpDAO.addError(errList, srcTable.getName(), exc.getMessage());
            }
        }
        size = tables.size();
        for (i = 0; i < size; ++i) {
            srcTable = tables.get(i);
            try {
                this.exportFKey(srcTable.getPackage(), srcTable.getName(), srcTable.getName(), tableImpExpMap);
                continue;
            }
            catch (Exception exc) {
                TableImpExpDAO.addError(errList, srcTable.getName(), exc.getMessage(), 1);
            }
        }
        return errList;
    }

    private void importTable(String packageName, String destTableName, String srcTableName, ArrayList importTableList) throws SQLException, BOSException {
        DataTableInfo table = DBTableLoader.getTable(this.cn, packageName, srcTableName);
        table.setPackage(packageName);
        table.setName(destTableName);
        Hashtable<String, ColumnInfo> multiLingualCols = new Hashtable<String, ColumnInfo>();
        for (int i = 0; i < table.getColumns().size(); ++i) {
            ColumnInfo col = table.getColumns().get(i);
            int index = col.getName().indexOf(multiLingualFlag);
            if (index <= 0) continue;
            String colName = col.getName().substring(0, index);
            boolean find = false;
            for (int j = 0; j < table.getColumns().size(); ++j) {
                if (!table.getColumns().get(j).getName().equals(colName)) continue;
                multiLingualCols.put(col.getName(), col);
                find = true;
                break;
            }
            if (find) continue;
            col.setMultilingual(true);
            col.setName(colName);
        }
        Enumeration e = multiLingualCols.keys();
        while (e.hasMoreElements()) {
            String colName = (String)e.nextElement();
            table.getColumns().remove((ColumnInfo)multiLingualCols.get(colName));
        }
        importTableList.add(table);
    }

    private void exportTable(String packageName, String destTableName, String srcTableName) throws BOSException, SQLException {
        AbstractTableInfo table = this.dtCtrl.getValue((IMetaDataPK)new MetaDataPK(packageName, srcTableName));
        if (table == null) {
            throw new MissingMetaDataException("datatable not exist,packageName:" + packageName + "srcTableName:" + srcTableName);
        }
        if (this.cn == null) {
            throw new SQLException("Connection is null");
        }
        DBTableStore.store(this.cn, table, destTableName, this.solution);
    }

    private void exportTable(String packageName, String destTableName, String srcTableName, TableImpExpMap tableImpExpMap) throws BOSException, SQLException {
        AbstractTableInfo table = this.dtCtrl.getValue((IMetaDataPK)new MetaDataPK(packageName, srcTableName));
        if (table == null) {
            throw new MissingMetaDataException("datatable not exist,packageName:" + packageName + "srcTableName:" + srcTableName);
        }
        DBTableStore.store(table, destTableName, this.solution, tableImpExpMap);
    }

    private void exportFKey(String packageName, String destTableName, String srcTableName) throws SQLException, BOSException {
        AbstractTableInfo table = this.dtCtrl.getValue((IMetaDataPK)new MetaDataPK(packageName, srcTableName));
        if (table == null) {
            throw new MissingMetaDataException("datatable not exist,packageName:" + packageName + "srcTableName:" + srcTableName);
        }
        if (this.cn == null) {
            throw new SQLException("Connection is null");
        }
        DBTableStore.createFK(this.cn, table, destTableName);
    }

    private void exportFKey(String packageName, String destTableName, String srcTableName, TableImpExpMap tableImpExpMap) throws SQLException, BOSException {
        AbstractTableInfo table = this.dtCtrl.getValue((IMetaDataPK)new MetaDataPK(packageName, srcTableName));
        if (table == null) {
            throw new MissingMetaDataException("datatable not exist,packageName:" + packageName + "srcTableName:" + srcTableName);
        }
        DBTableStore.createFK(table, destTableName, tableImpExpMap);
        DBTableStore.dropFK(table, destTableName, tableImpExpMap);
    }

    private static void addError(ArrayList errList, String tableName, String errMsg) {
        errList.add(new ImpExpErrorInfo(tableName, errMsg));
    }

    private static void addError(ArrayList errList, String tableName, String errMsg, int type) {
        errList.add(new ImpExpErrorInfo(tableName, errMsg, type));
    }
}

