/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate;

import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.dbupdate.DBCreateIndexSql;
import com.kingdee.bos.tool.dbupdate.DBCreateTableSql;
import com.kingdee.bos.tool.dbupdate.DBCreateXmlRoot;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.DefaultJDOMFactory;
import org.jdom2.Document;
import org.jdom2.Element;

public class DBCreateXml {
    private static final String SEPARATOR = System.getProperty("file.separator");
    private List tableSqls = new ArrayList();
    private List indexSqls = new ArrayList();
    private String packageName;
    private String basicCode;

    public String getPackageName() {
        return this.packageName;
    }

    public String getBasicCode() {
        return this.basicCode;
    }

    public DBCreateXml(PackageInfo pInfo) {
        this.packageName = pInfo.getPackage();
        this.basicCode = pInfo.getBasicCode();
    }

    public DBCreateXml(String packageName) {
        this.packageName = packageName;
        this.basicCode = null;
    }

    public Collection getCreateTableSqls() {
        return this.tableSqls;
    }

    public Collection getCreateIndexSqls() {
        return this.tableSqls;
    }

    public DBCreateTableSql addCreateTableSql(DBCreateTableSql sql) {
        this.tableSqls.add(sql);
        return sql;
    }

    public void removeCreateTableSql(DBCreateTableSql sql) {
        this.tableSqls.remove(sql);
    }

    public DBCreateIndexSql addCreateIndexSql(DBCreateIndexSql sql) {
        this.indexSqls.add(sql);
        return sql;
    }

    public void removeCreateIndexSql(DBCreateIndexSql sql) {
        this.indexSqls.remove(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File create(String scriptPath) throws IOException {
        File file = null;
        if (this.tableSqls.size() > 0 || this.indexSqls.size() > 0) {
            File path = new File(this.getFilePath(scriptPath));
            if (!path.exists()) {
                path.mkdirs();
            }
            file = new File(this.getFilePath(scriptPath) + SEPARATOR + "create.xml");
            FileOutputStream ops = null;
            try {
                Element node;
                File subFile;
                ops = new FileOutputStream(file);
                DefaultJDOMFactory jdomFactory = new DefaultJDOMFactory();
                Element root = jdomFactory.element("System");
                jdomFactory.document(root);
                root.setAttribute("name", MetaDataUtils.getClassName((String)this.packageName));
                int n = this.tableSqls.size();
                for (int i = 0; i < n; ++i) {
                    DBCreateTableSql tableSql = (DBCreateTableSql)this.tableSqls.get(i);
                    subFile = tableSql.create(scriptPath);
                    if (subFile == null) continue;
                    node = jdomFactory.element("Table");
                    node.setText(tableSql.getRelativePath() + SEPARATOR + subFile.getName());
                    root.addContent((Content)node);
                }
                int n2 = this.indexSqls.size();
                for (int i = 0; i < n2; ++i) {
                    DBCreateIndexSql indexSql = (DBCreateIndexSql)this.indexSqls.get(i);
                    subFile = indexSql.create(scriptPath);
                    if (subFile != null) {
                        node = jdomFactory.element("Index");
                        node.setText(indexSql.getRelativePath() + SEPARATOR + subFile.getName());
                        root.addContent((Content)node);
                    }
                    if (indexSql.getMssqlIndexSql() != null && (subFile = indexSql.getMssqlIndexSql().create(scriptPath)) != null) {
                        node = jdomFactory.element("Index");
                        node.setAttribute("type", "sqlserver");
                        node.setText(indexSql.getRelativePath() + SEPARATOR + subFile.getName());
                        root.addContent((Content)node);
                    }
                    if (indexSql.getOracleIndexSql() != null && (subFile = indexSql.getOracleIndexSql().create(scriptPath)) != null) {
                        node = jdomFactory.element("Index");
                        node.setAttribute("type", "oracle");
                        node.setText(indexSql.getRelativePath() + SEPARATOR + subFile.getName());
                        root.addContent((Content)node);
                    }
                    if (indexSql.getDb2IndexSql() != null && (subFile = indexSql.getDb2IndexSql().create(scriptPath)) != null) {
                        node = jdomFactory.element("Index");
                        node.setAttribute("type", "db2");
                        node.setText(indexSql.getRelativePath() + SEPARATOR + subFile.getName());
                        root.addContent((Content)node);
                    }
                    if (indexSql.getSybaseIndexSql() == null || (subFile = indexSql.getSybaseIndexSql().create(scriptPath)) == null) continue;
                    node = jdomFactory.element("Index");
                    node.setAttribute("type", "Sybase");
                    node.setText(indexSql.getRelativePath() + SEPARATOR + subFile.getName());
                    root.addContent((Content)node);
                }
                XmlUtils.output((Document)root.getDocument(), (OutputStream)ops);
            }
            catch (Throwable throwable) {
                FileUtils.close(ops);
                throw throwable;
            }
            FileUtils.close(ops);
        }
        return file;
    }

    public String getFilePath(String scriptPath) {
        String path = scriptPath + SEPARATOR + this.getRelativePath();
        return path;
    }

    public String getRelativePath() {
        String path = DBCreateXmlRoot.PATH_PERFIX + SEPARATOR + MetaDataUtils.getClassName((String)this.packageName);
        return path;
    }
}

