/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.kdbtools;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.PKColumnInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.bos.tool.dbupdate.kdbtools.DB2DAOUtil;
import com.kingdee.bos.tool.dbupdate.kdbtools.DmDAOUtil;
import com.kingdee.bos.tool.dbupdate.kdbtools.KDBSchema;
import com.kingdee.bos.tool.dbupdate.kdbtools.KDBUtils;
import com.kingdee.bos.tool.dbupdate.kdbtools.KingbaseDAOUtil;
import com.kingdee.bos.tool.dbupdate.kdbtools.OracleDAOUtil;
import com.kingdee.bos.tool.dbupdate.kdbtools.PostgresSqlDAOUtil;
import com.kingdee.bos.tool.dbupdate.kdbtools.SqlServerDAOUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Vector;

public class KDBSchemaDAO {
    public static AbstractTableInfo[] getAllTables(Connection cn) throws SQLException {
        ResultSet rs = null;
        Vector<String> vector = new Vector<String>(0);
        try {
            rs = DBUtils.isOracle(DBUtils.getDbType(cn)) ? cn.getMetaData().getTables(null, KSqlUtil.getOracleCurrentUser((Connection)cn), null, new String[]{"TABLE"}) : cn.getMetaData().getTables(null, null, null, new String[]{"TABLE"});
            while (rs.next()) {
                vector.addElement(rs.getString("TABLE_NAME"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs);
        Collections.sort(vector);
        int len = vector.size();
        AbstractTableInfo[] oldTables = new AbstractTableInfo[len];
        for (int i = 0; i < len; ++i) {
            String tableName = (String)vector.elementAt(i);
            oldTables[i] = KDBSchemaDAO.getTable(cn, tableName);
        }
        return oldTables;
    }

    public static AbstractTableInfo[] getTables(Connection cn, AbstractTableInfo[] newTables) throws SQLException {
        int len = newTables.length;
        AbstractTableInfo[] oldTables = new AbstractTableInfo[len];
        for (int i = 0; i < len; ++i) {
            String oldTableName = "";
            oldTableName = newTables[i].getOldTableName() != null ? newTables[i].getOldTableName() : newTables[i].getName();
            oldTables[i] = KDBSchemaDAO.getTable(cn, oldTableName);
        }
        return oldTables;
    }

    public static AbstractTableInfo getTable(Connection cn, String tableName) throws SQLException {
        if (!KDBUtils.isTableExists(cn, tableName)) {
            return null;
        }
        int type = DBUtils.getDbType(cn);
        if (DBUtils.isDB2(type)) {
            if (cn instanceof KDConnection) {
                cn = ((KDConnection)cn).getNativeConnection();
            }
            return DB2DAOUtil.getTable(cn, tableName);
        }
        if (DBUtils.isOracle(type)) {
            if (cn instanceof KDConnection) {
                cn = ((KDConnection)cn).getNativeConnection();
            }
            return OracleDAOUtil.getTable(cn, tableName);
        }
        if (DBUtils.isMSSQL(type)) {
            if (cn instanceof KDConnection) {
                cn = ((KDConnection)cn).getNativeConnection();
            }
            return SqlServerDAOUtil.getTable(cn, tableName);
        }
        if (DBUtils.isPostgresSql(type)) {
            if (cn instanceof KDConnection) {
                cn = ((KDConnection)cn).getNativeConnection();
            }
            return PostgresSqlDAOUtil.getTable(cn, tableName.toLowerCase());
        }
        if (DBUtils.isDM(type)) {
            if (cn instanceof KDConnection) {
                cn = ((KDConnection)cn).getNativeConnection();
            }
            return DmDAOUtil.getTable(cn, tableName.toLowerCase());
        }
        if (DBUtils.isKingbase(type)) {
            if (cn instanceof KDConnection) {
                cn = ((KDConnection)cn).getNativeConnection();
            }
            return KingbaseDAOUtil.getTable(cn, tableName.toLowerCase());
        }
        return KDBSchemaDAO.innerGetTable(cn, tableName);
    }

    public static void adjustTables(Connection cn, AbstractTableInfo[] tables) throws SQLException {
        int type = DBUtils.getDbType(cn);
        if (DBUtils.isDB2(type)) {
            if (cn instanceof KDConnection) {
                cn = ((KDConnection)cn).getNativeConnection();
            }
            DB2DAOUtil.adjustTables(cn, tables);
        } else if (DBUtils.isOracle(type)) {
            if (cn instanceof KDConnection) {
                cn = ((KDConnection)cn).getNativeConnection();
            }
            OracleDAOUtil.adjustTables(cn, tables);
        } else if (DBUtils.isMSSQL(type)) {
            if (cn instanceof KDConnection) {
                cn = ((KDConnection)cn).getNativeConnection();
            }
            SqlServerDAOUtil.adjustTables(cn, tables);
        } else if (DBUtils.isPostgresSql(type)) {
            if (cn instanceof KDConnection) {
                cn = ((KDConnection)cn).getNativeConnection();
            }
            PostgresSqlDAOUtil.adjustTables(cn, tables);
        } else {
            if (cn instanceof KDConnection) {
                cn = ((KDConnection)cn).getNativeConnection();
            }
            SqlServerDAOUtil.adjustTables(cn, tables);
        }
        for (int i = 0; i < tables.length; ++i) {
            KDBSchema.adjustTable(type, tables[i]);
        }
    }

    public static AbstractTableInfo innerGetTable(Connection cn, String tableName) throws SQLException {
        String fkName;
        ResultSet rs = null;
        AbstractTableInfo table = new AbstractTableInfo();
        tableName = 5 == DBUtils.getDbType(cn) ? tableName.toLowerCase() : tableName.toUpperCase();
        table.setName(tableName);
        try {
            rs = cn.getMetaData().getColumns(null, null, tableName, null);
            while (rs.next()) {
                ColumnInfo col = new ColumnInfo();
                col.setName(rs.getString("COLUMN_NAME"));
                short dataType = rs.getShort("DATA_TYPE");
                SQLType sqlType = KDBUtils.getSQLType(dataType);
                if (sqlType == null) {
                    throw new SQLException("unexcept data type:" + rs.getString("TYPE_NAME") + " in col:" + col.getName());
                }
                col.setTypeName(sqlType);
                col.setDefaultValue(rs.getString("COLUMN_DEF"));
                col.setLength(rs.getInt("COLUMN_SIZE"));
                col.setNullable(rs.getInt("NULLABLE") == 1);
                col.setPrecision(rs.getInt("COLUMN_SIZE"));
                col.setScale(rs.getInt("DECIMAL_DIGITS"));
                table.getColumns().add(col);
            }
            SQLUtils.cleanup((ResultSet)rs);
            rs = cn.getMetaData().getPrimaryKeys(null, null, tableName);
            if (rs.next()) {
                PrimaryKeyInfo pk = new PrimaryKeyInfo();
                pk.setName(rs.getString("PK_NAME"));
                table.setPrimaryKey(pk);
                ColumnInfo col = KDBUtils.getColumnByName(table, rs.getString("COLUMN_NAME"));
                PKColumnInfo pkcol = new PKColumnInfo();
                pkcol.setColumn(col);
                pk.getPKColumns().add(pkcol);
                while (rs.next()) {
                    col = KDBUtils.getColumnByName(table, rs.getString("COLUMN_NAME"));
                    pkcol = new PKColumnInfo();
                    pkcol.setColumn(col);
                    pk.getPKColumns().add(pkcol);
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            rs = cn.getMetaData().getIndexInfo(null, null, tableName, false, true);
            KDBUtils.fillIndex(rs, table);
            SQLUtils.cleanup((ResultSet)rs);
            rs = cn.getMetaData().getImportedKeys(null, null, tableName);
            while (rs.next()) {
                fkName = rs.getString("FK_NAME");
                ForeignKeyInfo fk = null;
                for (int i = 0; i < table.getForeignKeys().size(); ++i) {
                    if (!table.getForeignKeys().get(i).getName().equals(fkName)) continue;
                    fk = table.getForeignKeys().get(i);
                    break;
                }
                if (fk == null) {
                    fk = new ForeignKeyInfo();
                    AbstractTableInfo refTable = new AbstractTableInfo();
                    refTable.setName(rs.getString("PKTABLE_NAME"));
                    fk.setRefTable(refTable);
                    fk.setName(fkName);
                    table.getForeignKeys().add(fk);
                }
                FKColumnPairInfo fkcol = new FKColumnPairInfo();
                fkcol.setForeignKeyColumn(KDBUtils.getColumnByName(table, rs.getString("FKCOLUMN_NAME")));
                ColumnInfo pkcolumn = new ColumnInfo();
                pkcolumn.setName(rs.getString("PKCOLUMN_NAME"));
                fkcol.setPrimaryKeyColumn(pkcolumn);
                fk.getFKColumnPairs().add(fkcol);
            }
            SQLUtils.cleanup((ResultSet)rs);
            fkName = table;
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return fkName;
    }
}

