/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.ui.wizard;

import com.kingdee.bos.metadata.management.DataSource;
import com.kingdee.bos.metadata.management.JdbcDriverType;
import com.kingdee.bos.tool.dbupdate.data.DBCompareInfo;
import com.kingdee.bos.tool.dbupdate.ui.DBSynchronizerMessages;
import com.kingdee.bos.tool.dbupdate.ui.wizard.BaseWizardPage;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectTargetDB
extends BaseWizardPage {
    protected Text host;
    protected Text port;
    protected Text dbName;
    protected Text user;
    protected Text pw;
    protected Button btn_Test;
    protected Combo driverType;
    protected boolean connectSuccussfully = false;

    public SelectTargetDB(DBCompareInfo model) {
        super(DBSynchronizerMessages.SelectTargetDB);
        this.setTitle(DBSynchronizerMessages.SelectTargetDB);
        this.model = model;
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 10;
        container.setLayout((Layout)layout);
        this.layoutDataSource(container);
        this.initOptions();
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            // empty if block
        }
        this.verifyFinish();
    }

    private void initOptions() {
        if (this.model.getTargetDB().getHost() != null) {
            this.host.setText(this.model.getTargetDB().getHost());
        } else {
            this.host.setText("");
        }
        this.port.setText(String.valueOf(this.model.getTargetDB().getPort()));
        if (this.model.getTargetDB().getDbName() != null) {
            this.dbName.setText(this.model.getTargetDB().getDbName());
        } else {
            this.dbName.setText("");
        }
        if (this.model.getTargetDB().getUser() != null) {
            this.user.setText(this.model.getTargetDB().getUser());
        } else {
            this.user.setText("");
        }
        if (this.model.getTargetDB().getPassword() != null) {
            this.pw.setText(this.model.getTargetDB().getPassword());
        } else {
            this.pw.setText("");
        }
        if (this.model.getTargetDB().getDriverType().equals((Object)JdbcDriverType.ORACLE_THIN_DRIVER)) {
            this.driverType.select(1);
        } else if (this.model.getTargetDB().getDriverType().equals((Object)JdbcDriverType.IBM_DB2_NET_DRIVER)) {
            this.driverType.select(2);
        } else {
            this.driverType.select(0);
        }
        this.setToDSEnable(true);
    }

    private void setToDSEnable(boolean b) {
        this.btn_Test.setEnabled(b);
        this.host.setEnabled(b);
        this.port.setEnabled(b);
        this.pw.setEnabled(b);
        this.user.setEnabled(b);
        this.dbName.setEnabled(b);
        this.driverType.setEnabled(b);
    }

    private void layoutDataSource(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 6;
        layout.horizontalSpacing = 10;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        new Label((Composite)group, 0).setText(DBSynchronizerMessages.Driver);
        this.driverType = new Combo((Composite)group, 2056);
        this.driverType.setItems(new String[]{JdbcDriverType.MS_SQL_SERVER_DRIVER.getName(), JdbcDriverType.ORACLE_THIN_DRIVER.getName(), JdbcDriverType.IBM_DB2_NET_DRIVER.getName()});
        this.driverType.setLayoutData((Object)new GridData(768));
        new Label((Composite)group, 0).setText(DBSynchronizerMessages.Host);
        this.host = new Text((Composite)group, 2048);
        this.host.setLayoutData((Object)new GridData(256));
        new Label((Composite)group, 0).setText(DBSynchronizerMessages.Port);
        this.port = new Text((Composite)group, 2048);
        this.port.setLayoutData((Object)new GridData(256));
        new Label((Composite)group, 0).setText(DBSynchronizerMessages.DBName);
        this.dbName = new Text((Composite)group, 2048);
        this.dbName.setLayoutData((Object)new GridData(256));
        new Label((Composite)group, 0).setText(DBSynchronizerMessages.User);
        this.user = new Text((Composite)group, 2048);
        this.user.setLayoutData((Object)new GridData(256));
        new Label((Composite)group, 0).setText(DBSynchronizerMessages.PassWord);
        this.pw = new Text((Composite)group, 2048);
        this.pw.setEchoChar('*');
        this.pw.setLayoutData((Object)new GridData(256));
        new Label((Composite)group, 0);
        this.btn_Test = new Button((Composite)group, 8);
        this.btn_Test.setText(DBSynchronizerMessages.TestConnection);
        this.btn_Test.setLayoutData((Object)new GridData(128));
        TextModifyListener textModifyListener = new TextModifyListener();
        this.host.addModifyListener((ModifyListener)textModifyListener);
        this.port.addModifyListener((ModifyListener)textModifyListener);
        this.dbName.addModifyListener((ModifyListener)textModifyListener);
        this.user.addModifyListener((ModifyListener)textModifyListener);
        this.pw.addModifyListener((ModifyListener)textModifyListener);
        ButtonSelectionListener listener = new ButtonSelectionListener();
        this.btn_Test.addSelectionListener((SelectionListener)listener);
        this.driverType.addSelectionListener((SelectionListener)listener);
    }

    protected void performFinish(IProgressMonitor monitor) throws InterruptedException, BaseException {
    }

    private void verifyFinish() {
        if (!this.connectSuccussfully) {
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private class ButtonSelectionListener
    extends SelectionAdapter {
        private ButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource().equals(SelectTargetDB.this.driverType) && !SelectTargetDB.this.model.getTargetDB().getDriverType().equals((Object)JdbcDriverType.getEnum((String)SelectTargetDB.this.driverType.getText()))) {
                SelectTargetDB.this.model.getTargetDB().setDriverType(JdbcDriverType.getEnum((String)SelectTargetDB.this.driverType.getText()));
                SelectTargetDB.this.connectSuccussfully = false;
                SelectTargetDB.this.verifyFinish();
            }
            if (e.getSource().equals(SelectTargetDB.this.btn_Test)) {
                BusyIndicator.showWhile((Display)SelectTargetDB.this.getShell().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SelectTargetDB.this.connectSuccussfully = new DataSource(SelectTargetDB.this.model.getTargetDB()).connect();
                        if (!SelectTargetDB.this.connectSuccussfully) {
                            SelectTargetDB.this.showConnectWarning();
                        }
                        SelectTargetDB.this.verifyFinish();
                    }
                });
            }
        }
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            SelectTargetDB.this.connectSuccussfully = false;
            if (e.getSource().equals(SelectTargetDB.this.host)) {
                SelectTargetDB.this.model.getTargetDB().setHost(SelectTargetDB.this.host.getText());
            } else if (e.getSource().equals(SelectTargetDB.this.port)) {
                if (!StringUtils.isEmpty((String)SelectTargetDB.this.port.getText())) {
                    SelectTargetDB.this.model.getTargetDB().setPort(new Integer(SelectTargetDB.this.port.getText()).intValue());
                }
            } else if (e.getSource().equals(SelectTargetDB.this.dbName)) {
                SelectTargetDB.this.model.getTargetDB().setDbName(SelectTargetDB.this.dbName.getText());
            } else if (e.getSource().equals(SelectTargetDB.this.user)) {
                SelectTargetDB.this.model.getTargetDB().setUser(SelectTargetDB.this.user.getText());
            } else if (e.getSource().equals(SelectTargetDB.this.pw)) {
                SelectTargetDB.this.model.getTargetDB().setPassword(SelectTargetDB.this.pw.getText());
            }
            SelectTargetDB.this.verifyFinish();
        }
    }
}

