/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.function;

import com.kingdee.bos.tool.function.Func;
import com.kingdee.bos.tool.function.ToolRuntimeException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class DynamicBindContext {
    public static final String DIFF = "diff";
    public static final String DEFAULT_OUTPUT = "default_output";
    public static final String DEFAULT_INPUT = "default_input";
    public static final String BIM_DOWNLOAD_CACHE = "bim_download_cache";
    private static Map<String, Object> map = new HashMap<String, Object>();
    private static Map<String, Object> ext = new HashMap<String, Object>();

    private static void clearExtMap() {
        ext.clear();
    }

    public static Object getBindContextVariable(String key) {
        if (ext.containsKey(key)) {
            return ext.get(key);
        }
        return map.get(key);
    }

    public static void changeDownloadCacheDir(Object newPath) {
        if (ext.containsKey(BIM_DOWNLOAD_CACHE)) {
            ext.put(BIM_DOWNLOAD_CACHE, newPath);
        }
        map.put(BIM_DOWNLOAD_CACHE, newPath);
    }

    public static <T> T bind(Map<String, Object> extVariables, Func<T> run) {
        DynamicBindContext.clearExtMap();
        try {
            ext.putAll(extVariables);
            T t = run.invoke();
            return t;
        }
        catch (Exception e) {
            throw ToolRuntimeException.createToolRuntimeException(e);
        }
        finally {
            DynamicBindContext.clearExtMap();
        }
    }

    public static <T> T bindDebug(Func<T> run) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("debug", true);
        return DynamicBindContext.bind(map, run);
    }

    public static void main(String[] args) {
        System.out.println(DynamicBindContext.getBindContextVariable(BIM_DOWNLOAD_CACHE));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(BIM_DOWNLOAD_CACHE, "w:/server/cache");
        DynamicBindContext.bind(map, new Func<Void>(){

            @Override
            public Void invoke() {
                System.out.println(DynamicBindContext.getBindContextVariable(DynamicBindContext.BIM_DOWNLOAD_CACHE));
                return null;
            }
        });
        System.out.println(DynamicBindContext.getBindContextVariable(BIM_DOWNLOAD_CACHE));
    }

    static {
        map.put(BIM_DOWNLOAD_CACHE, "d:/bim-download-cache");
        map.put(DIFF, DIFF);
        map.put(DEFAULT_INPUT, System.in);
        map.put(DEFAULT_OUTPUT, System.out);
        map.put("debug", false);
        File localFile = new File(map.get(BIM_DOWNLOAD_CACHE).toString());
        boolean hasD = true;
        if (!localFile.exists()) {
            hasD = localFile.mkdirs();
        }
        if (!hasD) {
            map.put(BIM_DOWNLOAD_CACHE, "c:/bim-download-cache");
        }
    }
}

