/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.function;

import com.kingdee.bos.tool.function.Preconditions;
import java.util.List;

public class Strings {
    public static String format(String template, Object ... args) {
        return Preconditions.format(template, args);
    }

    public static String nullAsEmpty(String str) {
        return str == null ? "" : str;
    }

    public static String join(String str, String joinStr) {
        Preconditions.checkNotNull(str, "\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkNotNull(joinStr, "\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        return str + joinStr;
    }

    public static String join(String[] strs, String joinStr) {
        Preconditions.checkNotNull(strs, "\u5b57\u7b26\u4e32\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkNotNull(joinStr, "\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        if (joinStr.length() == 0) {
            return Strings.join(strs);
        }
        StringBuffer buf = new StringBuffer();
        for (String str : strs) {
            buf.append(str == null ? "" : str).append(joinStr);
        }
        return buf.substring(0, buf.length() - joinStr.length());
    }

    public static String join(List<String> list, String joinStr) {
        Preconditions.checkNotNull(list, "\u5b57\u7b26\u4e32\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkNotNull(joinStr, "\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        return Strings.join(list.toArray(new String[0]), joinStr);
    }

    public static String join(String[] strs) {
        Preconditions.checkNotNull(strs, "\u5b57\u7b26\u4e32\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        StringBuffer buf = new StringBuffer();
        for (String str : strs) {
            buf.append(str);
        }
        return buf.toString();
    }

    public static String dropLastChar(String str) {
        Preconditions.checkNotNull(str, "\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        if (str.length() == 0) {
            return str;
        }
        return str.substring(0, str.length() - 1);
    }

    public static String dropLastCharIf(String str, char c) {
        Preconditions.checkNotNull(str, "\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        if (str.length() == 0) {
            return str;
        }
        if (str.charAt(str.length() - 1) == c) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String dropFirstChar(String str) {
        Preconditions.checkNotNull(str, "\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        if (str.length() == 0) {
            return str;
        }
        return str.substring(1, str.length());
    }

    public static String dropFirstCharIf(String str, char c) {
        Preconditions.checkNotNull(str, "\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        if (str.length() == 0) {
            return str;
        }
        if (str.charAt(0) == c) {
            return str.substring(1, str.length());
        }
        return str;
    }

    public static void main(String[] args) {
        String[] strs = new String[]{"aa", "bb1", "cc456"};
        System.out.println(Strings.join(strs, "$"));
        System.out.println(Strings.dropLastChar("1234*").length());
        System.out.println(Strings.dropFirstCharIf("\\server/ab.jar", '\\'));
        System.out.println(Strings.dropLastCharIf("\\server/ab.jar#", '#'));
    }
}

