/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.md.multipageeditor.IMDSourceEditor;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.dao.ObjectValueHelper;
import com.kingdee.bos.tool.multipageeditor.AbstractPageSection;
import com.kingdee.bos.tool.multipageeditor.BasePage;
import com.kingdee.bos.tool.multipageeditor.ExceptionHandler;
import com.kingdee.bos.tool.multipageeditor.IObjectValueContainer;
import com.kingdee.bos.util.BOSObjectType;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public abstract class BasePageSection
extends AbstractPageSection {
    protected Hashtable bindedInEditor = new Hashtable();
    protected Hashtable bindedInContext = new Hashtable();
    protected HashMap bindedDataTypesInContext = new HashMap();
    protected ArrayList readonlyControls = new ArrayList();
    protected static final String EXTENDED_KEY = "EXTENDED";
    protected IObjectValueContainer contextContainer;
    private FocusListener focusListener = new InnerFocusListener();
    private SelectionListener selectionListener = new InnerSelectionAdapter();

    public BasePageSection(BasePage page, String title, String desc) {
        super(page, title, desc);
    }

    public void setContextContainer(IObjectValueContainer container) {
        this.contextContainer = container;
    }

    protected void bindText(Text control, String key) {
        this.bind((Control)control, key, false);
    }

    protected void bindText(Text control, String key, boolean readonly) {
        this.bind((Control)control, key, readonly);
    }

    protected void bindCheckBox(Button checkbox, String key) {
        this.bind((Control)checkbox, key, false);
    }

    protected void bindCheckBox(Button checkbox, String key, boolean readonly) {
        this.bind((Control)checkbox, key, readonly);
    }

    protected void bindCCombo(CCombo ccombo, String key, String[] labels) {
        Object[] possibleValues = new Object[labels.length];
        System.arraycopy(labels, 0, possibleValues, 0, labels.length);
        this.bindCCombo(ccombo, key, labels, possibleValues);
    }

    protected void bindCCombo(CCombo ccombo, String key, String[] labels, boolean readonly) {
        Object[] possibleValues = new Object[labels.length];
        System.arraycopy(labels, 0, possibleValues, 0, labels.length);
        this.bindCCombo(ccombo, key, labels, possibleValues, readonly);
    }

    protected void bindCCombo(CCombo ccombo, String key, String[] labels, Object[] possibleValues) {
        this.bind((Control)ccombo, new GroupInfo(key, labels, possibleValues), false);
    }

    protected void bindCCombo(CCombo ccombo, String key, String[] labels, Object[] possibleValues, boolean readonly) {
        this.bind((Control)ccombo, new GroupInfo(key, labels, possibleValues), readonly);
    }

    protected void bindGroup(Group group, String key, Button[] buttons, Object[] possibleValues) {
        this.bind((Control)group, new GroupInfo(key, buttons, possibleValues), false);
    }

    protected void bindGroup(Group group, String key, Button[] buttons, Object[] possibleValues, boolean readonly) {
        this.bind((Control)group, new GroupInfo(key, buttons, possibleValues), readonly);
    }

    private void bind(Control control, Object modelKey, boolean readonly) {
        this.bindedInEditor.put(control, modelKey);
        this.addListeners(control, modelKey, readonly);
    }

    protected boolean isBinded(Control control) {
        return this.bindedInEditor.containsKey(control);
    }

    protected Object getBindedKey(Control control) {
        if (!this.isBinded(control)) {
            return null;
        }
        return this.bindedInEditor.get(control);
    }

    protected void bindTextInContext(Text control, String key) {
        this.bindInContext((Control)control, key, null, false);
    }

    protected void bindTextInContext(Text control, String key, boolean readonly) {
        this.bindInContext((Control)control, key, null, readonly);
    }

    protected void bindTextInContext(Text control, String key, BOSObjectType[] dataTypes, boolean readonly) {
        this.bindInContext((Control)control, key, dataTypes, readonly);
    }

    protected void bindCheckBoxInContext(Button checkbox, String key) {
        this.bindInContext((Control)checkbox, key, null, false);
    }

    protected void bindCheckBoxInContext(Button checkbox, String key, boolean readonly) {
        this.bindInContext((Control)checkbox, key, null, readonly);
    }

    protected void bindCComboInContext(CCombo ccombo, String key, String[] labels) {
        Object[] possibleValues = new String[labels.length];
        System.arraycopy(labels, 0, possibleValues, 0, labels.length);
        this.bindInContext((Control)ccombo, new GroupInfo(key, labels, possibleValues), null, false);
    }

    protected void bindCComboInContext(CCombo ccombo, String key, String[] labels, Integer[] values) {
        this.bindInContext((Control)ccombo, new GroupInfo(key, labels, values), null, false);
    }

    protected void bindCComboInContext(CCombo ccombo, String key, String[] labels, boolean readonly) {
        Object[] possibleValues = new String[labels.length];
        System.arraycopy(labels, 0, possibleValues, 0, labels.length);
        this.bindInContext((Control)ccombo, new GroupInfo(key, labels, possibleValues), null, readonly);
    }

    protected void bindCComboInContext(CCombo ccombo, String key, String[] labels, Object[] possibleValues) {
        this.bindInContext((Control)ccombo, new GroupInfo(key, labels, possibleValues), null, false);
    }

    protected void bindCComboInContext(CCombo ccombo, String key, String[] labels, Object[] possibleValues, boolean readonly) {
        this.bindInContext((Control)ccombo, new GroupInfo(key, labels, possibleValues), null, readonly);
    }

    protected void bindCComboInContext(CCombo ccombo, String key, String[] labels, Object[] possibleValues, BOSObjectType[] types, boolean readonly) {
        this.bindInContext((Control)ccombo, new GroupInfo(key, labels, possibleValues), types, readonly);
    }

    protected void bindGroupInContext(Group group, String key, Button[] buttons, Object[] possibleValues) {
        this.bindInContext((Control)group, new GroupInfo(key, buttons, possibleValues), null, false);
    }

    protected void bindGroupInContext(Group group, String key, Button[] buttons, Object[] possibleValues, boolean readonly) {
        this.bindInContext((Control)group, new GroupInfo(key, buttons, possibleValues), null, readonly);
    }

    protected void bindInContext(Control control, Object key, BOSObjectType[] dataTypes, boolean readonly) {
        this.bindedInContext.put(control, key);
        this.bindedDataTypesInContext.put(control, dataTypes);
        this.addListeners(control, key, readonly);
    }

    protected boolean isBindedInContext(Control control) {
        return this.bindedInContext.containsKey(control);
    }

    protected Object getBindedKeyInContext(Control control) {
        return this.bindedInContext.get(control);
    }

    protected BOSObjectType[] getBindedTypeInContext(Control control) {
        return (BOSObjectType[])this.bindedDataTypesInContext.get(control);
    }

    private void addListeners(Control control, Object modelKey, boolean readonly) {
        if (modelKey instanceof GroupInfo) {
            for (int i = 0; i < ((GroupInfo)modelKey).orders.length; ++i) {
                Object obj = ((GroupInfo)modelKey).orders[i];
                if (control instanceof CCombo) {
                    ((CCombo)control).add((String)obj);
                    continue;
                }
                if (!(control instanceof Group)) continue;
                Button btn = (Button)obj;
                btn.addSelectionListener(this.selectionListener);
                if (!readonly) continue;
                btn.setEnabled(false);
                this.readonlyControls.add(btn);
            }
            if (control instanceof CCombo) {
                if ((((CCombo)control).getStyle() & 8) != 0) {
                    ((CCombo)control).addSelectionListener(this.selectionListener);
                } else {
                    ((CCombo)control).addFocusListener(this.focusListener);
                }
                if (readonly) {
                    ((CCombo)control).setEnabled(false);
                    this.readonlyControls.add(control);
                }
            }
            if (readonly) {
                this.getEditor().setReadOnlyKey(((GroupInfo)modelKey).key);
            }
        } else if (control instanceof Button && (control.getStyle() & 0x20) != 0) {
            ((Button)control).addSelectionListener(this.selectionListener);
            if (readonly) {
                this.getEditor().setReadOnlyKey((String)modelKey);
                control.setEnabled(false);
                this.readonlyControls.add(control);
            }
        } else {
            control.addFocusListener(this.focusListener);
            if (readonly) {
                this.getEditor().setReadOnlyKey((String)modelKey);
                control.setEnabled(false);
                this.readonlyControls.add(control);
            }
        }
    }

    protected void bindedControlFocusLost(FocusEvent e) {
        try {
            Control control = (Control)e.getSource();
            if (this.isBinded(control)) {
                Object key = this.getBindedKey(control);
                this.refreshModel(control, this.getModel(), key, null);
            } else if (this.isBindedInContext(control)) {
                Object key = this.getBindedKeyInContext(control);
                if (this.contextContainer.getObjectValue() instanceof PropertyInfo && "name".equals(key)) {
                    PropertyInfo propertyInfo = (PropertyInfo)this.contextContainer.getObjectValue();
                    if (!((Text)control).getText().equals(propertyInfo.getName())) {
                        propertyInfo.setName(((Text)control).getText());
                        this.getEditor().setNeedSync(true);
                        this.getEditor().setModify(true);
                    }
                } else {
                    this.refreshModel(control, this.contextContainer.getObjectValue(), key, this.getBindedTypeInContext(control));
                }
            }
        }
        catch (IDEException se) {
            ExceptionHandler.showException(se);
        }
    }

    protected void bindedControlSelected(SelectionEvent e) {
        try {
            Control control = (Control)e.getSource();
            if (control instanceof CCombo) {
                if (this.isBinded(control)) {
                    Object key = this.getBindedKey(control);
                    this.refreshModel(control, this.getModel(), key, null);
                } else if (this.isBindedInContext(control)) {
                    Object key = this.getBindedKeyInContext(control);
                    this.refreshModel(control, this.contextContainer.getObjectValue(), key, this.getBindedTypeInContext(control));
                }
            } else if (control instanceof Button) {
                if ((control.getStyle() & 0x20) != 0) {
                    if (this.isBinded(control)) {
                        Object key = this.getBindedKey(control);
                        this.refreshModel(control, this.getModel(), key, null);
                    } else if (this.isBindedInContext(control)) {
                        Object key = this.getBindedKeyInContext(control);
                        this.refreshModel(control, this.contextContainer.getObjectValue(), key, this.getBindedTypeInContext(control));
                    }
                } else {
                    Button button = (Button)e.getSource();
                    Group group = (Group)button.getParent();
                    if (this.isBinded((Control)group)) {
                        Object key = this.getBindedKey((Control)group);
                        this.refreshModel((Control)group, this.getModel(), key, null);
                    } else if (this.isBindedInContext((Control)group)) {
                        Object key = this.getBindedKeyInContext((Control)group);
                        this.refreshModel((Control)group, this.contextContainer.getObjectValue(), key, this.getBindedTypeInContext(control));
                    }
                }
            }
        }
        catch (IDEException se) {
            ExceptionHandler.showException(se);
        }
    }

    private void refreshModel(Control control, IObjectValue model, Object key, BOSObjectType[] types) throws IDEException {
        if (model != null && control != null && Boolean.TRUE.equals(control.getData(EXTENDED_KEY))) {
            String value = null;
            String vKey = null;
            if (control instanceof Text) {
                value = ((Text)control).getText();
                vKey = (String)key;
            } else if (control instanceof CCombo) {
                value = ((CCombo)control).getText();
                vKey = ((GroupInfo)key).getKey();
            } else if (control instanceof Button) {
                value = String.valueOf(((Button)control).getSelection());
                vKey = (String)key;
            } else if (control instanceof Group) {
                GroupInfo info = (GroupInfo)key;
                Enumeration enu = info.labels.keys();
                while (enu.hasMoreElements()) {
                    Button btn = (Button)enu.nextElement();
                    if (!btn.getSelection()) continue;
                    value = String.valueOf(info.labels.get(btn));
                    break;
                }
                vKey = info.getKey();
            }
            String oldValue = model.getExtendedProperty(vKey);
            if (value == null ? oldValue == null : value.equals(oldValue)) {
                return;
            }
            model.setExtendedProperty(vKey, value);
            this.getEditor().setModify(true);
            return;
        }
        if (control instanceof Text) {
            String oldValue;
            String value = ((Text)control).getText();
            if (!value.equals((oldValue = ObjectValueHelper.getStringFromModel(model, (String)key)) == null ? "" : oldValue)) {
                IMDSourceEditor editor = this.getEditor();
                ObjectValueHelper.setObjectIntoModel(model, (String)key, types, (Object)value, editor.getMDProject());
                editor.setNeedSync(true);
                editor.setModify(true);
            }
        } else if (control instanceof CCombo) {
            Object oldValue;
            GroupInfo info = (GroupInfo)key;
            String value = null;
            String text = ((CCombo)control).getText();
            Enumeration enu = info.labels.keys();
            while (enu.hasMoreElements()) {
                String str = (String)enu.nextElement();
                if (!str.equals(text)) continue;
                value = info.labels.get(str);
                break;
            }
            if (value == null) {
                value = text;
            }
            if (!value.equals(oldValue = ObjectValueHelper.getObjectFromModel(model, info.key))) {
                IMDSourceEditor editor = this.getEditor();
                ObjectValueHelper.setObjectIntoModel(model, info.key, types, (Object)value, editor.getMDProject());
                editor.setNeedSync(true);
                editor.setModify(true);
            }
        } else if (control instanceof Button) {
            boolean oldValue;
            boolean value;
            if ((control.getStyle() & 0x20) != 0 && (value = ((Button)control).getSelection()) != (oldValue = ObjectValueHelper.getBooleanFromModel(model, (String)key))) {
                IMDSourceEditor editor = this.getEditor();
                ObjectValueHelper.setObjectIntoModel(model, (String)key, types, (Object)new Boolean(value), editor.getMDProject());
                editor.setNeedSync(true);
                editor.setModify(true);
            }
        } else if (control instanceof Group) {
            Object oldValue;
            GroupInfo info = (GroupInfo)key;
            Object value = null;
            Enumeration enu = info.labels.keys();
            while (enu.hasMoreElements()) {
                Button btn = (Button)enu.nextElement();
                if (!btn.getSelection()) continue;
                value = info.labels.get(btn);
                break;
            }
            if (!value.equals(oldValue = ObjectValueHelper.getObjectFromModel(model, info.key))) {
                IMDSourceEditor editor = this.getEditor();
                ObjectValueHelper.setObjectIntoModel(model, info.key, types, value, editor.getMDProject());
                editor.setNeedSync(true);
                editor.setModify(true);
            }
        }
    }

    private void refreshControl(Control control, IObjectValue model, Object key, BOSObjectType[] types) throws IDEException {
        if (model != null && control != null && Boolean.TRUE.equals(control.getData(EXTENDED_KEY))) {
            if (control instanceof Text) {
                String value = model.getExtendedProperty(String.valueOf(key));
                ((Text)control).setText(value);
            } else if (control instanceof Button) {
                String value = model.getExtendedProperty(String.valueOf(key));
                ((Button)control).setSelection(Boolean.valueOf(value).booleanValue());
            } else if (control instanceof CCombo) {
                GroupInfo info = (GroupInfo)key;
                String value = model.getExtendedProperty(info.getKey());
                String text = null;
                Enumeration enu = info.labels.keys();
                while (enu.hasMoreElements()) {
                    String includedText = (String)enu.nextElement();
                    Object possibleValue = info.labels.get(includedText);
                    if (!possibleValue.equals(value)) continue;
                    text = includedText;
                    break;
                }
                if (text == null) {
                    text = value == null ? "" : value.toString();
                }
                ((CCombo)control).setText(text);
            } else if (control instanceof Group) {
                Object possibleValue;
                GroupInfo info = (GroupInfo)key;
                String value = model.getExtendedProperty(info.getKey());
                Button btn = null;
                Enumeration enu = info.labels.keys();
                while (enu.hasMoreElements() && !(possibleValue = info.labels.get(btn = (Button)enu.nextElement())).equals(value)) {
                }
                btn.setSelection(true);
            }
            return;
        }
        if (control instanceof Text) {
            String value = ObjectValueHelper.getStringFromModel(model, (String)key, types);
            if (value == null) {
                value = "";
            }
            ((Text)control).setText(value);
        } else if (control instanceof Button) {
            if ((control.getStyle() & 0x20) != 0) {
                boolean value = ObjectValueHelper.getBooleanFromModel(model, (String)key, types);
                ((Button)control).setSelection(value);
            }
        } else if (control instanceof CCombo) {
            GroupInfo info = (GroupInfo)key;
            Object value = ObjectValueHelper.getObjectFromModel(model, info.key, types);
            String text = null;
            Enumeration enu = info.labels.keys();
            while (enu.hasMoreElements()) {
                String includedText = (String)enu.nextElement();
                Object possibleValue = info.labels.get(includedText);
                if (!possibleValue.equals(value)) continue;
                text = includedText;
                break;
            }
            if (text == null) {
                text = value == null ? "" : value.toString();
            }
            ((CCombo)control).setText(text);
        } else if (control instanceof Group) {
            Object possibleValue;
            GroupInfo info = (GroupInfo)key;
            Object value = ObjectValueHelper.getObjectFromModel(model, info.key, types);
            Button btn = null;
            Enumeration enu = info.labels.keys();
            while (enu.hasMoreElements() && !(possibleValue = info.labels.get(btn = (Button)enu.nextElement())).equals(value)) {
            }
            btn.setSelection(true);
        }
    }

    protected IObjectValue getModel() {
        return this.getEditor().getModel();
    }

    @Override
    protected void updateControls() {
        super.updateControls();
        try {
            Object key;
            Control control;
            Enumeration enu = this.bindedInEditor.keys();
            while (enu.hasMoreElements()) {
                control = (Control)enu.nextElement();
                key = this.getBindedKey(control);
                this.refreshControl(control, this.getModel(), key, null);
            }
            enu = this.bindedInContext.keys();
            while (enu.hasMoreElements() && this.contextContainer != null) {
                control = (Control)enu.nextElement();
                key = this.getBindedKeyInContext(control);
                BOSObjectType[] types = this.getBindedTypeInContext(control);
                this.refreshControl(control, this.contextContainer.getObjectValue(), key, types);
            }
            for (Control c : this.readonlyControls) {
                c.setEnabled(false);
            }
        }
        catch (IDEException e) {
            ExceptionHandler.showException(e);
        }
    }

    protected class GroupInfo {
        String key;
        Hashtable labels = new Hashtable();
        Object[] orders;

        public GroupInfo(String key, Object[] possibleLabels, Object[] possibleValues) {
            this.key = key;
            for (int i = 0; i < possibleLabels.length; ++i) {
                this.labels.put(possibleLabels[i], possibleValues[i]);
            }
            this.orders = new Object[possibleLabels.length];
            System.arraycopy(possibleLabels, 0, this.orders, 0, possibleLabels.length);
        }

        public String getKey() {
            return this.key;
        }
    }

    private class InnerSelectionAdapter
    extends SelectionAdapter {
        private InnerSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            BasePageSection.this.bindedControlSelected(e);
        }
    }

    private class InnerFocusListener
    extends FocusAdapter {
        private InnerFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            BasePageSection.this.bindedControlFocusLost(e);
        }
    }
}

