/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.stconvert.STConverter;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.context.ToolContextManager;
import com.kingdee.bos.tool.dao.ORMStudioBridger;
import com.kingdee.bos.tool.dao.ORMUtil;
import com.kingdee.bos.tool.multipageeditor.Messages;
import com.kingdee.bos.tool.multipageeditor.SetTCConsoleMsgPrinter;
import com.kingdee.bos.util.BOSObjectType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;

public class SetTCWhenSaveHelper {
    public static boolean setTChineseAuto(IMDProject project, IObjectValue model) {
        return SetTCWhenSaveHelper.setTChineseAuto(project, model, true);
    }

    public static boolean setTChineseAuto(IMDProject project, IObjectValue model, boolean override) {
        boolean canDo = false;
        SolutionInfo solution = project.getSolutionInfo();
        LanguageCollection languages = solution.getLanguages();
        int lSize = languages.size();
        for (int i = 0; i < lSize; ++i) {
            LanguageInfo lInfo = languages.get(i);
            String localstr = lInfo.getLocaleString();
            if (!localstr.equals("zh_TW") && !localstr.equals("zh_HK")) continue;
            canDo = true;
            break;
        }
        if (!canDo) {
            MessageDialog.openWarning(null, (String)Messages.SetTCWhenSaveHelper_BuNengZhiXingCaoZuo, (String)Messages.SetTCWhenSaveHelper_MeiYouWeiJieJueFangAnSheZhiFanTiZhongWenXuanXiangQingQueRen);
            return false;
        }
        String cnLocaleStr = "zh_CN";
        String hkLocaleStr = "zh_HK";
        String twLocaleStr = "zh_TW";
        STConverter.reload();
        IMDFile file = MDResourceUtil.getFile(project, model);
        Map<String, Map> tempmap = new HashMap();
        IDevMetadataLoader loader = project.getMetadataLoader();
        try {
            BOSObjectType type = model.getBOSType();
            tempmap = loader.loadResource(type, (IMetaDataPK)file.getMetaDataPK());
            Set keys = tempmap.keySet();
            for (String key : keys) {
                if (key.indexOf("extendedProperty") != -1) continue;
                Map values = (Map)tempmap.get(key);
                String sc = (String)values.get(cnLocaleStr);
                String hk = (String)values.get(hkLocaleStr);
                String tw = (String)values.get(twLocaleStr);
                if (sc != null && !sc.equals("")) {
                    String tc = STConverter.sc2tc((String)sc);
                    if (hk == null || hk.equals("") || override) {
                        values.put(hkLocaleStr, tc);
                    }
                    if (tw == null || tw.equals("") || override) {
                        values.put(twLocaleStr, tc);
                    }
                }
                tempmap.put(key, values);
            }
            loader.saveResource((AbstractMetaDataValue)model, tempmap);
        }
        catch (Exception e) {
            LogTool.logError("\u4fdd\u5b58\u8d44\u6e90\u6587\u4ef6\u65f6\u51fa\u9519", e);
            SetTCConsoleMsgPrinter printer = new SetTCConsoleMsgPrinter(Messages.SetTCWhenSaveHelper_ZiDongSheZhiFanTiZhongWen);
            printer.printError(Messages.SetTCWhenSaveHelper_BaoCunYuanShuJuDuoYuYanXinXiShiBaiWenJian + file.getPath());
            return false;
        }
        return true;
    }

    public static boolean setTChineseAuto(IFile f, IObjectValue model) {
        boolean flag;
        boolean hasSetPreference = ToolCommonPlugin.getDefault().getPreferenceStore().contains("HAS_EVER_SET");
        boolean showSetTCDialog = ToolCommonPlugin.getDefault().getPreferenceStore().getBoolean("SHOW_AUTO_SET_CONFIRM_DIALOG");
        if (showSetTCDialog && !(flag = MessageDialog.openConfirm(null, (String)Messages.SetTCWhenSaveHelper_TiShi, (String)Messages.SetTCWhenSaveHelper_ShiFouZiDongSheZhiFanTiZhongWen))) {
            return flag;
        }
        boolean autoSetTC = ToolCommonPlugin.getDefault().getPreferenceStore().getBoolean("AUTO_SETTC");
        if (!autoSetTC && hasSetPreference) {
            return false;
        }
        boolean showOverRideDialog = ToolCommonPlugin.getDefault().getPreferenceStore().getBoolean("SHOW_SET_OVERRIDE_CONFIRM_DIALOG");
        boolean override = false;
        if (showOverRideDialog) {
            override = MessageDialog.openConfirm(null, (String)Messages.SetTCWhenSaveHelper_TiShi, (String)Messages.SetTCWhenSaveHelper_ShiFouYaoFuGaiYuanShuJuYuanYouDeFanTiZhongWenXuanXiangRuGuoBuFuGaiZeZhiSheZhiShangWeiSheZhiFanTiZhongWenDeXuanXiang);
        }
        boolean overRide = ToolCommonPlugin.getDefault().getPreferenceStore().getBoolean("OVERRIDE_QUONDAM_TC");
        if (!(override || !overRide && hasSetPreference)) {
            override = true;
        }
        boolean canDo = false;
        SolutionInfo solution = null;
        try {
            solution = ORMUtil.getSolution(f.getProject());
        }
        catch (IDEException e1) {
            LogTool.logError("", e1);
        }
        if (solution == null) {
            return false;
        }
        LanguageCollection languages = solution.getLanguages();
        int lSize = languages.size();
        for (int i = 0; i < lSize; ++i) {
            LanguageInfo lInfo = languages.get(i);
            String localstr = lInfo.getLocaleString();
            if (!localstr.equals("zh_TW") && !localstr.equals("zh_HK")) continue;
            canDo = true;
            break;
        }
        if (!canDo) {
            MessageDialog.openWarning(null, (String)Messages.SetTCWhenSaveHelper_BuNengZhiXingCaoZuo, (String)Messages.SetTCWhenSaveHelper_MeiYouWeiJieJueFangAnSheZhiFanTiZhongWenXuanXiangQingQueRen);
            return false;
        }
        String cnLocaleStr = "zh_CN";
        String hkLocaleStr = "zh_HK";
        String twLocaleStr = "zh_TW";
        STConverter.reload();
        Map<String, HashMap> tempmap = new HashMap();
        IFolder folder = ORMStudioBridger.getFolder((IResource)f);
        IDevMetadataLoader loader = ToolContextManager.getMetadataLoader(folder);
        try {
            BOSObjectType type = BOSObjectType.create((String)Utils.getBOSTypeBySuffix((String)f.getFileExtension()));
            tempmap = loader.loadResource(type, ORMStudioBridger.getFilePK((IResource)f));
            Set keys = tempmap.keySet();
            for (String key : keys) {
                if (key.indexOf("extendedProperty") != -1) continue;
                HashMap values = (HashMap)tempmap.get(key);
                String sc = (String)values.get(cnLocaleStr);
                String hk = (String)values.get(hkLocaleStr);
                String tw = (String)values.get(twLocaleStr);
                if (sc != null && !sc.equals("")) {
                    String tc = STConverter.sc2tc((String)sc);
                    if (hk == null || hk.equals("") || override) {
                        values.put(hkLocaleStr, tc);
                    }
                    if (tw == null || tw.equals("") || override) {
                        values.put(twLocaleStr, tc);
                    }
                }
                tempmap.put(key, values);
            }
            loader.saveResource((AbstractMetaDataValue)model, tempmap);
        }
        catch (Exception e) {
            LogTool.logError("\u4fdd\u5b58\u8d44\u6e90\u65f6\u51fa\u9519", e);
            SetTCConsoleMsgPrinter printer = new SetTCConsoleMsgPrinter(Messages.SetTCWhenSaveHelper_ZiDongSheZhiFanTiZhongWen);
            printer.printError(Messages.SetTCWhenSaveHelper_BaoCunYuanShuJuDuoYuYanXinXiShiBaiWenJian + f.getFullPath());
            return false;
        }
        return true;
    }
}

