/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor.common;

import com.kingdee.bos.md.multipageeditor.IMDSourceEditor;
import com.kingdee.bos.tool.multipageeditor.common.CommonPageSection;
import com.kingdee.bos.tool.multipageeditor.common.ICommonPage;
import com.kingdee.bos.tool.multipageeditor.common.ICommonPageSection;
import com.kingdee.bos.tool.multipageeditor.common.ITableWithButtonsSection;
import com.kingdee.bos.tool.multipageeditor.common.ShowFocusScrolledComposite;
import com.kingdee.bos.tool.multipageeditor.common.WidgetFactory;
import java.util.Vector;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;

public abstract class CommonPage
implements ICommonPage {
    protected WidgetFactory fWf;
    protected Color fHeadingBackground = null;
    protected Color fHeadingForeground = null;
    protected boolean fHeadingVisible = true;
    protected Image fHeadingImage;
    protected String fHeadingText;
    protected int fPageIndex;
    protected Composite fParent;
    private boolean fScrollable = true;
    protected Font fTitleFont;
    protected Vector fSections = null;
    protected Composite fControl1;
    protected Composite fControl2;
    private int TITLE_HMARGIN = 10;
    private int TITLE_VMARGIN = 5;
    protected String fTabText;
    private boolean fVerticalFit = true;
    public static final int VBAR_INCREMENT = 10;
    public static final int VPAGE_INCREMENT = 40;
    protected static final int HSPACING = 10;
    protected static final int VSPACING = 20;
    protected IMDSourceEditor fEditor;

    public CommonPage(IMDSourceEditor editor) {
        this.fEditor = editor;
        this.fWf = editor.getWidgetFactory();
        this.fTitleFont = JFaceResources.getHeaderFont();
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.createHeadingImage();
        this.createSections();
    }

    @Override
    public void createControl(Composite composite) {
        this.fParent = composite;
        this.setHeadingForeground(this.fWf.getColor("__blackColor"));
        if (this.fScrollable) {
            ShowFocusScrolledComposite showfocusscrolledcomposite = new ShowFocusScrolledComposite(this.fParent, 768);
            if (this.isVerticalFit()) {
                showfocusscrolledcomposite.setExpandHorizontal(true);
                showfocusscrolledcomposite.setExpandVertical(true);
            }
            this.initializeScrollBars(showfocusscrolledcomposite);
            this.fControl1 = showfocusscrolledcomposite;
        } else {
            this.fControl1 = new Composite(this.fParent, 0);
            GridLayout gridlayout = new GridLayout();
            gridlayout.marginHeight = 0;
            gridlayout.marginWidth = 0;
            this.fControl1.setLayout((Layout)gridlayout);
        }
    }

    protected void createSectionControls(Composite composite) {
        for (ICommonPageSection iCommonpagesection : this.fSections) {
            Control control = iCommonpagesection.createControl(composite);
            iCommonpagesection.setGridData(control);
        }
    }

    private void createHeadingImage() {
        this.fHeadingImage = this.fWf.getBanner();
    }

    @Override
    public void dispose() {
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        if (this.fSections != null) {
            for (ICommonPageSection iCommonpagesection : this.fSections) {
                iCommonpagesection.dispose();
            }
        }
    }

    @Override
    public Composite getPageControl() {
        return this.fControl1;
    }

    @Override
    public final Color getHeadingBackground() {
        return this.fHeadingBackground;
    }

    @Override
    public final Color getHeadingForeground() {
        return this.fHeadingForeground;
    }

    @Override
    public final Image getHeadingImage() {
        return this.fHeadingImage;
    }

    @Override
    public final String getHeadingText() {
        return this.fHeadingText;
    }

    protected int getTitleHeight() {
        int i = 0;
        if (this.fHeadingImage != null && !SWT.getPlatform().equals("motif")) {
            i = this.fHeadingImage.getBounds().height;
        }
        GC gc = new GC((Drawable)this.fControl2);
        gc.setFont(this.fTitleFont);
        FontMetrics fontmetrics = gc.getFontMetrics();
        int j = fontmetrics.getHeight();
        gc.dispose();
        int k = j + this.TITLE_VMARGIN + this.TITLE_VMARGIN;
        return Math.max(k, i);
    }

    protected final void initializeScrollBars(ScrolledComposite scrolledcomposite) {
        ScrollBar scrollbar1;
        ScrollBar scrollbar = scrolledcomposite.getHorizontalBar();
        if (scrollbar != null) {
            scrollbar.setIncrement(10);
            scrollbar.setPageIncrement(40);
        }
        if ((scrollbar1 = scrolledcomposite.getVerticalBar()) != null) {
            scrollbar1.setIncrement(10);
            scrollbar1.setPageIncrement(40);
        }
    }

    @Override
    public boolean isHeadingVisible() {
        return this.fHeadingVisible;
    }

    @Override
    public boolean isVerticalFit() {
        return this.fVerticalFit;
    }

    private void paint(Control control, GC gc) {
        Rectangle rectangle = control.getBounds();
        int i = this.getTitleHeight();
        if (this.fHeadingImage != null) {
            Rectangle rectangle1 = this.fHeadingImage.getBounds();
            int j = rectangle.width - rectangle1.width;
            int k = 0;
            j = 0;
            if (this.fHeadingBackground != null) {
                gc.setBackground(this.fHeadingBackground);
                gc.fillRectangle(0, 0, rectangle.width, i);
            }
            if (!SWT.getPlatform().equals("motif")) {
                gc.drawImage(this.fHeadingImage, j, k);
            }
            if (this.fHeadingForeground != null) {
                gc.setForeground(this.fHeadingForeground);
            } else {
                gc.setForeground(this.fWf.getForegroundColor());
            }
            gc.setFont(this.fTitleFont);
            gc.drawText(this.getHeadingText(), this.TITLE_HMARGIN, this.TITLE_VMARGIN, true);
        } else {
            gc.setFont(this.fTitleFont);
            gc.setBackground(this.fWf.getColor("__default__header__"));
            gc.setForeground(this.fWf.getForegroundColor());
            gc.drawText(this.getHeadingText(), this.TITLE_HMARGIN, this.TITLE_VMARGIN, true);
        }
    }

    @Override
    public void setActivated(boolean flag) {
        if (flag && this.fControl2 == null) {
            this.fControl2 = new Composite(this.fControl1, 0);
            this.fControl2.setBackground(this.fWf.getBackgroundColor());
            this.fControl2.setForeground(this.fWf.getForegroundColor());
            this.fControl2.addPaintListener((PaintListener)this);
            this.fControl2.setLayout((Layout)new FormLayout());
            Composite composite = this.fWf.createComposite(this.fControl2);
            GridLayout gridlayout = new GridLayout();
            gridlayout.numColumns = 2;
            gridlayout.marginWidth = 10;
            gridlayout.horizontalSpacing = 10;
            gridlayout.verticalSpacing = 20;
            composite.setLayout((Layout)gridlayout);
            this.createSectionControls(composite);
            if (this.fControl1 instanceof ShowFocusScrolledComposite) {
                ShowFocusScrolledComposite showfocusscrolledcomposite = (ShowFocusScrolledComposite)this.fControl1;
                showfocusscrolledcomposite.setContent((Control)this.fControl2);
                showfocusscrolledcomposite.init(1);
                this.updateScrolledComposite();
            }
            GridData griddata = new GridData(1808);
            this.fControl2.setLayoutData((Object)griddata);
            this.fControl1.setBackground(this.fControl2.getBackground());
            this.fControl2.layout(true);
            this.fControl1.layout(true);
            if (this.fSections != null && this.fSections.size() > 0) {
                ((CommonPageSection)this.fSections.get(0)).reflow();
            }
        }
        if (!flag) {
            for (ICommonPageSection iCommonpagesection : this.fSections) {
                if (!(iCommonpagesection instanceof ITableWithButtonsSection)) continue;
                ((ITableWithButtonsSection)iCommonpagesection).finishTableEditing();
            }
        }
    }

    @Override
    public void setSectionFocus() {
        if (this.fSections != null && this.fSections.size() > 0 && this.fSections.get(0) instanceof ICommonPageSection) {
            ((ICommonPageSection)this.fSections.get(0)).setFocus();
        }
    }

    public final void paintControl(PaintEvent paintevent) {
        if (this.fHeadingVisible) {
            Control control = (Control)paintevent.widget;
            this.paint(control, paintevent.gc);
        }
    }

    public void propertyChange(PropertyChangeEvent propertychangeevent) {
        this.fTitleFont = JFaceResources.getHeaderFont();
        if (this.fControl2 != null) {
            if (this.fSections != null) {
                for (ICommonPageSection iCommonpagesection : this.fSections) {
                    iCommonpagesection.propertyChange(null);
                }
            }
            this.fControl2.layout(true);
            this.fControl2.redraw();
            this.updateScrolledComposite();
        }
    }

    protected void registerSection(ICommonPageSection iCommonpagesection) {
        if (this.fSections == null) {
            this.fSections = new Vector();
        }
        if (!this.fSections.contains(iCommonpagesection)) {
            this.fSections.add(iCommonpagesection);
        }
    }

    protected void setScrollable(boolean flag) {
        this.fScrollable = flag;
    }

    @Override
    public final void setHeadingBackground(Color color) {
        this.fHeadingBackground = color;
    }

    @Override
    public final void setHeadingForeground(Color color) {
        this.fHeadingForeground = color;
    }

    @Override
    public final void setHeadingImage(Image image) {
        this.fHeadingImage = image;
    }

    @Override
    public void setHeadingVisible(boolean flag) {
        this.fHeadingVisible = flag;
        if (this.fControl2 != null) {
            this.fControl2.layout(true);
        }
    }

    @Override
    public void setOutlineSelection(IStructuredSelection istructuredselection) {
    }

    @Override
    public final void setHeadingText(String s) {
        this.fHeadingText = s;
    }

    @Override
    public final void setVerticalFit(boolean flag) {
        this.fVerticalFit = flag;
    }

    @Override
    public void unregisterSection(ICommonPageSection iCommonpagesection) {
        if (this.fSections != null && this.fSections.contains(iCommonpagesection)) {
            this.fSections.remove(iCommonpagesection);
        }
        this.updateScrolledComposite();
    }

    @Override
    public void updateScrolledComposite() {
        if (this.fControl1 instanceof ScrolledComposite) {
            ScrolledComposite scrolledcomposite = (ScrolledComposite)this.fControl1;
            Point point = this.fControl2.computeSize(-1, -1);
            this.fControl2.setSize(point);
            scrolledcomposite.setMinSize(point);
        }
    }

    protected boolean canPerformDirectly(String s, Control control) {
        if (control instanceof Text) {
            Text text = (Text)control;
            if (s.equals("cut")) {
                text.cut();
                return true;
            }
            if (s.equals("copy")) {
                text.copy();
                return true;
            }
            if (s.equals("paste")) {
                text.paste();
                return true;
            }
            if (s.equals("selectAll")) {
                text.selectAll();
                return true;
            }
            if (s.equals("delete")) {
                int i = text.getSelectionCount();
                if (i == 0) {
                    int j = text.getCaretPosition();
                    text.setSelection(j, j + 1);
                }
                text.insert("");
                return true;
            }
        } else if (control instanceof StyledText) {
            StyledText text = (StyledText)control;
            if (s.equals("cut")) {
                text.cut();
                return true;
            }
            if (s.equals("copy")) {
                text.copy();
                return true;
            }
            if (s.equals("paste")) {
                text.paste();
                return true;
            }
            if (s.equals("selectAll")) {
                text.selectAll();
                return true;
            }
            if (s.equals("delete")) {
                int i = text.getSelectionCount();
                if (i == 0) {
                    int j = text.getCaretOffset();
                    text.setSelection(j, j + 1);
                }
                text.insert("");
                return true;
            }
        }
        return false;
    }

    @Override
    public final int getPageIndex() {
        return this.fPageIndex;
    }

    @Override
    public final void setPageIndex(int i) {
        this.fPageIndex = i;
    }

    @Override
    public final void setReadOnly(boolean flag) {
        if (this.fSections != null) {
            for (ICommonPageSection iCommonpagesection : this.fSections) {
                iCommonpagesection.setReadOnly(flag);
            }
        }
    }

    @Override
    public final String getTabText() {
        return this.fTabText;
    }

    @Override
    public final void setTabText(String s) {
        this.fTabText = s;
    }

    @Override
    public IMDSourceEditor getEditor() {
        return this.fEditor;
    }

    protected abstract void createSections();

    public boolean doGlobalAction(String actionId) {
        Control focusControl = this.getFocusControl();
        if (focusControl == null) {
            return false;
        }
        if (this.canPerformDirectly(actionId, focusControl)) {
            return true;
        }
        CommonPageSection targetSection = null;
        for (Composite parent = focusControl.getParent(); parent != null; parent = parent.getParent()) {
            Object data = parent.getData();
            if (data == null || !(data instanceof CommonPageSection)) continue;
            targetSection = (CommonPageSection)data;
            break;
        }
        if (targetSection != null) {
            return targetSection.doGlobalAction(actionId);
        }
        return false;
    }

    protected Control getFocusControl() {
        Composite control = this.fControl1;
        if (control == null || control.isDisposed()) {
            return null;
        }
        Display display = control.getDisplay();
        Control focusControl = display.getFocusControl();
        if (focusControl == null || focusControl.isDisposed()) {
            return null;
        }
        return focusControl;
    }

    class FormLayout
    extends Layout {
        protected Point computeSize(Composite composite, int i, int j, boolean flag) {
            if (i != -1 && j != -1) {
                return new Point(i, j);
            }
            Control control = composite.getChildren()[0];
            Point point = control.computeSize(-1, -1, flag);
            if (CommonPage.this.fHeadingVisible) {
                point.y += CommonPage.this.getTitleHeight();
            }
            return point;
        }

        protected void layout(Composite composite, boolean flag) {
            Rectangle rectangle = composite.getClientArea();
            Control control = composite.getChildren()[0];
            int i = CommonPage.this.fHeadingVisible ? CommonPage.this.getTitleHeight() : 0;
            control.setBounds(rectangle.x, rectangle.y + i, rectangle.width, rectangle.height - i);
        }

        FormLayout() {
        }
    }
}

