/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.properties.solution;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.tool.celleditors.BooleanCellEditor;
import com.kingdee.bos.tool.celleditors.EnumerateCellEditor;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.common.IDESystem;
import com.kingdee.bos.tool.dao.ORMUtil;
import com.kingdee.bos.tool.properties.solution.Messages;
import com.kingdee.bos.tool.utils.IndexLocateUtil;
import com.kingdee.bos.tool.utils.ListUtil;
import com.kingdee.bos.ui.dtp.model.ComponentNameManager;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.IProgressService;

public class MutilLangInfoPropertyPage
extends PropertyPage {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.properties.solution.MutilLangInfoPropertyPage");
    private static final String NAME = "name";
    private static final String ALIAS = "alias";
    private static final String LOCALE = "locale";
    private static final String SUFFIX = "suffix";
    private static final String ISDEFAULT = "isdefault";
    private IProject project;
    private LanguageCollection langs;
    private LanguageInfo defaultLanguageInfo;
    private ComponentNameManager nameManager;
    private TableViewer tableView;

    public MutilLangInfoPropertyPage() {
        this.setDescription(Messages.MutilLangInfoPropertyPage_SheZhiJieJueFangAnDeDuoYuYanXinXi);
        this.langs = new LanguageCollection();
        this.nameManager = new ComponentNameManager();
    }

    public boolean performOk() {
        if (this.project == null) {
            return false;
        }
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.runInUI((IRunnableContext)progressService, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.setCanceled(false);
                    monitor.beginTask(Messages.MutilLangInfoPropertyPage_BaoCunJieJueFangAnDeDuoYuYanXinXi, 100);
                    monitor.setTaskName(Messages.MutilLangInfoPropertyPage_ZhengZaiBaoCunJieJueFangAnDeDuoYuYanXinXiQingShaoDeng);
                    monitor.subTask(Messages.MutilLangInfoPropertyPage_ZhengZaiBaoCun);
                    monitor.worked(10);
                    try {
                        SolutionInfo solution = ORMUtil.getSolution(MutilLangInfoPropertyPage.this.project);
                        monitor.worked(50);
                        if (solution == null) {
                            throw new IDEException(Messages.MutilLangInfoPropertyPage_BaoCunDuoYuYanXinXiShiDuQuSOLUTIONChuCuo);
                        }
                        solution.setDefaultLanguage(MutilLangInfoPropertyPage.this.defaultLanguageInfo);
                        solution.setLanguages(MutilLangInfoPropertyPage.this.langs);
                        IFile file = ORMUtil.getFile(MutilLangInfoPropertyPage.this.project, (IObjectValue)solution);
                        ORMUtil.store((IObjectValue)solution, file, null);
                    }
                    catch (Exception e) {
                        MutilLangInfoPropertyPage.this.setErrorMessage(Messages.MutilLangInfoPropertyPage_BaoCunJieJueFangAnDeDuoYuYanXinXiChuCuoQingYuGuanLiYuanLianXi);
                        logger.error((Object)"error", (Throwable)e);
                        throw new InvocationTargetException(e);
                    }
                }
            }, null);
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(Messages.MutilLangInfoPropertyPage_BaoCunJieJueFangAnDeDuoYuYanXinXiChuCuoQingYuGuanLiYuanLianXi);
            logger.error((Object)e.getCause());
            return false;
        }
        catch (InterruptedException e) {
            this.setErrorMessage(Messages.MutilLangInfoPropertyPage_BaoCunJieJueFangAnDeDuoYuYanXinXiChuCuoQingYuGuanLiYuanLianXi);
            logger.error((Object)"erro", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            this.setErrorMessage(Messages.MutilLangInfoPropertyPage_BaoCunJieJueFangAnDeDuoYuYanXinXiChuCuoQingYuGuanLiYuanLianXi);
            logger.error((Object)"error", (Throwable)e);
            return false;
        }
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        this.initLanguageInfos();
        Composite container = new Composite(parent, 0);
        container.setFont(parent.getFont());
        FillLayout layout = new FillLayout();
        layout.marginHeight = 10;
        container.setLayout((Layout)layout);
        this.createBody(container);
        return container;
    }

    private void initLanguageInfos() {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.runInUI((IRunnableContext)progressService, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.setCanceled(false);
                    monitor.beginTask(Messages.MutilLangInfoPropertyPage_ZhuangZaiJieJueFangAnDeDuoYuYanXinXi, 100);
                    monitor.setTaskName(Messages.MutilLangInfoPropertyPage_ZhengZaiZhuangZaiJieJueFangAnDeDuoYuYanXinXiQingShaoDeng);
                    monitor.subTask(Messages.MutilLangInfoPropertyPage_ZhengZaiDuQuGongChengXiangMu);
                    IAdaptable adapter = MutilLangInfoPropertyPage.this.getElement();
                    monitor.worked(10);
                    if (adapter != null) {
                        MutilLangInfoPropertyPage.this.project = (IProject)adapter.getAdapter(IResource.class);
                        if (MutilLangInfoPropertyPage.this.project != null) {
                            try {
                                monitor.subTask(Messages.MutilLangInfoPropertyPage_ZhengZaiDuQuJieJueFangAnXinXi);
                                SolutionInfo solution = ORMUtil.getSolution(MutilLangInfoPropertyPage.this.project);
                                monitor.worked(50);
                                if (solution != null) {
                                    monitor.subTask(Messages.MutilLangInfoPropertyPage_ZhengZaiDuQuDuoYuYanXinXi);
                                    MutilLangInfoPropertyPage.this.defaultLanguageInfo = solution.getDefaultLanguage();
                                    LanguageCollection tempLangs = solution.getLanguages();
                                    if (tempLangs != null) {
                                        int j = tempLangs.size();
                                        for (int i = 0; i < j; ++i) {
                                            monitor.worked(40 + 50 / j * i);
                                            MutilLangInfoPropertyPage.this.langs.add(tempLangs.get(i));
                                            MutilLangInfoPropertyPage.this.nameManager.put(tempLangs.get(i).getName());
                                            MutilLangInfoPropertyPage.this.nameManager.put(tempLangs.get(i).getPostfix());
                                        }
                                    }
                                    monitor.subTask(Messages.MutilLangInfoPropertyPage_ZhengZaiGouJianDuoYuYanXinXiBianJiJieMian);
                                }
                            }
                            catch (Exception e) {
                                MutilLangInfoPropertyPage.this.setErrorMessage(Messages.MutilLangInfoPropertyPage_ZaiZhuangJieJueFangAnDeDuoYuYanXinXiChuCuoQingYuGuanLiYuanLianXi);
                                logger.error((Object)"error", (Throwable)e);
                            }
                        }
                    }
                }
            }, null);
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(Messages.MutilLangInfoPropertyPage_ZaiZhuangJieJueFangAnDeDuoYuYanXinXiChuCuoQingYuGuanLiYuanLianXi);
            logger.error((Object)"error", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.setErrorMessage(Messages.MutilLangInfoPropertyPage_ZaiZhuangJieJueFangAnDeDuoYuYanXinXiChuCuoQingYuGuanLiYuanLianXi);
            logger.error((Object)"error", (Throwable)e);
        }
    }

    private void createBody(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Table table = new Table(container, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn nameCol = new TableColumn(table, 0x1000000);
        nameCol.setText(Messages.MutilLangInfoPropertyPage_MingCheng);
        nameCol.setWidth(70);
        nameCol.setAlignment(0x1000000);
        TableColumn aliasCol = new TableColumn(table, 0x1000000);
        aliasCol.setText(Messages.MutilLangInfoPropertyPage_BieMing);
        aliasCol.setWidth(100);
        aliasCol.setAlignment(0x1000000);
        TableColumn localeCol = new TableColumn(table, 0x1000000);
        localeCol.setText(Messages.MutilLangInfoPropertyPage_DangDiMingCheng);
        localeCol.setWidth(70);
        localeCol.setAlignment(0x1000000);
        TableColumn postfixCol = new TableColumn(table, 0x1000000);
        postfixCol.setText(Messages.MutilLangInfoPropertyPage_YuYan);
        postfixCol.setWidth(50);
        postfixCol.setAlignment(0x1000000);
        TableColumn defaultCol = new TableColumn(table, 0x1000000);
        defaultCol.setText(Messages.MutilLangInfoPropertyPage_ShiFouQueSheng);
        defaultCol.setWidth(60);
        defaultCol.setAlignment(0x1000000);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        TextCellEditor nameCellEditor = new TextCellEditor((Composite)table);
        TextCellEditor aliasCellEditor = new TextCellEditor((Composite)table);
        EnumerateCellEditor localeCellEditor = new EnumerateCellEditor((Composite)table, ListUtil.arrayToList((Object[])IDESystem.ALL_SUPPORT_LANGUAG), (ILabelProvider)new LabelProvider());
        TextCellEditor postfixCellEditor = new TextCellEditor((Composite)table);
        BooleanCellEditor isdefalutCellEditor = new BooleanCellEditor((Composite)table);
        this.tableView = new TableViewer(table);
        this.tableView.setColumnProperties(new String[]{NAME, ALIAS, LOCALE, SUFFIX, ISDEFAULT});
        this.tableView.setContentProvider((IContentProvider)new LanguageContentProvider());
        this.tableView.setLabelProvider((IBaseLabelProvider)new LanguageLabelProvider());
        this.tableView.setCellEditors(new CellEditor[]{nameCellEditor, aliasCellEditor, localeCellEditor, postfixCellEditor, isdefalutCellEditor});
        this.tableView.setCellModifier((ICellModifier)new LanguageModifer());
        this.tableView.setInput((Object)this.langs);
        Composite buttonContainer = new Composite(container, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        buttonContainer.setLayout((Layout)layout);
        data = new GridData(2);
        buttonContainer.setLayoutData((Object)data);
        Button addBtn = new Button(buttonContainer, 0);
        addBtn.setText(Messages.MutilLangInfoPropertyPage_XinZengN);
        data = new GridData();
        data.verticalAlignment = 2;
        data.widthHint = 80;
        addBtn.setLayoutData((Object)data);
        final Button delBtn = new Button(buttonContainer, 0);
        delBtn.setText(Messages.MutilLangInfoPropertyPage_ShanChuD);
        if (this.langs.size() == 0) {
            delBtn.setEnabled(false);
        }
        addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageInfo info = new LanguageInfo();
                info.setName(MutilLangInfoPropertyPage.this.nameManager.getNameByName(Messages.MutilLangInfoPropertyPage_XinYuYan));
                info.setLocaleString(IDESystem.ALL_SUPPORT_LANGUAG[0]);
                info.setPostfix(MutilLangInfoPropertyPage.this.nameManager.getNameByName("L"));
                MutilLangInfoPropertyPage.this.langs.add(info);
                MutilLangInfoPropertyPage.this.tableView.getTable().setRedraw(false);
                MutilLangInfoPropertyPage.this.tableView.refresh();
                MutilLangInfoPropertyPage.this.tableView.getTable().setSelection(MutilLangInfoPropertyPage.this.tableView.getTable().getItemCount() - 1);
                MutilLangInfoPropertyPage.this.tableView.getTable().setRedraw(true);
                if (MutilLangInfoPropertyPage.this.langs.size() == 1) {
                    delBtn.setEnabled(true);
                }
            }
        });
        delBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MutilLangInfoPropertyPage.this.tableView.getTable().getSelectionCount() <= 0) {
                    MessageDialogWithToggle.openInformation((Shell)MutilLangInfoPropertyPage.this.tableView.getControl().getShell(), (String)Messages.MutilLangInfoPropertyPage_TiShi, (String)Messages.MutilLangInfoPropertyPage_QingXuanZeSuoYaoShanChuDeYuYan);
                    return;
                }
                int nextSelIndex = MutilLangInfoPropertyPage.this.getNextItem(MutilLangInfoPropertyPage.this.tableView.getTable().getSelectionIndices());
                TableItem[] items = MutilLangInfoPropertyPage.this.tableView.getTable().getSelection();
                for (int i = 0; i < items.length; ++i) {
                    LanguageInfo info = (LanguageInfo)items[i].getData();
                    MutilLangInfoPropertyPage.this.langs.remove(info);
                    MutilLangInfoPropertyPage.this.nameManager.remove(info.getName());
                    MutilLangInfoPropertyPage.this.nameManager.remove(info.getPostfix());
                    if (!MutilLangInfoPropertyPage.this.isDefaultLocale(info)) continue;
                    if (MutilLangInfoPropertyPage.this.langs.size() > 0) {
                        MutilLangInfoPropertyPage.this.defaultLanguageInfo = MutilLangInfoPropertyPage.this.langs.get(0);
                        continue;
                    }
                    MutilLangInfoPropertyPage.this.defaultLanguageInfo = null;
                }
                MutilLangInfoPropertyPage.this.tableView.getTable().setRedraw(false);
                MutilLangInfoPropertyPage.this.tableView.refresh();
                MutilLangInfoPropertyPage.this.tableView.getTable().setSelection(nextSelIndex);
                MutilLangInfoPropertyPage.this.tableView.getTable().setRedraw(true);
                if (MutilLangInfoPropertyPage.this.langs.size() == 0) {
                    delBtn.setEnabled(false);
                }
            }
        });
        data = new GridData();
        data.verticalAlignment = 2;
        data.widthHint = 80;
        delBtn.setLayoutData((Object)data);
    }

    private int getNextItem(int[] removeIndecies) {
        return IndexLocateUtil.getNextSelectionIndex((int)this.langs.size(), (int[])removeIndecies);
    }

    private boolean isDefaultLocale(LanguageInfo info) {
        return this.defaultLanguageInfo != null && this.defaultLanguageInfo.equals((Object)info);
    }

    class LanguageModifer
    implements ICellModifier {
        LanguageModifer() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            String retString = null;
            if (element instanceof LanguageInfo) {
                LanguageInfo lan = (LanguageInfo)element;
                if (MutilLangInfoPropertyPage.NAME.equals(property)) {
                    retString = lan.getName();
                    return retString == null ? "" : retString;
                }
                if (MutilLangInfoPropertyPage.ALIAS.equals(property)) {
                    retString = lan.getAlias();
                    return retString == null ? "" : retString;
                }
                if (MutilLangInfoPropertyPage.LOCALE.equals(property)) {
                    retString = lan.getLocaleString();
                    return retString == null ? "" : retString;
                }
                if (MutilLangInfoPropertyPage.SUFFIX.equals(property)) {
                    retString = lan.getPostfix();
                    return retString == null ? "" : retString;
                }
                if (MutilLangInfoPropertyPage.ISDEFAULT.equals(property)) {
                    return MutilLangInfoPropertyPage.this.isDefaultLocale(lan);
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if (((TableItem)element).getData() instanceof LanguageInfo) {
                LanguageInfo lan = (LanguageInfo)((TableItem)element).getData();
                if (MutilLangInfoPropertyPage.NAME.equals(property)) {
                    if (StringUtils.isEmpty((String)((String)value))) {
                        MutilLangInfoPropertyPage.this.setMessage(Messages.MutilLangInfoPropertyPage_XiuGaiMingChengShiBaiDuoYuYanDeMingChengBuNengWeiKong, 1);
                        return;
                    }
                    if (!lan.getName().equals(value) && MutilLangInfoPropertyPage.this.nameManager.isUsed((String)value)) {
                        MutilLangInfoPropertyPage.this.setMessage(Messages.MutilLangInfoPropertyPage_XiuGaiMingChengShiBai + value + Messages.MutilLangInfoPropertyPage_GaiMingChengYiBeiShiYong, 1);
                        return;
                    }
                    MutilLangInfoPropertyPage.this.setMessage(null, 1);
                    MutilLangInfoPropertyPage.this.nameManager.rename(lan.getName(), (String)value);
                    lan.setName((String)value);
                } else if (MutilLangInfoPropertyPage.ALIAS.equals(property)) {
                    lan.setAlias((String)value);
                } else if (MutilLangInfoPropertyPage.LOCALE.equals(property)) {
                    lan.setLocaleString((String)value);
                } else if (MutilLangInfoPropertyPage.SUFFIX.equals(property)) {
                    if (StringUtils.isEmpty((String)((String)value))) {
                        MutilLangInfoPropertyPage.this.setMessage(Messages.MutilLangInfoPropertyPage_XiuGaiHouZhuiMingShiBaiDuoYuYanDeHouZhuiMingBuNengWeiKong, 1);
                        return;
                    }
                    if (!lan.getPostfix().equals(value) && MutilLangInfoPropertyPage.this.nameManager.isUsed((String)value)) {
                        MutilLangInfoPropertyPage.this.setMessage(Messages.MutilLangInfoPropertyPage_XiuGaiHouZhuiMingShiBai + value + Messages.MutilLangInfoPropertyPage_GaiHouZhuiMingYiBeiShiYong, 1);
                        return;
                    }
                    MutilLangInfoPropertyPage.this.setMessage(null, 1);
                    MutilLangInfoPropertyPage.this.nameManager.rename(lan.getPostfix(), (String)value);
                    lan.setPostfix((String)value);
                } else if (MutilLangInfoPropertyPage.ISDEFAULT.equals(property)) {
                    boolean isDefault = false;
                    isDefault = value instanceof Boolean ? ((Boolean)value).booleanValue() : Boolean.valueOf(value == null ? "false" : value.toString()).booleanValue();
                    if (isDefault) {
                        MutilLangInfoPropertyPage.this.defaultLanguageInfo = lan;
                    }
                }
                int selIndex = MutilLangInfoPropertyPage.this.tableView.getTable().getSelectionIndex();
                MutilLangInfoPropertyPage.this.tableView.getTable().setRedraw(false);
                MutilLangInfoPropertyPage.this.tableView.refresh();
                MutilLangInfoPropertyPage.this.tableView.getTable().setSelection(selIndex);
                MutilLangInfoPropertyPage.this.tableView.getTable().setRedraw(true);
            }
        }
    }

    class LanguageLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        LanguageLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String retText = "";
            if (element instanceof LanguageInfo) {
                switch (columnIndex) {
                    case 0: {
                        retText = ((LanguageInfo)element).getName();
                        break;
                    }
                    case 1: {
                        retText = ((LanguageInfo)element).getAlias();
                        break;
                    }
                    case 2: {
                        retText = ((LanguageInfo)element).getLocaleString();
                        break;
                    }
                    case 3: {
                        retText = ((LanguageInfo)element).getPostfix();
                        break;
                    }
                    case 4: {
                        retText = this.getDefaultLocaleLabel((LanguageInfo)element);
                    }
                }
            }
            return retText == null ? "" : retText;
        }

        private String getDefaultLocaleLabel(LanguageInfo info) {
            if (MutilLangInfoPropertyPage.this.isDefaultLocale(info)) {
                return Messages.MutilLangInfoPropertyPage_GOU;
            }
            return "";
        }
    }

    class LanguageContentProvider
    implements IStructuredContentProvider {
        LanguageContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof LanguageInfo[]) {
                return (LanguageInfo[])inputElement;
            }
            if (inputElement instanceof LanguageCollection) {
                int size = ((LanguageCollection)inputElement).size();
                Object[] lans = new LanguageInfo[size];
                for (int i = 0; i < size; ++i) {
                    lans[i] = ((LanguageCollection)inputElement).get(i);
                }
                return lans;
            }
            return new LanguageInfo[0];
        }
    }
}

