/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.solution;

import com.kingdee.bos.metadata.management.DataSourceInfo;
import com.kingdee.bos.metadata.management.JdbcDriverType;
import com.kingdee.bos.tool.utils.XMLResourceManager;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.jdom2.Content;
import org.jdom2.Element;

public class DataSourceManager {
    public static final String DATA_SOURCES = "datasources";
    public static final String DATA_SOURCE = "datasource";
    public static final String NAME = "name";
    public static final String DRIVER_TYPE = "drivertype";
    public static final String HOST_NAME = "host";
    public static final String PORT = "port";
    public static final String DB_NAME = "dbname";
    public static final String USER = "user";
    public static final String P = "password";

    public static Collection loadDataSources(IProject project) {
        ArrayList<DataSourceInfo> list = new ArrayList<DataSourceInfo>();
        IFile file = project.getFile(".solution.xml");
        if (file == null) {
            return list;
        }
        String filename = file.getLocation().toOSString();
        if (StringUtils.isEmpty((String)filename)) {
            return list;
        }
        Element eroot = XMLResourceManager.loadFromXML((String)filename);
        if (eroot == null) {
            return list;
        }
        Element dses = eroot.getChild(DATA_SOURCES);
        if (dses == null || dses.getChildren().isEmpty()) {
            return list;
        }
        for (Element ds : dses.getChildren()) {
            list.add(DataSourceManager.getDS(ds));
        }
        return list;
    }

    public static boolean storeDataSources(IProject project, Collection c) {
        IFile file = project.getFile(".solution.xml");
        if (file == null) {
            return false;
        }
        String filename = file.getLocation().toOSString();
        if (StringUtils.isEmpty((String)filename)) {
            return false;
        }
        Element eroot = XMLResourceManager.loadFromXML((String)filename);
        if (eroot == null) {
            return false;
        }
        Element dses = eroot.getChild(DATA_SOURCES);
        if (dses == null) {
            dses = new Element(DATA_SOURCES);
            eroot.addContent((Content)dses);
        } else {
            Iterator i = dses.getChildren().iterator();
            while (i.hasNext()) {
                dses.removeChild(((Element)i.next()).getName());
            }
        }
        for (DataSourceInfo ds : c) {
            dses.addContent((Content)DataSourceManager.getElement(ds));
        }
        int issuccess = XMLResourceManager.saveToXML((Element)eroot, (String)filename);
        return issuccess == 1;
    }

    private static DataSourceInfo getDS(Element e) {
        DataSourceInfo ds = new DataSourceInfo();
        String str = e.getChildTextTrim(DB_NAME);
        ds.setDbName(str == null ? "" : str);
        str = e.getChildTextTrim(DRIVER_TYPE);
        ds.setDriverType(str == null ? null : JdbcDriverType.getEnum((String)str));
        int port = new Integer(e.getChildTextTrim(PORT));
        ds.setPort(port);
        str = e.getChildTextTrim(HOST_NAME);
        ds.setHost(str == null ? "" : str);
        str = e.getChildTextTrim(USER);
        ds.setUser(str == null ? "" : str);
        str = e.getChildTextTrim(P);
        ds.setPassword(str == null ? "" : str);
        return ds;
    }

    private static Element getElement(DataSourceInfo ds) {
        Element eds = new Element(DATA_SOURCE);
        eds.addContent((Content)new Element(DB_NAME).setText(ds.getDbName()));
        eds.addContent((Content)new Element(DRIVER_TYPE).setText(ds.getDriverType().getName()));
        eds.addContent((Content)new Element(HOST_NAME).setText(ds.getHost()));
        eds.addContent((Content)new Element(PORT).setText(String.valueOf(ds.getPort())));
        eds.addContent((Content)new Element(USER).setText(ds.getUser()));
        eds.addContent((Content)new Element(P).setText(ds.getPassword()));
        return eds;
    }
}

