/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.stringextr.impl;

import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.stringextr.FileExtrInfo;
import com.kingdee.bos.tool.stringextr.FileTool;
import com.kingdee.bos.tool.stringextr.IStringExtractor;
import com.kingdee.bos.tool.stringextr.StringResourceInfo;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class EclipseJavaStringExtractor
implements IStringExtractor {
    public final String EXT_JAVA_NAME = "Messages.java";
    public final String PROPERTIES_NAME = "messages";
    public final String PROPERTIES_FILE = "messages_zh_CN.properties";
    public final String DEF_PROPERTIES_FILE = "messages.properties";

    @Override
    public String checkKey(String type, String key) {
        if (key.indexOf(46) != -1) {
            return "\u952e\u503c\u4e0d\u80fd\u5305\u542b.\u53f7";
        }
        return null;
    }

    @Override
    public void genExtCode(FileExtrInfo fileInfo, File destRoot) throws IOException {
        File destMsgJavaFile = new File(destRoot.getAbsolutePath() + File.separator + StringUtils.replace((String)fileInfo.getPkgName(), (String)".", (String)"/") + File.separator + "Messages.java");
        File msgJavaFile = null;
        if (destMsgJavaFile.exists()) {
            msgJavaFile = destMsgJavaFile;
        } else {
            msgJavaFile = new File(fileInfo.getSource().getParent() + File.separator + "Messages.java");
            if (!msgJavaFile.exists()) {
                msgJavaFile.createNewFile();
            }
        }
        StringBuffer msgJavaSB = FileTool.readFile(msgJavaFile);
        if (msgJavaSB.length() == 0) {
            msgJavaSB.append("package " + fileInfo.getPkgName() + ";\r\n");
            msgJavaSB.append("import org.eclipse.osgi.util.NLS;\r\n");
            msgJavaSB.append("public class Messages extends NLS {\r\n");
            msgJavaSB.append("\tprivate static final String BUNDLE_NAME = \"" + fileInfo.getPkgName() + "." + "messages" + "\";\r\n");
            msgJavaSB.append("\tstatic {\r\n");
            msgJavaSB.append("\t\tNLS.initializeMessages(BUNDLE_NAME, Messages.class);\r\n\t}\r\n");
            msgJavaSB.append("}");
        }
        List children = fileInfo.getStringInfos();
        for (int i = 0; i < children.size(); ++i) {
            StringResourceInfo sInfo = (StringResourceInfo)children.get(i);
            if (sInfo.isCanceled()) continue;
            int sPos = msgJavaSB.lastIndexOf("}");
            if (msgJavaSB.indexOf(sInfo.getKey() + ";") != -1) continue;
            msgJavaSB.insert(sPos - 1, "\n\tpublic static String " + sInfo.getKey() + ";");
        }
        FileTool.writ2File(msgJavaSB.toString(), destMsgJavaFile);
    }

    @Override
    public String getCode(String type, String pkgName, String key) {
        return pkgName + ".Messages." + key;
    }

    @Override
    public Properties loadOrgProperties(FileExtrInfo fileInfo, File destRoot) throws IOException {
        File targetFile = new File(destRoot + File.separator + StringUtils.replace((String)fileInfo.getPkgName(), (String)".", (String)"/") + File.separator + "messages_zh_CN.properties");
        if (targetFile.exists()) {
            return FileTool.readProperties(targetFile);
        }
        File file = new File(fileInfo.getSource().getParent() + File.separator + "messages_zh_CN.properties");
        if (!file.exists()) {
            file = new File(fileInfo.getSource().getParent() + File.separator + "messages.properties");
        }
        return FileTool.readProperties(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeProperties(Properties prop, FileExtrInfo fileInfo, File destRoot) throws IOException {
        File targetFile = new File(destRoot + File.separator + StringUtils.replace((String)fileInfo.getPkgName(), (String)".", (String)"/") + File.separator + "messages_zh_CN.properties");
        if (!targetFile.exists()) {
            targetFile.getParentFile().mkdirs();
            targetFile.createNewFile();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(targetFile);
            prop.store(out, "utf-8");
        }
        catch (Throwable throwable) {
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close(out);
    }
}

