/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.utils;

import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.util.SAXBuilderFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.osgi.framework.Bundle;

public class ClientVersionUtil {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.utils.ClientVersionUtil");

    public static boolean editable(String str) {
        String fileName = "/editablelist.xml";
        Bundle bundle = ToolCommonPlugin.getDefault().getBundle();
        String filePath = "";
        try {
            URL url = Platform.asLocalURL((URL)bundle.getEntry(fileName));
            if (url == null) {
                logger.error((Object)"cannot found editablelist.xml file!", null);
            }
            filePath = url.getPath();
        }
        catch (IOException e) {
            logger.debug((Object)"error", (Throwable)e);
        }
        File file = new File(filePath);
        if (!file.exists()) {
            logger.error((Object)"error, File does not exist!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(str, ".");
        Vector<String> sts = new Vector<String>();
        while (st.hasMoreTokens()) {
            sts.add(st.nextToken());
        }
        int size = sts.size();
        if (size < 1) {
            return false;
        }
        try {
            SAXBuilder builder = SAXBuilderFactory.create();
            Document doc = builder.build(file);
            Element root = doc.getRootElement();
            if (!root.getName().equals("editablelist")) {
                logger.error((Object)("error, " + file.getName() + "is not a valid file,root tag must be 'deployObjects'"));
                return false;
            }
            for (int i = 0; i < size; ++i) {
                Element te = root.getChild((String)sts.get(i));
                if (te == null) {
                    return false;
                }
                root = te;
            }
            return true;
        }
        catch (IOException ie) {
            logger.error((Object)("read file " + file.getAbsolutePath() + " error: " + ie.getMessage()));
            return false;
        }
        catch (JDOMException de) {
            logger.error((Object)("parse file " + file.getAbsolutePath() + " error: " + de.getMessage()));
            return false;
        }
    }

    public static void main(String[] args) {
        String ts1 = "entity.alias";
        boolean flag1 = ClientVersionUtil.editable(ts1);
        String ts2 = "entity.method.parameter";
        boolean flag2 = ClientVersionUtil.editable(ts2);
        String ts3 = "log.logItem.logBizRef.bizProperty.add";
        boolean flag3 = ClientVersionUtil.editable(ts3);
    }
}

