/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.AbstractMetaDataCtrl;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.tool.utils.MultiLangConvertException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.STConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MultiLangConvertUtil {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.utils.MultiLangConvertUtil");
    private SolutionInfo solution;
    private Context context;
    private String cnPostFix = null;
    private String hkPostFix = null;
    private String twPostFix = null;
    private String enPostFix = null;

    public MultiLangConvertUtil(SolutionInfo solution, Context context) {
        this.solution = solution;
        this.context = context;
        this.init();
    }

    private void init() {
        LanguageCollection languages = this.solution.getLanguages();
        int lSize = languages.size();
        for (int j = 0; j < lSize; ++j) {
            LanguageInfo lInfo = languages.get(j);
            String postfix = lInfo.getPostfix();
            String localStr = lInfo.getLocaleString();
            if (localStr.equals("zh_CN")) {
                this.cnPostFix = postfix;
                continue;
            }
            if (localStr.equals("zh_TW")) {
                this.twPostFix = postfix;
                continue;
            }
            if (localStr.equals("zh_HK")) {
                this.hkPostFix = postfix;
                continue;
            }
            if (!localStr.equals("en_US")) continue;
            this.enPostFix = postfix;
        }
    }

    public void sc2tc(IMetaDataPK pk, BOSObjectType type, boolean override) throws MultiLangConvertException {
        this.convert(pk, type, override, true, null);
    }

    public void sc2tc(IObjectValue model, boolean override) throws MultiLangConvertException {
        AbstractMetaDataValue metadata = (AbstractMetaDataValue)model;
        BOSObjectType type = metadata.getBOSType();
        MetaDataPK pk = new MetaDataPK(metadata.getPackage(), metadata.getName());
        this.convert((IMetaDataPK)pk, type, override, true, model);
    }

    public void tc2sc(IMetaDataPK pk, BOSObjectType type, boolean override) throws MultiLangConvertException {
        this.convert(pk, type, override, false, null);
    }

    public void tc2sc(IObjectValue model, boolean override) throws MultiLangConvertException {
        AbstractMetaDataValue metadata = (AbstractMetaDataValue)model;
        BOSObjectType type = metadata.getBOSType();
        MetaDataPK pk = new MetaDataPK(metadata.getPackage(), metadata.getName());
        this.convert((IMetaDataPK)pk, type, override, false, model);
    }

    private void convert(IMetaDataPK pk, BOSObjectType type, boolean override, boolean sc2tc, IObjectValue model) throws MultiLangConvertException {
        LanguageCollection languages = this.solution.getLanguages();
        int lSize = languages.size();
        boolean canDo = false;
        for (int i = 0; i < lSize; ++i) {
            LanguageInfo lInfo = languages.get(i);
            String localstr = lInfo.getLocaleString();
            if ((localstr.equals("zh_TW") || localstr.equals("zh_HK")) && sc2tc) {
                canDo = true;
                break;
            }
            if (!localstr.equals("zh_CN") || sc2tc) continue;
            canDo = true;
            break;
        }
        if (!canDo) {
            if (sc2tc) {
                throw new MultiLangConvertException("\u672a\u7ed9\u89e3\u51b3\u65b9\u6848\u8bbe\u7f6e\u7e41\u4f53\u4e2d\u6587\u9009\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
            if (!sc2tc) {
                throw new MultiLangConvertException("\u672a\u7ed9\u89e3\u51b3\u65b9\u6848\u8bbe\u7f6e\u7b80\u4f53\u4e2d\u6587\u9009\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
            }
        }
        Map<String, Map> tempmap = new HashMap();
        AbstractMetaDataCtrl tempctrl = null;
        try {
            tempctrl = (AbstractMetaDataCtrl)BOSObjectFactory.createBOSObject((Context)this.context, (BOSObjectType)type);
            if (tempctrl != null) {
                tempmap = tempctrl.loadResource(pk);
            }
            Set keys = tempmap.keySet();
            for (String key : keys) {
                if (key.indexOf("extendedProperty") != -1) continue;
                Map values = (Map)tempmap.get(key);
                this.cnPostFix = "l2";
                this.hkPostFix = "l3";
                this.twPostFix = "l3";
                this.enPostFix = "l1";
                String sc = (String)values.get(this.cnPostFix);
                if (sc == null) {
                    this.cnPostFix = "zh_CN";
                    this.hkPostFix = "zh_HK";
                    this.twPostFix = "zh_TW";
                    this.enPostFix = "en_US";
                    sc = (String)values.get(this.cnPostFix);
                }
                String hk = (String)values.get(this.hkPostFix);
                String tw = (String)values.get(this.twPostFix);
                String en = (String)values.get(this.enPostFix);
                if (sc != null && !sc.equals("") && sc2tc) {
                    String tc = STConverter.sc2tc((String)sc);
                    if (this.hkPostFix != null && (hk == null || hk.equals("") || override)) {
                        values.put(this.hkPostFix, tc);
                    }
                    if (this.twPostFix != null && (tw == null || tw.equals("") || override)) {
                        values.put(this.twPostFix, tc);
                    }
                    if (this.enPostFix != null && (en == null || en.equals("")) && !this.chineseCheck(sc) && type.equals((Object)MetaDataTypeList.UIOBJECT)) {
                        values.put(this.enPostFix, sc);
                    }
                } else if (tw != null && !tw.equals("") && !sc2tc) {
                    String tempsc = STConverter.tc2sc((String)tw);
                    if (this.cnPostFix != null && (sc == null || sc.equals("") || override)) {
                        values.put(this.cnPostFix, tempsc);
                    }
                }
                tempmap.put(key, values);
            }
        }
        catch (BOSException e) {
            logger.debug((Object)"", (Throwable)e);
            throw new MultiLangConvertException("\u65e0\u6cd5\u88c5\u8f7d\u7ed9\u5b9a\u7684\u5143\u6570\u636e" + pk.getFullName());
        }
        if (tempctrl != null) {
            try {
                if (model != null) {
                    tempctrl.storeResource(model, tempmap);
                } else {
                    tempctrl.storeResource(pk, tempmap);
                }
            }
            catch (Exception e) {
                logger.debug((Object)"", (Throwable)e);
                throw new MultiLangConvertException("\u4fdd\u5b58\u591a\u8bed\u8a00\u4fe1\u606f\u5931\u8d25\uff0c\u6587\u4ef6\uff1a" + pk.getFullName());
            }
        }
    }

    private boolean chineseCheck(String str) {
        byte[] bytes = str.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] > 0) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] a) {
    }
}

