/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.utils;

import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.tool.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPath;

public class XmlFileUtils {
    public static final String RUNTIME_SERVER_PROPERTIES_BOS_VERSION_DATA = "/runtime/server/properties/bos_version.data";
    public static final String RUNTIME_SERVER_PROPERTIES_EAS_VERSION_DATA = "/runtime/server/properties/eas_version.data";

    public static Element selectSingleNode(File xmlFile, String xpath_selector) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(xmlFile);
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((InputStream)inputStream);
            XPath dcXMLPath = XPath.newInstance((String)xpath_selector);
            Element element = (Element)dcXMLPath.selectSingleNode((Object)doc);
            return element;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("xml file no found!!!" + xmlFile, e);
        }
        catch (JDOMException e) {
            throw new RuntimeException("xml file parse error !!!" + xmlFile, e);
        }
        catch (IOException e) {
            throw new RuntimeException("xml file access error " + xmlFile, e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getProjectEasVersion(IMDProject project) {
        if (project.isDisposed()) {
            return "";
        }
        File easVerFile = new File(project.toFile().getAbsolutePath(), RUNTIME_SERVER_PROPERTIES_EAS_VERSION_DATA);
        return XmlFileUtils.getVersion(easVerFile, EAS_OR_BOS.EAS);
    }

    public static String getProjectBosVersion(IMDProject project) {
        if (project.isDisposed()) {
            return "";
        }
        File bosVerFile = new File(project.toFile().getAbsolutePath(), RUNTIME_SERVER_PROPERTIES_BOS_VERSION_DATA);
        return XmlFileUtils.getVersion(bosVerFile, EAS_OR_BOS.BOS);
    }

    public static boolean updateProjectVersion(IMDProject project, File bos_version, File eas_version) {
        if (!eas_version.exists() || !bos_version.exists()) {
            return false;
        }
        try {
            FileUtils.getFileUtils().copyFile(eas_version, new File(project.toFile().getAbsolutePath(), RUNTIME_SERVER_PROPERTIES_EAS_VERSION_DATA), true, false);
            FileUtils.getFileUtils().copyFile(bos_version, new File(project.toFile().getAbsolutePath(), RUNTIME_SERVER_PROPERTIES_BOS_VERSION_DATA), true, false);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static String getVersion(File versionFile, EAS_OR_BOS eas_or_bos) {
        if (!versionFile.exists()) {
            return "";
        }
        String condition = eas_or_bos.equals((Object)EAS_OR_BOS.BOS) ? "//Product[@name='BOS']" : "//Product[@name='EAS']";
        Element ele = XmlFileUtils.selectSingleNode(versionFile, condition);
        return ele == null ? "" : ele.getAttribute("productVersion").getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBundleVersionFromManifest(File manifest_mf) {
        if (!manifest_mf.exists()) {
            return "";
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(manifest_mf));
            String line = null;
            String server_version = null;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("Bundle-Version:")) continue;
                String string = server_version = line.replaceFirst("Bundle-Version:", "").trim();
                return string;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return "";
    }

    public static enum EAS_OR_BOS {
        EAS,
        BOS;

    }
}

