/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.views.verify;

import com.kingdee.bos.tool.views.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;

public class FilterDialog
extends Dialog {
    private Button limit;
    private Text limitText;
    private Button okButton;
    private Button errorButton;
    private Button warningButton;
    private Button fatalButton;
    private IMemento memento;

    public FilterDialog(Shell parentShell, IMemento memento) {
        super(parentShell);
        this.memento = memento;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.createEventTypesGroup(container);
        this.createLimitSection(container);
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void createEventTypesGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        gd.widthHint = 275;
        group.setLayoutData((Object)gd);
        group.setText(Messages.FilterDialog_XiaoYanLeiXingGuoLv);
        this.warningButton = new Button((Composite)group, 32);
        this.warningButton.setText(Messages.FilterDialog_JingGao);
        this.warningButton.setSelection(this.memento.getString("warning").equals("true"));
        this.errorButton = new Button((Composite)group, 32);
        this.errorButton.setText(Messages.FilterDialog_PuTongCuoWu);
        this.errorButton.setSelection(this.memento.getString("error").equals("true"));
        this.fatalButton = new Button((Composite)group, 32);
        this.fatalButton.setText(Messages.FilterDialog_ZhiMingCuoWu);
        this.fatalButton.setSelection(this.memento.getString("info").equals("true"));
    }

    private void createLimitSection(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.limit = new Button(comp, 32);
        this.limit.setText("");
        this.limit.setSelection(this.memento.getString("useLimit").equals("true"));
        this.limit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterDialog.this.limitText.setEnabled(((Button)e.getSource()).getSelection());
            }
        });
        this.limitText = new Text(comp, 2048);
        this.limitText.setTextLimit(4);
        this.limitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    if (FilterDialog.this.okButton == null) {
                        return;
                    }
                    Integer.parseInt(FilterDialog.this.limitText.getText());
                    FilterDialog.this.okButton.setEnabled(true);
                }
                catch (NumberFormatException e1) {
                    FilterDialog.this.okButton.setEnabled(false);
                }
            }
        });
        this.limitText.setLayoutData((Object)new GridData(768));
        this.limitText.setText(this.memento.getString("limit"));
        this.limitText.setEnabled(this.limit.getSelection());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.memento.putString("info", this.fatalButton.getSelection() ? "true" : "false");
        this.memento.putString("warning", this.warningButton.getSelection() ? "true" : "false");
        this.memento.putString("error", this.errorButton.getSelection() ? "true" : "false");
        this.memento.putString("limit", this.limitText.getText());
        this.memento.putString("useLimit", this.limit.getSelection() ? "true" : "false");
        super.okPressed();
    }
}

