/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.views.verify;

import com.kingdee.bos.dao.xml.CheckReportItem;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.tool.views.verify.VerifyMessageEntry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;

public class LogViewContentProvider
implements IStructuredContentProvider {
    private IMemento memento;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            List messages = (List)inputElement;
            boolean showFatal = true;
            boolean showWarning = true;
            boolean showError = true;
            int limit = -1;
            boolean uselimit = false;
            if (this.memento != null) {
                showFatal = Boolean.valueOf(this.memento.getString("info"));
                showWarning = Boolean.valueOf(this.memento.getString("warning"));
                showError = Boolean.valueOf(this.memento.getString("error"));
                uselimit = Boolean.valueOf(this.memento.getString("useLimit"));
                String ll = this.memento.getString("limit");
                if (ll != null && ll.length() > 0) {
                    boolean canuse = true;
                    for (int i = 0; i < ll.length(); ++i) {
                        char c = ll.charAt(i);
                        if (c >= '0' && c <= '9') continue;
                        canuse = false;
                        break;
                    }
                    if (canuse) {
                        limit = Integer.parseInt(ll);
                    }
                }
            }
            ArrayList<VerifyMessageEntry> temp = new ArrayList<VerifyMessageEntry>();
            int j = messages.size();
            for (int i = 0; i < j; ++i) {
                VerifyMessageEntry entry = new VerifyMessageEntry();
                if (messages.get(i) != null && messages.get(i) instanceof CheckReportItem) {
                    StringBuffer msg = new StringBuffer("");
                    CheckReportItem item = (CheckReportItem)messages.get(i);
                    int size = item.getMessages().length;
                    for (int k = 0; k < size; ++k) {
                        msg.append(item.getMessages()[k]);
                        msg.append("\n");
                    }
                    entry.setMessage(msg.toString());
                    MetaDataInfo md = new MetaDataInfo();
                    md.setName(item.getMetaDataPK().getName());
                    md.setPackage(item.getMetaDataPK().getPackage());
                    md.setMetaDataType(item.getMetaDataType().toString());
                    entry.setTarget(md);
                    entry.setLevel(item.getLevel());
                } else {
                    entry = (VerifyMessageEntry)messages.get(i);
                }
                int level = entry.getLevel();
                switch (level) {
                    case 0: {
                        if (!showError) break;
                        temp.add(entry);
                        break;
                    }
                    case 1: {
                        if (!showWarning) break;
                        temp.add(entry);
                        break;
                    }
                    case 2: {
                        if (!showFatal) break;
                        temp.add(entry);
                        break;
                    }
                    default: {
                        temp.add(entry);
                    }
                }
                if (uselimit && limit > -1 && temp.size() >= limit) break;
            }
            return temp.toArray(new VerifyMessageEntry[temp.size()]);
        }
        return EMPTY_ARRAY;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public void setMemento(IMemento memento) {
        this.memento = memento;
    }
}

