/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.wizard;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.engine.MDNotFoundException;
import com.kingdee.bos.md.mdfs.IMDObject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.md.wizard.BaseMDWizardPage;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.context.IToolContext;
import com.kingdee.bos.tool.context.ToolContextManager;
import com.kingdee.bos.tool.dao.ORMStudioBridger;
import com.kingdee.bos.tool.dao.ORMUtil;
import com.kingdee.bos.tool.dialog.SelectMetaDataDialog;
import com.kingdee.bos.tool.utils.EditorHelper;
import com.kingdee.bos.tool.utils.ExtHierarchyTreeNode;
import com.kingdee.bos.tool.wizard.ISelectionWizard;
import com.kingdee.bos.tool.wizard.NewExtendMetadataWizard;
import com.kingdee.bos.util.BOSObjectType;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewExtendMetadataWizardPage
extends BaseMDWizardPage {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.wizard.NewExtendMetadataWizardPage");
    private static String PAGE_NAME = "NewExtendMetadataWizardPage";
    private Group group;
    protected Text stdMDTxt;
    protected Button mdSelBtn;
    protected Combo extDirTxt;
    private String[] btnTexts;
    private String[] btnDatas;
    protected IFile standardMetadataFile;

    public NewExtendMetadataWizardPage(String[] btnTexts, String[] btnDatas) {
        super(PAGE_NAME);
        this.setTitle("\u884c\u4e1a\u5143\u6570\u636e");
        this.setDescription("\u521b\u5efa\u4e00\u4e2a\u884c\u4e1a\u5143\u6570\u636e");
        this.btnTexts = btnTexts;
        this.btnDatas = btnDatas;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 10;
        container.setLayout((Layout)layout);
        this.group = new Group(container, 0);
        GridData stdGroupGD = new GridData(768);
        stdGroupGD.horizontalSpan = 3;
        this.group.setLayoutData((Object)stdGroupGD);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 4;
        groupLayout.makeColumnsEqualWidth = true;
        this.group.setLayout((Layout)groupLayout);
        this.group.setText("\u5143\u6570\u636e\u7c7b\u578b");
        for (int i = 0; i < this.btnTexts.length; ++i) {
            Button btn = new Button((Composite)this.group, 16);
            btn.setText(this.btnTexts[i]);
            btn.setData((Object)this.btnDatas[i]);
        }
        new Label(container, 0).setText("\u6807\u51c6\u5143\u6570\u636e(&S):");
        this.stdMDTxt = new Text(container, 2048);
        this.stdMDTxt.setLayoutData((Object)new GridData(768));
        this.mdSelBtn = new Button(container, 8);
        this.mdSelBtn.setText("\u6d4f\u89c8(&B)...");
        this.mdSelBtn.setLayoutData((Object)new GridData(128));
        new Label(container, 0).setText("\u884c\u4e1a\u6587\u4ef6\u5939(&E):");
        this.extDirTxt = new Combo(container, 2052);
        this.extDirTxt.setLayoutData((Object)new GridData(768));
        new Label(container, 0).setVisible(false);
        this.setPageComplete(false);
        this.initExtArea();
        this.setControl((Control)container);
    }

    public void performFinish(IProgressMonitor monitor) throws IDEException {
        NewExtendMetadataWizard wizard = (NewExtendMetadataWizard)this.getWizard();
        AbstractMetaDataValue model = wizard.getStandardModel();
        IProject project = this.getFirstSelection().getProject();
        String extDirName = this.extDirTxt.getText();
        IFolder selFolder = project.getFolder(extDirName);
        IFile file = ORMUtil.getFile(selFolder, (IObjectValue)model);
        IDevMetadataLoader loader = ToolContextManager.getMetadataLoader(project.getFolder(extDirName));
        try {
            loader.tagExtend(model.getBOSType(), ORMStudioBridger.getFilePK((IResource)file));
            model = loader.loadMetadata(model.getBOSType(), MetaDataPKFactory.getMetaDataPK((String)model.getFullName()));
        }
        catch (MDNotFoundException e) {
            logger.debug((Object)"error", (Throwable)e);
        }
        file = ORMUtil.getFile(selFolder, (IObjectValue)model);
        EditorHelper.openFile(MDResourceUtil.toMDFile(file));
    }

    protected void initExtArea() {
        Button ctl;
        int i;
        IResource res = this.getFirstSelection();
        if (res == null) {
            return;
        }
        IProject project = res.getProject();
        IToolContext ctx = ToolContextManager.getContext(project);
        if (res instanceof IFile) {
            IMetaDataPK mpk = ORMStudioBridger.getFilePK((IResource)((IFile)res));
            this.stdMDTxt.setText(mpk.getPackage() + "." + mpk.getName());
            String suffix = ((IFile)res).getFileExtension();
            if (suffix.startsWith(".")) {
                suffix = suffix.substring(1);
            }
            Control[] children = this.group.getChildren();
            boolean everBreak = false;
            for (i = 0; i < children.length; ++i) {
                ctl = (Button)children[i];
                String data = (String)ctl.getData();
                if (suffix == null || !suffix.equals(data)) continue;
                ctl.setSelection(true);
                everBreak = true;
                break;
            }
            if (!everBreak) {
                Button ctl2 = (Button)children[0];
                ctl2.setSelection(true);
            }
        }
        Vector exdDirs = ctx.getExtDirs();
        int size = exdDirs.size();
        String[] items = new String[size];
        exdDirs.toArray(items);
        this.extDirTxt.setItems(items);
        if (items.length > 0) {
            this.extDirTxt.select(0);
            IFolder folder = ORMStudioBridger.getFolder(this.getFirstSelection());
            String fName = folder.getName();
            if (exdDirs.contains(fName)) {
                this.extDirTxt.setText(fName);
            }
        }
        if (res instanceof IFile) {
            this.standardMetadataFile = (IFile)res;
            try {
                AbstractMetaDataValue amv = (AbstractMetaDataValue)ORMUtil.load(this.standardMetadataFile);
                NewExtendMetadataWizard wizard = (NewExtendMetadataWizard)this.getWizard();
                wizard.setStandardModel(amv);
            }
            catch (IDEException e) {
                logger.debug((Object)"error", (Throwable)e);
            }
            this.verify();
        }
        this.mdSelBtn.addSelectionListener((SelectionListener)new ButtonSelectionListener());
        this.stdMDTxt.addModifyListener((ModifyListener)new ExtAreaModifyListener());
        this.extDirTxt.addModifyListener((ModifyListener)new ExtAreaModifyListener());
        Control[] children = this.group.getChildren();
        for (i = 0; i < children.length; ++i) {
            ctl = (Button)children[i];
            ctl.addSelectionListener((SelectionListener)new ButtonSelectionListener());
        }
    }

    protected IResource getFirstSelection() {
        IStructuredSelection fSelection;
        if (this.getWizard() instanceof ISelectionWizard && (fSelection = ((ISelectionWizard)this.getWizard()).getSelection()) != null && !fSelection.isEmpty()) {
            Object obj = fSelection.getFirstElement();
            if (obj instanceof IResource) {
                return (IResource)obj;
            }
            if (obj instanceof ExtHierarchyTreeNode) {
                ExtHierarchyTreeNode node = (ExtHierarchyTreeNode)((Object)obj);
                String proname = node.getProjectName();
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject pro = root.getProject(proname);
                IToolContext ctx = ToolContextManager.getContext(pro);
                String src = ctx.getSrcName();
                IFolder folder = pro.getFolder(src);
                String name = (String)node.getUserObject();
                int index = name.indexOf(46);
                if (index < 0) {
                    return folder;
                }
                String extension = name.substring(index + 1);
                BOSObjectType type = BOSObjectType.create((String)Utils.getBOSTypeBySuffix((String)extension));
                name = name.substring(0, index);
                Object[] objs = node.getUserObjectPath();
                String[] path = new String[objs.length];
                System.arraycopy(objs, 0, path, 0, objs.length);
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < path.length - 1; ++i) {
                    sb.append(path[i]);
                    sb.append(".");
                }
                sb.append(name);
                IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)sb.toString());
                return ORMUtil.getFile(pro, type, pk);
            }
        }
        return null;
    }

    protected void selectStdMD() {
        String[] suffixes = new String[1];
        NewExtendMetadataWizard wizard = null;
        if (this.getWizard() != null && this.getWizard() instanceof NewExtendMetadataWizard) {
            wizard = (NewExtendMetadataWizard)this.getWizard();
            Control[] children = this.group.getChildren();
            for (int i = 0; i < children.length; ++i) {
                Button ctl = (Button)children[i];
                if (ctl == null || !ctl.getSelection()) continue;
                suffixes[0] = (String)ctl.getData();
                break;
            }
        }
        SelectMetaDataDialog dlg = new SelectMetaDataDialog(this.getShell(), suffixes, (IMDObject)this.getMDProject());
        dlg.create();
        if (0 == dlg.open()) {
            this.standardMetadataFile = MDResourceUtil.toIFile(dlg.getSelectedFile());
            AbstractMetaDataValue value = dlg.getFirstSelection();
            wizard.setStandardModel(value);
            String pk = (String)value.get("package");
            String name = (String)value.get("name");
            this.stdMDTxt.setText(pk + "." + name);
        }
    }

    protected void verify() {
        IProject project;
        String extDirName = this.extDirTxt.getText();
        String mdName = this.stdMDTxt.getText();
        if (extDirName == null || extDirName.length() < 1) {
            this.setErrorMsg("\u8bf7\u9009\u62e9\u884c\u4e1a\u5143\u6570\u636e\u653e\u7f6e\u76ee\u5f55!");
            return;
        }
        if (extDirName != null && extDirName.length() > 0 && !(project = this.getFirstSelection().getProject()).getFolder(extDirName).exists()) {
            this.setErrorMsg("\u6240\u9009\u62e9\u7684\u884c\u4e1a\u5143\u6570\u636e\u653e\u7f6e\u76ee\u5f55\u4e0d\u5b58\u5728!");
            return;
        }
        if (mdName == null || mdName.length() < 1) {
            this.setErrorMsg("\u8bf7\u9009\u62e9\u6807\u51c6\u5143\u6570\u636e!");
            return;
        }
        if (mdName != null && mdName.length() > 0) {
            IMetaDataPK pk;
            IFolder operateFolder;
            IFile file;
            BOSObjectType iniType = null;
            Control[] children = this.group.getChildren();
            for (int i = 0; i < children.length; ++i) {
                Button ctl = (Button)children[i];
                if (ctl == null || !ctl.getSelection()) continue;
                String suffix = (String)ctl.getData();
                iniType = BOSObjectType.create((String)Utils.getBOSTypeBySuffix((String)suffix));
                break;
            }
            if (!(file = ORMUtil.getFile(operateFolder = this.getStandardMetadataFolder(), iniType, pk = MetaDataPKFactory.getMetaDataPK((String)mdName))).getLocation().toFile().exists()) {
                this.setErrorMsg("\u6240\u9009\u62e9\u7684\u6807\u51c6\u5143\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u7c7b\u578b\u6709\u8bef!");
                return;
            }
            IProject project2 = this.getFirstSelection().getProject();
            operateFolder = project2.getFolder(extDirName);
            file = ORMUtil.getFile(operateFolder, iniType, pk);
            if (file.getLocation().toFile().exists()) {
                this.setErrorMsg("\u6240\u9009\u62e9\u7684\u6807\u51c6\u5143\u6570\u636e\u7684\u63d2\u4ef6\u5df2\u7ecf\u5b58\u5728!");
                return;
            }
        }
        this.setErrorMsg(null);
    }

    protected IFolder getStandardMetadataFolder() {
        IProject project = this.getFirstSelection().getProject();
        IFolder operateFolder = project.getFolder("basetemp");
        return operateFolder;
    }

    protected void setErrorMsg(String msg) {
        this.setErrorMessage(msg);
        if (msg == null) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    private void btnSelected(SelectionEvent e) {
        if (e.getSource().equals(this.mdSelBtn)) {
            this.selectStdMD();
        } else {
            this.verify();
        }
    }

    private class ExtAreaModifyListener
    implements ModifyListener {
        private ExtAreaModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            NewExtendMetadataWizardPage.this.verify();
        }
    }

    private class ButtonSelectionListener
    extends SelectionAdapter {
        private ButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            NewExtendMetadataWizardPage.this.btnSelected(e);
        }
    }
}

