/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.wizard.saveas;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.tool.dao.ORMStudioBridger;
import com.kingdee.bos.tool.utils.CheckUtils;
import com.kingdee.bos.tool.wizard.AbstractMetaDataWizardPage;
import com.kingdee.bos.tool.wizard.BaseViewerWizard;
import com.kingdee.bos.tool.wizard.saveas.Messages;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SaveAsWizardPage
extends AbstractMetaDataWizardPage {
    private static final String SAVE_AS_NAME = "SaveAsWizardPage";
    private static final String INVALID_PACKAGE_NAME = Messages.SaveAsWizardPage_BuHeFaDeBaoMing;
    private IObjectValue model;

    public SaveAsWizardPage(IObjectValue model) {
        super(SAVE_AS_NAME);
        this.model = model;
        this.setTitle(Messages.SaveAsWizardPage_LingCunWei);
        this.setDescription(Messages.SaveAsWizardPage_CunWeiLingYiGeDuiXiang);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.fName != null && visible) {
            this.fName.setFocus();
        }
    }

    public void createControl(Composite parent) {
        Composite container = this.layoutChildContainer(parent, 3);
        this.layoutPackage(container);
        this.layoutName(container);
        TextModifyListener listener = new TextModifyListener();
        this.fName.addModifyListener((ModifyListener)listener);
        this.fPKName.addModifyListener((ModifyListener)listener);
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    @Override
    protected void init() {
        String str = ((AbstractMetaDataValue)this.model).getPackage();
        if (str != null) {
            this.fPKName.setText(str);
        }
        if ((str = ((AbstractMetaDataValue)this.model).getName()) != null) {
            this.fName.setText(str);
        }
    }

    protected void performFinish(IProgressMonitor monitor) {
        ((AbstractMetaDataValue)this.model).setPackage(this.fPKName.getText().trim());
        ((AbstractMetaDataValue)this.model).setName(this.fName.getText().trim());
        if (this.model.getBOSType().equals((Object)MetaDataTypeList.UIOBJECT)) {
            UIObjectInfo uiModel = (UIObjectInfo)this.model;
            String packageName = this.fPKName.getText().trim();
            String className = this.fName.getText().trim();
            uiModel.setPackage(packageName);
            uiModel.setReleasePackage(packageName);
            uiModel.setName(className);
            uiModel.setReleaseClass(className);
        }
    }

    private void inputIntoModel(ModifyEvent e) {
        if (e.getSource().equals(this.fName)) {
            ((AbstractMetaDataValue)this.model).setName(this.fName.getText().trim());
        } else if (e.getSource().equals(this.fPKName)) {
            ((AbstractMetaDataValue)this.model).setPackage(this.fPKName.getText().trim());
        }
    }

    private void verify() {
        IStructuredSelection sel = ((BaseViewerWizard)this.getWizard()).getSelection();
        IFolder folder = ORMStudioBridger.getFolder((IResource)sel.getFirstElement());
        if (!CheckUtils.isCommonMetaDataName(this.model.getBOSType(), this.fName.getText()) || CheckUtils.exist(folder, this.fPKName.getText(), this.fName.getText(), this.model.getBOSType())) {
            this.setErrorMessage(Messages.SaveAsWizardPage_BuHeFaDeMingChengHuoZheCunZaiTongMingDeDuiXiang);
            this.setPageComplete(false);
            return;
        }
        if (!CheckUtils.isValidPackageName(this.fPKName.getText())) {
            this.setErrorMessage(INVALID_PACKAGE_NAME);
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            SaveAsWizardPage.this.inputIntoModel(e);
            SaveAsWizardPage.this.verify();
        }
    }
}

