/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.utils;

import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.engine.MDNotFoundException;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDObject;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.IResourceChangeListener;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.webui.transfer.UIType;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.bos.utils.DefaultFileContext;
import com.kingdee.bos.utils.FileAccessSupport;
import com.kingdee.bos.utils.IFileAccessInfo;
import com.kingdee.bos.utils.IFileAccessRule;
import com.kingdee.bos.utils.IFileContext;
import com.kingdee.bos.utils.NullFileContext;
import com.kingdee.bos.utils.ProjectContext;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPath;

public class DefaultFileAccessRule
implements IFileAccessRule {
    DefaultFileAccessInfo _FileAccessRule_;
    private static String disMetadataClosed = null;
    private static Map<String, Map<String, List<String>>> cache = new HashMap<String, Map<String, List<String>>>();

    DefaultFileAccessRule() {
        this.registListener();
    }

    private void registListener() {
        MDResourceUtil.addResourceUpdateListener(new IResourceChangeListener(){

            @Override
            public void resourceCreated(IMDObject[] objects) {
            }

            @Override
            public void resourceDeleted(IMDObject[] objects) {
                for (IMDObject obj : objects) {
                    if (!(obj instanceof IMDProject)) continue;
                    DefaultFileAccessRule.clearCache((IMDProject)obj);
                }
            }

            @Override
            public void resourceUpdated(IMDObject[] objects) {
            }

            @Override
            public void workspaceUpdated() {
            }
        });
    }

    @Override
    public IFileAccessInfo getAccessInfo() {
        if (this._FileAccessRule_ == null) {
            this._FileAccessRule_ = new DefaultFileAccessInfo();
        }
        return this._FileAccessRule_;
    }

    public static boolean isDisMetadataClosed() {
        if (disMetadataClosed != null) {
            return "true".equalsIgnoreCase(disMetadataClosed);
        }
        try {
            URL url = ToolCommonPlugin.getPlugInURL("toolcommon.properties");
            Properties prs = new Properties();
            prs.load(url.openStream());
            disMetadataClosed = prs.getProperty("disMetadataClosed", "false");
            return "true".equalsIgnoreCase(disMetadataClosed);
        }
        catch (IDEException iDEException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean checkFileRule(ProjectContext context, IMDFile mdFile, FileAccessRule rule, Object field) {
        if (DefaultFileAccessRule.isDisMetadataClosed()) {
            return true;
        }
        if (rule.equals((Object)FileAccessRule.READ)) {
            return true;
        }
        if (DefaultFileAccessRule.checkWithDevModel(context.getDevModel())) {
            return true;
        }
        return DefaultFileAccessRule.checkWithSolutionONCustom(context.getProject(), context.getProject().isExtSolution(), mdFile, rule, field);
    }

    private static boolean existWithWhiteList(IMDFile mdFile) {
        if (mdFile.toFile().exists()) {
            return true;
        }
        if (DefaultFileAccessRule.getDepConfigFileList(mdFile.getMDProject()).size() == 0) {
            return true;
        }
        try {
            AbstractMetaDataValue md = DefaultFileAccessRule.getValue(mdFile.getMDProject(), mdFile.getBOSType(), (IMetaDataPK)mdFile.getMetaDataPK());
            return DefaultFileAccessRule.isAllowEdit(mdFile.getMDProject(), md);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static AbstractMetaDataValue getValue(IMDProject prj, BOSObjectType type, IMetaDataPK pk) throws MDNotFoundException {
        return prj.getMetadataLoader().loadMetadata(type, pk, false);
    }

    public static boolean isAllowEdit(IMDProject prj, AbstractMetaDataValue metadata) {
        if (BizUnitInfo.class.isInstance(metadata)) {
            return DefaultFileAccessRule.isAllowEdit(prj, (BizUnitInfo)metadata);
        }
        if (UIObjectInfo.class.isInstance(metadata)) {
            return DefaultFileAccessRule.isAllowEdit(prj, (UIObjectInfo)metadata);
        }
        return false;
    }

    public static void clearCache(IMDProject prj) {
        cache.remove(prj.getName());
    }

    public static boolean isInDepWhiteList(IMDProject prj, UIObjectInfo ui) {
        List<File> list = DefaultFileAccessRule.getDepConfigFileList(prj);
        if (cache.get(prj.getName()) == null) {
            cache.put(prj.getName(), new HashMap());
        }
        for (File file : list) {
            if (cache.get(prj.getName()).containsKey(file.getName())) continue;
            cache.get(prj.getName()).put(file.getName(), DefaultFileAccessRule.parseDepWhiteFile(file));
        }
        return DefaultFileAccessRule.contain(cache.get(prj.getName()).values(), ui.getFullName());
    }

    private static boolean contain(Collection<List<String>> col, String name) {
        for (List<String> list : col) {
            if (!list.contains(name)) continue;
            return true;
        }
        return false;
    }

    private static List<String> parseDepWhiteFile(File file) {
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(file);
            XPath xpath = XPath.newInstance((String)"metas/uis/ui");
            List list = xpath.selectNodes((Object)doc);
            ArrayList<String> dep_ui_names = new ArrayList<String>();
            for (Object obj : list) {
                Element ele = (Element)obj;
                dep_ui_names.add(ele.getAttributeValue("name"));
            }
            return dep_ui_names;
        }
        catch (Exception e) {
            LogTool.logError("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef,\u89e3\u6790\u51fa\u9519!" + file, e);
            return new ArrayList<String>();
        }
    }

    private static boolean isAllowEdit(IMDProject prj, UIObjectInfo editUI) {
        if (editUI != null && DefaultFileAccessRule.isEditUI(editUI)) {
            if (UIType.EDITUI != DefaultFileAccessRule.getUIType(editUI)) {
                return true;
            }
            return !DefaultFileAccessRule.isInDepWhiteList(prj, editUI);
        }
        return false;
    }

    private static boolean isAllowEdit(IMDProject prj, BizUnitInfo biz) {
        if (biz.getEditUIPK() == null) {
            return true;
        }
        try {
            UIObjectInfo uiObj = (UIObjectInfo)DefaultFileAccessRule.getValue(prj, MetaDataTypeList.UIOBJECT, (IMetaDataPK)MetaDataPK.create((String)biz.getEditUIPK()));
            return DefaultFileAccessRule.isAllowEdit(prj, uiObj);
        }
        catch (Exception exception) {
            return true;
        }
    }

    private static List<File> getDepConfigFileList(IMDProject prj) {
        String dep_path = "runtime/server/properties/dep/whitelist";
        File dep = new File(prj.getBaseMetadataDir().getParent(), dep_path);
        Object[] fileList = dep.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
        if (fileList != null) {
            return Arrays.asList((Object[])fileList);
        }
        return new ArrayList<File>();
    }

    public static boolean isEditUI(UIObjectInfo ui) {
        if (ui == null) {
            return false;
        }
        for (UIObjectInfo parent = ui.getParent(); parent != null; parent = parent.getParent()) {
            if (!"com.kingdee.eas.framework.client.EditUI".equals(parent.getFullName())) continue;
            return true;
        }
        return false;
    }

    public static UIType getUIType(UIObjectInfo ui) {
        if (ui != null) {
            DataObjectCollection col = ui.getDataObjects();
            DataObjectInfo doInfo = null;
            for (int i = 0; i < col.size(); ++i) {
                doInfo = col.get(i);
                if (doInfo == null) continue;
                if (MetaDataTypeList.ENTITY.toString().equals(doInfo.getObjectType())) {
                    return UIType.EDITUI;
                }
                if (!MetaDataTypeList.JOINQUERY.toString().equals(doInfo.getObjectType())) continue;
                return UIType.LISTUI;
            }
            return DefaultFileAccessRule.getUIType(ui.getParent());
        }
        return null;
    }

    public static IFileContext createFileContext(String resourceName) {
        return DefaultFileAccessRule.createFileContext(DefaultFileAccessRule.class.getResourceAsStream(resourceName));
    }

    private static IFileContext createFileContext(InputStream input) {
        return input == null ? new NullFileContext() : new DefaultFileContext(input);
    }

    public static boolean checkWithDevModel(ProjectContext.DevModel model) {
        return model.equals((Object)ProjectContext.DevModel.DEV_MODEL);
    }

    public static boolean isInLibs(IMDProject project, IMDFile mdFile) {
        return mdFile.isInLib();
    }

    public static boolean isUseDefined(Object field) {
        if (field instanceof String) {
            return false;
        }
        try {
            if (field instanceof FileAccessSupport.IUserDefinedAdapter) {
                return ((FileAccessSupport.IUserDefinedAdapter)field).isUserDefined();
            }
            if (field instanceof AbstractMDValue) {
                return ((AbstractMDValue)field).getBoolean("userDefined");
            }
            return (Boolean)field.getClass().getMethod("isUserDefined", new Class[0]).invoke(field, new Object[0]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean checkWithSolutionONCustom(IMDProject project, boolean isExtSolution, IMDFile mdFile, FileAccessRule rule, Object field) {
        if (DefaultFileAccessRule.isInLibs(project, mdFile)) {
            return DefaultFileAccessRule.checkWithSystemFileOnCustom(isExtSolution, rule, field, DefaultFileAccessRule.existWithWhiteList(mdFile));
        }
        return DefaultFileAccessRule.checkWithCustomFileWithCustom(isExtSolution, rule, field);
    }

    public static boolean checkWithSystemFileOnCustom(boolean isExtSolution, FileAccessRule rule, Object field, boolean isInWhite) {
        if (isExtSolution || isInWhite) {
            if (FileAccessRule.ADDFIELD.equals((Object)rule) || FileAccessRule.WRITE.equals((Object)rule)) {
                return true;
            }
            return field != null && DefaultFileAccessRule.isUseDefined(field);
        }
        return false;
    }

    public static boolean checkWithCustomFileWithCustom(boolean isExtSolution, FileAccessRule rule, Object field) {
        return true;
    }

    class DefaultFileAccessInfo
    implements IFileAccessInfo {
        DefaultFileAccessInfo() {
        }

        @Override
        public boolean canRead(ProjectContext context, IMDFile mdFile) {
            return DefaultFileAccessRule.checkFileRule(context, mdFile, FileAccessRule.READ, null);
        }

        @Override
        public boolean canWrite(ProjectContext context, IMDFile mdFile) {
            return DefaultFileAccessRule.checkFileRule(context, mdFile, FileAccessRule.WRITE, null);
        }

        @Override
        public boolean canAddField(ProjectContext context, IMDFile mdFile) {
            return DefaultFileAccessRule.checkFileRule(context, mdFile, FileAccessRule.ADDFIELD, null);
        }

        @Override
        public boolean canDeleteField(ProjectContext context, IMDFile mdFile, Object field) {
            return DefaultFileAccessRule.checkFileRule(context, mdFile, FileAccessRule.DELETEFIELD, field);
        }

        @Override
        public boolean canModifyField(ProjectContext context, IMDFile mdFile, Object field) {
            return DefaultFileAccessRule.checkFileRule(context, mdFile, FileAccessRule.MODIFYFIELD, field);
        }
    }

    static enum FileAccessRule {
        READ,
        WRITE,
        ADDFIELD,
        DELETEFIELD,
        MODIFYFIELD;

    }
}

