/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cust;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.cust.WFRoleFactory;
import com.kingdee.bos.workflow.cust.WFRoleInfo;
import com.kingdee.bos.workflow.cust.WFRoleState;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.DataSubmitModeEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WFRoleDataImport
extends AbstractDataTransmission {
    protected static Logger logger = Logger.getLogger((String)WFRoleDataImport.class.getName());
    private HashMap adminOrgMap = new HashMap(2);
    private IObjectPK TEMPPK = null;
    private Set idsEverImported = new HashSet();
    String[] exportfields = new String[]{"tree.number", "tree.name", "roleName", "roleNumber"};
    Map<String, CoreBaseInfo> cache = new HashMap<String, CoreBaseInfo>();
    Map<String, WFRoleInfo> roleCache = new HashMap<String, WFRoleInfo>();

    protected DataSubmitModeEnum getDataSubmitMode() {
        return DataSubmitModeEnum.SQL;
    }

    protected String[] getExportFields() {
        return null;
    }

    public Map<String, String> exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            for (int i = 0; i < this.exportfields.length; ++i) {
                if (StringUtils.isEmpty((String)rs.getString(this.exportfields[i]))) continue;
                result.put(this.exportfields[i], rs.getString(this.exportfields[i]));
            }
            String[] childFields = this.getExportFields();
            if (childFields != null) {
                for (int i = 0; i < childFields.length; ++i) {
                    if (StringUtils.isEmpty((String)rs.getString(childFields[i]))) continue;
                    result.put(childFields[i], rs.getString(childFields[i]));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new TaskExternalException("Database access error occurs, can't read field values!", (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof TaskExternalException) {
                throw (TaskExternalException)e;
            }
            logger.error((Object)e.getMessage());
        }
        return result;
    }

    protected void putBoolean(IRowSet rs, Map<String, String> result, String fieldName) throws TaskExternalException {
        try {
            String val = rs.getString(fieldName);
            val = "true".equals(val) ? "\u662f" : "\u5426";
            result.put(fieldName, val);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new TaskExternalException("Database access error occurs, can't read field values!", (Throwable)e);
        }
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.bos.workflow.cust.app.WFRolewithEntryQuery";
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return WFRoleFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), bex.getCause());
        }
    }

    public int getSubmitType() {
        return 1;
    }

    public String getMainField() {
        return "number";
    }

    protected CoreBaseInfo getInfoPKbyNumber(Context ctx, ICoreBase coreBase, String number) throws TaskExternalException {
        String key = coreBase.getName() + "$$" + number;
        CoreBaseInfo info = this.cache.get(key);
        if (info != null) {
            return info;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        try {
            CoreBaseCollection col = coreBase.getCollection(viewInfo);
            if (col.size() > 0) {
                info = col.get(0);
                this.cache.put(key, info);
                return info;
            }
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), bex.getCause());
        }
        return null;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase ipurReturns = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !ipurReturns.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                this.TEMPPK = ipurReturns.addnew(coreBaseInfo);
            } else {
                ipurReturns.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
            this.idsEverImported.add(this.TEMPPK);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    protected String getStringTokenValue(String key, Hashtable hsData) {
        if (hsData.get(key) == null) {
            return null;
        }
        return (String)((DataToken)hsData.get((Object)key)).data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable chsData, Context ctx) throws TaskExternalException {
        WFRoleInfo info = new WFRoleInfo();
        UserInfo userinfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        info.setAdmin(userinfo);
        info.setState(WFRoleState.enabled);
        boolean isUpdate = this.isSltImportUpdate();
        for (int t = 0; t < chsData.size(); ++t) {
            Hashtable hsData = (Hashtable)chsData.get(t);
            String roleNumber = this.getStringTokenValue("roleNumber", hsData);
            String roleName = this.getStringTokenValue("roleName", hsData);
            if (StringUtils.isEmpty((String)roleNumber)) {
                throw new TaskExternalException("\u89d2\u8272\u7f16\u7801\u5fc5\u5f55\u3002");
            }
            if (StringUtils.isEmpty((String)roleName)) {
                throw new TaskExternalException("\u89d2\u8272\u540d\u79f0\u5fc5\u5f55\u3002");
            }
            if (this.roleCache.containsKey(roleNumber)) {
                info = this.roleCache.get(roleNumber);
            } else {
                CoreBaseInfo cbi = this.getInfoPKbyNumber(ctx, this.getController(ctx), roleNumber);
                if (cbi != null) {
                    this.TEMPPK = new ObjectUuidPK(cbi.getId());
                    if (!isUpdate) throw new TaskExternalException("\u7f16\u7801" + roleNumber + "\u7684\u89d2\u8272\u5df2\u5b58\u5728");
                    try {
                        info = (WFRoleInfo)this.getController(ctx).getValue(this.TEMPPK);
                        if (!(userinfo.getId().equals((Object)info.getAdmin().getId()) || userinfo.getId().equals((Object)info.getCreator().getId()) || Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(userinfo.getId())))) {
                            throw new TaskExternalException("\u89d2\u8272" + roleNumber + "\u5bfc\u5165\u5931\u8d25\u3002\u5f53\u524d\u7528\u6237\u4e0d\u662f\u8be5\u89d2\u8272\u7684\u521b\u5efa\u8005\u6216\u7ba1\u7406\u5458\u6216administrator\uff0c\u65e0\u6cd5\u66f4\u65b0\u6570\u636e");
                        }
                    }
                    catch (EASBizException e) {
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                    catch (BOSException e) {
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                    info.getPersonEntrys().clear();
                    info.getPositionEntrys().clear();
                    info.getOrgEntrys().clear();
                } else {
                    this.TEMPPK = null;
                }
                info.setNumber(roleNumber);
                info.setRoleName(roleName);
                this.roleCache.put(roleNumber, info);
            }
            try {
                String treeNumber = this.getStringTokenValue("tree.number", hsData);
                if (StringUtils.isEmpty((String)treeNumber)) {
                    throw new TaskExternalException("\u6240\u5c5e\u7ec4\u7ec7\u7f16\u7801\u5fc5\u5f55");
                }
                AdminOrgUnitInfo orgInfo = this.getOrgInfo(ctx, treeNumber);
                if (orgInfo != null) {
                    info.setTreeid(orgInfo);
                    continue;
                }
                if (this.isScientificNotation(treeNumber)) {
                    orgInfo = this.getOrgInfo(ctx, this.SNtoNormal(treeNumber));
                }
                if (orgInfo != null) continue;
                throw new TaskExternalException("\u6240\u5c5e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u6b63\u786e\uff0c\u8bfb\u53d6\u5230\u7684\u7ec4\u7ec7\u7f16\u7801\u662f" + treeNumber);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        return info;
    }

    private AdminOrgUnitInfo getOrgInfo(Context ctx, String treeNumber) throws TaskExternalException, BOSException {
        AdminOrgUnitInfo orgInfo = null;
        if (!StringUtils.isEmpty((String)treeNumber)) {
            orgInfo = (AdminOrgUnitInfo)this.getInfoPKbyNumber(ctx, (ICoreBase)AdminOrgUnitFactory.getLocalInstance((Context)ctx), treeNumber);
        }
        return orgInfo;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        return filter;
    }

    public boolean isScientificNotation(String number) {
        String pattern = "^[-+]?\\d+(\\.\\d+)?([eE][-+]?\\d+)?$";
        Pattern scientificPattern = Pattern.compile(pattern);
        return scientificPattern.matcher(number).matches();
    }

    public String SNtoNormal(String number) {
        return String.format("%.0f", Double.valueOf(number));
    }
}

