/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cust;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.workflow.cust.WFPositionRoleInfo;
import com.kingdee.bos.workflow.cust.WFRoleDataImport;
import com.kingdee.bos.workflow.cust.WFRoleInfo;
import com.kingdee.bos.workflow.cust.WFRoleType;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.Hashtable;
import java.util.Map;

public class WFRolePositionDataImport
extends WFRoleDataImport {
    @Override
    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.bos.workflow.cust.app.WFRolewithEntryQuery";
    }

    @Override
    protected String[] getExportFields() {
        String[] exportfields = new String[]{"positionRole.AdminOrgUnit.number", "positionRole.AdminOrgUnit.name", "positionRole.DelePerson.number", "positionRole.DelePerson.name", "positionRole.Position.number", "positionRole.Position.name"};
        return exportfields;
    }

    @Override
    public Map<String, String> exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Map<String, String> result = super.exportTransmit(rs, ctx);
        this.putBoolean(rs, result, "positionRole.IsInclude");
        return result;
    }

    @Override
    public CoreBaseInfo transmit(Hashtable chsData, Context ctx) throws TaskExternalException {
        CoreBaseInfo corebaseinfo = super.transmit(chsData, ctx);
        for (int t = 0; t < chsData.size(); ++t) {
            Hashtable hsData = (Hashtable)chsData.get(t);
            this.handlePositionRole(ctx, (WFRoleInfo)corebaseinfo, hsData);
        }
        return corebaseinfo;
    }

    @Override
    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("roleType", (Object)1);
        return filter;
    }

    private void handlePositionRole(Context ctx, WFRoleInfo info, Hashtable hsData) throws TaskExternalException {
        info.setRoleType(WFRoleType.POSITIONROLE);
        WFPositionRoleInfo positionRole = new WFPositionRoleInfo();
        positionRole.setIsInclude(false);
        positionRole.setIsDele(false);
        String positionNumber = this.getStringTokenValue("positionRole.Position.number", hsData);
        String orgNumber = this.getStringTokenValue("positionRole.AdminOrgUnit.number", hsData);
        String delePersonNumber = this.getStringTokenValue("positionRole.DelePerson.number", hsData);
        if (StringUtils.isEmpty((String)orgNumber)) {
            throw new TaskExternalException("\u5206\u5f55\u7ec4\u7ec7\u7f16\u7801\u5fc5\u5f55\u3002");
        }
        String isInclude = this.getStringTokenValue("positionRole.IsInclude", hsData);
        if ("\u662f".equals(isInclude) || "true".equals(isInclude)) {
            positionRole.setIsInclude(true);
        }
        try {
            PositionInfo pinfo = (PositionInfo)this.getInfoPKbyNumber(ctx, (ICoreBase)PositionFactory.getLocalInstance((Context)ctx), positionNumber);
            if (pinfo == null) {
                if (this.isScientificNotation(positionNumber)) {
                    pinfo = (PositionInfo)this.getInfoPKbyNumber(ctx, (ICoreBase)PositionFactory.getLocalInstance((Context)ctx), this.SNtoNormal(positionNumber));
                }
                if (pinfo == null) {
                    throw new BOSException("\u804c\u4f4d\u7f16\u7801\u4e3a\u7a7a\u6216\u4e0d\u6b63\u786e\uff0c\u8bfb\u53d6\u5230\u7684\u804c\u4f4d\u7f16\u7801\u662f" + positionNumber);
                }
            }
            positionRole.setPositionID(pinfo);
            AdminOrgUnitInfo orgInfo = (AdminOrgUnitInfo)this.getInfoPKbyNumber(ctx, (ICoreBase)AdminOrgUnitFactory.getLocalInstance((Context)ctx), orgNumber);
            if (orgInfo != null) {
                positionRole.setOrgID(orgInfo);
            } else {
                if (this.isScientificNotation(orgNumber)) {
                    orgInfo = (AdminOrgUnitInfo)this.getInfoPKbyNumber(ctx, (ICoreBase)AdminOrgUnitFactory.getLocalInstance((Context)ctx), this.SNtoNormal(orgNumber));
                }
                if (orgInfo == null) {
                    throw new TaskExternalException("\u5206\u5f55\u7ec4\u7ec7\u7f16\u7801\u4e0d\u6b63\u786e\uff0c\u8bfb\u53d6\u5230\u7684\u5206\u5f55\u7ec4\u7ec7\u7f16\u7801\u662f" + orgNumber);
                }
            }
            positionRole.setOrgID(orgInfo);
            PersonInfo delpinfo = null;
            if (!StringUtils.isEmpty((String)delePersonNumber) && (delpinfo = (PersonInfo)this.getInfoPKbyNumber(ctx, (ICoreBase)PersonFactory.getLocalInstance((Context)ctx), delePersonNumber)) != null) {
                positionRole.setDelePersonID(delpinfo);
                positionRole.setIsDele(true);
            }
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        info.getPositionEntrys().add(positionRole);
    }
}

