/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cust.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.cust.WFRoleType;
import com.kingdee.bos.workflow.cust.app.impl.IWfRoleAdapter;
import com.kingdee.bos.workflow.cust.app.impl.WfRoleUtils;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.EngineUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.LocaleUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class WfRoleAdapter
implements IWfRoleAdapter {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.cust.app.impl.WfRoleAdapter");

    @Override
    public boolean test(Context ctx, String roleId, IObjectValue billInfo, String requestPropertyName, boolean isInclude) throws WfException {
        if (roleId == null) {
            throw new WfException("\u53c2\u6570\u503c\u89d2\u8272ID\u4e3a\u7a7a\u3002");
        }
        if (billInfo == null) {
            throw new WfException("\u53c2\u6570\u503c\u5355\u636e\u4fe1\u606fbillInfo\u4e3a\u7a7a\u3002");
        }
        if (requestPropertyName == null) {
            throw new WfException("\u53c2\u6570\u503c\u7533\u8bf7\u5c5e\u6027requestProName\u4e3a\u7a7a\u3002");
        }
        PersonInfo person = this.findPersonInBillInfo(ctx, billInfo, requestPropertyName);
        boolean bTested = this.test(ctx, roleId, person);
        return isInclude ? bTested : !bTested;
    }

    protected String getRequestType(Context ctx, String billId, String requestProName) throws WfException {
        if (requestProName == null || requestProName.length() <= 0) {
            throw new WfException("\u5355\u636e(" + billId + ")\u7533\u8bf7\u4eba\u5c5e\u6027\u53c2\u6570requestProName\u4e3anull");
        }
        String requestType = "9";
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)billId, (boolean)true);
        LinkPropertyInfo lp = WfRoleUtils.getLp(ctx, bosType, requestProName);
        String requestEntityName = lp.getRelationship().getSupplierObject().getFullName();
        if (requestEntityName.equalsIgnoreCase("com.kingdee.eas.basedata.person.app.Person")) {
            requestType = "1";
        } else if (requestEntityName.equalsIgnoreCase("com.kingdee.eas.base.permission.app.User")) {
            requestType = "0";
        } else {
            throw new WfException("\u5355\u636e(" + billId + ")\u7533\u8bf7\u4eba\u5c5e\u6027(" + requestProName + ")\u503c\u4e0d\u662f\u7528\u6237\u7c7b\u578b\u6216\u5458\u5de5\u7c7b\u578b.");
        }
        return requestType;
    }

    @Override
    public boolean test(Context ctx, String roleId, String billId, String requestPropertyName, boolean isInclude) throws WfException {
        if (roleId == null) {
            throw new WfException("\u53c2\u6570\u503c\u89d2\u8272ID\u4e3a\u7a7a\u3002");
        }
        if (billId == null) {
            throw new WfException("\u53c2\u6570\u503c\u5355\u636e\u4fe1\u606fbillId\u4e3a\u7a7a\u3002");
        }
        if (requestPropertyName == null) {
            throw new WfException("\u53c2\u6570\u503c\u7533\u8bf7\u5c5e\u6027requestProName\u4e3a\u7a7a\u3002");
        }
        String requestType = this.getRequestType(ctx, billId, requestPropertyName);
        PersonInfo person = this.findPersonInBill(ctx, billId, requestPropertyName, requestType);
        boolean bTested = this.test(ctx, roleId, person);
        return isInclude ? bTested : !bTested;
    }

    public boolean test(Context ctx, String roleId, String personId) throws Exception {
        PersonInfo person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
        return this.test(ctx, roleId, person);
    }

    private boolean test(Context ctx, String roleId, PersonInfo person) throws WfException {
        Map<String, Object> roleData = this.getRoleData(ctx, roleId);
        boolean bRet = false;
        WFRoleType roleType = (WFRoleType)((Object)roleData.get("roletype"));
        if (roleType.getValue() == 0) {
            bRet = this.test4person(ctx, person, roleId);
        } else if (roleType.getValue() == 1) {
            bRet = this.test4Position(ctx, person, roleId);
        } else if (roleType.getValue() == 2) {
            bRet = this.test4Org(ctx, person, roleId);
        }
        return bRet;
    }

    private boolean test4person(Context ctx, PersonInfo person, String roleId) throws WfException {
        String sqlStr = "select fid from T_WFR_PERSONROLE where FROLEID = ? and FPSERSONID = ? ";
        List<?> list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12, 12}, new String[]{roleId, person.getId().toString()});
        if (list.size() > 0) {
            return true;
        }
        sqlStr = "select count(*) ftotal from T_WFR_PERSONROLE t1,  T_ORG_PositionMember t3, T_ORG_Position t4,T_ORG_Admin t5,T_ORG_Admin t6  where t3.FPositionID = t4.FID  and t5.FID = t4.FAdminOrgUnitID  and t1.FORGID = t6.FID  and (SUBSTRING(t5.FLongNumber, 0,LENGTH(t6.FLongNumber) + 1) = t6.FLongNumber || '!' AND t5.FLevel > t6.FLevel) and t3.FPersonID = ?  and t1.FROLEID = ?  and t1.FPSERSONID = ?  and t1.FISINCLUDE = 1 ";
        list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12, 12, 12}, new String[]{roleId, person.getId().toString(), person.getId().toString()});
        return this.isExisted(list);
    }

    private boolean test4Position(Context ctx, PersonInfo person, String roleId) throws WfException {
        String sqlStr = "select count(*) ftotal from T_WFR_POSITIONROLE t1, T_ORG_PositionMember t2 where t2.FPositionID  =  t1.FPOSITIONID and t1.FROLEID = ? and t2.FPERSONID = ? ";
        List<?> list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12, 12}, new String[]{roleId, person.getId().toString()});
        if (this.isExisted(list)) {
            return true;
        }
        sqlStr = "select count(*) ftotal from T_WFR_POSITIONROLE t1,  T_ORG_PositionMember t3, T_ORG_Position t4,T_ORG_Admin t5,T_ORG_Admin t6  where t3.FPositionID = t4.FID  and t5.FID = t4.FAdminOrgUnitID  and t1.FORGID = t6.FID  and (SUBSTRING(t5.FLongNumber, 0,LENGTH(t6.FLongNumber) + 1) = t6.FLongNumber || '!' AND t5.FLevel > t6.FLevel) and t1.FPositionID = t3.FPositionID  and t1.FISINCLUDE = 1  and t1.FROLEID = ?  and t3.FPERSONID = ? ";
        list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12, 12}, new String[]{roleId, person.getId().toString()});
        return this.isExisted(list);
    }

    private boolean test4Org(Context ctx, PersonInfo person, String roleId) throws WfException {
        String sqlStr = "select count(*) ftotal from T_WFR_WFOrgRole t1, T_ORG_PositionMember t3, T_ORG_Position t4  where t3.FPositionID = t4.FID  and t1.FORGID = t4.FAdminOrgUnitID  and t1.FROLEID = ?  and t3.FPersonID = ?";
        List<?> list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12, 12}, new String[]{roleId, person.getId().toString()});
        if (this.isExisted(list)) {
            return true;
        }
        sqlStr = "select count(*) ftotal from T_WFR_WFOrgRole t1, T_ORG_PositionMember t3, T_ORG_Position t4,T_ORG_Admin t5,T_ORG_Admin t6  where t3.FPositionID = t4.FID  and t5.FID = t4.FAdminOrgUnitID  and t1.FORGID = t6.FID  and (SUBSTRING(t5.FLongNumber, 0,LENGTH(t6.FLongNumber) + 1) = t6.FLongNumber || '!' AND t5.FLevel > t6.FLevel) and t1.FISINCLUDE = 1  and t1.FROLEID = ?  and t3.FPersonID = ?";
        list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12, 12}, new String[]{roleId, person.getId().toString()});
        return this.isExisted(list);
    }

    protected boolean isExisted(List<?> list) {
        if (list == null || list.size() <= 0) {
            return false;
        }
        Map item = (Map)list.get(0);
        int total = Integer.parseInt(item.get("ftotal").toString());
        return total > 0;
    }

    @Override
    public List<Person> getRolePersons(Context ctx, String roleId, String billId, String orgProName) throws WfException {
        OrgUnitInfo[] orgInfos = null;
        if (billId != null) {
            OrgType orgType = WfRoleUtils.getOrgType(ctx, billId, orgProName);
            orgInfos = WfRoleUtils.findOrgInfosBillInfo(ctx, billId, orgProName, orgType);
        }
        return this.getRolePersons(ctx, roleId, orgInfos);
    }

    public List<Person> getRolePersons(Context ctx, String roleId, IObjectValue billInfo, String orgProName, boolean isRoleGroup) throws WfException {
        OrgUnitInfo[] orgInfos = null;
        if (billInfo != null) {
            OrgType orgType = WfRoleUtils.getOrgType(ctx, billInfo.getBOSType(), orgProName);
            orgInfos = WfRoleUtils.findOrgInfosBillInfo(ctx, billInfo, orgProName, orgType);
        }
        if (!isRoleGroup) {
            return this.getRolePersons(ctx, roleId, orgInfos);
        }
        return this.getRolePersonsbyGroupId(ctx, roleId, orgInfos);
    }

    private List<?> getRoleInfo(Context ctx, String roleId) throws WfException {
        String sql = "select fid id,frolename_" + LocaleUtils.getShortCode((Locale)ctx.getLocale()) + " name,fnumber number,froletype roletype from T_WFR_WFROLE where fid in (";
        String[] ids = roleId.split(";");
        if (ids.length == 0) {
            return null;
        }
        String[] params = new String[ids.length];
        int[] types = new int[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                sql = sql + ",";
            }
            sql = sql + "?";
            types[i] = 12;
            params[i] = ids[i];
        }
        sql = sql + ")";
        List<?> list = WfRoleUtils.exectueQuery(ctx, sql, types, params);
        return list;
    }

    private List<?> getRole4GroupInfo(Context ctx, String groupRoleId) throws WfException {
        String sql = "select froleid from T_WFR_WFRoleGroupEntrys where FPARENTID in (";
        String[] ids = groupRoleId.split(";");
        if (ids.length == 0) {
            return null;
        }
        String[] params = new String[ids.length];
        int[] types = new int[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                sql = sql + ",";
            }
            sql = sql + "?";
            types[i] = 12;
            params[i] = ids[i];
        }
        sql = sql + ")";
        List<?> list = WfRoleUtils.exectueQuery(ctx, sql, types, params);
        String roleIds = "";
        if (list.size() > 0) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Map item = (Map)list.get(i);
                if (!"".equals(roleIds)) {
                    roleIds = roleIds + ";";
                }
                roleIds = roleIds + (String)item.get("froleid");
            }
        }
        List<?> roleList = this.getRoleInfo(ctx, roleIds);
        return roleList;
    }

    private List<Person> getRolePersons(Context ctx, String roleId, OrgUnitInfo[] orgInfos) throws WfException {
        Map<String, Object> roleData = this.getRoleData(ctx, roleId);
        WFRoleType roleType = (WFRoleType)((Object)roleData.get("roletype"));
        List<Person> persons = null;
        if (roleType.getValue() == 0) {
            persons = this.findPersons4Person(ctx, orgInfos, roleId);
        } else if (roleType.getValue() == 1) {
            persons = this.findPersons4Position(ctx, orgInfos, roleId);
        } else if (roleType.getValue() == 2) {
            persons = this.findPersons4Org(ctx, orgInfos, roleId);
        }
        return persons;
    }

    private List<Person> findPersons4Person(Context ctx, OrgUnitInfo[] orgInfos, String roleId) throws WfException {
        String sqlStr = "select fpsersonid fpersonid,fisdele,fdelepersonid from T_WFR_PERSONROLE where FROLEID = ? ";
        if (orgInfos != null && orgInfos.length != 0) {
            String orgIdStr = WfRoleUtils.joinIdString(orgInfos);
            sqlStr = sqlStr + " and FORGID in (" + orgIdStr + ")";
        }
        List<?> list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12}, new String[]{roleId});
        sqlStr = "select t1.fpsersonid fpersonid,t1.fisdele,t1.fdelepersonid from T_WFR_PERSONROLE t1 inner join T_ORG_Admin t2 on t1.FORGID = t2.FID where t1.FROLEID = ? and t1.FISINCLUDE = 1 ";
        if (orgInfos != null && orgInfos.length != 0) {
            String longNumStrParam = WfRoleUtils.joinLongNumString(orgInfos);
            sqlStr = sqlStr + " and  t2.FLongNumber in (" + longNumStrParam + ") ";
        }
        List<?> temp = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12}, new String[]{roleId});
        WfRoleUtils.appendList(list, temp);
        return this.findAllPersons(ctx, list);
    }

    private List<Person> findAllPersons(Context ctx, List<?> list) throws WfException {
        if (list.size() <= 0) {
            return null;
        }
        LinkedHashMap<String, List<Person>> personIdMap = new LinkedHashMap<String, List<Person>>();
        LinkedHashMap<String, List<Person>> delePersonIdMap = new LinkedHashMap<String, List<Person>>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map item = (Map)list.get(i);
            String personId = (String)item.get("fpersonid");
            if (personId != null && !personIdMap.containsKey(personId)) {
                personIdMap.put(personId, null);
            }
            if (item.get("fisdele") == null) continue;
            Boolean isDelegate = Integer.parseInt(item.get("fisdele").toString()) == 1;
            String delegatePersonId = (String)item.get("fdelepersonid");
            if (!isDelegate.booleanValue() || delegatePersonId == null || delePersonIdMap.containsKey(delegatePersonId)) continue;
            delePersonIdMap.put(delegatePersonId, null);
        }
        List<Person> ps = new ArrayList<Person>();
        if (personIdMap.size() > 0) {
            ps = this.findAvaliblePerson(ctx, personIdMap);
        }
        if (ps.size() <= 0 && delePersonIdMap.size() > 0) {
            ps = this.findAvaliblePerson(ctx, delePersonIdMap);
        }
        return ps;
    }

    private List<Person> findAvaliblePerson(Context ctx, Map<String, List<Person>> personMap) throws WfException {
        StringBuilder personIdStr = new StringBuilder();
        for (String personId : personMap.keySet()) {
            personIdStr.append("'").append(personId).append("'").append(",");
        }
        personIdStr.setLength(personIdStr.length() - 1);
        String sqlStr = "select t1.fid userid, t1.fname_l1 uname_l1, t1.fname_l2 uname_l2, t1.fname_l3 uname_l3, t2.fid personid, t2.fname_l1 pname_l1, t2.fname_l2 pname_l2, t2.fname_l3 pname_l3 from T_PM_USER t1 , T_BD_PERSON t2 where t1.fpersonid = t2.fid and t1.fisDelete = 0 and t1.FForbidden = 0 and t1.feffectiveDate < now() and t1.finvalidationDate > now() and  t2.fid in (" + personIdStr + ") ";
        List<?> list = WfRoleUtils.exectueQuery(ctx, sqlStr, null, null);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map item = (Map)list.get(i);
            String personId = (String)item.get("personid");
            Person wfPersonInfo = new Person();
            wfPersonInfo.setUserId((String)item.get("userid"));
            wfPersonInfo.setEmployeeId(personId);
            wfPersonInfo.setUserName(LocaleUtils.locale_L1, (String)item.get("uname_l1"));
            wfPersonInfo.setUserName(LocaleUtils.locale_L2, (String)item.get("uname_l2"));
            wfPersonInfo.setUserName(LocaleUtils.locale_L3, (String)item.get("uname_l3"));
            wfPersonInfo.setEmployeeName(LocaleUtils.locale_L1, (String)item.get("pname_l1"));
            wfPersonInfo.setEmployeeName(LocaleUtils.locale_L2, (String)item.get("pname_l2"));
            wfPersonInfo.setEmployeeName(LocaleUtils.locale_L3, (String)item.get("pname_l3"));
            List<Person> personList = personMap.get(personId);
            if (personList == null) {
                personList = new ArrayList<Person>();
                personMap.put(personId, personList);
            }
            personList.add(wfPersonInfo);
        }
        ArrayList<Person> retData = new ArrayList<Person>(list.size());
        for (Map.Entry<String, List<Person>> personEntry : personMap.entrySet()) {
            List<Person> personList = personEntry.getValue();
            if (personList == null || personList.size() <= 0) continue;
            retData.addAll(personList);
        }
        return retData;
    }

    private List<Person> findPersons4Position(Context ctx, OrgUnitInfo[] orgInfos, String roleId) throws WfException {
        String sqlStr = "select t2.fpersonid fpersonid,t1.fisdele,t1.fdelepersonid from T_WFR_POSITIONROLE t1 left join  T_ORG_PositionMember t2 on (t2.FPositionID  =  t1.FPOSITIONID) where t1.FROLEID =?";
        if (orgInfos != null && orgInfos.length != 0) {
            String orgIdStr = WfRoleUtils.joinIdString(orgInfos);
            sqlStr = sqlStr + " and t1.FORGID in (" + orgIdStr + ")";
        }
        List<?> list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12}, new String[]{roleId});
        sqlStr = " select t2.fpersonid fpersonid, t1.fisdele, t1.fdelepersonid  from T_WFR_POSITIONROLE  t1   left join  T_ORG_PositionMember t2 on t1.FPOSITIONID =t2.FPOSITIONID    left join t_org_admin t3 on t1.forgId=t3.fid    where t1.FISINCLUDE = 1 and   t1.FROLEID = ? ";
        if (orgInfos != null && orgInfos.length != 0) {
            String longNumStrParam = WfRoleUtils.joinLongNumString(orgInfos);
            sqlStr = sqlStr + " and t3.FLongNumber in (" + longNumStrParam + ")";
        }
        List<?> temp = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12}, new String[]{roleId});
        WfRoleUtils.appendList(list, temp);
        return this.findAllPersons(ctx, list);
    }

    private List<Person> findPersons4Org(Context ctx, OrgUnitInfo[] orgInfos, String roleId) throws WfException {
        String sqlStr = "select forgid from T_WFR_WFOrgRole where FROLEID = ? ";
        if (orgInfos != null && orgInfos.length != 0) {
            String orgIdStr = WfRoleUtils.joinIdString(orgInfos);
            sqlStr = sqlStr + " and FORGID in (" + orgIdStr + ")";
        }
        List<?> list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12}, new String[]{roleId});
        sqlStr = "select top 1 t1.forgid from T_WFR_WFOrgRole t1 inner join T_ORG_Admin t2 on t1.FORGID = t2.FID where t1.FROLEID = ? and t1.FISINCLUDE = 1 ";
        if (orgInfos != null && orgInfos.length != 0) {
            String longNumStrParam = WfRoleUtils.joinLongNumString(orgInfos);
            sqlStr = sqlStr + " and  t2.FLongNumber in (" + longNumStrParam + ") ";
        }
        sqlStr = sqlStr + " order by t2.flevel desc ";
        List<?> temp = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12}, new String[]{roleId});
        WfRoleUtils.appendList(list, temp);
        if (list.size() > 0) {
            String orgId = (String)((Map)list.get(0)).get("forgid");
            Person[] ps = this.participantProvider(ctx).getOrgMember(ctx, orgId);
            ArrayList<Person> psList = new ArrayList<Person>();
            HashSet<String> pidSet = new HashSet<String>();
            for (Person p : ps) {
                if (!pidSet.add(p.getEmployeeId())) continue;
                psList.add(p);
            }
            return psList;
        }
        return null;
    }

    @Override
    public List<Person> getRoleGroupPersons(Context ctx, String roleGroupId, String billId, String orgProName) throws WfException {
        OrgUnitInfo[] orgInfos = null;
        if (billId != null) {
            OrgType orgType = WfRoleUtils.getOrgType(ctx, billId, orgProName);
            orgInfos = WfRoleUtils.findOrgInfosBillInfo(ctx, billId, orgProName, orgType);
        }
        return this.getRolePersonsbyGroupId(ctx, roleGroupId, orgInfos);
    }

    private List<Person> getRolePersonsbyGroupId(Context ctx, String roleGroupId, OrgUnitInfo[] orgInfos) throws WfException {
        String[] roleIdArray = this.getRolesOfGroup(ctx, roleGroupId);
        ArrayList<Person> allPersons = new ArrayList<Person>();
        for (String roleId : roleIdArray) {
            List<Person> ps = this.getRolePersons(ctx, roleId, orgInfos);
            if (ps == null) continue;
            allPersons.addAll(ps);
        }
        return allPersons;
    }

    protected String[] getRolesOfGroup(Context ctx, String groupId) throws WfException {
        String sqlStr = "select froleid from T_WFR_WFRoleGroupEntrys where FPARENTID = ?";
        List<?> list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12}, new String[]{groupId});
        String[] roleIds = null;
        if (list.size() > 0) {
            roleIds = new String[list.size()];
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Map item = (Map)list.get(i);
                roleIds[i] = (String)item.get("froleid");
            }
        } else {
            throw new WfException("\u6ca1\u6709\u627e\u5230\u89d2\u8272\u7ec4\u4fe1\u606f" + groupId);
        }
        return roleIds;
    }

    protected Map<String, Object> getRoleData(Context ctx, String roleId) throws WfException {
        String sqlStr = "select fid id,frolename_" + LocaleUtils.getShortCode((Locale)ctx.getLocale()) + " name,fstate state,froletype roletype from T_WFR_WFROLE where fid = ?";
        List<?> list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12}, new String[]{roleId});
        Map item = null;
        if (list.size() <= 0) {
            throw new WfException("\u6ca1\u6709\u627e\u89d2\u8272\u4fe1\u606f" + roleId);
        }
        item = (Map)list.get(0);
        int state = Integer.parseInt(item.get("state").toString());
        if (state == 1) {
            throw new WfException("\u89d2\u8272" + item.get("fname") + "\u5df2\u7ecf\u88ab\u7981\u7528");
        }
        int roleType = Integer.parseInt(item.get("roletype").toString());
        item.put("roletype", WFRoleType.getEnum(roleType));
        return item;
    }

    protected PersonInfo findPersonInBill(Context ctx, String billId, String requestProName, String requestType) throws WfException {
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)billId, (boolean)true);
        IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        ObjectStringPK pk = new ObjectStringPK(billId);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        if (requestType.equalsIgnoreCase("0")) {
            selector.add(new SelectorItemInfo(requestProName + ".id"));
            selector.add(new SelectorItemInfo(requestProName + ".name"));
            selector.add(new SelectorItemInfo(requestProName + ".person.id"));
            selector.add(new SelectorItemInfo(requestProName + ".person.name"));
        } else {
            selector.add(new SelectorItemInfo(requestProName + ".id"));
            selector.add(new SelectorItemInfo(requestProName + ".name"));
        }
        PersonInfo person = null;
        IObjectValue objVal = null;
        try {
            objVal = dynamicObject.getValue(bosType, (IObjectPK)pk, selector);
        }
        catch (BOSException e) {
            throw new WfException(e.getMessage(), (Throwable)e);
        }
        if (objVal == null) {
            throw new WfException("\u5355\u636e(" + billId + ")\u4e0d\u5b58\u5728.");
        }
        if (requestType.equalsIgnoreCase("0")) {
            UserInfo userInfo = (UserInfo)WfRoleUtils.getBillPropInfo(objVal, requestProName);
            if (userInfo == null) {
                throw new WfException("\u5355\u636e(" + billId + ")\u7533\u8bf7\u4eba\u5c5e\u6027(" + requestProName + ")\u503c\u4e3a\u7a7a.");
            }
            person = userInfo.getPerson();
        } else {
            PersonInfo personInfo = (PersonInfo)WfRoleUtils.getBillPropInfo(objVal, requestProName);
            if (personInfo == null) {
                throw new WfException("\u5355\u636e(" + billId + ")\u7533\u8bf7\u4eba\u5c5e\u6027(" + requestProName + ")\u503c\u4e3a\u7a7a.");
            }
            person = personInfo;
        }
        return person;
    }

    protected PersonInfo findPersonInBillInfo(Context ctx, IObjectValue billInfo, String requestProName) throws WfException {
        String billId = billInfo.getString(billInfo.getPKField());
        Object requestVal = WfRoleUtils.getBillPropInfo(billInfo, requestProName);
        if (requestVal == null) {
            throw new WfException("\u5355\u636e(" + billId + ")\u7533\u8bf7\u4eba\u5c5e\u6027(" + requestProName + ")\u503c\u4e3a\u7a7a.");
        }
        if (requestVal instanceof UserInfo) {
            UserInfo userInfo = (UserInfo)billInfo.get(requestProName);
            ObjectStringPK pk = new ObjectStringPK(userInfo.getId().toString());
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("person.id"));
            selector.add(new SelectorItemInfo("person.name"));
            try {
                userInfo = (UserInfo)UserFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)pk, selector);
            }
            catch (EASBizException e) {
                throw new WfException((Throwable)e);
            }
            catch (BOSException e) {
                throw new WfException((Throwable)e);
            }
            return userInfo.getPerson();
        }
        if (requestVal instanceof PersonInfo) {
            return (PersonInfo)requestVal;
        }
        throw new WfException("\u5355\u636e(" + billId + ")\u7533\u8bf7\u4eba\u5c5e\u6027(" + requestProName + ")\u503c\u4e0d\u662f\u7528\u6237\u7c7b\u578b\u6216\u5458\u5de5\u7c7b\u578b.");
    }

    private IParticipantProvider participantProvider(Context ctx) throws WfException {
        WfEngine engine = EngineUtil.getEngine((Context)ctx);
        return engine.getPariticipantProvider();
    }

    @Override
    public boolean testByOrgProName(Context ctx, String orgRoleId, String billId, String orgPropertyName, boolean OrgIsInclude) throws WfException {
        if (orgRoleId == null) {
            throw new WfException("\u53c2\u6570\u503c\u89d2\u8272ID\u4e3a\u7a7a\u3002");
        }
        if (billId == null) {
            throw new WfException("\u53c2\u6570\u503c\u5355\u636e\u4fe1\u606fbillId\u4e3a\u7a7a\u3002");
        }
        if (orgPropertyName == null) {
            throw new WfException("\u53c2\u6570\u503c\u7533\u8bf7\u5c5e\u6027orgPropertyName\u4e3a\u7a7a\u3002");
        }
        OrgType orgType = WfRoleUtils.getOrgType(ctx, billId, orgPropertyName);
        OrgUnitInfo[] orgs = WfRoleUtils.findOrgInfosBillInfo(ctx, billId, orgPropertyName, orgType);
        boolean orgTest = this.test4OrgRole(ctx, orgs, orgRoleId);
        return OrgIsInclude ? orgTest : !orgTest;
    }

    @Override
    public boolean testByOrgProName(Context ctx, String orgRoleId, IObjectValue billInfo, String orgPropertyName, boolean OrgIsInclude) throws WfException {
        if (orgRoleId == null) {
            throw new WfException("\u53c2\u6570\u503c\u89d2\u8272ID\u4e3a\u7a7a\u3002");
        }
        if (billInfo == null) {
            throw new WfException("\u53c2\u6570\u503c\u5355\u636e\u4fe1\u606fbillInfo\u4e3a\u7a7a\u3002");
        }
        if (orgPropertyName == null) {
            throw new WfException("\u53c2\u6570\u503c\u7ec4\u7ec7\u5c5e\u6027orgPropertyName\u4e3a\u7a7a\u3002");
        }
        OrgUnitInfo orgInfo = (OrgUnitInfo)WfRoleUtils.getBillPropInfo(billInfo, orgPropertyName);
        OrgType orgType = WfRoleUtils.getOrgType(ctx, billInfo, orgPropertyName);
        OrgUnitInfo[] orgs = WfRoleUtils.findAdminOrgInfos(ctx, orgInfo, orgType);
        boolean orgTest = this.test4OrgRole(ctx, orgs, orgRoleId);
        return OrgIsInclude ? orgTest : !orgTest;
    }

    private String joinLongNumString(Context ctx, OrgUnitInfo[] orgInfos) throws WfException {
        StringBuffer longNumStrParam = new StringBuffer();
        for (OrgUnitInfo orgInfo : orgInfos) {
            String longnum = orgInfo.getLongNumber();
            if (longnum == null) {
                String getlongNumSQL = "select flongnumber from T_ORG_Admin where fid= ?";
                List<?> longNumList = WfRoleUtils.exectueQuery(ctx, getlongNumSQL, new int[]{12}, new String[]{orgInfo.getId().toString()});
                Map item = (Map)longNumList.get(0);
                longnum = item.get("flongnumber").toString();
                longNumStrParam.append(WfRoleUtils.longNum2ParamStr(longnum)).append(",");
                continue;
            }
            longNumStrParam.append(WfRoleUtils.longNum2ParamStr(orgInfo.getLongNumber().toString())).append(",");
        }
        longNumStrParam.setLength(longNumStrParam.length() - 1);
        return longNumStrParam.toString();
    }

    public boolean test4OrgRole(Context ctx, OrgUnitInfo[] orgInfos, String roleId) throws WfException {
        List<?> list;
        Map<String, Object> roleData = this.getRoleData(ctx, roleId);
        WFRoleType roleType = (WFRoleType)((Object)roleData.get("roletype"));
        String tableName = "";
        if (roleType.getValue() == 0) {
            tableName = "T_WFR_PERSONROLE";
        } else if (roleType.getValue() == 1) {
            tableName = "T_WFR_POSITIONROLE";
        } else if (roleType.getValue() == 2) {
            tableName = "T_WFR_WFOrgRole";
        }
        String sqlStr = "select forgid from " + tableName + " where FROLEID = ? ";
        if (orgInfos != null && orgInfos.length != 0) {
            String orgIdStr = WfRoleUtils.joinIdString(orgInfos);
            logger.error((Object)("---orgIdStr=[" + orgIdStr + "]----"));
            sqlStr = sqlStr + " and FORGID in (" + orgIdStr + ")";
        }
        if ((list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12}, new String[]{roleId})).size() <= 0) {
            sqlStr = "select top 1 t1.forgid from " + tableName + " t1 inner join T_ORG_Admin t2 on t1.FORGID = t2.FID where t1.FROLEID = ? and t1.FISINCLUDE = 1 ";
            if (orgInfos != null && orgInfos.length != 0) {
                String longNumStrParam = WfRoleUtils.joinLongNumString(orgInfos);
                logger.error((Object)("---longNumStrParam = " + longNumStrParam + " ---"));
                sqlStr = sqlStr + " and  t2.FLongNumber in (" + longNumStrParam + ") ";
            }
            sqlStr = sqlStr + " order by t2.flevel desc ";
            list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12}, new String[]{roleId});
        }
        return list != null && list.size() > 0;
    }
}

