/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cust.app.startsheme;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public final class SQLUtils {
    private static Logger logger = Logger.getLogger(SQLUtils.class);
    private static final int MAX_DATA_ROW = 8000;

    public static int execute(Context ctx, String sql) throws BOSException {
        int n;
        Connection conn = null;
        Statement statement = null;
        try {
            int number;
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            n = number = statement.executeUpdate(sql);
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)sql, (Throwable)exc);
                throw new BOSException(sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)statement, (Connection)conn);
        return n;
    }

    public static int execute(Context ctx, String sql, Object[] params) throws BOSException {
        int n;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            int number;
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            n = number = ps.executeUpdate();
        }
        catch (SQLException exc) {
            try {
                StringBuffer sb = new StringBuffer("");
                for (int i = 0; i < params.length; ++i) {
                    sb.append("param ").append(i).append(" is:").append(params[i]);
                }
                logger.error((Object)("sql is:" + sql + " param is:" + sb.toString()), (Throwable)exc);
                throw new BOSException(sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return n;
    }

    public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)sql, (Throwable)exc);
                throw new BOSException(sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return jdbcRowSet;
    }

    public static IRowSet executeQuery(Context ctx, String sql, Object[] params) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        if (sql == null) {
            return null;
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                StringBuffer sb = new StringBuffer("");
                for (int i = 0; i < params.length; ++i) {
                    sb.append("param ").append(i).append(" is:").append(params[i]);
                }
                logger.error((Object)("sql is:" + sql + " param is:" + sb.toString()));
                logger.error((Object)exc);
                throw new BOSException(sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return jdbcRowSet;
    }

    public static int[] executeBatch(Context ctx, String sql, List paramsList) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        long startTime = 0L;
        int[] resultNum = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            Object[] params = null;
            int k = 1;
            boolean flag = false;
            for (int i = 0; i < paramsList.size(); ++i) {
                params = (Object[])paramsList.get(i);
                for (int j = 0; j < params.length; ++j) {
                    if (params[j] != null) {
                        ps.setObject(j + 1, params[j]);
                        continue;
                    }
                    ps.setNull(j + 1, 12);
                }
                ps.addBatch();
                if (i == k * 8000) {
                    flag = true;
                }
                if (i <= k * 8000 || !flag) continue;
                long timeFrom = System.currentTimeMillis();
                if (startTime <= 0L) {
                    startTime = timeFrom;
                }
                int[] result = ps.executeBatch();
                resultNum = SQLUtils.arraycopy(resultNum, result);
                ++k;
                flag = false;
                ps.clearBatch();
            }
            if (!flag) {
                long timeFrom = System.currentTimeMillis();
                if (startTime <= 0L) {
                    startTime = timeFrom;
                }
                int[] result = ps.executeBatch();
                resultNum = SQLUtils.arraycopy(resultNum, result);
            }
        }
        catch (SQLException exc) {
            try {
                throw new BOSException(sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return resultNum;
    }

    public static int[] executeBatch(Context ctx, String[] sqls) throws BOSException {
        int[] nArray;
        Connection conn = null;
        Statement statement = null;
        try {
            int[] resultNum;
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            for (int i = 0; i < sqls.length; ++i) {
                statement.addBatch(sqls[i]);
            }
            nArray = resultNum = statement.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)statement, (Connection)conn);
        return nArray;
    }

    public static final int[] arraycopy(int[] resultNum, int[] result) {
        int[] temp = null;
        if (resultNum != null && result != null) {
            temp = new int[result.length + resultNum.length];
            System.arraycopy(resultNum, 0, temp, 0, resultNum.length);
            System.arraycopy(result, 0, temp, resultNum.length, result.length);
        }
        return temp;
    }

    public static final void cleanup(Connection cn) {
        SQLUtils.cleanup(null, null, cn);
    }

    public static final void cleanup(Statement stmt) {
        SQLUtils.cleanup(null, stmt, null);
    }

    public static final void cleanup(Statement stmt, Connection cn) {
        SQLUtils.cleanup(null, stmt, cn);
    }

    public static final void cleanup(ResultSet rs) {
        SQLUtils.cleanup(rs, null, null);
    }

    public static final void cleanup(ResultSet rs, Statement stmt) {
        SQLUtils.cleanup(rs, stmt, null);
    }

    public static void cleanup(ResultSet rs, Statement stmt, Connection cn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception _) {
                logger.error((Object)_);
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception _) {
                logger.error((Object)_);
            }
            stmt = null;
        }
        if (cn != null) {
            try {
                cn.close();
            }
            catch (Exception _) {
                logger.error((Object)_);
            }
            cn = null;
        }
    }
}

