/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AbstractTaskServiceActivityDef;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.EndActivityDef;
import com.kingdee.bos.workflow.define.EventActivityDef;
import com.kingdee.bos.workflow.define.FunctionActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ReceiveSignalEndEventActivityDef;
import com.kingdee.bos.workflow.define.ReceiveSignalIntermediateEventActivityDef;
import com.kingdee.bos.workflow.define.RouterActivityDef;
import com.kingdee.bos.workflow.define.ScriptActivityDef;
import com.kingdee.bos.workflow.define.SignalStartEventActivityDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.TimerIntermediateEventActivityDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.define.extended.BotpActivityDef;
import com.kingdee.bos.workflow.define.extended.ManualDecisionActivityDef;
import com.kingdee.bos.workflow.define.extended.MessageActivityDef;
import com.kingdee.bos.workflow.define.extended.OtherSysActivityDef;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.bos.workflow.ext.IWfMonitorExt;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.monitor.WfProcessImage;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.service.ormrpc.struct.IProcessImage;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class WfProcDiagramEncoder {
    private static final Color BG_COLOR = new Color(255, 255, 255);
    WfProcessImage image;
    IEnactmentService service;
    Locale locale;
    Context ctx;
    private static Map ICON_MAP = new Hashtable();

    public WfProcDiagramEncoder(String procInstOrDefId, Context ctx) throws BOSException {
        this.service = EnactmentServiceFactory.createEnactService((Context)ctx);
        this.locale = ctx.getLocale();
        this.ctx = ctx;
        if (procInstOrDefId.endsWith("WFPCINST")) {
            this.image = new WfProcessImage(this.locale, this.service, procInstOrDefId, BG_COLOR);
        } else if (procInstOrDefId.endsWith("WFPRCDEF")) {
            String procDefId = procInstOrDefId;
            String hash = this.service.getProcessDefInfo(procDefId).getMd5HashValue();
            ProcessDef processDef = this.service.getProcessDefByDefineHashValue(hash);
            this.image = new WfProcessImage(this.locale, processDef, BG_COLOR);
        } else {
            throw new BOSException("invalid operation!");
        }
    }

    public void outputImage(OutputStream out) throws Exception {
        this.image.setDefaultGraphics();
        this.image.paintLines();
        this.image.paintNotes();
        this.paintActivities();
        try {
            IWfMonitorExt ext = ConfigLoader.getConfig4Server().getWfMonitorExt(this.ctx);
            if (ext != null) {
                ext.paintDecoration(this.image.getGraphic(), this.image.getActivities2(), this.image.getOffsetX(), this.image.getOffsetY());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ImageIO.write((RenderedImage)this.image.getImage(), "png", out);
    }

    public void outputImage(OutputStream out, boolean isWeb) throws Exception {
        this.image.setDefaultGraphics();
        this.image.paintLines();
        this.image.paintNotes();
        this.paintActivities();
        try {
            IWfMonitorExt ext = ConfigLoader.getConfig4Server().getWfMonitorExt(this.ctx);
            if (ext != null) {
                ext.paintDecoration(this.image.getGraphic(), this.image.getActivities2(), this.image.getOffsetX(), this.image.getOffsetY());
            }
        }
        catch (Throwable ext) {
            // empty catch block
        }
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        encoder.encode(this.image.getImage());
    }

    public byte[] getImageBytes() throws Exception {
        this.image.setDefaultGraphics();
        this.image.paintLines();
        this.image.paintNotes();
        this.paintActivities();
        try {
            IWfMonitorExt ext = ConfigLoader.getConfig4Server().getWfMonitorExt(this.ctx);
            if (ext != null) {
                ext.paintDecoration(this.image.getGraphic(), this.image.getActivities2(), this.image.getOffsetX(), this.image.getOffsetY());
            }
        }
        catch (Throwable ext) {
            // empty catch block
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)this.image.getImage(), "png", bos);
        bos.close();
        return bos.toByteArray();
    }

    public Map getActBounds() throws WfException {
        IProcessImage.Activity info;
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        HashMap actDefInsts = new HashMap();
        HashSet<String> openActDefs = new HashSet<String>();
        LinkedList<String> actsHasAppended = new LinkedList<String>();
        HashMap activities = this.image.getActivities();
        HashSet<String> needShowActActvitities = new HashSet<String>();
        HashSet timeWaiterActs = new HashSet();
        for (String id : activities.keySet()) {
            info = (IProcessImage.Activity)activities.get(id);
            Rectangle rect = (Rectangle)info.bound.clone();
            rect.x += this.image.getOffsetX();
            rect.y += this.image.getOffsetY();
            map.put(id, rect);
            map.put(id + ".width", new Integer(info.bound.width));
            if (info.actDef instanceof TimerIntermediateEventActivityDef && "open.not_running.not_started".equals(info.state)) {
                needShowActActvitities.add(info.actDef.getID());
            }
            if (info.isManpower || info.actDef instanceof MessageActivityDef) {
                needShowActActvitities.add(info.actDef.getID());
            } else {
                actDefInsts.put(info.actDef.getID(), null);
            }
            if (info.state != null && (info.state.equals("open.running") || info.state.equals("open.not_running.not_started") || info.state.equals("open.not_running"))) {
                openActDefs.add(info.actDef.getID());
            }
            if (!info.hasAppended) continue;
            actsHasAppended.add(info.actDef.getID());
        }
        ActivityInstInfo[] array = this.image.getActivityInstInfos();
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                info = array[i];
                String defId = info.getActDefId();
                ArrayList<String> list = (ArrayList<String>)actDefInsts.get(defId);
                if (list == null) {
                    list = new ArrayList<String>();
                    actDefInsts.put(defId, list);
                }
                if (!needShowActActvitities.contains(info.getActDefId())) continue;
                list.add(info.getActInstId());
            }
        }
        map.put("{performer}", actDefInsts);
        map.put("{openActDefs}", openActDefs);
        map.put("{appendedActs}", actsHasAppended);
        return map;
    }

    private void paintActivities() {
        Graphics2D g = this.image.getGraphic();
        g.setColor(new Color(0, 0, 0));
        FontMetrics metrics = g.getFontMetrics();
        HashMap activities = this.image.getActivities();
        int ox = this.image.getOffsetX();
        int oy = this.image.getOffsetY();
        for (IProcessImage.Activity info : activities.values()) {
            String label;
            int pos;
            ImageIcon icon = WfProcDiagramEncoder.getIconByActivityTypeAndState(info.state, info.actDef, info.inited);
            int offsetX = (info.bound.width - icon.getIconWidth()) / 2 + ox;
            int x = info.bound.x + offsetX;
            int y = info.bound.y + 4 + oy;
            g.drawImage(icon.getImage(), x, y, null);
            if (info.isAppended) {
                g.drawString("+", x + icon.getIconWidth(), y + icon.getIconHeight());
            }
            if ((pos = this.calcTrimPos(label = info.name)) < 0) {
                if (info.count > 1) {
                    label = label + "[" + info.count + "]";
                }
                int width = metrics.stringWidth(label);
                offsetX = (info.bound.width - width) / 2 + ox;
                g.drawString(label, info.bound.x + offsetX, y + 46);
                continue;
            }
            String s1 = label.substring(0, pos);
            String s2 = label.substring(pos);
            if ((pos = this.calcTrimPos(s2)) >= 0) {
                s2 = s2.substring(0, pos - 2) + "\u2026";
            }
            if (info.count > 1) {
                s2 = s2 + "[" + info.count + "]";
            }
            g.drawString(s1, x - 20, y + 46);
            int width = metrics.stringWidth(s2);
            offsetX = (info.bound.width - width) / 2 + ox;
            g.drawString(s2, info.bound.x + offsetX, y + 66);
        }
    }

    private int calcTrimPos(String s) {
        if (s == null) {
            return -1;
        }
        if (s.length() <= 6) {
            return -1;
        }
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ((count += c <= '\u0100' ? 1 : 2) <= 12) continue;
            return i;
        }
        return -1;
    }

    private static ImageIcon getIconByActivityTypeAndState(String stateStr, ActivityDef actDef, boolean inited) {
        WfState state;
        String name = null;
        WfState wfState = state = stateStr == null ? null : WfState.getEnum((String)stateStr);
        if (actDef instanceof StartActivityDef) {
            name = WfState.COMPLETED.equals((Object)state) ? "wf_start_complete" : "wf_start";
        } else if (actDef instanceof EndActivityDef) {
            name = WfState.COMPLETED.equals((Object)state) ? "wf_end_complete" : "wf_end";
        } else if (actDef instanceof RouterActivityDef) {
            name = ((RouterActivityDef)actDef).isSync() ? (WfState.COMPLETED.equals((Object)state) ? "wf_wait_complete" : "wf_wait") : (WfState.COMPLETED.equals((Object)state) ? "wf_empty_complete" : "wf_empty");
        } else if (actDef instanceof ManpowerActivityDef) {
            name = actDef instanceof ApproveActivityDef ? (state == null ? "wf_audit" : (WfState.NOT_STARTED.equals((Object)state) ? "wf_audit" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "wf_audit_suspend" : (WfState.ABORTED.equals((Object)state) ? "wf_audit_abort" : (WfState.TERMINATED.equals((Object)state) ? "wf_audit_terminate" : (WfState.RUNNING.equals((Object)state) ? "wf_audit" : (WfState.COMPLETED.equals((Object)state) && !inited ? "wf_audit_hasNoPersonAndSkip" : "wf_audit_complete"))))))) : (actDef instanceof ManualDecisionActivityDef ? (state == null ? "wf_decision" : (WfState.NOT_STARTED.equals((Object)state) ? "wf_decision" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "wf_decision_suspend" : (WfState.ABORTED.equals((Object)state) ? "wf_decision_abort" : (WfState.TERMINATED.equals((Object)state) ? "wf_decision_terminate" : (WfState.RUNNING.equals((Object)state) ? "wf_decision" : "wf_decision_complete")))))) : (state == null ? "wf_manual" : (WfState.NOT_STARTED.equals((Object)state) ? "wf_manual" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "wf_manual_suspend" : (WfState.ABORTED.equals((Object)state) ? "wf_manual_abort" : (WfState.TERMINATED.equals((Object)state) ? "wf_manual_terminate" : (WfState.RUNNING.equals((Object)state) ? "wf_manual" : "wf_manual_complete")))))));
        } else if (actDef instanceof ToolActivityDef) {
            name = actDef instanceof MessageActivityDef ? (state == null || WfState.NOT_STARTED.equals((Object)state) ? "wf_message" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "wf_message_suspend" : (WfState.ABORTED.equals((Object)state) ? "wf_message_abort" : (WfState.TERMINATED.equals((Object)state) ? "wf_message_terminate" : "wf_message_complete")))) : (actDef instanceof ScriptActivityDef ? (state == null || WfState.NOT_STARTED.equals((Object)state) ? "wf_script" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "wf_script_suspend" : (WfState.ABORTED.equals((Object)state) ? "wf_script_abort" : (WfState.TERMINATED.equals((Object)state) ? "wf_script_terminate" : "wf_script_complete")))) : (actDef instanceof FunctionActivityDef ? (state == null || WfState.NOT_STARTED.equals((Object)state) ? "wf_function" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "wf_function_suspend" : (WfState.ABORTED.equals((Object)state) ? "wf_function_abort" : (WfState.TERMINATED.equals((Object)state) ? "wf_function_terminate" : "wf_function_complete")))) : (actDef instanceof BotpActivityDef ? (state == null || WfState.NOT_STARTED.equals((Object)state) ? "wf_botp" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "wf_botp_suspend" : (WfState.ABORTED.equals((Object)state) ? "wf_botp_abort" : (WfState.TERMINATED.equals((Object)state) ? "wf_botp_terminate" : "wf_botp_complete")))) : (actDef instanceof OtherSysActivityDef ? (WfState.COMPLETED.equals((Object)state) ? "imgWf_otherSys_complete" : (WfState.TERMINATED.equals((Object)state) ? "imgWf_otherSys_terminate" : (WfState.ABORTED.equals((Object)state) ? "imgWf_otherSys_abort" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "imgWf_otherSys_suspend" : "imgWf_otherSys")))) : (state == null || WfState.NOT_STARTED.equals((Object)state) ? "wf_auto" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "wf_auto_suspend" : (WfState.ABORTED.equals((Object)state) ? "wf_auto_abort" : (WfState.TERMINATED.equals((Object)state) ? "wf_auto_terminate" : "wf_auto_complete"))))))));
        } else if (actDef instanceof SubflowActivityDef) {
            name = state == null || WfState.NOT_STARTED.equals((Object)state) ? "wf_subflow" : (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state) ? "wf_subflow_suspend" : (WfState.ABORTED.equals((Object)state) ? "wf_subflow_abort" : (WfState.TERMINATED.equals((Object)state) ? "wf_subflow_terminate" : (WfState.RUNNING.equals((Object)state) ? "wf_subflow" : "wf_subflow_complete"))));
        } else if (actDef instanceof EventActivityDef) {
            if (actDef instanceof ReceiveSignalIntermediateEventActivityDef || actDef instanceof ReceiveSignalEndEventActivityDef || actDef instanceof SignalStartEventActivityDef) {
                name = "wf_waitevent_receiver";
                if (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state)) {
                    name = name + "_suspend";
                } else if (WfState.ABORTED.equals((Object)state)) {
                    name = name + "_abort";
                } else if (WfState.TERMINATED.equals((Object)state)) {
                    name = name + "_terminate";
                } else if (WfState.COMPLETED.equals((Object)state)) {
                    name = name + "_complete";
                }
            } else if (actDef instanceof TimerIntermediateEventActivityDef) {
                name = "wf_waitevent_timer";
                if (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state)) {
                    name = name + "_suspend";
                } else if (WfState.ABORTED.equals((Object)state)) {
                    name = name + "_abort";
                } else if (WfState.TERMINATED.equals((Object)state)) {
                    name = name + "_terminate";
                } else if (WfState.COMPLETED.equals((Object)state)) {
                    name = name + "_complete";
                }
            } else {
                name = "wf_event_sender";
                if (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state)) {
                    name = name + "_suspend";
                } else if (WfState.ABORTED.equals((Object)state)) {
                    name = name + "_abort";
                } else if (WfState.TERMINATED.equals((Object)state)) {
                    name = name + "_terminate";
                } else if (WfState.COMPLETED.equals((Object)state)) {
                    name = name + "_complete";
                }
            }
        } else if (actDef instanceof AbstractTaskServiceActivityDef) {
            name = "wf_auto";
            if (WfState.SUSPENDED.equals((Object)state) || WfState.BLOCKED.equals((Object)state)) {
                name = name + "_suspend";
            } else if (WfState.ABORTED.equals((Object)state)) {
                name = name + "_abort";
            } else if (WfState.TERMINATED.equals((Object)state)) {
                name = name + "_terminate";
            } else if (WfState.COMPLETED.equals((Object)state)) {
                name = name + "_complete";
            }
        }
        if (name == null) {
            BufferedImage img = new BufferedImage(54, 32, 1);
            Graphics2D g = (Graphics2D)img.getGraphics();
            String text = actDef.getType().toString();
            int len = g.getFontMetrics().stringWidth(text);
            g.drawString(text, (54 - len) / 2, 12);
            ImageIcon icon = new ImageIcon();
            icon.setImage(img);
            return icon;
        }
        ImageIcon image = WfProcDiagramEncoder.getIcon(name);
        return image;
    }

    private static ImageIcon getIcon(String name) {
        ImageIcon image = (ImageIcon)ICON_MAP.get(name);
        if (image == null) {
            URL url = WfProcDiagramEncoder.class.getResource("icons/" + name + ".png");
            image = new ImageIcon(url);
            ICON_MAP.put(name, image);
        }
        return image;
    }
}

