/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.app;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.monitor.BillDigestFactory;
import com.kingdee.bos.workflow.monitor.BillDigestInfo;
import com.kingdee.bos.workflow.monitor.IBillDigest;
import com.kingdee.bos.workflow.monitor.IBillDigestUpdater;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class BillDigestUpdater
extends ORMObject
implements IBillDigestUpdater {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.monitor.app.BillDigestUpdater");

    @Override
    public void update() throws Exception {
        StringBuffer buffer = new StringBuffer();
        IBillDigest instance = BillDigestFactory.getLocalInstance(ConfigMDUtil.getContext());
        instance.delete("where id is not null");
        List<File> files = this.getAllXmls();
        for (File file : files) {
            try {
                CoreBaseCollection col = this.translate(file);
                if (col.isEmpty()) continue;
                instance.save(col);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                buffer.append(file.getName() + " , ");
            }
        }
        if (buffer.length() > 0) {
            throw new RuntimeException(buffer.toString() + " \u5347\u7ea7\u51fa\u9519");
        }
    }

    private List<File> getAllXmls() {
        File dirFile;
        String dir = System.getProperty("eas.properties.dir");
        if (!StringUtils.isEmpty((String)dir) && (dirFile = new File(dir + "/mobile/wf")) != null && dirFile.isDirectory()) {
            return this.getAllXmls(dirFile);
        }
        return null;
    }

    private List<File> getAllXmls(File parent) {
        LinkedList<File> result = new LinkedList<File>();
        File[] children = parent.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    List<File> xmls = this.getAllXmls(child);
                    result.addAll(xmls);
                    continue;
                }
                if (!child.getName().endsWith(".xml")) continue;
                result.add(child);
            }
        }
        return result;
    }

    public CoreBaseCollection translate(File file) throws Exception {
        CoreBaseCollection col = new CoreBaseCollection();
        Document doc = new SAXReader().read(file);
        Element root = doc.getRootElement();
        String pk = this.getMetaDataPK(root.element("BOSType"));
        if (pk == null) {
            pk = this.getMetaDataPK(file);
        }
        if (!StringUtils.isEmpty((String)pk)) {
            Element group = root.element("properties");
            List properties = group.elements("prop");
            for (int i = 0; i < properties.size(); ++i) {
                Element property = (Element)properties.get(i);
                BillDigestInfo digest = this.createBillDigest(pk, property);
                col.add((CoreBaseInfo)digest);
            }
            List entrys = group.elements("entry");
            if (entrys != null) {
                for (int i = 0; i < entrys.size(); ++i) {
                    Element entry = (Element)entrys.get(i);
                    String groupName = entry.attributeValue("name");
                    properties = entry.elements("prop");
                    for (int j = 0; j < properties.size(); ++j) {
                        Element property = (Element)properties.get(j);
                        BillDigestInfo digest = this.createBillDigest(pk, groupName, property);
                        col.add((CoreBaseInfo)digest);
                    }
                }
            }
        } else {
            throw new RuntimeException("can't find metadatapk @ file : " + file.getName());
        }
        return col;
    }

    private String getMetaDataPK(Element uuid) {
        BOSObjectType type;
        IMetaDataPK pk;
        String text;
        if (uuid != null && !StringUtils.isEmpty((String)(text = uuid.getText())) && (pk = MDContextFactory.getSystemMDContext().entityMapping.getProperty(type = BOSObjectType.create((String)(text = text.trim())))) != null) {
            return pk.getFullName();
        }
        return null;
    }

    private String getMetaDataPK(File file) {
        String name = file.getName();
        int index = name.indexOf("_default.xml");
        if (index <= 0) {
            index = name.indexOf(".");
        }
        if (index > 0) {
            name = name.substring(0, index);
        }
        File temp = file;
        while ((temp = temp.getParentFile()) != null) {
            String tempName = temp.getName();
            name = tempName + "." + name;
            if (!"com".equals(tempName)) continue;
            break;
        }
        return name;
    }

    private BillDigestInfo createBillDigest(String pk, Element property) {
        BillDigestInfo digest = new BillDigestInfo();
        digest.setMetadataPK(pk);
        digest.setPropertyName(property.attributeValue("name"));
        digest.setAlias(property.attributeValue("caption"));
        return digest;
    }

    private BillDigestInfo createBillDigest(String pk, String group, Element property) {
        BillDigestInfo digest = new BillDigestInfo();
        digest.setMetadataPK(pk);
        digest.setPropertyName(property.attributeValue("name"));
        digest.setPropertyGroup(group);
        return digest;
    }
}

