/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.monitor.IWorkFlowMonitorPanelFacade;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.service.ormrpc.IWfFacade;
import com.kingdee.bos.workflow.service.ormrpc.WfFacadeFactory;
import com.kingdee.bos.workflow.service.ormrpc.struct.IProcessImage;
import java.util.HashMap;
import java.util.Map;

public class WorkFlowMonitorPanelFacade
implements IWorkFlowMonitorPanelFacade {
    private Context ctx;

    public WorkFlowMonitorPanelFacade(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public Map<String, Object> getData(Map<String, Object> params) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String procinstID = (String)params.get("procinstID");
        IWfFacade facade = WfFacadeFactory.getLocalInstance((Context)this.ctx);
        IProcessImage image = facade.getProcessImage(this.ctx.getLocale(), procinstID);
        data.put("image", image);
        procinstID = image.getProcInstId();
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        if (procinstID.endsWith("WFPRCDEF")) {
            String hash = service.getProcessDefInfo(procinstID).getMd5HashValue();
            ProcessDef processDef = service.getProcessDefByDefineHashValue(hash);
            data.put("processDef", processDef);
        } else if (procinstID.endsWith("WFPCINST")) {
            ActivityInstInfo[] actInstInfos = service.getActInstMetaArrayByProcInstId(procinstID);
            data.put("actInstInfos", actInstInfos);
            ProcessInstInfo procInstInfo = service.getProcessInstInfo(procinstID);
            data.put("procInstInfo", procInstInfo);
            ProcessDef processDef = service.getProcessDefByDefineHashValue(procInstInfo.getProcDefHashValue());
            data.put("processDef", processDef);
        }
        return data;
    }
}

