/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.statsa.syn;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.md5;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.metas.SAActInstFactory;
import com.kingdee.bos.workflow.metas.SAActInstInfo;
import com.kingdee.bos.workflow.metas.SAProcInstInfo;
import com.kingdee.bos.workflow.statsa.caldate.SAWorkCalendarUtil;
import com.kingdee.bos.workflow.statsa.service.SAProcessDATASyncMange;
import com.kingdee.bos.workflow.statsa.util.SAUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SAActinstDATASync {
    private Context ctx;
    private static Logger log = Logger.getLogger(SAActinstDATASync.class);
    private static Map<String, Map<String, Boolean>> procdefMap = new HashMap<String, Map<String, Boolean>>();

    public SAActinstDATASync(Context ctx) {
        this.ctx = ctx;
    }

    public boolean synData(SAProcInstInfo tSAProcInstInfo) throws BOSException {
        String procInstId = tSAProcInstInfo.getProcInstID().toString();
        try {
            CoreBaseCollection tCoreCollection = new CoreBaseCollection();
            ActivityInstInfo[] activitys = WfEngine.getEngine((Context)this.ctx).getActInstMetaArrayByProcInstId(procInstId);
            Map<String, Boolean> actDefMap = this.getActivityDefListMark(this.ctx, tSAProcInstInfo.getProcdefHash());
            for (int index = 0; index < activitys.length; ++index) {
                ActivityInstInfo activityInfo = activitys[index];
                if (actDefMap.get(activityInfo.getActDefId()) == null) continue;
                tCoreCollection.add(this.createSAActInstInfo(tSAProcInstInfo, activityInfo));
            }
            if (tCoreCollection.size() > 0) {
                SAActInstFactory.getLocalInstance((Context)this.ctx).addnewBatchData(tCoreCollection);
            }
        }
        catch (Exception e) {
            throw new BOSException("\u540c\u6b65\u6d41\u7a0b\uff1a" + procInstId + "\u5bf9\u5e94\u7684\u6d3b\u52a8\u5b9e\u4f8b\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
        return true;
    }

    public Map<String, Boolean> getActivityDefListMark(Context ctx, String procdefHash) throws WfException {
        HashMap<String, Boolean> actDefMap = new HashMap();
        if (procdefMap.get(procdefHash) == null) {
            ProcessDef processDef = WfEngine.getEngine((Context)ctx).getProcessDef(procdefHash);
            ActivityCollection actDefCollection = processDef.getActivitys();
            for (int index = 0; index < actDefCollection.size(); ++index) {
                ActivityDef actDef = actDefCollection.get(index);
                String actDefID = actDef.getID();
                if (!(actDef instanceof ManpowerActivityDef) && !(actDef instanceof SubflowActivityDef)) continue;
                actDefMap.put(actDefID, true);
            }
            procdefMap.put(procdefHash, actDefMap);
        } else {
            actDefMap = procdefMap.get(procdefHash);
        }
        return actDefMap;
    }

    private CoreBaseInfo createSAActInstInfo(SAProcInstInfo tSAProcInstInfo, ActivityInstInfo activityInfo) throws BOSException {
        SAActInstInfo tSAActInstInfo = new SAActInstInfo();
        EntityObjectInfo tEntityObjectInfo = SAUtil.getMetaDataLoader(this.ctx).getEntity(tSAActInstInfo.getBOSType());
        PropertyCollection tPropertyCollection = tEntityObjectInfo.getInheritedPropertiesRuntime();
        for (int index = 0; index < tPropertyCollection.size(); ++index) {
            DataType tDataType;
            PropertyInfo tPropertyInfo = tPropertyCollection.get(index);
            String name = tPropertyInfo.getName();
            if (!(tPropertyInfo instanceof OwnPropertyInfo)) continue;
            Object value = activityInfo.getData(name);
            if (value != null) {
                tSAActInstInfo.put(name, value);
            }
            if (!(tDataType = ((OwnPropertyInfo)tPropertyInfo).getDataType()).equals((Object)DataType.BOSUUID) || !(value instanceof String)) continue;
            tSAActInstInfo.put(name, value != null ? BOSUuid.read((String)value.toString()) : null);
        }
        tSAActInstInfo.setActDefHash(this.createNewActDefId(tSAActInstInfo.getProcDefID().toString(), tSAActInstInfo.getActDefID().toString(), tSAProcInstInfo.getBillBostype()));
        tSAActInstInfo.setProcDefName(activityInfo.getProcDefName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
        tSAActInstInfo.setProcDefName(activityInfo.getProcDefName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
        tSAActInstInfo.setProcDefName(activityInfo.getProcDefName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        tSAActInstInfo.setActDefName(activityInfo.getActDefName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
        tSAActInstInfo.setActDefName(activityInfo.getActDefName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
        tSAActInstInfo.setActDefName(activityInfo.getActDefName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        tSAActInstInfo.setInitiatorID(tSAProcInstInfo.getInitiatorID());
        tSAActInstInfo.setInitiatorName(tSAProcInstInfo.getInitiatorName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
        tSAActInstInfo.setInitiatorName(tSAProcInstInfo.getInitiatorName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
        tSAActInstInfo.setInitiatorName(tSAProcInstInfo.getInitiatorName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        tSAActInstInfo.setId(BOSUuid.create((BOSObjectType)tSAActInstInfo.getBOSType()));
        tSAActInstInfo.setBillBostype(tSAProcInstInfo.getBillBostype());
        tSAActInstInfo.setBillBostypeName(tSAProcInstInfo.getBillBostypeName());
        BigDecimal executeTime = SAWorkCalendarUtil.calExecuteTime(this.ctx, tSAActInstInfo.getCreatedTime(), tSAActInstInfo.getComleteTime());
        tSAActInstInfo.setExecuteTime(executeTime);
        return tSAActInstInfo;
    }

    private BOSUuid createNewActDefId(String procDefId, String actDefId, String bostype) {
        String uuid = "";
        try {
            md5 md = new md5(procDefId + actDefId + bostype);
            md.processString();
            String hashValue = md.getStringDigest();
            uuid = hashValue.substring(0, 8) + "-" + hashValue.substring(8, 12) + "-" + hashValue.substring(12, 16) + "-" + hashValue.substring(16, 20) + "-" + hashValue.substring(20) + "WFACTHSH";
            return BOSUuid.read((String)uuid);
        }
        catch (Exception e) {
            if (!SAProcessDATASyncMange.logIsClose) {
                log.error((Object)("\u751f\u6210uuid\u62a5\u9519:" + uuid), (Throwable)e);
            }
            return BOSUuid.read((String)actDefId);
        }
    }

    public static void clearMap() {
        procdefMap.clear();
    }
}

