/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.BizProcInfo;
import com.kingdee.bos.workflow.biz.DeployedEventSet;
import com.kingdee.bos.workflow.biz.IBizProcFinder;
import com.kingdee.bos.workflow.cust.app.impl.WfRoleAdapter;
import com.kingdee.bos.workflow.define.AccessLevel;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.ConditionDef;
import com.kingdee.bos.workflow.define.ConditionType;
import com.kingdee.bos.workflow.define.EventActivityDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.SignalStartEventActivityDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.engine.core.ThreadCache;
import com.kingdee.bos.workflow.metas.EventProcMetaInfo;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.WfEngineEventEnum;
import com.kingdee.bos.workflow.participant.Group;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.JobInfo;
import com.kingdee.bos.workflow.participant.OrgUnitInfo;
import com.kingdee.bos.workflow.participant.PerformerType;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.participant.PositionInfo;
import com.kingdee.bos.workflow.store.EventStorer;
import com.kingdee.bos.workflow.store.ProcessStorer;
import com.kingdee.bos.workflow.util.CommonEventUtils;
import com.kingdee.bos.workflow.util.PermissionUtil;
import com.kingdee.bos.workflow.util.WfRoleInvoke;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DefaultBizProcFinder
implements IBizProcFinder {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.biz.DefaultBizProcFinder");
    private WfEngine wfEngine;
    private WfLogger wfLogger;

    public DefaultBizProcFinder(WfEngine engine) {
        this.wfEngine = engine;
        this.wfLogger = this.wfEngine.getWfLogger();
    }

    public WfEngine geWfEngine() {
        return this.wfEngine;
    }

    @Override
    public ProcessDefInfo[] getProcDefArrayDistinctByUserID(String userId) throws WfException {
        Person person = this.wfEngine.getPariticipantProvider().getPersonByUserId(this.geWfEngine().context(), userId);
        String empId = person.getEmployeeId();
        BizProcInfo[] bizProcInfoArray = this.findProcDef(empId);
        ArrayList<String> procDefIdList = new ArrayList<String>();
        for (int i = 0; i < bizProcInfoArray.length; ++i) {
            String procDefId = bizProcInfoArray[i].getProcDefId();
            if (procDefIdList.contains(procDefId)) continue;
            procDefIdList.add(procDefId);
        }
        Vector<ProcessDefInfo> procDefVector = new Vector<ProcessDefInfo>();
        for (int i = 0; i < procDefIdList.size(); ++i) {
            String procDefId = (String)procDefIdList.get(i);
            ProcessDefInfo processDefInfo = this.wfEngine.getDefinitionMgr().getProcessDefInfo(procDefId);
            if (processDefInfo == null || !processDefInfo.getClientStart()) continue;
            procDefVector.add(processDefInfo);
        }
        ProcessDefInfo[] procDefArray = new ProcessDefInfo[procDefVector.size()];
        procDefVector.toArray(procDefArray);
        return procDefArray;
    }

    @Override
    public BizProcInfo[] findProcDef(Person performer, PerformerType performerType, String bizFunc, String bizPackage, String bizOperation) throws WfException {
        BizProcInfo[] bizProcInfos;
        if (PerformerType.USER.equals((Object)performerType)) {
            ProcessStorer storer = this.wfEngine.getStoreManager().getProcessStorer();
            bizProcInfos = storer.getBizProcList(performer.getUserId(), bizFunc, bizPackage, bizOperation);
        } else {
            bizProcInfos = this.innerFindProcDef(performer, performerType, bizFunc, bizPackage, bizOperation);
        }
        if (bizProcInfos == null) {
            return new BizProcInfo[0];
        }
        ArrayList<BizProcInfo> filterList = new ArrayList<BizProcInfo>();
        int n = bizProcInfos.length;
        for (int i = 0; i < n; ++i) {
            if (filterList.contains(bizProcInfos[i])) continue;
            filterList.add(bizProcInfos[i]);
        }
        ArrayList<BizProcInfo> rtnList = new ArrayList<BizProcInfo>();
        int n2 = filterList.size();
        for (int i = 0; i < n2; ++i) {
            BizProcInfo bizProcInfo = (BizProcInfo)filterList.get(i);
            if (this.exceptContains(bizProcInfo, performer)) continue;
            rtnList.add(bizProcInfo);
        }
        BizProcInfo[] rtnValue = new BizProcInfo[rtnList.size()];
        rtnList.toArray(rtnValue);
        return rtnValue;
    }

    private boolean exceptContains(BizProcInfo bizProcInfo, Person person) throws WfException {
        String userID;
        String performerID = bizProcInfo.getExceptPerformerID();
        PerformerType performerType = bizProcInfo.getExceptPerformerType();
        if (StringUtils.isEmpty((String)performerID) || performerType == null) {
            return false;
        }
        String personID = person.getEmployeeId();
        IParticipantProvider provider = this.geWfEngine().getPariticipantProvider();
        if (PerformerType.USER.equals((Object)performerType) && performerID.equals(userID = person.getUserId())) {
            return true;
        }
        if (PerformerType.EMPLOYEE.equals((Object)performerType) && performerID.equals(personID)) {
            return true;
        }
        if (PerformerType.POSITION.equals((Object)performerType)) {
            for (PositionInfo positionInfo : provider.getPositionArrayByEmployeeId(this.geWfEngine().context(), personID)) {
                if (!positionInfo.getId().equals(performerID)) continue;
                return true;
            }
        }
        if (PerformerType.ORG_UNIT.equals((Object)performerType)) {
            OrgUnitInfo[] orgs = provider.getOrgUnitArrayByEmployeeId(this.geWfEngine().context(), personID);
            int n = orgs.length;
            for (int i = 0; i < n; ++i) {
                if (!orgs[i].getId().equals(performerID)) continue;
                return true;
            }
        }
        if (PerformerType.ROLE.equals((Object)performerType)) {
            // empty if block
        }
        if (PerformerType.ORG_UNIT_PRINCIPAL.equals((Object)performerType)) {
            // empty if block
        }
        if (PerformerType.PERMISION_OWNNER.equals((Object)performerType)) {
            // empty if block
        }
        return PerformerType.ALL.equals((Object)performerType);
    }

    private Map permissionCheckResult(Map procRelationMap, String performerUserId) {
        Context context = this.wfEngine.context();
        Iterator iterator = procRelationMap.entrySet().iterator();
        HashMap<String, HashSet<String>> permissionItemsMap = new HashMap<String, HashSet<String>>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ArrayList bizProcInfos = (ArrayList)entry.getValue();
            for (int i = 0; i < bizProcInfos.size(); ++i) {
                BizProcInfo bizProcInfo = (BizProcInfo)bizProcInfos.get(i);
                PerformerType localPerformerType = bizProcInfo.getPerformerType();
                if (!PerformerType.PERMISION_OWNNER.equals((Object)localPerformerType)) continue;
                try {
                    String procdefId = bizProcInfo.getProcDefId();
                    String startActID = bizProcInfo.getProcStartActDefId();
                    WfProcessMgr mgr = this.wfEngine.getProcessMgr(procdefId);
                    ActivityDef actDef = mgr.getProcessDef().getActivityDef(startActID);
                    if (!(actDef instanceof ManpowerActivityDef)) continue;
                    ManpowerActivityDef man = (ManpowerActivityDef)actDef;
                    ParticipantCollection participantCollection = man.getParticipants();
                    for (ParticipantDef participant : participantCollection) {
                        ExtendedAttributeDef ea;
                        if (!participant.getParticipantType().equals((Object)ParticipantType.ORGANIZATIONAL_UNIT_PERMISSION_OWNER) || !bizProcInfo.getPerformerId().equals(participant.getParticipantValue()) || (ea = participant.getExtendedAttributes().get("permissionItem")) == null) continue;
                        String permissionItem = ea.getValue();
                        String orgunit = bizProcInfo.getPerformerId();
                        if (StringUtils.isEmpty((String)permissionItem) || StringUtils.isEmpty((String)orgunit)) continue;
                        HashSet<String> orgs = (HashSet<String>)permissionItemsMap.get(permissionItem);
                        if (orgs == null) {
                            orgs = new HashSet<String>();
                            permissionItemsMap.put(permissionItem, orgs);
                        }
                        orgs.add(orgunit);
                    }
                    continue;
                }
                catch (BOSException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        Iterator it = permissionItemsMap.entrySet().iterator();
        Set authorizedOrgs = null;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String permissionItem = (String)entry.getKey();
            Set orgs = (Set)entry.getValue();
            try {
                authorizedOrgs = this.wfEngine.getPermissionProvider().checkPermission(context, performerUserId, 0, orgs.toArray(new String[0]), permissionItem);
            }
            catch (BOSException e) {
                log.warn((Object)("batch permission check failed. userid=" + performerUserId + "; item=" + permissionItem), (Throwable)e);
            }
            orgs.clear();
            if (authorizedOrgs == null) continue;
            orgs.addAll(authorizedOrgs);
        }
        return permissionItemsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BizProcInfo[] innerFindProcDef(Person performer, PerformerType performerType, String bizFunc, String bizPackage, String bizOperation) throws WfException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "innerFindProcDef", null);
        }
        try {
            Map procRelationMap;
            try {
                ProcessStorer storer = this.wfEngine.getStoreManager().getProcessStorer();
                procRelationMap = storer.getBizProcRelationMap(bizFunc, bizPackage, bizOperation);
            }
            catch (SQLException ex) {
                throw new WfException(ex.getMessage(), (Throwable)ex);
            }
            Context context = this.wfEngine.context();
            String performerUserId = performer.getUserId();
            String performerEmployeeId = performer.getEmployeeId();
            Map authorizedOrgs = this.permissionCheckResult(procRelationMap, performerUserId);
            ArrayList<BizProcInfo> bizProcInfoList = new ArrayList<BizProcInfo>();
            for (Map.Entry entry : procRelationMap.entrySet()) {
                ArrayList bizProcInfos = (ArrayList)entry.getValue();
                block9: for (int i = 0; i < bizProcInfos.size(); ++i) {
                    BizProcInfo bizProcInfo = (BizProcInfo)bizProcInfos.get(i);
                    PerformerType localPerformerType = bizProcInfo.getPerformerType();
                    if (!PerformerType.PERMISION_OWNNER.equals((Object)localPerformerType)) continue;
                    PermissionItemCollection permissions = null;
                    try {
                        String procdefId = bizProcInfo.getProcDefId();
                        String startActID = bizProcInfo.getProcStartActDefId();
                        WfProcessMgr mgr = this.wfEngine.getProcessMgr(procdefId);
                        ActivityDef actDef = mgr.getProcessDef().getActivityDef(startActID);
                        if (!(actDef instanceof ManpowerActivityDef)) continue;
                        ManpowerActivityDef man = (ManpowerActivityDef)actDef;
                        ParticipantCollection participantCollection = man.getParticipants();
                        Iterator iter = participantCollection.iterator();
                        while (iter.hasNext()) {
                            ExtendedAttributeDef ea;
                            boolean hasPermission = false;
                            ParticipantDef participant = (ParticipantDef)iter.next();
                            if (!participant.getParticipantType().equals((Object)ParticipantType.ORGANIZATIONAL_UNIT_PERMISSION_OWNER) || !bizProcInfo.getPerformerId().equals(participant.getParticipantValue()) || (ea = participant.getExtendedAttributes().get("permissionItem")) == null) continue;
                            if (ea != null && !StringUtils.isEmpty((String)ea.getValue())) {
                                String permissionItem = ea.getValue();
                                PermissionItemInfo permissionInfo = new PermissionItemInfo();
                                permissionInfo.setName(permissionItem);
                                String orgunit = bizProcInfo.getPerformerId();
                                String string = orgunit = StringUtils.isEmpty((String)orgunit) ? null : orgunit;
                                if (orgunit == null) {
                                    hasPermission = this.wfEngine.getPermissionProvider().checkPermission(context, performerUserId, 0, orgunit, permissionInfo);
                                } else {
                                    Set orgs = (Set)authorizedOrgs.get(permissionItem);
                                    boolean bl = hasPermission = orgs != null && orgs.contains(orgunit);
                                }
                                if (!hasPermission) continue;
                                bizProcInfoList.add(bizProcInfo);
                                continue block9;
                            }
                            if (permissions == null) {
                                permissions = PermissionUtil.getPermissionItemCollection(context, bizPackage, bizFunc, bizOperation);
                            }
                            if (!(hasPermission = this.wfEngine.getPermissionProvider().checkPermission(context, performerUserId, 0, null, permissions))) continue;
                            bizProcInfoList.add(bizProcInfo);
                            continue block9;
                        }
                        continue;
                    }
                    catch (BOSException e) {
                        log.warn((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            int listSize = bizProcInfoList.size();
            if (listSize > 0) {
                for (int i = 0; i < listSize; ++i) {
                    BizProcInfo bizProcInfo = (BizProcInfo)bizProcInfoList.get(i);
                    if (!bizProcInfo.getInheritParentProcess()) continue;
                    BizProcInfo[] parentBizProcInfoArray = this.findProcDef(performerEmployeeId, performerType, bizFunc, bizPackage, bizOperation, procRelationMap);
                    for (int j = 0; j < parentBizProcInfoArray.length; ++j) {
                        bizProcInfoList.add(parentBizProcInfoArray[j]);
                    }
                }
                if (!this.wfLogger.checkLogLevel(LogTypeEnum.INFO) && bizProcInfoList != null && bizProcInfoList.size() > 0) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("Find ");
                    buffer.append(bizProcInfoList.size());
                    buffer.append(" PERMISION_OWNNER's processdef!");
                    String message = buffer.toString();
                    this.wfLogger.addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.FINDPROCESSDEF, "", message);
                }
                BizProcInfo[] rtnArray = new BizProcInfo[bizProcInfoList.size()];
                bizProcInfoList.toArray(rtnArray);
                BizProcInfo[] bizProcInfoArray = rtnArray;
                return bizProcInfoArray;
            }
            BizProcInfo[] bizProcInfoArray = this.findProcDef(performerEmployeeId, performerType, bizFunc, bizPackage, bizOperation, procRelationMap);
            return bizProcInfoArray;
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    @Override
    public BizProcInfo[] findProcDef(String performerId, PerformerType performerType, String bizFunc, String bizPackage, String bizOperation) throws WfException {
        Map map;
        ProcessStorer storer = this.wfEngine.getStoreManager().getProcessStorer();
        if (PerformerType.USER.equals((Object)performerType)) {
            return storer.getBizProcList(performerId, bizFunc, bizPackage, bizOperation);
        }
        try {
            map = storer.getBizProcRelationMap(bizFunc, bizPackage, bizOperation);
        }
        catch (SQLException ex) {
            throw new WfException(ex.getMessage(), (Throwable)ex, true);
        }
        return this.findProcDef(performerId, performerType, bizFunc, bizPackage, bizOperation, map);
    }

    public BizProcInfo[] findProcDef_old(String performerId, PerformerType performerType, String bizFunc, String bizPackage, String bizOperation) throws WfException {
        BizProcInfo bizProcInfo;
        ProcessStorer storer = this.wfEngine.getStoreManager().getProcessStorer();
        ArrayList<BizProcInfo> bizProcInfoList = new ArrayList<BizProcInfo>();
        try {
            bizProcInfo = storer.getBizProcRelation(performerId, bizFunc, bizPackage, bizOperation);
        }
        catch (SQLException ex) {
            throw new WfException(ex.getMessage(), (Throwable)ex, true);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e, true);
        }
        if (bizProcInfo != null) {
            bizProcInfoList.add(bizProcInfo);
        }
        if (bizProcInfo == null || bizProcInfo.getInheritParentProcess()) {
            IParticipantProvider participantProvider = this.wfEngine.getPariticipantProvider();
            if (performerType.equals((Object)PerformerType.EMPLOYEE)) {
                long start = System.currentTimeMillis();
                PositionInfo[] positionArray = participantProvider.getPositionArrayByEmployeeId(this.geWfEngine().context(), performerId);
                long end = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("get position cost : " + (end - start)));
                    log.debug((Object)("get position cost : " + (end - start) + ", positionArray's length : " + positionArray.length));
                }
                for (int i = 0; i < positionArray.length; ++i) {
                    BizProcInfo[] bizProcArray = this.findProcDef(positionArray[i].getId(), PerformerType.POSITION, bizFunc, bizPackage, bizOperation);
                    for (int j = 0; j < bizProcArray.length; ++j) {
                        bizProcInfoList.add(bizProcArray[j]);
                    }
                }
                end = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("find position's process cost : " + (end - start)));
                    log.debug((Object)("find position's process cost : " + (end - start)));
                }
                if (bizProcInfoList.size() == 0) {
                    // empty if block
                }
                if (bizProcInfoList.size() == 0) {
                    start = System.currentTimeMillis();
                    OrgUnitInfo[] orgArray = participantProvider.getOrgUnitArrayByEmployeeId(this.geWfEngine().context(), performerId);
                    if (orgArray == null) {
                        orgArray = new OrgUnitInfo[]{};
                    }
                    end = System.currentTimeMillis();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("get organization cost : " + (end - start)));
                        log.debug((Object)("get organization cost : " + (end - start) + ", orgArray's length : " + (orgArray != null ? orgArray.length + "" : " null ")));
                    }
                    if (orgArray != null) {
                        for (int i = 0; i < orgArray.length; ++i) {
                            BizProcInfo[] bizProcArray = this.findProcDef(orgArray[i].getId(), PerformerType.ORG_UNIT, bizFunc, bizPackage, bizOperation);
                            for (int j = 0; j < bizProcArray.length; ++j) {
                                bizProcInfoList.add(bizProcArray[j]);
                            }
                        }
                    }
                    end = System.currentTimeMillis();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("find organization's process cost : " + (end - start)));
                        log.debug((Object)("find organization's process cost : " + (end - start)));
                    }
                }
            } else if (!performerType.equals((Object)PerformerType.POSITION)) {
                if (performerType.equals((Object)PerformerType.ORG_UNIT)) {
                    long start = System.currentTimeMillis();
                    OrgUnitInfo parentOrgUnit = participantProvider.getParentOrgUnit(this.geWfEngine().context(), performerId);
                    long end = System.currentTimeMillis();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("get parentOrganization cost : " + (end - start)));
                        log.debug((Object)("get parentOrganization cost : " + (end - start)));
                    }
                    if (parentOrgUnit != null) {
                        BizProcInfo[] bizProcArray = this.findProcDef(parentOrgUnit.getId(), PerformerType.ORG_UNIT, bizFunc, bizPackage, bizOperation);
                        for (int i = 0; i < bizProcArray.length; ++i) {
                            bizProcInfoList.add(bizProcArray[i]);
                        }
                    }
                    end = System.currentTimeMillis();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("find super organization's process cost : " + (end - start)));
                        log.debug((Object)("find super organization's process cost : " + (end - start)));
                    }
                } else {
                    throw new WfException("TODO");
                }
            }
        }
        BizProcInfo[] rtnArray = new BizProcInfo[bizProcInfoList.size()];
        bizProcInfoList.toArray(rtnArray);
        return rtnArray;
    }

    @Override
    public BizProcInfo[] findProcDef(String performerUserId) throws WfException {
        boolean hpro;
        Vector bizProcInfoVector;
        Vector<BizProcInfo> returnValue = new Vector<BizProcInfo>();
        ProcessStorer storer = this.wfEngine.getStoreManager().getProcessStorer();
        try {
            bizProcInfoVector = storer.getBizProcRelationVector(null, null, null);
        }
        catch (SQLException ex) {
            throw new WfException(ex.getMessage(), (Throwable)ex, true);
        }
        int size = bizProcInfoVector.size();
        for (int i = size - 1; i >= 0; --i) {
            BizProcInfo bizProcInfo = (BizProcInfo)bizProcInfoVector.get(i);
            if (!performerUserId.equalsIgnoreCase(bizProcInfo.getPerformerId())) continue;
            returnValue.add(bizProcInfo);
            bizProcInfoVector.remove(bizProcInfo);
        }
        boolean haveProcDefReleatedPosition = this.haveProcDefReleatedPosition(bizProcInfoVector);
        if (haveProcDefReleatedPosition && bizProcInfoVector != null) {
            Vector procDefReleatedPosition = this.findProcDefReleatedPosition(performerUserId, bizProcInfoVector);
            returnValue.addAll(procDefReleatedPosition);
        }
        if ((hpro = this.haveProcDefReleatedORG(bizProcInfoVector)) && bizProcInfoVector != null) {
            Vector pro = this.findProcDefReleatedORG(performerUserId, bizProcInfoVector);
            returnValue.addAll(pro);
        }
        size = bizProcInfoVector.size();
        for (int i = size - 1; i >= 0; --i) {
            BizProcInfo bizProcInfo = (BizProcInfo)bizProcInfoVector.get(i);
            if (!PerformerType.ALL.equals((Object)bizProcInfo.getPerformerType())) continue;
            returnValue.add(bizProcInfo);
            bizProcInfoVector.remove(bizProcInfo);
        }
        int bizProcSize = returnValue.size();
        BizProcInfo[] returnBizProcInfoArray = new BizProcInfo[bizProcSize];
        returnValue.toArray(returnBizProcInfoArray);
        return returnBizProcInfoArray;
    }

    public void setBizProcRelation(BizProcInfo bizProcInfo, boolean isIngonreRepeate) throws WfException {
        if (bizProcInfo == null) {
            String message = "\"bizProcInfo\" is null!";
            throw new IllegalArgumentException(message);
        }
        try {
            ProcessStorer storer = this.wfEngine.getStoreManager().getProcessStorer();
            BizProcInfo dbBizProcInfo = storer.getBizProcRelation(bizProcInfo.getPerformerId(), bizProcInfo.getBizFunction(), bizProcInfo.getBizPackage(), bizProcInfo.getBizOperation());
            if (!isIngonreRepeate && bizProcInfo.getPerformerType().equals((Object)PerformerType.ALL)) {
                Vector infos = storer.getBizProcRelationVector(bizProcInfo.getBizFunction(), bizProcInfo.getBizPackage(), bizProcInfo.getBizOperation());
                int n = infos.size();
                for (int i = 0; i < n; ++i) {
                    BizProcInfo info = (BizProcInfo)infos.get(i);
                    if (!info.getPerformerType().equals((Object)PerformerType.ALL) || info.getProcDefId().equals(bizProcInfo.getProcDefId())) continue;
                    throw new WfException("WFE_DEF_StartCondRep", null, null);
                }
            }
            if (!isIngonreRepeate && !dbBizProcInfo.getProcDefId().equals(bizProcInfo.getProcDefId())) {
                throw new WfException("WFE_DEF_StartCondRep", null, null);
            }
            storer.createBizProcRelation(bizProcInfo);
        }
        catch (SQLException ex) {
            throw new WfException(ex.getMessage(), (Throwable)ex, true);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e, true);
        }
    }

    @Override
    public void setBizProcRelation(BizProcInfo bizProcInfo) throws WfException {
        this.setBizProcRelation(bizProcInfo, true);
    }

    public void clearBizProcRelation(String processDefId) throws WfException {
        try {
            ProcessStorer storer = this.wfEngine.getStoreManager().getProcessStorer();
            storer.clearBizProcRelation(processDefId);
        }
        catch (SQLException ex) {
            throw new WfException(ex.getMessage(), (Throwable)ex, true);
        }
    }

    @Override
    public void handlerProcDefReleaseEvent(ProcessDef processDef) throws WfException {
        if (processDef == null) {
            throw new IllegalArgumentException();
        }
        if (AccessLevel.PRIVATE.equals((Object)processDef.getAccessLevel())) {
            return;
        }
        StartActivityDef startActDef = processDef.getStartActivity();
        if (startActDef == null) {
            throw new WfException("WFE_DEF_noStartAct", null, null).addArg(processDef.getID()).addArg(processDef.getName());
        }
        ActivityCollection firstActList = startActDef.getPostActivities();
        this.handleFunctionProcDefTrigger(processDef, firstActList);
        this.handleEventProcDefTrigger(processDef, firstActList);
    }

    private void handleEventProcDefTrigger(ProcessDef processDef, ActivityCollection firstActList) throws WfException {
        if (processDef == null || firstActList.size() <= 0) {
            return;
        }
        EventProcMetaInfo[] eventProcMetaInfos = this.getEventProcMetaInfo(firstActList);
        if (eventProcMetaInfos == null || eventProcMetaInfos.length <= 0) {
            return;
        }
        this.clearEventProcRelation(processDef.getID());
        this.wfEngine.setEventProcRelation(eventProcMetaInfos);
    }

    public void clearEventProcRelation(String processDefId) throws WfException {
        try {
            EventStorer storer = this.wfEngine.getStoreManager().getEventStorer();
            storer.clearEventProcRelation(processDefId);
        }
        catch (SQLException ex) {
            throw new WfException(ex.getMessage(), (Throwable)ex, true);
        }
    }

    private EventProcMetaInfo[] getEventProcMetaInfo(ActivityCollection firstActList) throws WfException {
        if (firstActList == null || firstActList.size() <= 0) {
            return null;
        }
        ArrayList<EventProcMetaInfo> eventProcMetaInfos = new ArrayList<EventProcMetaInfo>();
        EventProcMetaInfo eventProcMetaInfo = null;
        for (int i = 0; i < firstActList.size(); ++i) {
            EventActivityDef eventActivityDef;
            ManpowerActivityDef manActDef;
            ActivityDef actDef = firstActList.get(i);
            if (actDef instanceof SignalStartEventActivityDef) {
                eventProcMetaInfo = CommonEventUtils.constructEventProcMetaInfo((EventActivityDef)((SignalStartEventActivityDef)actDef), null);
            } else if (actDef instanceof ManpowerActivityDef && !StringUtils.isEmpty((String)(manActDef = (ManpowerActivityDef)actDef).getRefEventActDefId()) && (eventActivityDef = (EventActivityDef)((ProcessDef)manActDef.getContainer()).getActivityDef(manActDef.getRefEventActDefId())) != null && !StringUtils.isEmpty((String)eventActivityDef.getEventName())) {
                eventProcMetaInfo = CommonEventUtils.constructEventProcMetaInfo(eventActivityDef, manActDef);
            }
            if (eventProcMetaInfo == null) continue;
            eventProcMetaInfos.add(eventProcMetaInfo);
        }
        return eventProcMetaInfos.toArray(new EventProcMetaInfo[0]);
    }

    private boolean isLegalManpowerAct(ManpowerActivityDef act) {
        try {
            ApplicationDef appDef = act.getRelatedApplication();
            if (appDef == null) {
                return false;
            }
            FunctionDef funcDef = appDef.getFunction();
            if (funcDef == null || StringUtils.isEmpty((String)funcDef.getPackageName()) || StringUtils.isEmpty((String)funcDef.getOperation())) {
                return false;
            }
            ActivityCollection preColl = act.getPreviousActivities();
            ActivityCollection postColl = act.getPostActivities();
            log.error((Object)("\u4eba\u5de5\u8282\u70b9:" + act.getName() + "(" + act.getID() + ")"));
            if (preColl.size() > 0 && postColl.size() > 0) {
                return true;
            }
        }
        catch (WfException e) {
            log.error((Object)e);
        }
        return false;
    }

    private void handleFunctionProcDefTrigger(ProcessDef processDef, ActivityCollection firstActList) throws WfException {
        if (processDef == null || firstActList.size() <= 0) {
            return;
        }
        this.clearBizProcRelation(processDef.getID());
        String compareBosType = null;
        for (int i = 0; i < firstActList.size(); ++i) {
            ManpowerActivityDef manpowerActDef;
            ActivityDef actDef = firstActList.get(i);
            if (actDef instanceof ApproveActivityDef || !(actDef instanceof ManpowerActivityDef) || !this.isLegalManpowerAct(manpowerActDef = (ManpowerActivityDef)actDef)) continue;
            FunctionDef funcDef = manpowerActDef.getRelatedApplication().getFunction();
            String bizPackage = funcDef.getPackageName();
            String funcName = funcDef.getName();
            String operName = funcDef.getOperation();
            try {
                DeployedEventSet.getInstance((Context)this.wfEngine.context()).add(bizPackage, funcName, operName);
            }
            catch (BOSException e) {
                throw new WfException((Throwable)e, true);
            }
            ParticipantCollection participantCollection = manpowerActDef.getParticipants();
            ConditionDef conditionDef = null;
            if (actDef.getIncomingTransitions().size() > 1) {
                for (int index = 0; index < actDef.getIncomingTransitions().size(); ++index) {
                    TransitionDef transitionDef = actDef.getIncomingTransitions().get(index);
                    if (!(transitionDef.getFrom() instanceof StartActivityDef)) continue;
                    conditionDef = transitionDef.getCondition();
                    break;
                }
            } else {
                conditionDef = actDef.getIncomingTransitions().get(0).getCondition();
            }
            String billBostype = this.getBillBostype(funcDef);
            if (compareBosType == null) {
                compareBosType = billBostype;
            } else if (compareBosType != null && billBostype != null && !compareBosType.equals(billBostype)) {
                log.error((Object)" ---not support more bostype in one procdef-----");
                throw new WfException("\u4e0d\u5141\u8bb8\u4e00\u4e2a\u6d41\u7a0b\u5b9a\u4e49\u4e2d\u591a\u4e2a\u542f\u52a8\u8282\u70b9\u914d\u7f6e\u4e0d\u540c\u5355\u636e\u7c7b\u578b");
            }
            processDef.setBillBostype(compareBosType);
            if (!StringUtils.isEmpty((String)compareBosType)) {
                this.insertSubProcBosType(processDef.getID(), compareBosType);
            }
            List<String[]> conditions = this.getStartCondition(conditionDef);
            ArrayList<ParticipantDef> exceptList = new ArrayList<ParticipantDef>();
            HashMap<String, BizProcInfo> map = new HashMap<String, BizProcInfo>();
            for (int j = 0; j < participantCollection.size(); ++j) {
                ParticipantDef participant = participantCollection.get(j);
                if (!StringUtils.isEmpty((String)participant.getExceptFormRef())) {
                    exceptList.add(participant);
                    continue;
                }
                if (participant.getParticipantType().equals((Object)ParticipantType.RELATION) || participant.getParticipantType().equals((Object)ParticipantType.VARIANT)) continue;
                BizProcInfo bizProcInfo = new BizProcInfo();
                bizProcInfo.setBizFunction(funcDef.getName());
                bizProcInfo.setBizPackage(funcDef.getPackageName());
                bizProcInfo.setBizOperation(funcDef.getOperation());
                bizProcInfo.setPerformerId(participant.getParticipantValue());
                bizProcInfo.setProcDefId(processDef.getID());
                bizProcInfo.setProcStartActDefId(actDef.getID());
                bizProcInfo.setInheritParentProcess(false);
                bizProcInfo.setPerformerType(this.getPerformerType(participant.getParticipantType(), bizProcInfo));
                bizProcInfo.setProcPriority(processDef.getProcessHeader().getPriority());
                bizProcInfo.setBillBosType(billBostype);
                this.setManpowerOrgProp(bizProcInfo, participant);
                bizProcInfo.setStartCondition(conditions.get(0)[0]);
                bizProcInfo.setApplierPropName(conditions.get(0)[1]);
                bizProcInfo.setStartRoleInclude(conditions.get(0)[2]);
                bizProcInfo.setStartRoleId(conditions.get(0)[3]);
                bizProcInfo.setIsFromRole(Integer.parseInt(conditions.get(0)[4]));
                bizProcInfo.setOrgPropName(conditions.get(1)[0]);
                bizProcInfo.setOrgStartRoleInclude(conditions.get(1)[1]);
                bizProcInfo.setOrgStartRoleId(conditions.get(1)[2]);
                bizProcInfo.setOrgPropIsFromRole(Integer.parseInt(conditions.get(1)[3]));
                map.put(participant.getUniqueID(), bizProcInfo);
            }
            if (!exceptList.isEmpty()) {
                for (ParticipantDef exceptParticipant : exceptList) {
                    String exceptRefID = exceptParticipant.getExceptFormRef();
                    if (map.containsKey(exceptRefID)) {
                        BizProcInfo bizProcInfo = (BizProcInfo)map.get(exceptRefID);
                        bizProcInfo.setExceptPerformerID(exceptParticipant.getParticipantValue());
                        bizProcInfo.setExceptPerformerType(this.getPerformerType(exceptParticipant.getParticipantType(), bizProcInfo));
                        continue;
                    }
                    log.error((Object)("the include participant is not found, include participant id is:" + exceptRefID + " , the except participant id is:" + exceptParticipant.getID()));
                }
            }
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                this.setBizProcRelation((BizProcInfo)map.get(it.next()));
            }
        }
    }

    private void insertSubProcBosType(String processDefID, String compareBosType) {
        try {
            String child;
            Context ctx = this.geWfEngine().context();
            String sql = "SELECT FCHILDPROCESS as child FROM t_wfd_processdef where FPROCESSID =?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{processDefID});
            if (rowSet.next() && !StringUtils.isEmpty((String)(child = rowSet.getString("child")))) {
                String[] array = child.split(";");
                StringBuffer sb = new StringBuffer();
                for (String c : array) {
                    sb.append("'").append(c).append("',");
                }
                String filter = sb.substring(0, sb.length() - 1);
                sql = "UPDATE T_wfr_procdef SET FBILLBOSTYPE=? WHERE (FBILLBOSTYPE is null or FBILLBOSTYPE='NOBOSTYPE' or FBILLBOSTYPE='63D30103') and FPROCDEFID in(" + filter + ")";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{compareBosType});
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setManpowerOrgProp(BizProcInfo bizProcInfo, ParticipantDef participant) {
        if (participant.getParticipantType() == ParticipantType.WFROLE || participant.getParticipantType() == ParticipantType.WFROLE_GROUP) {
            bizProcInfo.setManpowerOrgprop(participant.getWFROrgAttribute());
        }
    }

    private List<String[]> getStartCondition(ConditionDef tConditionDef) {
        String tStartCondtion = "";
        if (ConditionType.CONDITION.equals((Object)tConditionDef.getConditionType())) {
            if (tConditionDef.getXpressionList().size() > 0) {
                String tCondtion = tConditionDef.getXpressionList().get(0).toString();
                if (tCondtion.indexOf("processDefId") < 0) {
                    if (tCondtion.length() == 0) {
                        tStartCondtion = "NOCONDTION";
                    } else if (tCondtion.length() < 1200) {
                        tStartCondtion = tCondtion;
                    }
                }
            } else {
                tStartCondtion = "NOCONDTION";
            }
        }
        String roleId = tConditionDef.getWfRoleId();
        String includeString = "Y";
        String applierPropertyName = null;
        int isFromRole = 1;
        if (roleId != null && roleId.trim().length() > 0) {
            roleId = roleId.trim();
            String isCludeStr = tConditionDef.getIsInclude();
            if (isCludeStr != null && isCludeStr.trim().length() > 0 && isCludeStr.trim().equalsIgnoreCase("false")) {
                includeString = "N";
            }
            applierPropertyName = tConditionDef.getWfrAppl();
            isFromRole = tConditionDef.isFromRole() ? 1 : 0;
        }
        String orgRoleId = tConditionDef.getOrgWfRoleId();
        String orgIncludeString = "Y";
        String orgPropertyName = null;
        int orgPropIsFromRole = 1;
        if (orgRoleId != null && orgRoleId.trim().length() > 0) {
            orgRoleId = orgRoleId.trim();
            String _include = tConditionDef.getOrgIsInclude();
            if (_include != null && _include.trim().length() > 0 && _include.trim().equalsIgnoreCase("false")) {
                orgIncludeString = "N";
            }
            orgPropertyName = tConditionDef.getWFROrgAttribute();
            orgPropIsFromRole = tConditionDef.isOrg_isFromRole() ? 1 : 0;
        }
        ArrayList<String[]> applierAndOrg = new ArrayList<String[]>();
        String[] applier = new String[]{tStartCondtion, applierPropertyName, includeString, roleId, String.valueOf(isFromRole)};
        String[] org = new String[]{orgPropertyName, orgIncludeString, orgRoleId, String.valueOf(orgPropIsFromRole)};
        applierAndOrg.add(applier);
        applierAndOrg.add(org);
        return applierAndOrg;
    }

    private String getBillBostype(FunctionDef funcDef) {
        String billBosType = null;
        MetaDataPK funcMetaPK = MetaDataPK.create((String)funcDef.getPackageName(), (String)funcDef.getName());
        FunctionObjectInfo funcObjInfo = MetaDataLoader.getFunction((Context)this.wfEngine.context(), (IMetaDataPK)funcMetaPK);
        if (funcObjInfo != null && funcObjInfo.getOperation() != null && funcObjInfo.getOperation().size() > 0) {
            int size = funcObjInfo.getOperation().size();
            for (int indexI = 0; indexI < size; ++indexI) {
                OperationInfo operInfo = funcObjInfo.getOperation().get(indexI);
                if (!operInfo.getName().equals(funcDef.getOperation()) || operInfo.getEntityObjectRef() == null) continue;
                EntityObjectInfo entityObjectInfo = operInfo.getEntityObjectRef();
                try {
                    Class infoClass = entityObjectInfo.getObjectValueClazzRuntime();
                    IObjectValue objectInfo = null;
                    try {
                        objectInfo = (IObjectValue)infoClass.newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if ("com.kingdee.eas.ep.CoreBillBaseCustomInfo".equals(infoClass.getName()) || entityObjectInfo.isDynamic() && objectInfo != null && objectInfo instanceof ICommonBOSType) {
                        billBosType = entityObjectInfo.getType().toString();
                        break;
                    }
                    IObjectValue objectValue = (IObjectValue)infoClass.newInstance();
                    billBosType = objectValue.getBOSType().toString();
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
                break;
            }
        }
        return billBosType;
    }

    private PerformerType getPerformerType(ParticipantType type, BizProcInfo bizProcInfo) throws WfException {
        if (type.equals((Object)ParticipantType.HUMAN)) {
            return PerformerType.EMPLOYEE;
        }
        if (type.equals((Object)ParticipantType.POSITION)) {
            return PerformerType.POSITION;
        }
        if (type.equals((Object)ParticipantType.ORGANIZATIONAL_UNIT_ALLMEMBER)) {
            return PerformerType.ORG_UNIT;
        }
        if (type.equals((Object)ParticipantType.ORGANIZATIONAL_UNIT_MEMBER)) {
            return PerformerType.ORG_UNIT;
        }
        if (type.equals((Object)ParticipantType.ROLE)) {
            return PerformerType.ROLE;
        }
        if (type.equals((Object)ParticipantType.ALL)) {
            return PerformerType.ALL;
        }
        if (type.equals((Object)ParticipantType.ORGANIZATIONAL_UNIT_PRINCIPAL)) {
            return PerformerType.ORG_UNIT_PRINCIPAL;
        }
        if (type.equals((Object)ParticipantType.ORGANIZATIONAL_UNIT_PERMISSION_OWNER)) {
            return PerformerType.PERMISION_OWNNER;
        }
        if (type.equals((Object)ParticipantType.ORGANIZATIONAL_UNIT_JOB)) {
            return PerformerType.ORG_UNIT_JOB;
        }
        if (type.equals((Object)ParticipantType.GROUP)) {
            return PerformerType.GROUP;
        }
        if (type.equals((Object)ParticipantType.ORGANIZATIONAL_UNIT_SCOPE)) {
            return PerformerType.ORGANIZATIONAL_UNIT_SCOPE;
        }
        if (type.equals((Object)ParticipantType.RELATION)) {
            log.warn((Object)("Process starte activity participant is relation" + bizProcInfo.getProcDefId()));
            return null;
        }
        if (type.equals((Object)ParticipantType.VARIANT)) {
            log.warn((Object)("Process starte activity participant is relation" + bizProcInfo.getProcDefId()));
            return null;
        }
        if (type.equals((Object)ParticipantType.PROCESS_EXECUTOR)) {
            return PerformerType.EMPLOYEE;
        }
        if (type.equals((Object)ParticipantType.WFROLE)) {
            return PerformerType.WFROLRE;
        }
        if (type.equals((Object)ParticipantType.WFROLE_GROUP)) {
            return PerformerType.WFROLRE_GROUP;
        }
        if (ParticipantType.USER.equals((Object)type)) {
            return PerformerType.USER;
        }
        throw new WfException("WFE_PAR_noSupport", null, null).addArg(type.toString());
    }

    private BizProcInfo[] findProcDef(String performerEmployeeId, PerformerType performerType, String function, String packageName, String operation, Map procRelationMap) throws WfException {
        ArrayList bizProcInfoList = new ArrayList();
        ArrayList bizProcInfos = (ArrayList)procRelationMap.get(performerEmployeeId);
        if (bizProcInfos != null) {
            if (!this.wfLogger.checkLogLevel(LogTypeEnum.INFO)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Find ");
                buffer.append(bizProcInfos.size());
                buffer.append(" HUMAN's processdef!");
                String message = buffer.toString();
                this.wfLogger.addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.FINDPROCESSDEF, "", message);
            }
            for (int i = 0; i < bizProcInfos.size(); ++i) {
                bizProcInfoList.add(bizProcInfos.get(i));
            }
            procRelationMap.remove(performerEmployeeId);
        }
        IParticipantProvider participantProvider = this.wfEngine.getPariticipantProvider();
        if (performerType.equals((Object)PerformerType.EMPLOYEE)) {
            boolean hasGroupBizProc;
            boolean hasOrgBizProc;
            boolean hasJobBizProc;
            long end;
            long start = System.currentTimeMillis();
            boolean hasPosBizProc = this.isBizMatched(procRelationMap, PerformerType.POSITION);
            if (hasPosBizProc) {
                PositionInfo[] positionArray = participantProvider.getPositionArrayByEmployeeId(this.geWfEngine().context(), performerEmployeeId);
                end = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("get position cost : " + (end - start)));
                    log.debug((Object)("get position cost : " + (end - start) + ", positionArray's length : " + positionArray.length));
                }
                for (int i = 0; i < positionArray.length; ++i) {
                    BizProcInfo[] bizProcArray = this.findProcDef(positionArray[i].getId(), PerformerType.POSITION, function, packageName, operation, procRelationMap);
                    for (int j = 0; j < bizProcArray.length; ++j) {
                        bizProcInfoList.add(bizProcArray[j]);
                    }
                }
                end = System.currentTimeMillis();
                log.debug((Object)("find position's process cost : " + (end - start)));
                log.debug((Object)("find position's process cost : " + (end - start)));
            }
            if (hasJobBizProc = this.isBizMatched(procRelationMap, PerformerType.ORG_UNIT_JOB)) {
                JobInfo[] jobArray = participantProvider.getJobArrayByEmployeeId(this.geWfEngine().context(), performerEmployeeId);
                end = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("get Job cost : " + (end - start)));
                    log.debug((Object)("get Job cost : " + (end - start) + ", jobArray's length : " + jobArray.length));
                }
                if (jobArray != null) {
                    for (int i = 0; i < jobArray.length; ++i) {
                        BizProcInfo[] bizProcArray = this.findProcDef(jobArray[i].getId(), PerformerType.ORG_UNIT_JOB, function, packageName, operation, procRelationMap);
                        for (int j = 0; j < bizProcArray.length; ++j) {
                            bizProcInfoList.add(bizProcArray[j]);
                        }
                    }
                }
                end = System.currentTimeMillis();
                log.debug((Object)("find position's process cost : " + (end - start)));
                log.debug((Object)("find position's process cost : " + (end - start)));
            }
            if (bizProcInfoList.size() == 0) {
                // empty if block
            }
            if (hasOrgBizProc = this.isBizMatched(procRelationMap, PerformerType.ORG_UNIT)) {
                start = System.currentTimeMillis();
                OrgUnitInfo[] orgArray = participantProvider.getOrgUnitArrayByEmployeeId(this.geWfEngine().context(), performerEmployeeId);
                if (orgArray == null) {
                    orgArray = new OrgUnitInfo[]{};
                }
                end = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("get organization cost : " + (end - start)));
                    log.debug((Object)("get organization cost : " + (end - start) + ", orgArray's length : " + (orgArray != null ? orgArray.length + "" : " null ")));
                }
                if (orgArray != null) {
                    for (int i = 0; i < orgArray.length; ++i) {
                        BizProcInfo[] bizProcArray = this.findProcDef(orgArray[i].getId(), PerformerType.ORG_UNIT, function, packageName, operation, procRelationMap);
                        for (int j = 0; j < bizProcArray.length; ++j) {
                            bizProcInfoList.add(bizProcArray[j]);
                        }
                    }
                }
                end = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("find organization's process cost : " + (end - start)));
                    log.debug((Object)("find organization's process cost : " + (end - start)));
                }
            }
            if (hasGroupBizProc = this.isBizMatched(procRelationMap, PerformerType.GROUP)) {
                Group[] groupArray = participantProvider.getGroupArrayByEmployeeId(this.geWfEngine().context(), performerEmployeeId);
                end = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("get Group cost : " + (end - start) + ", GroupArray's length : " + groupArray.length));
                }
                if (groupArray != null) {
                    for (int i = 0; i < groupArray.length; ++i) {
                        BizProcInfo[] bizProcArray = this.findProcDef(groupArray[i].getGroupId(), PerformerType.GROUP, function, packageName, operation, procRelationMap);
                        for (int j = 0; j < bizProcArray.length; ++j) {
                            bizProcInfoList.add(bizProcArray[j]);
                        }
                    }
                }
                end = System.currentTimeMillis();
                log.debug((Object)("find group's process cost : " + (end - start)));
            }
            this.dealWfRoleType(this.geWfEngine().context(), bizProcInfoList, procRelationMap, performerEmployeeId);
        } else if (!(performerType.equals((Object)PerformerType.POSITION) || performerType.equals((Object)PerformerType.ORG_UNIT) || performerType.equals((Object)PerformerType.ALL))) {
            log.error((Object)("findProcDef error:  performerType[" + performerType.getAlias() + "] not support!"));
        }
        if (performerType.equals((Object)PerformerType.EMPLOYEE)) {
            for (ArrayList bizs : procRelationMap.values()) {
                if (bizs == null) continue;
                for (int i = 0; i < bizs.size(); ++i) {
                    BizProcInfo bizProcInfo = (BizProcInfo)bizs.get(i);
                    if (!bizProcInfo.getPerformerType().equals((Object)PerformerType.ALL)) continue;
                    bizProcInfoList.add(bizProcInfo);
                }
            }
        }
        BizProcInfo[] rtnArray = new BizProcInfo[bizProcInfoList.size()];
        bizProcInfoList.toArray(rtnArray);
        return rtnArray;
    }

    private boolean isBizMatched(Map procRelationMap, PerformerType perfromerType) {
        boolean hasBizProc = false;
        block0: for (ArrayList bizProcInfos : procRelationMap.values()) {
            for (int i = 0; i < bizProcInfos.size(); ++i) {
                BizProcInfo bizProcInfo = (BizProcInfo)bizProcInfos.get(i);
                if (!bizProcInfo.getPerformerType().equals((Object)perfromerType)) continue;
                hasBizProc = true;
                continue block0;
            }
        }
        return hasBizProc;
    }

    private void dealWfRoleType(Context ctx, ArrayList bizProcInfoList, Map procRelationMap, String performerEmployeeId) {
        Object value = ThreadCache.get("OBJECT_VALUE");
        Object ID = null;
        if (value == null) {
            ID = ThreadCache.get("OBJECT_ID");
        }
        for (ArrayList bizProcInfos : procRelationMap.values()) {
            for (int i = 0; i < bizProcInfos.size(); ++i) {
                boolean isRoleGroup;
                BizProcInfo bizProcInfo = (BizProcInfo)bizProcInfos.get(i);
                PerformerType ptype = bizProcInfo.getPerformerType();
                if (ptype != PerformerType.WFROLRE && ptype != PerformerType.WFROLRE_GROUP) continue;
                boolean bl = isRoleGroup = ptype == PerformerType.WFROLRE_GROUP;
                if (value != null) {
                    WfRoleAdapter roleAdapter = new WfRoleAdapter();
                    try {
                        List persons = roleAdapter.getRolePersons(ctx, bizProcInfo.getPerformerId(), (IObjectValue)value, bizProcInfo.getManpowerOrgprop(), isRoleGroup);
                        if (!this.isInPersonList(performerEmployeeId, persons)) continue;
                        bizProcInfoList.add(bizProcInfo);
                    }
                    catch (Exception e) {
                        log.error((Object)"DefaultBizProcFinder.dealWfRoleType error", (Throwable)e);
                    }
                    continue;
                }
                if (ID == null) continue;
                try {
                    List<Person> persons = this.getWfRolePersonsBybillId(ctx, ID, bizProcInfo, isRoleGroup);
                    if (!this.isInPersonList(performerEmployeeId, persons)) continue;
                    bizProcInfoList.add(bizProcInfo);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"DefaultBizProcFinder.dealWfRoleType error", (Throwable)e);
                }
            }
        }
    }

    private List<Person> getWfRolePersonsBybillId(Context ctx, Object ID, BizProcInfo bizProcInfo, boolean isRoleGroup) throws WfException {
        if (isRoleGroup) {
            return WfRoleInvoke.getInstance().getRoleGroupPersons(ctx, bizProcInfo.getPerformerId(), (String)ID, bizProcInfo.getManpowerOrgprop());
        }
        return WfRoleInvoke.getInstance().getRolePersons(ctx, bizProcInfo.getPerformerId(), (String)ID, bizProcInfo.getManpowerOrgprop());
    }

    private boolean isInPersonList(String personId, List<Person> persons) {
        if (persons == null) {
            return false;
        }
        for (Person person : persons) {
            if (!personId.equals(person.getEmployeeId())) continue;
            return true;
        }
        return false;
    }

    private Vector findProcDefReleatedParentORG(String orgID, Vector bizProcInfoVector) throws WfException {
        if (orgID == null || orgID.length() == 0 || bizProcInfoVector == null) {
            throw new IllegalArgumentException();
        }
        Vector<BizProcInfo> returnValue = new Vector<BizProcInfo>();
        IParticipantProvider participantProvider = this.wfEngine.getPariticipantProvider();
        OrgUnitInfo parentOrgUnit = participantProvider.getParentOrgUnit(this.geWfEngine().context(), orgID);
        if (parentOrgUnit != null) {
            String parentOrgID = parentOrgUnit.getId();
            int size = bizProcInfoVector.size();
            for (int i = size - 1; i >= 0; --i) {
                BizProcInfo bzProcInfo = (BizProcInfo)bizProcInfoVector.get(i);
                if (!bzProcInfo.getPerformerId().equalsIgnoreCase(parentOrgID)) continue;
                returnValue.add(bzProcInfo);
            }
            Vector procDefReleatedPPORG = this.findProcDefReleatedParentORG(parentOrgID, bizProcInfoVector);
            returnValue.addAll(procDefReleatedPPORG);
        }
        return returnValue;
    }

    private Vector findProcDefReleatedORG(String performerUserId, Vector bizProcInfoVector) throws WfException {
        if (performerUserId == null || performerUserId.length() == 0 || bizProcInfoVector == null) {
            throw new IllegalArgumentException();
        }
        Vector<BizProcInfo> returnValue = new Vector<BizProcInfo>();
        IParticipantProvider participantProvider = this.wfEngine.getPariticipantProvider();
        OrgUnitInfo[] orgArray = participantProvider.getOrgUnitArrayByEmployeeId(this.geWfEngine().context(), performerUserId);
        if (orgArray != null && orgArray.length > 0) {
            for (int i = 0; i <= orgArray.length - 1; ++i) {
                OrgUnitInfo orgUnitInfo = orgArray[i];
                String orgID = orgUnitInfo.getId();
                int size = bizProcInfoVector.size();
                for (int j = size - 1; j >= 0; --j) {
                    BizProcInfo bpi = (BizProcInfo)bizProcInfoVector.get(j);
                    if (!bpi.getPerformerId().equalsIgnoreCase(orgID)) continue;
                    returnValue.add(bpi);
                    bizProcInfoVector.remove(bpi);
                }
                Vector procDefReleatedParentORG = this.findProcDefReleatedParentORG(orgID, bizProcInfoVector);
                returnValue.addAll(procDefReleatedParentORG);
            }
        }
        return returnValue;
    }

    private Vector findProcDefReleatedPosition(String performerUserId, Vector bizProcInfoVector) throws WfException {
        if (performerUserId == null || performerUserId.length() == 0 || bizProcInfoVector == null) {
            throw new IllegalArgumentException();
        }
        Vector<BizProcInfo> returnValue = new Vector<BizProcInfo>();
        IParticipantProvider participantProvider = this.wfEngine.getPariticipantProvider();
        PositionInfo[] positionArray = participantProvider.getPositionArrayByEmployeeId(this.geWfEngine().context(), performerUserId);
        for (int i = 0; i < positionArray.length; ++i) {
            PositionInfo positionInfo = positionArray[i];
            String positionInfoID = positionInfo.getId();
            int size = bizProcInfoVector.size();
            for (int j = size - 1; j >= 0; --j) {
                BizProcInfo bpi = (BizProcInfo)bizProcInfoVector.get(j);
                if (!bpi.getPerformerId().equalsIgnoreCase(positionInfoID)) continue;
                returnValue.add(bpi);
                bizProcInfoVector.remove(bpi);
            }
        }
        return returnValue;
    }

    private boolean haveProcDefReleatedPosition(Vector bizProcInfoVector) {
        if (bizProcInfoVector == null) {
            throw new IllegalArgumentException();
        }
        boolean hasPosBizProc = false;
        for (BizProcInfo bizProcInfo : bizProcInfoVector) {
            if (bizProcInfo.getPerformerType() == null || !bizProcInfo.getPerformerType().equals((Object)PerformerType.POSITION)) continue;
            hasPosBizProc = true;
            break;
        }
        return hasPosBizProc;
    }

    private boolean haveProcDefReleatedORG(Vector bizProcInfoVector) {
        if (bizProcInfoVector == null) {
            throw new IllegalArgumentException();
        }
        boolean hasOrgBizProc = false;
        for (BizProcInfo bizProcInfo : bizProcInfoVector) {
            if (!bizProcInfo.getPerformerType().equals((Object)PerformerType.ORG_UNIT) && !bizProcInfo.getPerformerType().equals((Object)PerformerType.ORGANIZATIONAL_UNIT_SCOPE)) continue;
            hasOrgBizProc = true;
            break;
        }
        return hasOrgBizProc;
    }
}

