/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.biz;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.metadata.event.EventMethodInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.service.AbstractServiceAdapter;
import com.kingdee.bos.service.CannotCreateServiceManagerException;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.BizEventMap;
import com.kingdee.bos.workflow.biz.EventUtils;
import com.kingdee.bos.workflow.biz.WfBizEvent;
import com.kingdee.bos.workflow.biz.WfBizEventListenerHelper;
import com.kingdee.bos.workflow.biz.WfDirectCreateProcessEvent;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.engine.core.thread.WfOtherSysHandler;
import com.kingdee.bos.workflow.exception.AwaitingProcessInstanceException;
import com.kingdee.bos.workflow.history.HistoryHandler;
import com.kingdee.bos.workflow.metas.IOtherSysTask;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.OtherSysTaskFactory;
import com.kingdee.bos.workflow.metas.OtherSysTaskInfo;
import com.kingdee.bos.workflow.metas.WfEngineEventEnum;
import com.kingdee.bos.workflow.service.DynamicActDef;
import com.kingdee.bos.workflow.service.DynamicWfCfg;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.transaction.WfTxContext;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;

public final class WfBizEventListener
extends AbstractServiceAdapter {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.biz.WfBizEventListener");
    private static final String WORKFLOW_SERVICE = "WORKFLOW_BIZEVENT";
    private static final int WORKFLOW_PRIORITY = 1;
    public static volatile boolean checkLicense = false;

    public int getPriority() {
        return 1;
    }

    public String getName() {
        return WORKFLOW_SERVICE;
    }

    private void logServiceState() {
        try {
            if (WfTxContext.current() == null && logger.isDebugEnabled()) {
                logger.debug((Object)("WfEventListenerStateManager.getInstance().isEnable():false \nThe thread:" + Thread.currentThread().getName() + "\nStack:" + StringUtils.stackToString((Exception)new Exception())));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void execute(IServiceContext serviceContext) throws BOSException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(((Object)((Object)this)).getClass().getName(), "execute", null);
        }
        LowTimer timer = new LowTimer();
        try {
            if (1 == serviceContext.getExecutionMode() && this.isEntityOrFacadeInvoke(serviceContext)) {
                this.executeAfter(serviceContext);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("WfBizeventListener.execute executeAfter cost:" + timer.msValue()));
                }
            }
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    private boolean isEntityOrFacadeInvoke(IServiceContext serviceContext) {
        return MetaDataTypeList.ENTITY.equals((Object)serviceContext.getMetaType()) || MetaDataTypeList.FACADE.equals((Object)serviceContext.getMetaType());
    }

    private WfBizEvent createEventByAssignemnt(IServiceContext serviceContext, BizEventMap.EventStructEntry eventStructEntry, String boId, String assignmentID, String userId) {
        WfBizEvent event = new WfBizEvent();
        event.setBoId(boId);
        event.setAssignmentId(assignmentID);
        event.setMethodReturnValue(serviceContext.getMethodReturnValue());
        if (!StringUtils.isEmpty((String)userId)) {
            event.setUserId(userId);
        } else {
            event.setUserId(serviceContext.getContext().getCaller().toString());
        }
        event.setOperationName(eventStructEntry.getOperation());
        event.setFuncName(eventStructEntry.getFunction());
        event.setEventName(eventStructEntry.getEvent().getName());
        return event;
    }

    private void executeAfter(IServiceContext serviceContext) throws BOSException {
        boolean b;
        String directCreateProcessDefId;
        IObjectValue bizObject;
        String methodPK;
        Context ctx = serviceContext.getContext();
        BOSObjectType boType = serviceContext.getBoType();
        IMetaDataPK operationPK = serviceContext.getOperationPK();
        Object[] args = serviceContext.getOperationParameters();
        WfBizEventListenerHelper helper = WfBizEventListenerHelper.getHelper(serviceContext);
        helper.handleTempBizProcRelation();
        boolean isSubmit = false;
        String guessId = null;
        if (args.length >= 2 && args[0] instanceof Context && ("dfd2c083-00fa-1000-e000-001fc0a813e6".equals(methodPK = operationPK.toString()) || "a864e653-00fa-1000-e000-0001c0a813e6".equals(methodPK))) {
            guessId = EventUtils.convertPK(args[1]);
            if (!checkLicense && !(checkLicense = this.checkWfLicence())) {
                WfEngine.getEngine(ctx).getWfLogger().addWfEngineLog(LogTypeEnum.ERROR, WfEngineEventEnum.ACCEPTEVENT, "has no BPM license!, boId:" + guessId, "has no BPM license!, boId:" + guessId, null);
                return;
            }
            isSubmit = true;
            logger.info((Object)("Submit boid:" + guessId + " botype:" + boType + " operation:" + operationPK));
            if (!WfEventListenerStateManager.getInstance().isEnable()) {
                logger.error((Object)("Shocked!!! WfEventListenerStateManager.getInstance().isEnable() = false,  boid:" + guessId));
                logger.error((Object)("BizCallMethods:\n" + WfEventListenerStateManager.getInstance().getBizCallMethods()));
                Throwable t = new Throwable();
                logger.error((Object)"Invoke Stack:", t);
                return;
            }
        }
        String logStr_pre = null;
        if (logger.isDebugEnabled()) {
            logStr_pre = "botype:" + boType + ",operation:" + operationPK + ",boid:" + guessId;
            logger.debug((Object)(logStr_pre + ",isSbumit :" + isSubmit + ",enter...."));
        }
        if (!WfEventListenerStateManager.getInstance().isEnable()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(logStr_pre + ",WfEventListenerStateManager.getInstance().isEnable() = false"));
            }
            return;
        }
        if (this.checkAndDealOtherSysCallback(args, operationPK.toString())) {
            return;
        }
        if (isSubmit && guessId != null && guessId.length() > 0 && (bizObject = this.getBizObjectFromServiceContext(serviceContext, guessId)) != null && (directCreateProcessDefId = bizObject.getExtendedProperty("workflowDirectCreateProcessDefId")) != null) {
            WfDirectCreateProcessEvent event = new WfDirectCreateProcessEvent();
            event.setBoId(guessId);
            event.setUserId(ctx.getCaller().toString());
            event.setProcDefId(directCreateProcessDefId);
            WfEngine.getEngine(ctx).putEventQueue(event);
            logger.info((Object)("success create directCreateProcessEvent in job. boid=" + event.getBoId()));
            return;
        }
        BizEventMap.EventStructEntry[] eventStructEntries = EventUtils.getMatchedEventStructEntries(ctx, boType, operationPK);
        if (eventStructEntries == null || eventStructEntries.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(logStr_pre + ",Can't find eventStructEntries"));
            }
            return;
        }
        if (eventStructEntries.length > 1) {
            String warnMsg = "EventStructEntry's length is " + eventStructEntries.length + "  ,EventStructEntry[0].function is " + eventStructEntries[0].getFunction() + " ,boId{" + guessId + "},boType{" + boType + "},operationPK{" + operationPK + "}";
            WfEngine.getEngine(ctx).getWfLogger().addWfEngineLog(LogTypeEnum.WARN, WfEngineEventEnum.ACCEPTEVENT, warnMsg, null);
        }
        EventInfo eventInfo = eventStructEntries[0].getEvent();
        EventMethodInfo eventMethod = null;
        if (eventInfo != null && eventInfo.getEventMethods() != null) {
            eventMethod = eventInfo.getEventMethods().get(operationPK.toString());
        }
        if (eventMethod == null) {
            logger.warn((Object)("can't find event or event method. botype:" + boType + " operation:" + operationPK));
            return;
        }
        String boId = EventUtils.getBoPK(eventMethod, args);
        if (boId == null || boId.length() == 0) {
            String warnMsg = guessId + " , can't find bo id. botype:" + boType + " operation:" + operationPK;
            logger.warn((Object)warnMsg);
            WfEngine.getEngine(ctx).getWfLogger().addWfEngineLog(LogTypeEnum.WARN, WfEngineEventEnum.ACCEPTEVENT, warnMsg, null);
            return;
        }
        if (isSubmit && (b = this.checkExistRecentProcess(ctx, boId, 30))) {
            logger.error((Object)("\u5355\u636e\u6b63\u5728\u63d0\u4ea4\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002id:" + boId));
            throw new AwaitingProcessInstanceException("\u5355\u636e\u5df2\u7ecf\u5728\u63d0\u4ea4\u4e2d\uff0c\u8bf730\u79d2\u540e\u91cd\u8bd5\uff01");
        }
        IObjectValue bizObject2 = this.getBizObjectFromServiceContext(serviceContext, boId);
        String userId = null;
        if (bizObject2 != null) {
            userId = bizObject2.getExtendedProperty("sp_PersonId");
            String ignoreWf = bizObject2.getExtendedProperty("ignoreWorkflow");
            if (Boolean.valueOf(ignoreWf).booleanValue()) {
                String warnMsg = "ignore workflow by bo:" + boId;
                logger.warn((Object)warnMsg);
                WfEngine.getEngine(ctx).getWfLogger().addWfEngineLog(LogTypeEnum.WARN, WfEngineEventEnum.ACCEPTEVENT, warnMsg, null);
                return;
            }
        }
        WfBizEvent wfBizEvent = null;
        if (this.isBOBindAssignment(bizObject2)) {
            String assignmentID = bizObject2.getExtendedProperty("assignmentID");
            helper.checkAssignmentState(assignmentID);
            wfBizEvent = this.createEventByAssignemnt(serviceContext, eventStructEntries[0], boId, assignmentID, userId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(logStr_pre + ",isBOBindAssignment assignmentID:" + assignmentID));
            }
        }
        if (wfBizEvent == null) {
            wfBizEvent = helper.checkBizEvent(eventStructEntries, boId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(logStr_pre + ",wfBizEvent:" + wfBizEvent));
            }
            this.saveBizAlterInfo(isSubmit, wfBizEvent, ctx, boType, args);
        }
        if (wfBizEvent != null && bizObject2 != null) {
            helper.processDesignateNextActivityPerformer(wfBizEvent, bizObject2);
            String wfDynamicAppendCFG = bizObject2.getExtendedProperty("WFDynamicAppendCFG");
            if (!StringUtils.isEmpty((String)wfDynamicAppendCFG)) {
                List defs = JSONArray.parseArray((String)wfDynamicAppendCFG, DynamicActDef.class);
                new DynamicWfCfg(ctx).saveDynamicCfg(boId, defs);
            }
        }
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        if (StringUtils.isEmpty((String)wfBizEvent.getAssignmentId())) {
            Context userCtx = new Context((IObjectPK)new ObjectUuidPK(ctx.getCaller().toString()), ctx.getSolution(), ctx.getAIS(), ctx.getLocale());
            userCtx.put((Object)OrgType.ControlUnit, ctx.get((Object)OrgType.ControlUnit));
            userCtx.put((Object)"UserInfo", ctx.get((Object)"UserInfo"));
            userCtx.setClientHostIP(ctx.getClientHostIP());
            userCtx.setClientHostName(ctx.getClientHostName());
            wfBizEvent.getExtendProperties().put("userCtx", this.remakeContext(ctx));
            boolean isBindedProcessStartEvent = service.isBindedProcessStartEvent(wfBizEvent.getFuncName(), wfBizEvent.getOperationName());
            if (!isBindedProcessStartEvent) {
                String warnMsg = "not bind process start event, will ignore. func:" + wfBizEvent.getFuncName() + " operation:" + wfBizEvent.getOperationName();
                WfEngine.getEngine(ctx).getWfLogger().addWfEngineLog(LogTypeEnum.WARN, WfEngineEventEnum.ACCEPTEVENT, warnMsg, null);
                logger.warn((Object)warnMsg);
                return;
            }
        }
        wfBizEvent.putExtendProperty((Object)"lastRealLocale", (Object)ctx.getLocale());
        wfBizEvent.getExtendProperties().put("userCtx", this.remakeContext(ctx));
        service.putEventQueue(wfBizEvent);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(logStr_pre + ",success create wfBizEvent. wfBizEvent:" + wfBizEvent));
        }
    }

    private Context remakeContext(Context ctx) {
        try {
            Context userCtx = new Context((IObjectPK)new ObjectUuidPK(ctx.getCaller().toString()), ctx.getSolution(), ctx.getAIS(), ctx.getLocale());
            userCtx.put((Object)OrgType.ControlUnit, ctx.get((Object)OrgType.ControlUnit));
            userCtx.put((Object)"UserInfo", ctx.get((Object)"UserInfo"));
            userCtx.setClientHostIP(ctx.getClientHostIP());
            userCtx.setClientHostName(ctx.getClientHostName());
            return userCtx;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return ctx;
        }
    }

    private boolean checkAndDealOtherSysCallback(Object[] args, String methodPK) {
        if ("790afccd-e776-4c8b-8dd8-1feaf35676f0".equals(methodPK)) {
            ObjectUuidPK pk = new ObjectUuidPK((String)args[1]);
            try {
                Context ctx = (Context)args[0];
                IOtherSysTask task = OtherSysTaskFactory.getLocalInstance((Context)ctx);
                OtherSysTaskInfo model = task.getValue((IObjectPK)pk);
                WfOtherSysHandler.enqueue(ctx, model.getProcinstId(), model.getActinstId());
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private void saveBizAlterInfo(boolean isSubmit, WfBizEvent wfBizEvent, Context ctx, BOSObjectType boType, Object[] args) {
        if (isSubmit && null != wfBizEvent.getAssignmentId()) {
            try {
                HistoryHandler.saveBillHistory((Context)ctx, (CoreBaseInfo)((CoreBaseInfo)args[1]));
            }
            catch (Exception e) {
                logger.error((Object)"\u4fdd\u5b58\u5355\u636e\u4fee\u6539\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            }
        }
    }

    private IObjectValue getBizObjectFromServiceContext(IServiceContext serviceContext, String boId) {
        Object[] args = serviceContext.getOperationParameters();
        IObjectValue bizObject = null;
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            if (!(args[i] instanceof IObjectValue) || !((IObjectValue)args[i]).getBOSType().equals((Object)BOSUuid.read((String)boId).getType())) continue;
            bizObject = (IObjectValue)args[i];
            return bizObject;
        }
        return null;
    }

    private boolean isBOBindAssignment(IObjectValue objectValue) {
        return objectValue != null && objectValue.getExtendedProperty("assignmentID") != null && "isAddNew".equals(objectValue.getExtendedProperty("isAddNew"));
    }

    private boolean checkExistRecentProcess(Context ctx, String boid, int interval) throws WfException {
        String sql = "select top 1 p.fprocinstid from T_WFR_ProcInstRef r, t_wfr_procinst p where r.fprocinstid=p.fprocinstid and r.ftype=1 and p.fstate='closed.completed' and p.FPARENTPROCINSTID  is null and r.frefid=? and p.fcomletetime>? ";
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(sql);
            ps.setString(1, boid);
            Calendar cal = Calendar.getInstance();
            cal.add(13, interval * -1);
            Timestamp ts = new Timestamp(cal.getTimeInMillis());
            ps.setTimestamp(2, ts);
            rs = ps.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
        catch (Exception e) {
            throw new WfException((Throwable)e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable throwable) {}
            try {
                ps.close();
            }
            catch (Throwable throwable) {}
            try {
                cn.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private boolean checkWfLicence() throws BOSException {
        int r;
        try {
            Class<?> cls = Class.forName("com.kingdee.eas.base.license.agent.LicenseSrvFactory");
            Object srv = cls.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Method m = srv.getClass().getMethod("licenseCheck", String.class);
            r = (Integer)m.invoke(srv, "BPM");
        }
        catch (Exception e) {
            logger.error((Object)"workflow license check failed and omitted! continue ...", (Throwable)e);
            r = 4;
        }
        if (r != 1) {
            logger.error((Object)"\u6ca1\u6709\u5de5\u4f5c\u6d41\u7684license has no BPM license!");
            return false;
        }
        return true;
    }
}

