/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.biz.event;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.EventActivityDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.app.AbstractApplicationManager;
import com.kingdee.bos.workflow.enactment.app.WfApplicationManagerFactory;
import com.kingdee.bos.workflow.exception.TransactionRollbackException;
import com.kingdee.bos.workflow.transaction.ActivityRunner;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import org.apache.log4j.Logger;

public class EventActivityRunner
implements ActivityRunner {
    private static final Logger logger = Logger.getLogger(EventActivityRunner.class);
    private WfActivity innerActivityInst;
    private EventActivityDef innerActivityDef;

    public EventActivityRunner(WfActivity activityInst) {
        if (activityInst == null) {
            throw new IllegalArgumentException("activityInst");
        }
        this.innerActivityInst = activityInst;
        ActivityDef activityDef = this.innerActivityInst.getDefinition();
        if (!(activityDef instanceof EventActivityDef)) {
            throw new UnsupportedOperationException();
        }
        this.innerActivityDef = (EventActivityDef)activityDef;
    }

    @Override
    public void start() throws WfException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "start", null);
        }
        try {
            logger.debug((Object)"EventActivityRunner.start() begin!");
            this.invokeEventApp();
            logger.debug((Object)"EventActivityRunner.start() end!");
        }
        catch (TransactionRollbackException e) {
            throw e;
        }
        catch (Throwable e) {
            if (e instanceof WfException) {
                throw (WfException)e;
            }
            throw new WfException("EventActivityRunner.start() error!", e, true);
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    private void invokeEventApp() throws WfException {
        ApplicationDef applicationDef = this.innerActivityDef.getRelatedApplication();
        AbstractApplicationManager manager = WfApplicationManagerFactory.createApplicationManager(this.innerActivityInst);
        manager.invokeApplication(applicationDef, this.innerActivityDef.getActualParameters());
    }
}

