/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.bos.workflow.util.EngineConfig;
import com.kingdee.util.StringUtils;

public class BufferedAssignmentChecker {
    private static final String SEPARATOR = "_";
    private final Context ctx;

    public BufferedAssignmentChecker(Context ctx) {
        this.ctx = ctx;
    }

    public WfAssignment checkAssignmentInCache(String businessObjId, String userId, String packageName, String functionName, String operation) throws WfException {
        if (BufferedAssignmentChecker.enable(this.ctx)) {
            String identifier = BufferedAssignmentChecker.getFullIdentifier(businessObjId, userId, packageName, functionName, operation);
            WfEngine wfEngine = WfEngine.getEngine(this.ctx);
            WfAssignment assignment = wfEngine.getCacheManager().getCachedAssignment(identifier);
            if (assignment != null && (WfAssignmentState.ACCEPTED.equals((Object)assignment.getMeta().getState()) || WfAssignmentState.ASSIGNED.equals((Object)assignment.getMeta().getState()))) {
                return assignment;
            }
        }
        return null;
    }

    public WfAssignment checkAssignmentInCache(String businessObjId, String userId) throws WfException {
        return this.checkAssignmentInCache(businessObjId, userId, null, null, null);
    }

    private static String getFullIdentifier(String businessObjId, String userId, String packageName, String functionName, String operation) {
        StringBuffer buffer = new StringBuffer(200);
        buffer.append(userId).append(SEPARATOR);
        buffer.append(businessObjId).append(SEPARATOR);
        if (!StringUtils.isEmpty((String)packageName)) {
            buffer.append(packageName).append(SEPARATOR);
        }
        if (!StringUtils.isEmpty((String)functionName)) {
            buffer.append(functionName).append(SEPARATOR);
        }
        if (!StringUtils.isEmpty((String)operation)) {
            buffer.append(operation);
        }
        return buffer.toString();
    }

    public static String getFullIdentifier(AssignInfo assignInfo) {
        return BufferedAssignmentChecker.getFullIdentifier(assignInfo.getBizObjID(), assignInfo.getPersonUserID().toString(), assignInfo.getBizPackage(), assignInfo.getBizFunction(), assignInfo.getBizOperation());
    }

    public static String getSimpleIdentifier(AssignInfo assignInfo) {
        return BufferedAssignmentChecker.getFullIdentifier(assignInfo.getBizObjID(), assignInfo.getPersonUserID().toString(), null, null, null);
    }

    public static boolean enable(Context ctx) {
        if (EngineConfig.getInstance().isEnableBufferedAssignmentCheck()) {
            return ApplicationUtil.getDbType((Context)ctx) != 1;
        }
        return false;
    }
}

