/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.job.core.JobLoader;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.SubmitAssignResult;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.TimerIntermediateEventActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.define.extended.ManualDecisionActivityDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.app.DefaultApplicationManager;
import com.kingdee.bos.workflow.enactment.app.ManPowerAppManager;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.monitor.ApprovePolicy;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.transaction.WfTxHelper;
import com.kingdee.bos.workflow.transaction.WfTxInvocationDesc;
import com.kingdee.bos.workflow.util.MethodDesc;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.InputType;
import com.kingdee.eas.base.multiapprove.ManualDecisionInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.IObjectBase;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class WfBillUtil {
    private static final Logger logger = Logger.getLogger(WfBillUtil.class);
    private static final Locale L1 = new Locale("l1");
    private static final Locale L2 = new Locale("l2");
    private static final Locale L3 = new Locale("l3");

    public static void test(String uuid, String personId, Context ctx) throws Exception {
        logger.info((Object)("invoke test process : req param[ uuid: " + uuid + " personId: " + personId + " ctx: " + ctx));
        IObjectValue billByUUid = null;
        billByUUid = WfBillUtil.getBillByUUid(ctx, uuid, personId);
        logger.info((Object)billByUUid);
    }

    public static String test(String billNumber, String bostype, String personId, Context ctx) throws Exception {
        logger.info((Object)("invoke test process : req param[ uuid: " + billNumber + " bostype:" + bostype + "personId: " + personId + " ctx: " + ctx));
        IObjectValue billObject = WfBillUtil.getBillByNumberAndBostype(ctx, billNumber, bostype, personId);
        logger.info((Object)billObject);
        return billObject.getString("id");
    }

    public static IObjectValue getBillByNumberAndBostype(Context ctx, String billNumber, String bostype, String personId) throws Exception {
        CoreBaseInfo dataObj;
        IObjectBase objectBase = (IObjectBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType(bostype));
        try {
            CoreBaseCollection dataObjs = objectBase.getCollection("where number ='" + billNumber + "'");
            dataObj = dataObjs.get(0);
            if (dataObj == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new Exception("\u6839\u636e\u7f16\u53f7\u548c\u7c7b\u578b\u4e0d\u80fd\u627e\u5230\u5bf9\u5e94\u7684\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        dataObj.setExtendedProperty("CTRL_SHIFT_ALT", "true");
        dataObj.setExtendedProperty("sp_PersonId", personId);
        objectBase.submit(dataObj);
        return dataObj;
    }

    public static IObjectValue getBillByUUid(Context ctx, String uuid, String personId) throws Exception {
        BOSUuid bosuuid = BOSUuid.read((String)uuid);
        BOSObjectType type = bosuuid.getType();
        ICoreBase base = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)type);
        CoreBaseInfo dataObj = null;
        dataObj = base.getValue((IObjectPK)new ObjectUuidPK(bosuuid));
        dataObj.setExtendedProperty("CTRL_SHIFT_ALT", "true");
        dataObj.setExtendedProperty("sp_PersonId", personId);
        base.submit(dataObj);
        return dataObj;
    }

    public static void submitDecision(Context ctx, AssignmentInfo assInfo, Map decision) throws Exception {
        IEnactmentService enactService = EnactmentServiceFactory.createEnactService((Context)ctx);
        String bizPackgeName = assInfo.getBizPackage();
        String bizFunName = assInfo.getBizFunction();
        String bizOperation = assInfo.getBizOperation();
        String userID = assInfo.getUserId();
        String name = (String)decision.get("name");
        String selectedindices = (String)decision.get("selectedindices");
        String selectitems = (String)decision.get("selectitems");
        String selecteditems = (String)decision.get("selecteditems");
        String description = (String)decision.get("description");
        String selectedopinions = (String)decision.get("selectedopinions");
        String selectopinions = (String)decision.get("selectopinions");
        ManualDecisionInfo decisionInfo = new ManualDecisionInfo();
        decisionInfo.setName(name);
        decisionInfo.setSelectItemCount(1);
        decisionInfo.setSelectedIndices(selectedindices);
        decisionInfo.setSelectItems(selectitems);
        decisionInfo.setSelectedItems(selecteditems);
        decisionInfo.setDescription(description);
        decisionInfo.setSelectedOpinions(selectedopinions);
        decisionInfo.setSelectOpinions(selectopinions);
        String newId = BOSUuid.create((BOSObjectType)decisionInfo.getBOSType()).toString();
        decisionInfo.setId(BOSUuid.read((String)newId));
        HashMap<String, ManualDecisionInfo> map = new HashMap<String, ManualDecisionInfo>();
        map.put(newId, decisionInfo);
        SubmitAssignResult result = enactService.submitAssignment(map, userID, bizPackgeName, bizFunName, bizOperation, assInfo, null);
    }

    public static void submitMultiapprove(Context ctx, AssignmentInfo assign, Map approve) throws Exception {
        logger.info((Object)("invoke submitMultiapprove : req param[ assign: " + assign + " ctx: " + ctx));
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        MultiApproveInfo info = new MultiApproveInfo();
        info.setAssignment(assign.getAssignmentId());
        info.setBillId(BOSUuid.read((String)assign.getBizObjectIds()));
        info.setExtendedProperty("businuessObjectId", assign.getBizObjectIds());
        info.setExtendedProperty("assignmentID", assign.getAssignmentId());
        info.setExtendedProperty("isAddNew", "isAddNew");
        boolean isSendSMS = "true".equals(approve.get("isSendSMS"));
        boolean isSendMail = "true".equals(approve.get("isSendMail"));
        info.setIsMailNotifyNext(isSendMail);
        info.setIsMobelNotifyNext(isSendSMS);
        info.setOpinion((String)approve.get("opinion"));
        String result = (String)approve.get("approveResult");
        info.setIsPass(ApproveResult.getEnum((String)result));
        String handlerOpinion = (String)approve.get("handlerOpinion");
        info.setHandlerOpinion(Integer.parseInt(handlerOpinion));
        String handlerContent = (String)approve.get("handlerContent");
        info.setHandlerContent(handlerContent);
        info.setStatus(MultiApproveStatusEnum.SUBMIT);
        info.setExtendedProperty("sp_PersonId", assign.getUserId());
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)assign.getUserId()));
        info.setCreator(userInfo);
        info.setLastUpdateUser(userInfo);
        info.setInputType(InputType.PROC_CENTER);
        MultiApproveFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)info);
    }

    public static void submitEventTime(Context ctx, String procInstId) throws Exception {
        String title = "~EventTimer:" + procInstId;
        String sql = "update t_job_inst set fscheduledtime=? where ftitle = ?";
        int[] types = new int[]{93, 12};
        Object[] params = new Object[]{new Timestamp(System.currentTimeMillis() - 60000L), title};
        SQL.executeUpdate((Context)ctx, (String)sql, (int[])types, (Object[])params);
        JobLoader.newJobEnqueued((Context)ctx);
    }

    public static ActivityInstInfo getActivityInst(Context ctx, String actInstId) throws Exception {
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        return svc.getActivityInstByActInstId(actInstId);
    }

    private static List getDecisionItems(String decisions, Context ctx) {
        ArrayList<ApprovePolicy> decisionItems = new ArrayList<ApprovePolicy>();
        int agrees = 0;
        int disagrees = 0;
        String[] items = StringUtils.split((String)decisions, (String)":");
        for (int i = 0; i < items.length; ++i) {
            String line;
            String[] itemRow = StringUtils.split((String)items[i], (String)";");
            String key = itemRow[0];
            String text = itemRow[1];
            String type = itemRow.length == 2 ? "\u5168\u90e8" : itemRow[2];
            String string = line = itemRow.length < 4 ? "" : itemRow[3];
            if ("agree".equalsIgnoreCase(type) || type.equals("\u540c\u610f")) {
                decisionItems.add(WfBillUtil.toMap(key, text, "true", "\u540c\u610f", line, false, ctx));
                ++agrees;
                continue;
            }
            if ("disagree".equalsIgnoreCase(type) || type.equals("\u4e0d\u540c\u610f")) {
                decisionItems.add(WfBillUtil.toMap(key, text, "false", "\u4e0d\u540c\u610f", line, false, ctx));
                ++disagrees;
                continue;
            }
            if (!"all".equalsIgnoreCase(type) && !type.equals("\u5168\u90e8")) continue;
            decisionItems.add(WfBillUtil.toMap(key, text, "true", "\u540c\u610f", line, true, ctx));
            ++agrees;
            decisionItems.add(WfBillUtil.toMap(key, text, "false", "\u4e0d\u540c\u610f", line, true, ctx));
            ++disagrees;
        }
        if (agrees + disagrees > 0 && agrees * disagrees == 0) {
            if (agrees == 0) {
                decisionItems.add(WfBillUtil.toMap("0", "", "true", "\u540c\u610f", "", true, ctx));
            } else if (disagrees == 0) {
                decisionItems.add(WfBillUtil.toMap("0", "", "false", "\u4e0d\u540c\u610f", "", true, ctx));
            }
        }
        return decisionItems;
    }

    private static ApprovePolicy toMap(String key, String text, String result, String title, String associatedLine, boolean isAll, Context ctx) {
        if (L1.equals(ctx.getLocale())) {
            if ("\u540c\u610f".equals(title)) {
                title = "Agree";
            } else if ("\u4e0d\u540c\u610f".equals(title)) {
                title = "Disagree";
            } else if ("\u65e0".equals(title)) {
                title = "All";
            }
        } else if (L3.equals(ctx.getLocale())) {
            if ("\u540c\u610f".equals(title)) {
                title = "\u901a\u904e";
            } else if ("\u4e0d\u540c\u610f".equals(title)) {
                title = "\u4e0d\u901a\u904e";
            }
        }
        if (L1.equals(ctx.getLocale())) {
            if (!"none".equalsIgnoreCase(text) && text != null && text.length() > 0) {
                title = title + ", " + text;
            }
        } else if (!"\u65e0".equals(text) && text != null && text.length() > 0) {
            title = title + "\uff0c" + text;
        }
        return new ApprovePolicy(result, key, text, title, associatedLine);
    }

    public static String getApproveDecision(Context ctx, String actInstId) throws Exception {
        WfEngine engine = WfEngine.getEngine(ctx);
        WfActivity activityInst = engine.getActivityInst(actInstId);
        ActivityDef actDef = activityInst.getDefinition();
        String decisions = "";
        if (actDef instanceof ApproveActivityDef && StringUtils.isEmpty((String)(decisions = ((ApproveActivityDef)actDef).getManualDecisionItems(ctx.getLocale()))) && StringUtils.isEmpty((String)(decisions = ((ApproveActivityDef)actDef).getManualDecisionItems()))) {
            decisions = ((ApproveActivityDef)actDef).getManualDecisionItems(L2);
        }
        ExtendedAttributeCollection eac = actDef.getActivityHeader().getExtendedAttributes();
        ExtendedAttributeDef ead = null;
        if (StringUtils.isEmpty((String)decisions)) {
            ead = eac.get("manualDecisionItems");
            decisions = ead != null ? ead.getValue() : null;
        }
        List decisionItems = WfBillUtil.getDecisionItems(decisions, ctx);
        return JSON.toJSONString((Object)decisionItems);
    }

    public static String getManualDesc(Context ctx, String actInstId) throws Exception {
        WfEngine engine = WfEngine.getEngine(ctx);
        WfActivity activityInst = engine.getActivityInst(actInstId);
        ActivityDef actDef = activityInst.getDefinition();
        String decisions = "";
        if (actDef instanceof ManualDecisionActivityDef) {
            ManpowerActivityDef manpowerActivityDef = (ManpowerActivityDef)actDef;
            Map parameterMap = DefaultApplicationManager.getParameterMap(activityInst, activityInst.container().getProcessContext(), manpowerActivityDef.getActualParameters(), manpowerActivityDef.getRelatedApplication().getFormalParameters(), true);
            ArrayList argList = DefaultApplicationManager.getInvokeArgs(activityInst, manpowerActivityDef.getActualParameters(), manpowerActivityDef.getRelatedApplication().getFormalParameters(), parameterMap, true);
            Map args = DefaultApplicationManager.getInvokeArgs(argList, manpowerActivityDef.getRelatedApplication().getFormalParameters());
            decisions = JSON.toJSONString((Object)args);
        }
        return decisions;
    }

    public static void submitActInst(Context ctx, String actInstId, Map params) throws Exception {
        logger.info((Object)("invoke submitActInst : req param[ actInstId: " + actInstId + " params: " + params + " ctx: " + ctx));
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        ActivityInstInfo activityInst = svc.getActivityInstByActInstId(actInstId);
        if (activityInst != null && "open.not_running.not_started".equals(activityInst.getState())) {
            ActivityDef actDef = svc.getActDefByActInstInfo(activityInst);
            if (actDef instanceof ApproveActivityDef) {
                AssignmentInfo[] assignments = svc.getAssignmentByActInstId(actInstId, WfAssignmentState.ASSIGNED);
                AssignmentInfo assignment = assignments[0];
                String desc = WfBillUtil.getApproveDecision(ctx, actInstId);
                WfBillUtil.submitMultiapprove(ctx, assignment, params);
            } else if (actDef instanceof ManualDecisionActivityDef) {
                AssignmentInfo[] assignments = svc.getAssignmentByActInstId(actInstId, WfAssignmentState.ASSIGNED);
                AssignmentInfo assignment = assignments[0];
                String desc = WfBillUtil.getManualDesc(ctx, actInstId);
                WfBillUtil.submitDecision(ctx, assignment, params);
            } else if (actDef instanceof TimerIntermediateEventActivityDef) {
                WfBillUtil.submitEventTime(ctx, activityInst.getProcInstId());
            } else if (actDef instanceof ManpowerActivityDef) {
                AssignmentInfo[] assignments = svc.getAssignmentByActInstId(actInstId, WfAssignmentState.ASSIGNED);
                AssignmentInfo assignment = assignments[0];
                WfEngine engine = WfEngine.getEngine(ctx);
                WfActivity activityInst1 = engine.getActivityInst(actInstId);
                ManpowerActivityDef manpowerActivityDef = (ManpowerActivityDef)actDef;
                ManPowerAppManager manPowerAppManager = new ManPowerAppManager(activityInst1, assignment);
                Class<ManPowerAppManager> classCaller = ManPowerAppManager.class;
                ManPowerAppManager obj = manPowerAppManager;
                String methodName = "invokeApplication";
                Class[] parameterTypes = new Class[]{ApplicationDef.class, ActualParameterCollection.class};
                Object[] args = new Object[]{manpowerActivityDef.getRelatedApplication(), manpowerActivityDef.getActualParameters()};
                MethodDesc methodDesc = new MethodDesc(classCaller, methodName, parameterTypes);
                WfTxInvocationDesc invocationDesc = new WfTxInvocationDesc(methodDesc, obj, args);
                Object object = WfTxHelper.invokeSupports(ctx, invocationDesc);
            }
        } else {
            throw new Exception("\u5b9e\u4f8b\u72b6\u6001\u4e0d\u662f\u672a\u5f00\u59cb\u72b6\u6001");
        }
    }

    public static List getSubFLowProcInstIds(Context ctx, String procInstId) {
        String sql = "select FPROCINSTID  from t_wfr_procinst where FPARENTPROCINSTID = ?";
        ArrayList list = new ArrayList();
        try {
            ArrayList result = SQL.executeQuery((Context)ctx, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{procInstId});
            for (int i = 0; i < result.size(); ++i) {
                Map map = (Map)result.get(i);
                list.add(map.get("fprocinstid"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return list;
    }
}

