/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataFieldCollection;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.EventPolicyCollection;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ProcessEvent;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.thread.RepairSchedulerDataPolicy;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.event.WfEventPolicy;
import com.kingdee.bos.workflow.exception.CannotDeleteException;
import com.kingdee.bos.workflow.exception.InvalidRequesterException;
import com.kingdee.bos.workflow.exception.NotEnabledException;
import com.kingdee.bos.workflow.exception.RequesterRequired;
import com.kingdee.bos.workflow.exception.WfExpiredException;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.ProcInstDataInfo;
import com.kingdee.bos.workflow.metas.ProcInstInfo;
import com.kingdee.bos.workflow.metas.ProcessInstEventEnum;
import com.kingdee.bos.workflow.metas.WfEngineEventEnum;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.store.DataFieldStorer;
import com.kingdee.bos.workflow.store.ProcessStorer;
import com.kingdee.bos.workflow.store.StoreManager;
import com.kingdee.bos.workflow.store.util.RelevantDatas;
import com.kingdee.bos.workflow.transaction.SnapshotRecorder;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.bos.workflow.util.WfBizObjUtils;
import com.kingdee.bos.workflow.util.WorkflowUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.exception.ExceptionMessage;
import com.kingdee.exception.ExceptionUtil;
import com.kingdee.exception.IExceptionInfoSupport;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.marshal.ExternalizeDelegate;
import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class WfProcessMgr
implements IMarshalObject {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.enactment.WfProcessMgr");
    private WfEngine engine;
    private ProcessDef procDef;
    private ProcessDefInfo procDefMeta;
    private int innerVersion;
    private Map contextSignature = new Hashtable();
    private Map resultSignature = new Hashtable();
    List eventPolicyIdList = new LinkedList();

    public WfProcessMgr() {
    }

    public WfProcessMgr(WfEngine engine, ProcessDefInfo procDefMeta) throws WfException {
        if (engine == null) {
            String msg = "Parameter \"engine\" is null!";
            log.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        if (procDefMeta == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Fatal Error. process definition not release.");
            buffer.append("EngineKey is \"" + engine.getEngineKey() + "\"!");
            String msg = buffer.toString();
            log.error((Object)msg);
            RepairSchedulerDataPolicy policy = new RepairSchedulerDataPolicy();
            policy.executePolicy(engine);
            throw new IllegalArgumentException(msg);
        }
        this.engine = engine;
        this.procDefMeta = procDefMeta;
        this.innerVersion = procDefMeta.getInnerVersion();
        this.procDef = this.engine.getProcessDef(procDefMeta.getMd5HashValue());
        this.procDef.setLocale(LocaleUtils.getLocale((String)"L2"));
        this.addProcessEventPolicy();
    }

    public WfEngine getWfEngine() {
        return this.engine;
    }

    public ProcessDefInfo getData() {
        return this.procDefMeta;
    }

    public ProcessDef getProcessDef() {
        if (this.procDef == null) {
            String hashValue = "";
            if (this.procDefMeta != null) {
                hashValue = this.procDefMeta.getMd5HashValue();
            }
            try {
                this.procDef = this.engine.getProcessDef(hashValue);
                this.procDef.setLocale(LocaleUtils.getLocale((String)"L2"));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("can not get process define by hashvalue[" + hashValue + "]");
            }
        }
        return this.procDef;
    }

    public StoreManager getStoreManager() throws WfException {
        return this.engine.getStoreManager();
    }

    public String name() throws WfException {
        if (this.getProcessDef() == null) {
            throw new WfException("process define not avialable");
        }
        return this.getProcessDef().getName();
    }

    public String description() throws WfException {
        if (this.getProcessDef() == null) {
            throw new WfException("process define not avialable");
        }
        return this.getProcessDef().getProcessHeader().getDescription();
    }

    public String category() throws WfException {
        throw new WfException("TODO");
    }

    public String version() throws WfException {
        if (this.getProcessDef() == null) {
            throw new WfException("process define not avialable");
        }
        return this.getProcessDef().getProcessHeader().getVersion();
    }

    public int getInnverVersion() {
        return this.innerVersion;
    }

    public Map contextSignature() throws WfException {
        return this.contextSignature;
    }

    public Map resultSignature() throws WfException {
        return this.resultSignature;
    }

    private void checkExpire(WfActivity parentActInst) throws WfException {
        ProcessDef procDef = this.getProcessDef();
        Date validFrom = procDef.getProcessHeader().getValidFrom();
        Date validTo = procDef.getProcessHeader().getValidTo();
        long currentTime = System.currentTimeMillis();
        if (validFrom != null && validFrom.getTime() > currentTime) {
            WfException exception = new WfExpiredException("WFE_SER_validTo", null, null).addArg(procDef.getNameResource().getPossibleValue(null)).addArg(procDef.getCode()).addArg(DateTimeUtils.format((Date)validFrom) + "; now-from:" + new Timestamp(currentTime).toString());
            if (parentActInst != null) {
                WorkflowUtils.logProcessException(parentActInst.getProcInstId(), this.getWfEngine(), exception);
            }
            throw exception;
        }
        if (validTo != null && currentTime > validTo.getTime()) {
            WfException exception = new WfExpiredException("WFE_SER_validFrom", null, null).addArg(procDef.getNameResource().getPossibleValue(null)).addArg(procDef.getCode()).addArg(DateTimeUtils.format((Date)validTo) + "; now-to:" + new Timestamp(currentTime).toString());
            ExceptionUtil.process((Throwable)exception, null);
            ExceptionMessage errMsg = ExceptionUtil.getMessages((IExceptionInfoSupport)exception);
            try {
                WfLogger wfLogger = this.getWfEngine().getWfLogger();
                wfLogger.addWfEngineLog(LogTypeEnum.WARN, WfEngineEventEnum.CREATE, errMsg.getSimple(), errMsg.getDetail());
            }
            catch (Exception ex) {
                log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            if (parentActInst != null) {
                WorkflowUtils.logProcessException(parentActInst.getProcInstId(), this.getWfEngine(), exception, ProcessInstEventEnum.EXPIRED);
            }
            throw exception;
        }
    }

    public void processProcessTopic(WfProcess procInst) throws WfException {
        SnapshotRecorder recorder = SnapshotRecorder.create();
        recorder.snapshoot((AbstractObjectValue)procInst.getData().getMeta());
        ProcessDef processDef = this.getProcessDef();
        Locale[] locales = ApplicationUtil.getContextLocales((Context)this.engine.context());
        String instTopic = null;
        for (Locale locale : locales) {
            String topic = processDef.getProcessHeader().getProcessTopic(locale);
            instTopic = !StringUtils.isEmpty((String)topic) ? this.getProcTopicString(procInst, locale, topic) : this.getProcessTopic(procInst, locale);
            if (instTopic != null && instTopic.length() >= 80) {
                instTopic = instTopic.substring(0, 79);
            }
            procInst.getData().getMeta().setProcInstTopic(instTopic, locale);
        }
        recorder.snapshoot((AbstractObjectValue)procInst.getData().getMeta());
        recorder.recordSnapshots();
    }

    public String getProcessTopic(WfProcess procInst, Locale locale) {
        StringBuffer topic = new StringBuffer();
        try {
            String parentInstId = procInst.getProcessMeta().getParentProcInstId();
            if (!StringUtils.isEmpty((String)parentInstId)) {
                return procInst.getWfEngine().getProcessInst(parentInstId).getProcessMeta().getInstTopic(locale);
            }
            String billId = procInst.getBizObjIds()[0];
            BOSUuid bosuuid = BOSUuid.read((String)billId);
            BOSObjectType type = bosuuid.getType();
            ICoreBase base = (ICoreBase)BOSObjectFactory.createBOSObject((Context)this.engine.context(), (BOSObjectType)type);
            CoreBaseInfo dataObj = base.getValue((IObjectPK)new ObjectUuidPK(bosuuid));
            String number = dataObj.get("number").toString();
            IMetaDataLoader loaderMeta = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.engine.context());
            String billTypeName = loaderMeta.getEntity(dataObj.getBOSType()).getAlias(locale);
            Locale newLocale = LocaleUtils.getShortLocale((Locale)locale);
            String billNubmerName = "\u5355\u636e\u7f16\u53f7\uff1a";
            if (LocaleUtils.locale_l1.equals(newLocale)) {
                billNubmerName = "bill number :";
            } else if (LocaleUtils.locale_l3.equals(newLocale)) {
                billNubmerName = "\u55ae\u64da\u7de8\u865f\uff1a";
            }
            topic.append(billTypeName).append(",").append(billNubmerName).append(number);
        }
        catch (Exception e) {
            log.error((Object)"\u8f93\u51fa\u6d41\u7a0b\u5b9e\u4f8b\u51fa\u9519", (Throwable)e);
        }
        return topic.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProcTopicString(WfProcess procInst, Locale locale, String scriptString) throws WfException {
        try {
            ContextUtils.setLocaleToThread((Locale)locale);
            String bodyFormatString = this.scriptFormat(procInst, locale, scriptString);
            if (bodyFormatString.indexOf("@@") >= 0) {
                DataFieldCollection dc = procInst.getDefinition().getDataFields();
                ProcessContext context = procInst.getProcessContext();
                String[] dataFieldNames = context.getDataFieldNames();
                this.reSort(dataFieldNames);
                for (int i = 0; i < dataFieldNames.length; ++i) {
                    String dataFieldValStr;
                    DataFieldDef dfd;
                    String variableName = dataFieldNames[i];
                    if (variableName == null || variableName.trim().length() == 0 || (dfd = dc.getByName(variableName)) != null && (dfd.getDataType().equals(BasicType.BIZOBJ) || dfd.getDataType().equals(BasicType.APPROVERESULT))) continue;
                    Object dataFieldVal = context.getDataFieldValue(variableName);
                    if (dataFieldVal instanceof Date) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String s = sdf.format((Date)dataFieldVal);
                        if (s.endsWith("00:00:00")) {
                            s = s.substring(0, 10);
                        }
                        dataFieldVal = s;
                    }
                    if ((dataFieldValStr = StringUtils.cnulls((Object)dataFieldVal)) == null) {
                        dataFieldValStr = "";
                    }
                    bodyFormatString = StringUtils.replace((String)bodyFormatString, (String)("@@" + variableName), (String)dataFieldValStr);
                }
                bodyFormatString = WfBizObjUtils.replaceBizObjValue(procInst.getProcessContext(), procInst.getDefinition(), dc, bodyFormatString);
            }
            String string = bodyFormatString;
            return string;
        }
        finally {
            ContextUtils.setLocaleToThread((Locale)LocaleUtils.locale_l2);
        }
    }

    private void reSort(String[] dataFieldNames) {
        for (int i = 0; i < dataFieldNames.length; ++i) {
            for (int j = i + 1; j < dataFieldNames.length; ++j) {
                if (dataFieldNames[j].trim().length() <= dataFieldNames[i].trim().length()) continue;
                String tmpVar = dataFieldNames[i].trim();
                dataFieldNames[i] = dataFieldNames[j].trim();
                dataFieldNames[j] = tmpVar;
            }
        }
    }

    private String scriptFormat(WfProcess procInst, Locale locale, String strToFormat) throws WfException {
        if (strToFormat.indexOf("<%") != -1) {
            HashMap<String, Object> replaceMap = new HashMap<String, Object>();
            StringTokenizer token = new StringTokenizer(strToFormat, "<%");
            while (token.hasMoreTokens()) {
                Object obj;
                String temp = token.nextToken();
                if (temp.indexOf("%>") != -1) {
                    temp = temp.substring(0, temp.lastIndexOf("%>"));
                }
                if ((obj = ScriptUtil.evelScript(temp, procInst.getData(), locale, procInst.getWfEngine())) == null) continue;
                replaceMap.put(temp, obj);
            }
            for (Map.Entry entry : replaceMap.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                strToFormat = StringUtils.replace((String)strToFormat, (String)("<%" + key + "%>"), (String)value.toString());
            }
        }
        return strToFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WfProcess createProcess(WfActivity parentActInst, Person person) throws WfException, NotEnabledException, InvalidRequesterException, RequesterRequired {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "createProcess", null);
        }
        try {
            WfLogger wfLogger;
            LowTimer lowTimer = new LowTimer();
            boolean processEnable = this.getData().isEnable();
            if (!processEnable) {
                WfException exception = null;
                if (parentActInst != null) {
                    WfProcess parentProcess = parentActInst.container();
                    exception = new NotEnabledException("WFE_PROCESS_createSub_enable", null, null).addArg(parentProcess.getProcessMeta().getMeta().getProcdefName()).addArg(parentActInst.getMeta().getActInstInfo().getActDefName()).addArg(this.getProcessDef().getNameResource().getPossibleValue(null)).addArg(this.getProcessDef().getID()).addArg(this.getData().getInnerVersion() + "");
                } else {
                    exception = new NotEnabledException("WFE_PROCESS_createSub_enable", null, null).addArg("").addArg("").addArg(this.getProcessDef().getNameResource().getPossibleValue(null)).addArg(this.getProcessDef().getID()).addArg(this.getData().getInnerVersion() + "");
                }
                if (parentActInst != null) {
                    WorkflowUtils.logProcessException(parentActInst.getProcInstId(), this.getWfEngine(), exception);
                }
                throw exception;
            }
            this.checkExpire(parentActInst);
            ProcInstInfo procInstInfo = ProcessStorer.buildNewProcInstInfo(this.getWfEngine().context(), this, parentActInst, person);
            if (log.isDebugEnabled()) {
                log.debug((Object)("WfProcessMgr.createProcess() buildNewProcInstInfo cost : " + lowTimer.msValue()));
                lowTimer.reset();
            }
            SnapshotRecorder recorder = SnapshotRecorder.create();
            recorder.snapshoot((AbstractObjectValue)procInstInfo);
            recorder.recordSnapshots();
            if (log.isDebugEnabled()) {
                log.debug((Object)("WfProcessMgr.createProcess() storer.addInstance cost : " + lowTimer.msValue()));
                lowTimer.reset();
            }
            if (!(wfLogger = this.getWfEngine().getWfLogger()).checkLogLevel(LogTypeEnum.INFO)) {
                try {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("Initiator is ");
                    if (person == null) {
                        buffer.append("null");
                    } else {
                        buffer.append(person.getUserId());
                    }
                    wfLogger.addWfProcessInstLog(LogTypeEnum.INFO, ProcessInstEventEnum.CREATE, procInstInfo.getProcInstID().toString(), buffer.toString());
                }
                catch (Throwable e) {
                    log.warn((Object)"WfProcess creatProcess log error.", e);
                }
            }
            lowTimer.reset();
            WfProcessMgr procMgr = this.getWfEngine().getProcessMgr(procInstInfo.getProcdefID().toString(), procInstInfo.getProcdefVer());
            if (log.isDebugEnabled()) {
                log.debug((Object)("WfProcessMgr.createProcess() getProcessMgr() cost : " + lowTimer.msValue()));
                lowTimer.reset();
            }
            WfProcess wfProcess = new WfProcess(new ProcessInstInfo(procInstInfo), procMgr);
            ProcessContext processContext = this.createProcessContext(wfProcess);
            wfProcess.setProcessContext(processContext);
            lowTimer.reset();
            this.getWfEngine().eventService().raiseProcessEvent(ProcessEvent.OnProcessCreated, wfProcess, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("WfProcessMgr.createProcess() raiseProcessEvent cost : " + lowTimer.msValue()));
                lowTimer.reset();
            }
            this.getWfEngine().getCacheManager().addProcInst(wfProcess);
            if (log.isDebugEnabled()) {
                log.debug((Object)("WfProcessMgr.createProcess() addProcInstToCache cost : " + lowTimer.msValue()));
                lowTimer.reset();
            }
            this.getWfEngine().increaseNewProcessInstCount();
            if (log.isDebugEnabled()) {
                log.debug((Object)("WfProcessMgr.createProcess() increaseNewProcessInstCount cost : " + lowTimer.msValue()));
                lowTimer.reset();
            }
            WfProcess wfProcess2 = wfProcess;
            return wfProcess2;
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    public ProcessContext createProcessContext(WfProcess wfProcess) throws WfException {
        LowTimer lowTimer = new LowTimer();
        ProcessContext processContext = null;
        DataFieldCollection datas = wfProcess.getDefinition().getDataFields();
        if (datas != null) {
            RelevantDatas relevantDatas = new RelevantDatas();
            relevantDatas.initial(datas);
            ProcInstDataInfo procInstDataInfo = DataFieldStorer.buildNewProcInstDataInfo(this.engine.context(), this, wfProcess.getId(), relevantDatas.toXML(), false);
            processContext = new ProcessContext(this.engine, wfProcess, procInstDataInfo);
            SnapshotRecorder recorder = SnapshotRecorder.create();
            recorder.snapshoot((AbstractObjectValue)procInstDataInfo);
            recorder.recordSnapshots();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("WfProcessMgr.createProcessContext() dataStorer.initValue cost : " + lowTimer.msValue()));
        }
        return processContext;
    }

    private void addProcessEventPolicy() {
        if (this.getProcessDef() != null && this.engine != null) {
            EventPolicyCollection eventPolicyDefs = this.getProcessDef().getProcessHeader().getEventPolicies();
            for (int i = 0; i < eventPolicyDefs.size(); ++i) {
                String processdefId = this.procDefMeta.getProcDefId().toString();
                WfEventPolicy eventPolicy = new WfEventPolicy(processdefId, this.innerVersion, eventPolicyDefs.get(i));
                this.eventPolicyIdList.add(eventPolicy.getId());
                this.engine.addEventPolicy(eventPolicy);
            }
        }
    }

    private void adjustProcessEventPolicy() {
        if (this.eventPolicyIdList != null && this.getProcessDef() != null && this.engine != null) {
            EventPolicyCollection eventPolicyDefs = this.getProcessDef().getProcessHeader().getEventPolicies();
            if (eventPolicyDefs.size() == this.eventPolicyIdList.size()) {
                for (int i = 0; i < eventPolicyDefs.size(); ++i) {
                    String processdefId = this.procDefMeta.getProcDefId().toString();
                    WfEventPolicy eventPolicy = new WfEventPolicy(processdefId, this.innerVersion, eventPolicyDefs.get(i));
                    eventPolicy.setId("" + this.eventPolicyIdList.get(i));
                    this.engine.addEventPolicy(eventPolicy);
                }
            } else {
                log.warn((Object)"Process Event Policy is avoidable!!!");
            }
        }
    }

    public void deleteProcessInst(String procInstId) throws SQLException, WfException {
        this.deleteProcessInst(procInstId, true);
    }

    public void deletePhysicsProcessInst(String procInstId) throws SQLException, WfException {
        this.deleteProcessInst(procInstId, false);
    }

    public void deleteProcessInst(String procInstId, boolean all) throws SQLException, WfException {
        WfProcess procInst = this.getWfEngine().getProcessInst(procInstId);
        if (procInst.state().startsWith("open.running")) {
            throw new CannotDeleteException("can not delete procInst, because the process has not been closed");
        }
        this.getWfEngine().eventService().raiseProcessEvent(ProcessEvent.BeforeProcessDeleted, procInst, null);
        this.getWfEngine().getStoreManager().getProcessStorer().deleteProcessInst(procInstId, all);
        this.getWfEngine().eventService().raiseProcessEvent(ProcessEvent.AfterProcessDeleted, procInst, null);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        new ExternalizeDelegate((IMarshalObject)this).writeExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new ExternalizeDelegate((IMarshalObject)this).readExternal(in);
    }

    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeObject((Object)this.getWfEngine().getEngineKey());
        marshaller.writeObject((Object)this.getWfEngine().getInitContext());
        marshaller.writeObject((Object)this.contextSignature);
        marshaller.writeInt(this.innerVersion);
        marshaller.writeObject((Object)this.procDefMeta);
        marshaller.writeObject((Object)this.resultSignature);
        marshaller.writeObject((Object)this.eventPolicyIdList);
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        String engineKey = (String)unmarshaller.readObject();
        Context engineContext = (Context)unmarshaller.readObject();
        WfEngine engine = null;
        try {
            engine = WfEngine.getEngine(engineKey, engineContext);
        }
        catch (Exception ex) {
            throw new RuntimeException("Get WfEngine[" + engineKey + "] error! context: " + engineContext);
        }
        this.engine = engine;
        this.contextSignature = (Map)unmarshaller.readObject();
        this.innerVersion = unmarshaller.readInt();
        this.procDefMeta = (ProcessDefInfo)unmarshaller.readObject();
        this.resultSignature = (Map)unmarshaller.readObject();
        this.eventPolicyIdList = (List)unmarshaller.readObject();
        this.adjustProcessEventPolicy();
    }
}

