/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.async;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.sql.util.Base64;
import com.kingdee.bos.workflow.define.OtherSys;
import com.kingdee.bos.workflow.enactment.async.HttpUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YsqUtil {
    public static final String OPEN_API_LOGIN_URL = "/easportal/openapi/login?authPattern=BaseTrdLtpaToken&dcName={dataCenter}&isEncodePwd=1&language=l2&password={pwd}&user={userName}";
    public static final String OPEN_API_CALL_URL = "/easportal/openapi/api?token=";
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static Logger logger = LoggerFactory.getLogger(YsqUtil.class);
    private static final SimpleDateFormat SDF = new SimpleDateFormat("ss mm HH dd MM ? yyyy");
    private static final int DELAY_MINUTE = 45;
    private static final String SUCCESS = "0";
    private static String ysqToken = "";
    private static final String YSQ_LOGIN_URL = "/oapi/v1/token";
    private static final String GET_YSQ_ROBOT_URL = "/oapi/v1/process";
    private static final String GET_YSQ_ROBOT_PATAMS = "/oapi/v1/process/params";
    private static final String SCHEDULE_ADD = "/oapi/v1/schedule/add";
    private static String rpaToken = "";
    private static final String filePath = System.getProperty("EAS_INSTANCE_CONFIG_PATH") + "/portalConfig/LtpaToken.properties";

    public static String[] getYsqTimestampAndSignature(String accesstoken, TreeMap<String, Object> params) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(YsqUtil.buildQueryString(params));
        if (sb.length() > 0) {
            sb.append("&");
        }
        long c = Calendar.getInstance().getTimeInMillis();
        sb.append("timestamp=").append(c);
        String splice = YsqUtil.specialUrlEncode(sb.toString());
        String key256 = accesstoken;
        splice = YsqUtil.HMACSHA256StrByKey(splice, key256);
        String signature = Base64.encodeBytes((byte[])splice.getBytes(Charset.forName("UTF-8")));
        signature = signature.replaceAll("\r|\n", "");
        String[] str = new String[]{String.valueOf(c), signature};
        return str;
    }

    public static String getYsqToken(String serverAdress, String accessKey, String secretKey) throws IOException {
        JSONObject resultJson;
        String code;
        StringBuffer url = new StringBuffer(serverAdress).append(YSQ_LOGIN_URL);
        url.append("?accessKey=").append(accessKey);
        url.append("&secretKey=").append(secretKey);
        String result = HttpUtil.sendGetRequest(url.toString(), null, null, null);
        if (!StringUtils.isEmpty((String)result) && SUCCESS.equals(code = (resultJson = (JSONObject)JSON.parse((String)result)).getString("code"))) {
            return resultJson.getJSONObject("result").getString("access_token");
        }
        return null;
    }

    public static List<Map<String, String>> getYsqWorkflowList(String serverAdress, String accesstoken, String timestamp, String signature) throws IOException {
        JSONObject resultJson;
        String code;
        StringBuffer url = new StringBuffer(serverAdress).append(GET_YSQ_ROBOT_URL);
        String result = HttpUtil.sendGetRequest(url.toString(), accesstoken, timestamp, signature);
        if (!StringUtils.isEmpty((String)result) && SUCCESS.equals(code = (resultJson = (JSONObject)JSON.parse((String)result)).getString("code"))) {
            try {
                return YsqUtil.ysqWorkflowInfoToList(resultJson.getJSONObject("result").getJSONArray("items"), "procCode", "procName");
            }
            catch (JSONException e) {
                logger.error("YsqUtil.getYsqWorkflowList().error:", (Throwable)e);
            }
        }
        return null;
    }

    public static List<Map<String, String>> getYsqWorkflowParams(String serverAdress, String accesstoken, String timestamp, String signature, Map<String, Object> params) throws IOException {
        JSONObject resultJson;
        String code;
        StringBuffer url = new StringBuffer(serverAdress).append(GET_YSQ_ROBOT_PATAMS);
        String result = HttpUtil.sendPostRequestByParamsWithHeader(signature, timestamp, accesstoken, url.toString(), params);
        if (!StringUtils.isEmpty((String)result) && SUCCESS.equals(code = (resultJson = (JSONObject)JSON.parse((String)result)).getString("code"))) {
            try {
                return YsqUtil.wfParamsInfoToList(resultJson.getJSONArray("result"));
            }
            catch (JSONException e) {
                logger.error("YsqUtil.getYsqWorkflowParams().error:", (Throwable)e);
            }
        }
        return null;
    }

    public static List<Map<String, String>> ysqWorkflowInfoToList(JSONArray jsonArray, String idKey, String nameKey) throws JSONException {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        list.add(YsqUtil.getNullItem());
        for (int i = 0; i < jsonArray.size(); ++i) {
            HashMap<String, String> item = new HashMap<String, String>();
            JSONObject json = (JSONObject)jsonArray.get(i);
            item.put("value", json.getString(idKey));
            item.put("title", json.getString(nameKey));
            list.add(item);
        }
        return list;
    }

    public static List<Map<String, String>> wfParamsInfoToList(JSONArray jsonArray) throws JSONException {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject json = jsonArray.getJSONObject(i);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("othersysinvoker_input_param_name", json.getString("Name"));
            map.put("othersysinvoker_input_param_type", json.getString("Type"));
            map.put("othersysinvoker_input_param_description", json.getString("Desc"));
            list.add(map);
        }
        return list;
    }

    private static String specialUrlEncode(String url) throws UnsupportedEncodingException {
        return URLEncoder.encode(url, "UTF8").replace("+", "%20").replace("*", "%2A").replace("~", "%7E");
    }

    private static String buildQueryString(SortedMap<String, Object> parameters) {
        if (!parameters.isEmpty()) {
            Iterator<String> it = parameters.keySet().iterator();
            StringBuilder queryString = new StringBuilder();
            while (it.hasNext()) {
                String name = it.next();
                queryString.append("&").append(name).append('=').append(parameters.get(name));
            }
            return queryString.substring(1);
        }
        return "";
    }

    public static String[] buildSing(String accesstoken, TreeMap<String, Object> params) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(YsqUtil.buildQueryString(params));
        if (sb.length() > 0) {
            sb.append("&");
        }
        long c = Calendar.getInstance().getTimeInMillis();
        sb.append("timestamp=").append(c);
        System.out.println("timestamp=" + c);
        System.out.println("\u6e90\u4e32:" + sb.toString());
        String splice = YsqUtil.specialUrlEncode(sb.toString());
        System.out.println("splice:::: " + splice);
        String key256 = accesstoken;
        splice = YsqUtil.HMACSHA256StrByKey(splice, key256);
        System.out.println("splice hmac:::: " + splice);
        String signature = Base64.encodeBytes((byte[])splice.getBytes(Charset.forName("UTF-8")));
        signature = signature.replaceAll("\r|\n", "");
        System.out.println("signature:" + signature);
        String[] str = new String[]{String.valueOf(c), signature};
        return str;
    }

    public static String HMACSHA256StrByKey(String data, String key) throws Exception {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes("UTF-8"));
        StringBuilder sb = new StringBuilder();
        byte[] var6 = array;
        int var7 = array.length;
        for (int var8 = 0; var8 < var7; ++var8) {
            byte item = var6[var8];
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }

    public static String getScheduleExpre() {
        Date date = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(13, 45);
        date = c.getTime();
        return SDF.format(date);
    }

    public static Map<String, String> getNullItem() {
        HashMap<String, String> nullItem = new HashMap<String, String>();
        nullItem.put("value", "");
        nullItem.put("title", "\u8bf7\u9009\u62e9");
        return nullItem;
    }

    public static synchronized void setToken(String token) {
        rpaToken = token;
    }

    public static String getToken() {
        return rpaToken;
    }

    public static String callYsq(String serverAdress, String accesstoken, String timestamp, String signature, Map<String, Object> params) throws Exception {
        StringBuffer url = new StringBuffer(serverAdress).append(SCHEDULE_ADD);
        String result = HttpUtil.sendPostRequestByParamsWithHeader(signature, timestamp, accesstoken, url.toString(), params);
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!SUCCESS.equals(resultJson.getString("code"))) {
            throw new Exception("\u827a\u8d5b\u65d7\u8c03\u7528\u5931\u8d25\uff1a" + resultJson.getString("msg"));
        }
        return null;
    }

    public static String callYsqDynamic(String serverAdress, String accesstoken, String timestamp, String signature, Map<String, Object> params) {
        return null;
    }

    public static Map<String, Object> getYsqBodyParams(OtherSys os, String taskId, Map parameterMap, Context ctx) throws Exception {
        TreeMap<String, String> BodyParams = new TreeMap<String, String>();
        JSONArray startJsonArray = new JSONArray();
        for (Map.Entry entry : parameterMap.entrySet()) {
            if (null == entry.getValue()) continue;
            JSONObject json = new JSONObject();
            json.put("Name", entry.getKey());
            json.put("Type", (Object)"string");
            json.put("Value", (Object)String.valueOf(entry.getValue()));
            startJsonArray.add((Object)json);
        }
        String easAddress = InetAddress.getLocalHost().getHostAddress();
        easAddress = "http://" + easAddress + ":";
        startJsonArray.add((Object)YsqUtil.setCallBackParams("easAddress", easAddress));
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String getEasTokenUrl = new String(OPEN_API_LOGIN_URL);
        String callBackUrl = new String(OPEN_API_CALL_URL);
        getEasTokenUrl = getEasTokenUrl.replace("{dataCenter}", ctx.getAIS());
        getEasTokenUrl = getEasTokenUrl.replace("{pwd}", LtpaTokenManager.generate((String)userInfo.getNumber(), (String)filePath).toString());
        getEasTokenUrl = getEasTokenUrl.replace("{userName}", userInfo.getNumber());
        startJsonArray.add((Object)YsqUtil.setCallBackParams("getEasTokenUrl", getEasTokenUrl));
        startJsonArray.add((Object)YsqUtil.setCallBackParams("callBackUrl", callBackUrl));
        JSONObject callBackJson = new JSONObject();
        callBackJson.put("api", (Object)"callBackEasWorkflow");
        JSONArray dataArray = new JSONArray();
        dataArray.add((Object)taskId);
        dataArray.add((Object)"{returnValue}");
        callBackJson.put("data", (Object)dataArray);
        startJsonArray.add((Object)YsqUtil.setCallBackParams("callBackParams", callBackJson.toString()));
        BodyParams.put("scheduleExpre", YsqUtil.getScheduleExpre());
        BodyParams.put("schName", os.getRobotId() + new Date().getTime());
        BodyParams.put("procCode", os.getRobotId());
        BodyParams.put("schParam", startJsonArray.toJSONString());
        parameterMap.clear();
        parameterMap.put("bodyParams", BodyParams);
        parameterMap.put("serverAddress", os.getApiBaseUrl());
        parameterMap.put("secretKey", os.getAppSecret());
        parameterMap.put("accessKey", os.getAppId());
        return parameterMap;
    }

    private static JSONObject setCallBackParams(String key, String value) throws JSONException {
        JSONObject openApiStratParamsJson = new JSONObject();
        openApiStratParamsJson.put("Name", (Object)key);
        openApiStratParamsJson.put("Type", (Object)"string");
        openApiStratParamsJson.put("Value", (Object)value);
        return openApiStratParamsJson;
    }

    public static Map<String, Object> getYsqdynamicBodyParams(OtherSys os, String taskId, Map parameterMap, Context ctx) throws UnknownHostException, JSONException {
        String ysq_workflowID = String.valueOf(parameterMap.get("ysq_workflowID"));
        String schParams = String.valueOf(parameterMap.get("ysq_workflow_schParams"));
        TreeMap<String, String> BodyParams = new TreeMap<String, String>();
        JSONArray startJsonArray = new JSONArray();
        JSONObject json = new JSONObject();
        json.put("Name", (Object)"ysq_workflow_schParams");
        json.put("Type", (Object)"string");
        json.put("Value", (Object)schParams);
        startJsonArray.add((Object)json);
        try {
            JSONObject bodyParmasJson = (JSONObject)JSON.parse((String)schParams);
            Set keys = bodyParmasJson.keySet();
            for (String key : keys) {
                JSONObject j = new JSONObject();
                json.put("Name", (Object)key);
                json.put("Type", (Object)"string");
                json.put("Value", (Object)bodyParmasJson.getString(key));
                startJsonArray.add((Object)j);
            }
        }
        catch (Exception bodyParmasJson) {
            // empty catch block
        }
        String easAddress = InetAddress.getLocalHost().getHostAddress();
        easAddress = "http://" + easAddress + ":";
        startJsonArray.add((Object)YsqUtil.setCallBackParams("easAddress", easAddress));
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String getEasTokenUrl = new String(OPEN_API_LOGIN_URL);
        String callBackUrl = new String(OPEN_API_CALL_URL);
        getEasTokenUrl = getEasTokenUrl.replace("{dataCenter}", ctx.getAIS());
        getEasTokenUrl = getEasTokenUrl.replace("{pwd}", LtpaTokenManager.generate((String)userInfo.getNumber(), (String)filePath).toString());
        getEasTokenUrl = getEasTokenUrl.replace("{userName}", userInfo.getNumber());
        startJsonArray.add((Object)YsqUtil.setCallBackParams("getEasTokenUrl", getEasTokenUrl));
        startJsonArray.add((Object)YsqUtil.setCallBackParams("callBackUrl", callBackUrl));
        JSONObject callBackJson = new JSONObject();
        callBackJson.put("api", (Object)"callBackEasWorkflow");
        JSONArray dataArray = new JSONArray();
        dataArray.add((Object)taskId);
        dataArray.add((Object)"{returnValue}");
        callBackJson.put("data", (Object)dataArray);
        startJsonArray.add((Object)YsqUtil.setCallBackParams("callBackParams", callBackJson.toString()));
        BodyParams.put("scheduleExpre", YsqUtil.getScheduleExpre());
        BodyParams.put("schName", ysq_workflowID + new Date().getTime());
        BodyParams.put("procCode", ysq_workflowID);
        BodyParams.put("schParam", startJsonArray.toJSONString());
        parameterMap.clear();
        parameterMap.put("bodyParams", BodyParams);
        parameterMap.put("serverAddress", os.getApiBaseUrl());
        parameterMap.put("secretKey", os.getAppSecret());
        parameterMap.put("accessKey", os.getAppId());
        return parameterMap;
    }
}

