/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.cache;

import com.kingdee.bos.cache.CacheException;
import com.kingdee.bos.jcache.Attributes;
import com.kingdee.bos.jcache.Region;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.cache.EffectRegion;
import com.kingdee.bos.workflow.enactment.cache.IdentifiableInvocationDesc;
import com.kingdee.bos.workflow.util.InvocationExecutor;
import com.kingdee.bos.workflow.util.WorkflowClusterConfig;
import com.kingdee.util.ObjectUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvocationCacheManager {
    private static final Logger logger = Logger.getLogger(InvocationCacheManager.class);
    private final Region parentRegion;
    private static final String INVOCATION_RESULT_REGION = "INVOCATION_RESULT_REGION";
    private final Set methodEffectRegions;

    public InvocationCacheManager(Region rootRegion) {
        this.parentRegion = this.createMethodRootRegion(rootRegion);
        this.methodEffectRegions = Collections.synchronizedSet(new HashSet());
    }

    private Object load(IdentifiableInvocationDesc invocationDesc) {
        try {
            return InvocationExecutor.execute(invocationDesc);
        }
        catch (WfException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private Region createMethodRootRegion(Object rootRegion) {
        Region region = (Region)rootRegion;
        Attributes attributes = new Attributes(region.attributes());
        attributes.setBoolean((Object)"autoLoad", false);
        attributes.setBoolean((Object)"autoDelete", true);
        attributes.setValue((Object)"objectHandlerClass", (Object)Attributes.IDLE_TIMEOUT);
        attributes.setLong((Object)"timeout", 1800000L);
        attributes.setBoolean((Object)"distributed", WorkflowClusterConfig.getInstance().isGroupType());
        return region.getRegion((Object)INVOCATION_RESULT_REGION, true, attributes);
    }

    public Object get(IdentifiableInvocationDesc invocationDesc) {
        Object returnObj = this.getObjectImpl(this.parentRegion, invocationDesc);
        if (returnObj == null) {
            return null;
        }
        try {
            return ObjectUtils.createCopy((Object)returnObj);
        }
        catch (Throwable e) {
            logger.warn((Object)e.getMessage(), e);
            return returnObj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(EffectRegion removedMethodEffectRegion) {
        Set set = this.methodEffectRegions;
        synchronized (set) {
            for (EffectRegion methodEffectRegion : this.methodEffectRegions) {
                if (!methodEffectRegion.isAffected(removedMethodEffectRegion)) continue;
                Region affectedRegion = this.parentRegion.getRegion((Object)methodEffectRegion.getName());
                affectedRegion.discard(true);
            }
        }
    }

    private Object getObjectImpl(Region parentRegion, IdentifiableInvocationDesc invocationDesc) {
        String invokedIdentifier;
        EffectRegion methodEffectRegion = invocationDesc.getIdentifiableMethodDesc().getEffectRegion();
        String effectRegionName = methodEffectRegion.getName();
        Region effectRegion = parentRegion.getRegion((Object)effectRegionName);
        if (effectRegion == null) {
            effectRegion = this.createEffectRegion(parentRegion, methodEffectRegion);
        }
        if (!effectRegion.exists((Object)(invokedIdentifier = invocationDesc.getIdentifier()))) {
            effectRegion.put((Object)invokedIdentifier, this.load(invocationDesc));
        } else if (effectRegion.get((Object)invokedIdentifier) == null) {
            effectRegion.put((Object)invokedIdentifier, this.load(invocationDesc));
        }
        return effectRegion.get((Object)invokedIdentifier);
    }

    private Region createEffectRegion(Region parentRegion, EffectRegion methodEffectRegion) {
        this.methodEffectRegions.add(methodEffectRegion);
        Attributes attributes = new Attributes(parentRegion.attributes());
        Region effectRegion = parentRegion.getRegion((Object)methodEffectRegion.getName(), true, attributes);
        return effectRegion;
    }

    public int size() {
        Object[] regions = this.parentRegion.getNames();
        int count = 0;
        for (int i = 0; i < regions.length; ++i) {
            Region r = this.parentRegion.getRegion(regions[i]);
            if (r == null) continue;
            count += r.size();
        }
        return count;
    }
}

