/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.cache;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.jcache.CacheLoader;
import com.kingdee.bos.jcache.ObjectRef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.util.PermissionUtil;
import java.util.Locale;
import org.apache.log4j.Logger;

public class UserServiceContextCacheLoader
implements com.kingdee.bos.cache.CacheLoader,
CacheLoader {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.enactment.cache.UserServiceContextCacheLoader");
    private WfEngine engine;

    public UserServiceContextCacheLoader(WfEngine destEngine) {
        this.engine = destEngine;
    }

    public Object load(Object args) {
        if (args == null) {
            throw new IllegalArgumentException();
        }
        long time = System.currentTimeMillis();
        String userId = args.toString().substring(0, args.toString().indexOf(","));
        String userName = args.toString().substring(userId.length() + 1);
        Context ctx = new Context((IObjectPK)new ObjectUuidPK(userId), this.engine.getEngineSolution(), this.engine.getEngineAis(), new Locale("l2"));
        ctx.setUserName(userName);
        try {
            PermissionUtil.simulateLogin(ctx);
        }
        catch (Throwable t) {
            log.error((Object)t);
        }
        if (log.isDebugEnabled()) {
            log.info((Object)("simulateLogin cost:" + (System.currentTimeMillis() - time)));
        }
        return ctx;
    }

    public void cleanUp() {
    }

    public Object load(ObjectRef ref) throws Exception {
        return this.load(ref.name());
    }

    public void unload(ObjectRef ref, Object value) {
        log.info((Object)("cache item " + ref + " unload value " + value));
    }
}

