/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.extend.jump;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.EndActivityDef;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ScriptActivityDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.define.extended.ManualDecisionActivityDef;
import com.kingdee.bos.workflow.define.extended.MessageActivityDef;
import com.kingdee.bos.workflow.enactment.ParticipantHelper;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfExecutionObject;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.extend.jump.IJumpTargetPolicy;
import com.kingdee.bos.workflow.metas.WfState;
import java.util.List;
import java.util.Map;

public class JumpTargetPolicy
implements IJumpTargetPolicy {
    private static IJumpTargetPolicy instance = new JumpTargetPolicy();

    public static IJumpTargetPolicy getInstance() {
        return instance;
    }

    @Override
    public boolean isSuitableTarget(Context ctx, String processInstId, ActivityDef activityDef) throws WfException {
        WfEngine engine = WfEngine.getEngine(ctx);
        WfProcess procInst = engine.getProcessInst(processInstId);
        ProcessContext procCtx = procInst.getProcessContext();
        Map dataMap = procCtx.getDataCopy();
        ActivityInstInfo[] actInsts = engine.getActInstMetaByDefId(activityDef.getID(), processInstId, false);
        if (actInsts != null && actInsts.length > 0 && actInsts[0] != null) {
            int n = actInsts.length;
            for (int i = 0; i < n; ++i) {
                if (!actInsts[i].getState().startsWith(WfState.OPEN.getValue())) continue;
                return false;
            }
            return !(activityDef instanceof StartActivityDef);
        }
        if (activityDef instanceof MessageActivityDef) {
            return this.checkParticipant(engine, ((MessageActivityDef)activityDef).getReceivers(), processInstId, activityDef);
        }
        if (activityDef instanceof ScriptActivityDef) {
            return true;
        }
        if (activityDef instanceof ManpowerActivityDef) {
            return this.checkParticipant(engine, procCtx, ((ManpowerActivityDef)activityDef).getParticipants(), processInstId, activityDef) && this.checkInputParameters(activityDef, dataMap);
        }
        if (activityDef instanceof ToolActivityDef) {
            return this.checkInputParameters(activityDef, dataMap);
        }
        if (activityDef instanceof StartActivityDef) {
            return false;
        }
        if (activityDef instanceof EndActivityDef) {
            return false;
        }
        if (activityDef instanceof SubflowActivityDef) {
            ProcessDef subFlowDef = engine.getDefinitionMgr().getProcessDef(((SubflowActivityDef)activityDef).getSubflowId());
            FormalParameterCollection formalParamCol = subFlowDef.getFormalParameters();
            ActivityCollection subStartupActs = subFlowDef.getStartupActivities();
            if (subStartupActs.size() != 1) {
                return false;
            }
            ActivityDef subStartupActDef = subStartupActs.get(0);
            boolean canJump = this.checkInputParameters(activityDef, ((SubflowActivityDef)activityDef).getActualParameters(), formalParamCol, dataMap);
            if (subStartupActDef instanceof ManpowerActivityDef) {
                canJump = canJump && this.checkParticipant(engine, ((ManpowerActivityDef)subStartupActDef).getParticipants(), processInstId, subStartupActDef);
            }
            return canJump;
        }
        return true;
    }

    private boolean checkInputParameters(ActivityDef activityDef, ActualParameterCollection actualParameters, FormalParameterCollection formalParamCol, Map procContext) throws WfException {
        int n = formalParamCol.size();
        for (int i = 0; i < n; ++i) {
            FormalParameterDef formalParamDef = formalParamCol.get(i);
            if (!formalParamDef.getMode().equals((Object)FormalParameterMode.IN) && !formalParamDef.getMode().equals((Object)FormalParameterMode.INOUT)) continue;
            int index = formalParamDef.getIndex();
            ActualParameterDef actParamDef = this.getActualParameter(actualParameters, index);
            if (actParamDef == null) {
                throw new WfException("processDef is bad!bad Activity is" + activityDef.getID());
            }
            String dataFieldId = actParamDef.getExpr();
            ProcessDef procDef = (ProcessDef)activityDef.getContainer();
            String dataFieldName = procDef.getDataFields().get(dataFieldId).getName();
            Object dataFieldValue = procContext.get(dataFieldName);
            DataFieldDef dataField = procDef.getDataFields().get(dataFieldId);
            if (!(activityDef instanceof ApproveActivityDef || activityDef instanceof ManualDecisionActivityDef ? dataField.getDataType().equals(BasicType.BOID) && dataFieldValue == null : dataFieldValue == null)) continue;
            return false;
        }
        return true;
    }

    private boolean checkInputParameters(ActivityDef activityDef, Map procContext) throws WfException {
        ApplicationDef appDef = null;
        ActualParameterCollection actParamCol = null;
        if (activityDef instanceof ManpowerActivityDef) {
            appDef = ((ManpowerActivityDef)activityDef).getRelatedApplication();
            actParamCol = ((ManpowerActivityDef)activityDef).getActualParameters();
        } else if (activityDef instanceof ToolActivityDef) {
            appDef = ((ToolActivityDef)activityDef).getRelatedApplication();
            actParamCol = ((ToolActivityDef)activityDef).getActualParameters();
        } else {
            return true;
        }
        if (appDef == null || actParamCol == null) {
            throw new WfException("processDef is bad!bad Activity is" + activityDef.getID());
        }
        FormalParameterCollection formalParamCol = appDef.getFormalParameters();
        return this.checkInputParameters(activityDef, actParamCol, formalParamCol, procContext);
    }

    private ActualParameterDef getActualParameter(ActualParameterCollection actParamCol, int index) {
        int n = actParamCol.size();
        for (int i = 0; i < n; ++i) {
            if (actParamCol.get(i).getIndex() != index) continue;
            return actParamCol.get(i);
        }
        return null;
    }

    private boolean checkParticipant(WfEngine engine, ParticipantCollection receivers, String procInstId, ActivityDef actDef) throws WfException {
        WfProcess wfProcess = engine.getProcessInst(procInstId);
        int n = receivers.size();
        for (int i = 0; i < n; ++i) {
            ParticipantDef participantDef = receivers.get(i);
            if (!participantDef.getParticipantType().equals((Object)ParticipantType.ALL)) continue;
            return false;
        }
        List persons = null;
        try {
            persons = ParticipantHelper.getPersonsByParticipants((WfExecutionObject)wfProcess, actDef, procInstId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return persons != null && persons.size() > 0;
    }

    private boolean checkParticipant(WfEngine engine, ProcessContext procCtx, ParticipantCollection receivers, String procInstId, ActivityDef actDef) throws WfException {
        WfProcess wfProcess = engine.getProcessInst(procInstId);
        int n22 = receivers.size();
        for (int i = 0; i < n22; ++i) {
            ParticipantDef participantDef = receivers.get(i);
            if (!participantDef.getParticipantType().equals((Object)ParticipantType.ALL)) continue;
            return false;
        }
        List persons = null;
        try {
            persons = ParticipantHelper.getPersonsByParticipants((WfExecutionObject)wfProcess, actDef, procInstId);
        }
        catch (Exception n22) {
            // empty catch block
        }
        boolean flag = persons != null && persons.size() > 0;
        boolean dp = procCtx.getDataCopy().get("DP_" + wfProcess.getProcessMeta().getProcDefHashValue() + "@" + actDef.getID().toString()) != null;
        return flag || dp;
    }
}

