/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.message;

import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.service.message.agent.Transformer;
import com.kingdee.bos.workflow.enactment.message.DirectReceiverAgent;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DirectSenderAgent
extends SenderAgent {
    private int state = 0;
    private DirectReceiverAgent recevierAgent;
    private ArrayList transformers = new ArrayList();
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.service.message.agent.DirectSenderAgent");
    private boolean bLoaded = false;
    private static DirectSenderAgent instance = new DirectSenderAgent();

    public static DirectSenderAgent getInstance() {
        return instance;
    }

    protected DirectSenderAgent() {
        this.recevierAgent = new DirectReceiverAgent();
        this.init();
        this.start();
    }

    public void sendMessage(Message msg, boolean transacted) {
        if (this.state != 1) {
            throw new IllegalStateException("sender agent not running");
        }
        Message source = msg;
        for (int i = 0; i < this.transformers.size(); ++i) {
            Transformer trans = (Transformer)this.transformers.get(i);
            source = trans.transforme(source);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"call sendMessage(Message msg)");
        }
        this.sendDirect(source);
    }

    public void sendMessage(Message msg) {
        this.sendMessage(msg, false);
    }

    public int getState() {
        return this.state;
    }

    public void start() {
        if (this.state == 1) {
            return;
        }
        this.state = 1;
        this.recevierAgent.start();
        log.info((Object)"senderAgent started!");
    }

    public void stop() {
        if (this.state != 1) {
            log.warn((Object)"sender agent is already stoped!");
            return;
        }
        this.state = 2;
        this.recevierAgent.stop();
        log.info((Object)"senderAgent closed");
    }

    protected void init() {
        this.loadTransformers();
        this.recevierAgent.init();
    }

    private void loadTransformers() {
        if (this.bLoaded) {
            return;
        }
        ConfigurationItem config = Configuration.getInstance().getConfigItemByPath("MessageService/transformers");
        if (config == null) {
            log.info((Object)"no transformers Configuration found!");
            return;
        }
        List transformerConfigs = config.getAllChildren();
        for (int i = 0; i < transformerConfigs.size(); ++i) {
            ConfigurationItem item = (ConfigurationItem)transformerConfigs.get(i);
            String className = item.getProperty("class");
            if (className == null || className.length() == 0) continue;
            Transformer transformer = null;
            try {
                Class<?> transformerClass = Class.forName(className);
                transformer = (Transformer)transformerClass.newInstance();
            }
            catch (Throwable ex) {
                log.error((Object)"cannot load transformer class!", ex);
            }
            if (transformer == null) continue;
            this.transformers.add(transformer);
        }
        this.bLoaded = true;
    }

    void sendDirect(Message msg) {
        try {
            this.recevierAgent.onMessage(msg);
        }
        catch (Exception ex) {
            log.error((Object)"send message to destination error", (Throwable)ex);
        }
    }
}

