/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.returns.Destroy;
import com.kingdee.bos.service.job.util.Cache;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.WfBizEvent;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.queue.impl.WfTransQueueEntry;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;

public class Mutex {
    private static HashMap<String, Mutex> mutexes = new HashMap();
    private String datacenter;
    private static Cache cache = new Cache(1000);

    public static void init(Context ctx) {
        Mutex.getMutex(ctx.getAIS());
    }

    public static synchronized Mutex getMutex(String datacenter) {
        Mutex m = mutexes.get(datacenter);
        if (m == null) {
            m = new Mutex(datacenter);
            mutexes.put(datacenter, m);
        }
        return m;
    }

    public static String getMutex(Context ctx, WfTransQueueEntry entry) {
        return Mutex.getMutex(ctx, entry.getProcInstId());
    }

    public static String getMutex(Context ctx, WfBizEvent event) {
        String procInstId;
        String assignId = event.getAssignmentId();
        if (event.getAssignmentId() == null) {
            String billId = event.getBoId();
            if (billId == null || billId.length() == 0) {
                billId = "^_^";
            }
            return billId;
        }
        try {
            procInstId = WfEngine.getEngine(ctx).getAssignment(assignId).getProcInstId();
        }
        catch (WfException e) {
            throw new RuntimeException("retrieve procInstId for assign {" + assignId + "} failed!", e);
        }
        return Mutex.getMutex(ctx, procInstId);
    }

    public static String getMutex(Context ctx, AssignmentInfo info) {
        return Mutex.getMutex(ctx, info.getProcInstId());
    }

    public static boolean lock(String datacenter, String obj) throws AlreadyInProcessQueueException {
        Mutex m = Mutex.getMutex(datacenter);
        if (!m.lock(obj)) {
            String msg = "mutex {" + obj + "} has been in wf queue, please refresh your UI's state or submit later.";
            throw new AlreadyInProcessQueueException(msg);
        }
        return true;
    }

    public static boolean lock(Context ctx, String obj) throws AlreadyInProcessQueueException {
        return Mutex.lock(ctx.getAIS(), obj);
    }

    public static boolean exists(String datacenter, String obj) {
        Mutex m = Mutex.getMutex(datacenter);
        return m.exists(obj);
    }

    public static boolean exists(Context ctx, String obj) {
        return Mutex.exists(ctx.getAIS(), obj);
    }

    public static void unlock(Context ctx, String obj) {
        Mutex m = Mutex.getMutex(ctx.getAIS());
        m.unlock(obj);
    }

    private Mutex(String datacenter) {
        String sql = "select KSQL_TABNAME as c from KSQL_USERTABLES WHERE KSQL_TABNAME='T_WFR_LOCKER'";
        try {
            if (SQL.executeQuery((String)datacenter, (String)sql).size() == 0) {
                sql = "CREATE TABLE T_WFR_LOCKER(fid varchar(44) not null, ftime DateTime not null, CONSTRAINT PK_WFR_LOCKER PRIMARY KEY(fid))";
                SQL.executeUpdate((String)datacenter, (String)sql);
            }
        }
        catch (BOSException e) {
            throw new RuntimeException("check or create table {T_WFR_LOCKER} failed!", e);
        }
        this.datacenter = datacenter;
    }

    public static void clearLocalLock() {
    }

    public boolean lock(String obj) {
        if (this.exists(obj)) {
            return false;
        }
        try {
            LockerHandler h = new LockerHandler();
            Context ctx = Ctx.getDefaultContext((String)this.datacenter);
            String title = "~locker:" + obj;
            JobInstanceConfig cfg = new JobInstanceConfig((IJobHandler)h, true, true, 0);
            Job job = new Job(obj, ctx, title, cfg, null);
            Timestamp t = new Timestamp(System.currentTimeMillis() + 180000L);
            job.setScheduledTime((Date)t);
            JobManager.instance().add(job);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void unlock(String obj) {
        try {
            Context ctx = Ctx.getDefaultContext((String)this.datacenter);
            String title = "~locker:" + obj;
            int affected = JobServiceFactory.getLocalInstance((Context)ctx).drop(obj, title);
            if (affected > 0) {
                return;
            }
        }
        catch (BOSException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private boolean exists(String obj) {
        if (obj == null || obj.length() == 0) {
            throw new IllegalArgumentException("obj is null!");
        }
        try {
            Context ctx = Ctx.getDefaultContext((String)this.datacenter);
            return JobServiceFactory.getLocalInstance((Context)ctx).exists(obj);
        }
        catch (BOSException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String getMutex(Context ctx, String procInstId) {
        String key = procInstId;
        String mutex = (String)cache.getCachedObject(key);
        if (mutex == null) {
            ProcessInstInfo info;
            do {
                mutex = procInstId;
                try {
                    info = WfEngine.getEngine(ctx).getProcessInst(procInstId).getInstanceInfo();
                }
                catch (WfException e) {
                    throw new RuntimeException("retrieve process instance {" + procInstId + "} failed!", e);
                }
            } while ((procInstId = info.getParentProcInstId()) != null);
            cache.pushCachedObject(key, (Object)mutex);
        }
        return mutex;
    }

    private static class LockerHandler
    implements IJobHandler {
        private static final long serialVersionUID = 3623977117678045845L;

        private LockerHandler() {
        }

        public Object execute(Job job) throws Exception {
            return Destroy.instance();
        }
    }
}

