/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core.thread;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobEvent;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.service.job.util.IListener;
import com.kingdee.bos.workflow.define.WfPriority;
import com.kingdee.bos.workflow.engine.core.thread.WfAutoFixListener;
import com.kingdee.bos.workflow.engine.core.thread.WfJobHandler;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import java.sql.Timestamp;

public class JobDispatcher {
    public static final JobIsolationLevel LEVEL = Configuration.defaultJobIsolationLevel();

    public static void dispatch(String jobId, Context ctx, String title, WfJobHandler handler, boolean isSmall, WfPriority priority) throws AlreadyInProcessQueueException {
        JobInstanceConfig dyn = new JobInstanceConfig((IJobHandler)handler, true, isSmall, 0, null, null, LEVEL);
        dyn.addEventListener(JobEvent.OnComplete, (IListener)new WfAutoFixListener());
        dyn.addEventListener(JobEvent.OnFailed, (IListener)new WfAutoFixListener());
        Job job = new Job(jobId, Ctx.toDispatchShadowContext((Context)ctx), title, dyn, null);
        if (WfJobHandler.join(job)) {
            return;
        }
        try {
            JobState jobState = JobServiceFactory.getLocalInstance((Context)ctx).getState(jobId);
            if (jobState != null) {
                if (jobState.isClose()) {
                    JobServiceFactory.getLocalInstance((Context)ctx).moveToHistory(jobId);
                } else {
                    if (!jobId.endsWith("WFPCINST")) {
                        return;
                    }
                    String msg = "mutex {" + jobId + "} has been in wf queue, please refresh your UI's state or submit later.";
                    throw new AlreadyInProcessQueueException(msg);
                }
            }
            JobManager.instance().add(job);
        }
        catch (Exception e) {
            String msg = "mutex {" + jobId + "} has been in wf queue, please refresh your UI's state or submit later.";
            throw new AlreadyInProcessQueueException(msg, (Throwable)e);
        }
    }

    static void broadcast(Context ctx, String mutex, String title, IJobHandler handler, boolean includeMe) {
        ClusterStateManager cm = ClusterStateManager.get((Context)(ctx = Ctx.toShadowContext((Context)ctx)));
        String[] instances = cm.getSameVersionServiceInstanceIds();
        if (instances.length == 0) {
            throw new RuntimeException("wfEngine is not ready, please retry later.");
        }
        String me = Configuration.instanceId();
        for (int i = 0; i < instances.length; ++i) {
            String isolationBoundary = instances[i];
            if (me.equals(isolationBoundary) && !includeMe) continue;
            JobInstanceConfig dyn = new JobInstanceConfig(handler, true, true, 0, mutex, null, JobIsolationLevel.Instance);
            Timestamp scheduledTime = new Timestamp(System.currentTimeMillis() - 1000000L);
            Job job = new Job(ctx, title, dyn, null, scheduledTime, null, 0, isolationBoundary);
            JobManager.instance().add(job);
        }
    }
}

