/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core.thread;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.ActivitySuspendedException;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.WfPriority;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.engine.core.thread.JobDispatcher;
import com.kingdee.bos.workflow.engine.core.thread.WfJobHandler;
import java.util.Map;

public class WfAssignExecutor
extends WfJobHandler {
    private static final long serialVersionUID = -3149519947280565253L;
    private AssignmentInfo info;
    private Map<?, ?> boMap;

    public static boolean enqueue(Context ctx, Map<?, ?> boMap, AssignmentInfo info) throws WfException {
        if (WfJobHandler.existRuningJob()) {
            return false;
        }
        WfEngine engine = WfEngine.getEngine(ctx);
        WfActivity act = engine.getActivityInst(info.getActInstId());
        if (act.state().equals("open.not_running.suspended") || act.state().equals("open.not_running.blocked")) {
            throw new ActivitySuspendedException();
        }
        String procInstId = info.getProcInstId();
        String jobId = Mutex.getMutex(ctx, procInstId);
        String title = "~WFAssign: " + info.getAssignmentId();
        JobDispatcher.dispatch(jobId, ctx, title, new WfAssignExecutor(info, boMap, ctx.getCaller().toString()), false, WfPriority.HIGHEST);
        return true;
    }

    private WfAssignExecutor(AssignmentInfo info, Map<?, ?> boMap, String userId) {
        super(userId);
        this.info = info;
        this.boMap = boMap;
    }

    @Override
    public void run(Context ctx) throws Exception {
        WfEngine engine = WfEngine.getEngine(ctx);
        engine.innerExecuteAssignment(this.boMap, this.info);
    }

    @Override
    protected boolean requiresTran() {
        return true;
    }

    @Override
    protected String getProcInstId() {
        return this.info.getProcInstId();
    }
}

