/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core.thread;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.IWfJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.Returns;
import com.kingdee.bos.service.job.returns.Destroy;
import com.kingdee.bos.service.job.returns.Failed;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.rpc.ObjectFactory;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.WfRuntimeStat;
import com.kingdee.bos.workflow.engine.core.ThreadCache;
import com.kingdee.bos.workflow.transaction.WfTxContext;
import com.kingdee.bos.workflow.transaction.WfTxHelper;
import com.kingdee.bos.workflow.transaction.WfTxInvocationDesc;
import com.kingdee.bos.workflow.util.MethodDesc;
import com.kingdee.bos.workflow.util.WorkflowUtils;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public abstract class WfJobHandler
implements IJobHandler,
IWfJobHandler {
    private static final long serialVersionUID = 7300319812295748520L;
    private static Logger logger = Logger.getLogger(WfJobHandler.class);
    private static ThreadLocal<Job> current = new ThreadLocal();
    private String userId;

    static boolean join(Job job) {
        IJobHandler h = job.getHandler();
        if (!(h instanceof WfJobHandler)) {
            return false;
        }
        Job current = WfJobHandler.current.get();
        if (current == null) {
            return false;
        }
        if (!job.getId().equals(current.getId())) {
            return false;
        }
        LinkedList queue = (LinkedList)current.getParameters();
        queue.addLast((WfJobHandler)h);
        return true;
    }

    static boolean existRuningJob() {
        Job current = WfJobHandler.current.get();
        return current != null;
    }

    public static boolean join(WfJobHandler h) {
        Job current = WfJobHandler.current.get();
        if (current == null) {
            return false;
        }
        LinkedList queue = (LinkedList)current.getParameters();
        queue.addLast(h);
        return true;
    }

    protected WfJobHandler(String userId) {
        this.userId = userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Returns execute(Job job) {
        LinkedList<WfJobHandler> queue = this.prepare(job);
        current.set(job);
        try {
            Destroy destroy;
            LinkedList<WfJobHandler> failed = new LinkedList<WfJobHandler>();
            Throwable error = null;
            while (queue.size() > 0) {
                WfJobHandler h = queue.removeFirst();
                try {
                    h.innerRun(job.getContext().getAIS());
                    if (queue.size() <= 0) continue;
                    job.saveParameter(queue);
                }
                catch (Throwable e) {
                    failed.addFirst(h);
                    error = e;
                    break;
                }
            }
            if (error == null) {
                destroy = Destroy.instance();
                return destroy;
            }
            job.setParameters(failed);
            destroy = new Failed(error);
            return destroy;
        }
        catch (Throwable error) {
            this.handleError(job.getContext(), error);
            Failed failed = new Failed(error);
            return failed;
        }
        finally {
            current.remove();
        }
    }

    private LinkedList<WfJobHandler> prepare(Job job) {
        LinkedList<WfJobHandler> queue = (LinkedList<WfJobHandler>)job.getParameters();
        if (queue == null) {
            queue = new LinkedList<WfJobHandler>();
            queue.addLast(this);
            job.setParameters(queue);
        }
        return queue;
    }

    private void innerRun(String dc) throws Exception {
        Context ctx = Ctx.getContext((String)dc, (String)this.userId, null, null);
        WfRuntimeStat.incCurrentRunningCount();
        ThreadCache.create();
        try {
            WfJobHandler.invoke(this, ctx);
        }
        finally {
            ThreadCache.destroy();
            WfRuntimeStat.decCurrentRunningCount();
        }
    }

    private void handleError(Context ctx, Throwable error) {
        String procInstId;
        WfRuntimeStat.incErrorCount();
        if (error instanceof Error) {
            WfRuntimeStat.incFatalErrorCount();
        }
        if ((procInstId = this.getProcInstId()) != null) {
            logger.error((Object)("Error of procInstId:" + procInstId), error);
            this.saveLog(error, ctx, procInstId);
        }
    }

    protected void saveLog(Throwable error, Context ctx, String procInstId) {
        try {
            WfEngine engine = WfEngine.getEngine(ctx);
            WfException ex = new WfException("WFE_invokeToolError", engine.getLocale().getLanguage(), error);
            WorkflowUtils.logProcessException(procInstId, engine, ex);
        }
        catch (Throwable e) {
            logger.error((Object)("Error of procInstId:" + procInstId), error);
        }
        this.suspendProcInst(procInstId, ctx);
    }

    private void suspendProcInst(String procinstId, Context ctx) {
        try {
            String sql = "update t_wfr_procinst set fstate = 'open.not_running.suspended' where fprocinstid = ?  ";
            int[] types = new int[]{12};
            Object[] params = new Object[]{procinstId};
            SQL.executeUpdate((Context)ctx, (String)sql, (int[])types, (Object[])params);
        }
        catch (BOSException e) {
            logger.error((Object)("susPengProcIsnt procInstId:" + procinstId), (Throwable)e);
        }
    }

    private static void invoke(WfJobHandler handler, Context ctx) throws Exception {
        MethodDesc methodDesc = new MethodDesc(handler.getClass(), "run", new Class[]{Context.class});
        WfTxInvocationDesc invocationDesc = new WfTxInvocationDesc(methodDesc, handler, new Object[]{ctx});
        if (handler.requiresTran()) {
            WfTxHelper.invokeRequired(ctx, invocationDesc);
        } else {
            WfTxHelper.invokeNotSupported(ctx, invocationDesc);
        }
    }

    public void commitMgrAndRuntime(WfProcess process, FlowContext runtime) throws WfException {
        process.getProcessContext().setFlowContext(runtime);
        WfTxContext.current().getLazyPersistentMgr().commit();
    }

    public void commitMgrAndRuntimeTx(WfProcess process, FlowContext runtime) throws WfException {
        Class<?> cls = this.getClass();
        Class[] ptypes = new Class[]{WfProcess.class, FlowContext.class};
        Object[] params = new Object[]{process, runtime};
        try {
            Method m = ObjectFactory.getMethod(cls, (String)"commitMgrAndRuntime", (Class[])ptypes);
            ObjectFactory.invokeRequired((Object)this, (Method)m, (Object[])params);
        }
        catch (Exception e) {
            throw new WfException("commitMgrAndRuntime failed", (Throwable)e);
        }
    }

    public abstract void run(Context var1) throws Exception;

    protected abstract String getProcInstId();

    protected abstract boolean requiresTran();
}

